/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.LocalObjectReferenceBuilder;
import io.fabric8.openshift.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TLSConfigFluent<A extends TLSConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String caCertificate;
    private String certificate;
    private String destinationCACertificate;
    private LocalObjectReferenceBuilder externalCertificate;
    private String insecureEdgeTerminationPolicy;
    private String key;
    private String termination;

    public TLSConfigFluent() {
    }

    public TLSConfigFluent(TLSConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LocalObjectReference buildExternalCertificate() {
        return this.externalCertificate != null ? this.externalCertificate.build() : null;
    }

    protected void copyInstance(TLSConfig instance) {
        TLSConfig tLSConfig = instance = instance != null ? instance : new TLSConfig();
        if (instance != null) {
            this.withCaCertificate(instance.getCaCertificate());
            this.withCertificate(instance.getCertificate());
            this.withDestinationCACertificate(instance.getDestinationCACertificate());
            this.withExternalCertificate(instance.getExternalCertificate());
            this.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy());
            this.withKey(instance.getKey());
            this.withTermination(instance.getTermination());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExternalCertificateNested<A> editExternalCertificate() {
        return this.withNewExternalCertificateLike(Optional.ofNullable(this.buildExternalCertificate()).orElse(null));
    }

    public ExternalCertificateNested<A> editOrNewExternalCertificate() {
        return this.withNewExternalCertificateLike(Optional.ofNullable(this.buildExternalCertificate()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ExternalCertificateNested<A> editOrNewExternalCertificateLike(LocalObjectReference item) {
        return this.withNewExternalCertificateLike(Optional.ofNullable(this.buildExternalCertificate()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSConfigFluent that = (TLSConfigFluent)((Object)o);
        if (!Objects.equals(this.caCertificate, that.caCertificate)) {
            return false;
        }
        if (!Objects.equals(this.certificate, that.certificate)) {
            return false;
        }
        if (!Objects.equals(this.destinationCACertificate, that.destinationCACertificate)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalCertificate, (Object)that.externalCertificate)) {
            return false;
        }
        if (!Objects.equals(this.insecureEdgeTerminationPolicy, that.insecureEdgeTerminationPolicy)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.termination, that.termination)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getDestinationCACertificate() {
        return this.destinationCACertificate;
    }

    public String getInsecureEdgeTerminationPolicy() {
        return this.insecureEdgeTerminationPolicy;
    }

    public String getKey() {
        return this.key;
    }

    public String getTermination() {
        return this.termination;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCaCertificate() {
        return this.caCertificate != null;
    }

    public boolean hasCertificate() {
        return this.certificate != null;
    }

    public boolean hasDestinationCACertificate() {
        return this.destinationCACertificate != null;
    }

    public boolean hasExternalCertificate() {
        return this.externalCertificate != null;
    }

    public boolean hasInsecureEdgeTerminationPolicy() {
        return this.insecureEdgeTerminationPolicy != null;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean hasTermination() {
        return this.termination != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.caCertificate, this.certificate, this.destinationCACertificate, this.externalCertificate, this.insecureEdgeTerminationPolicy, this.key, this.termination, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caCertificate != null) {
            sb.append("caCertificate:");
            sb.append(this.caCertificate);
            sb.append(",");
        }
        if (this.certificate != null) {
            sb.append("certificate:");
            sb.append(this.certificate);
            sb.append(",");
        }
        if (this.destinationCACertificate != null) {
            sb.append("destinationCACertificate:");
            sb.append(this.destinationCACertificate);
            sb.append(",");
        }
        if (this.externalCertificate != null) {
            sb.append("externalCertificate:");
            sb.append((Object)this.externalCertificate);
            sb.append(",");
        }
        if (this.insecureEdgeTerminationPolicy != null) {
            sb.append("insecureEdgeTerminationPolicy:");
            sb.append(this.insecureEdgeTerminationPolicy);
            sb.append(",");
        }
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key);
            sb.append(",");
        }
        if (this.termination != null) {
            sb.append("termination:");
            sb.append(this.termination);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCaCertificate(String caCertificate) {
        this.caCertificate = caCertificate;
        return (A)((Object)this);
    }

    public A withCertificate(String certificate) {
        this.certificate = certificate;
        return (A)((Object)this);
    }

    public A withDestinationCACertificate(String destinationCACertificate) {
        this.destinationCACertificate = destinationCACertificate;
        return (A)((Object)this);
    }

    public A withExternalCertificate(LocalObjectReference externalCertificate) {
        this._visitables.remove((Object)"externalCertificate");
        if (externalCertificate != null) {
            this.externalCertificate = new LocalObjectReferenceBuilder(externalCertificate);
            this._visitables.get((Object)"externalCertificate").add(this.externalCertificate);
        } else {
            this.externalCertificate = null;
            this._visitables.get((Object)"externalCertificate").remove((Object)this.externalCertificate);
        }
        return (A)((Object)this);
    }

    public A withInsecureEdgeTerminationPolicy(String insecureEdgeTerminationPolicy) {
        this.insecureEdgeTerminationPolicy = insecureEdgeTerminationPolicy;
        return (A)((Object)this);
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public ExternalCertificateNested<A> withNewExternalCertificate() {
        return new ExternalCertificateNested(null);
    }

    public A withNewExternalCertificate(String name) {
        return this.withExternalCertificate(new LocalObjectReference(name));
    }

    public ExternalCertificateNested<A> withNewExternalCertificateLike(LocalObjectReference item) {
        return new ExternalCertificateNested(item);
    }

    public A withTermination(String termination) {
        this.termination = termination;
        return (A)((Object)this);
    }

    public class ExternalCertificateNested<N>
    extends LocalObjectReferenceFluent<ExternalCertificateNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ExternalCertificateNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)TLSConfigFluent.this.withExternalCertificate(this.builder.build());
        }

        public N endExternalCertificate() {
            return this.and();
        }
    }
}

