/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventListBuilder;
import io.fabric8.openshift.api.model.NamedTagEventListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamStatusFluent<A extends ImageStreamStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String dockerImageRepository;
    private String publicDockerImageRepository;
    private ArrayList<NamedTagEventListBuilder> tags = new ArrayList();

    public ImageStreamStatusFluent() {
    }

    public ImageStreamStatusFluent(ImageStreamStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToTags(Collection<NamedTagEventList> items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        }
        return (A)((Object)this);
    }

    public TagsNested<A> addNewTag() {
        return new TagsNested(-1, null);
    }

    public TagsNested<A> addNewTagLike(NamedTagEventList item) {
        return new TagsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTags(NamedTagEventList ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTags(int index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public NamedTagEventList buildFirstTag() {
        return this.tags.get(0).build();
    }

    public NamedTagEventList buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    public NamedTagEventList buildMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NamedTagEventList buildTag(int index) {
        return this.tags.get(index).build();
    }

    public List<NamedTagEventList> buildTags() {
        return this.tags != null ? ImageStreamStatusFluent.build(this.tags) : null;
    }

    protected void copyInstance(ImageStreamStatus instance) {
        ImageStreamStatus imageStreamStatus = instance = instance != null ? instance : new ImageStreamStatus();
        if (instance != null) {
            this.withDockerImageRepository(instance.getDockerImageRepository());
            this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
            this.withTags(instance.getTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "tags"));
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    public TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "tags"));
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "tags"));
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "tags"));
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusFluent that = (ImageStreamStatusFluent)((Object)o);
        if (!Objects.equals(this.dockerImageRepository, that.dockerImageRepository)) {
            return false;
        }
        if (!Objects.equals(this.publicDockerImageRepository, that.publicDockerImageRepository)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    public String getPublicDockerImageRepository() {
        return this.publicDockerImageRepository;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    public boolean hasMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPublicDockerImageRepository() {
        return this.publicDockerImageRepository != null;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.dockerImageRepository, this.publicDockerImageRepository, this.tags, this.additionalProperties);
    }

    public A removeAllFromTags(Collection<NamedTagEventList> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get((Object)"tags").remove((Object)builder);
            this.tags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTags(NamedTagEventList ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.get((Object)"tags").remove((Object)builder);
            this.tags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTags(Predicate<NamedTagEventListBuilder> predicate) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        Iterator<NamedTagEventListBuilder> each = this.tags.iterator();
        List visitables = this._visitables.get((Object)"tags");
        while (each.hasNext()) {
            NamedTagEventListBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TagsNested<A> setNewTagLike(int index, NamedTagEventList item) {
        return new TagsNested(index, item);
    }

    public A setToTags(int index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get((Object)"tags").add(builder);
            this.tags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dockerImageRepository != null) {
            sb.append("dockerImageRepository:");
            sb.append(this.dockerImageRepository);
            sb.append(",");
        }
        if (this.publicDockerImageRepository != null) {
            sb.append("publicDockerImageRepository:");
            sb.append(this.publicDockerImageRepository);
            sb.append(",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)((Object)this);
    }

    public A withPublicDockerImageRepository(String publicDockerImageRepository) {
        this.publicDockerImageRepository = publicDockerImageRepository;
        return (A)((Object)this);
    }

    public A withTags(List<NamedTagEventList> tags) {
        if (this.tags != null) {
            this._visitables.get((Object)"tags").clear();
        }
        if (tags != null) {
            this.tags = new ArrayList();
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(NamedTagEventList ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public class TagsNested<N>
    extends NamedTagEventListFluent<TagsNested<N>>
    implements Nested<N> {
        NamedTagEventListBuilder builder;
        int index;

        TagsNested(int index, NamedTagEventList item) {
            this.index = index;
            this.builder = new NamedTagEventListBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamStatusFluent.this.setToTags(this.index, this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }
}

