/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private Map<String, String> selector;
    private DeploymentStrategyBuilder strategy;
    private PodTemplateSpecBuilder template;
    private Boolean test;
    private ArrayList<DeploymentTriggerPolicyBuilder> triggers = new ArrayList();

    public DeploymentConfigSpecFluent() {
    }

    public DeploymentConfigSpecFluent(DeploymentConfigSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)((Object)this);
    }

    public TriggersNested<A> addNewTrigger() {
        return new TriggersNested(-1, null);
    }

    public TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item) {
        return new TriggersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTriggers(DeploymentTriggerPolicy ... items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTriggers(int index, DeploymentTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
        if (index < 0 || index >= this.triggers.size()) {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        } else {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public DeploymentTriggerPolicy buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    public DeploymentTriggerPolicy buildLastTrigger() {
        return this.triggers.get(this.triggers.size() - 1).build();
    }

    public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        for (DeploymentTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public DeploymentTriggerPolicy buildTrigger(int index) {
        return this.triggers.get(index).build();
    }

    public List<DeploymentTriggerPolicy> buildTriggers() {
        return this.triggers != null ? DeploymentConfigSpecFluent.build(this.triggers) : null;
    }

    protected void copyInstance(DeploymentConfigSpec instance) {
        DeploymentConfigSpec deploymentConfigSpec = instance = instance != null ? instance : new DeploymentConfigSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withPaused(instance.getPaused());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSelector(instance.getSelector());
            this.withStrategy(instance.getStrategy());
            this.withTemplate(instance.getTemplate());
            this.withTest(instance.getTest());
            this.withTriggers(instance.getTriggers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TriggersNested<A> editFirstTrigger() {
        if (this.triggers.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "triggers"));
        }
        return this.setNewTriggerLike(0, this.buildTrigger(0));
    }

    public TriggersNested<A> editLastTrigger() {
        int index = this.triggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "triggers"));
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggers.size(); ++i) {
            if (!predicate.test(this.triggers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "triggers"));
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(new DeploymentStrategyBuilder().build()));
    }

    public StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(item));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(null));
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TriggersNested<A> editTrigger(int index) {
        if (this.triggers.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "triggers"));
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigSpecFluent that = (DeploymentConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals((Object)this.strategy, (Object)that.strategy)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals(this.test, that.test)) {
            return false;
        }
        if (!Objects.equals(this.triggers, that.triggers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public Boolean getTest() {
        return this.test;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        for (DeploymentTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public boolean hasPaused() {
        return this.paused != null;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public boolean hasTest() {
        return this.test != null;
    }

    public boolean hasTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minReadySeconds, this.paused, this.replicas, this.revisionHistoryLimit, this.selector, this.strategy, this.template, this.test, this.triggers, this.additionalProperties});
    }

    public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items) {
        if (this.triggers == null) {
            return (A)((Object)this);
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get((Object)"triggers").remove((Object)builder);
            this.triggers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTriggers(DeploymentTriggerPolicy ... items) {
        if (this.triggers == null) {
            return (A)((Object)this);
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get((Object)"triggers").remove((Object)builder);
            this.triggers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTriggers(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        if (this.triggers == null) {
            return (A)((Object)this);
        }
        Iterator<DeploymentTriggerPolicyBuilder> each = this.triggers.iterator();
        List visitables = this._visitables.get((Object)"triggers");
        while (each.hasNext()) {
            DeploymentTriggerPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TriggersNested<A> setNewTriggerLike(int index, DeploymentTriggerPolicy item) {
        return new TriggersNested(index, item);
    }

    public A setToTriggers(int index, DeploymentTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
        if (index < 0 || index >= this.triggers.size()) {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.add(builder);
        } else {
            this._visitables.get((Object)"triggers").add(builder);
            this.triggers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds);
            sb.append(",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit);
            sb.append(",");
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector);
            sb.append(",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append((Object)this.strategy);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template);
            sb.append(",");
        }
        if (this.test != null) {
            sb.append("test:");
            sb.append(this.test);
            sb.append(",");
        }
        if (this.triggers != null && !this.triggers.isEmpty()) {
            sb.append("triggers:");
            sb.append(this.triggers);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)((Object)this);
    }

    public StrategyNested<A> withNewStrategy() {
        return new StrategyNested(null);
    }

    public StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNested(item);
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public A withPaused() {
        return this.withPaused(true);
    }

    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)((Object)this);
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)((Object)this);
    }

    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)((Object)this);
    }

    public A withStrategy(DeploymentStrategy strategy) {
        this._visitables.remove((Object)"strategy");
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.get((Object)"strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get((Object)"strategy").remove((Object)this.strategy);
        }
        return (A)((Object)this);
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public A withTest() {
        return this.withTest(true);
    }

    public A withTest(Boolean test) {
        this.test = test;
        return (A)((Object)this);
    }

    public A withTriggers(List<DeploymentTriggerPolicy> triggers) {
        if (this.triggers != null) {
            this._visitables.get((Object)"triggers").clear();
        }
        if (triggers != null) {
            this.triggers = new ArrayList();
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        } else {
            this.triggers = null;
        }
        return (A)((Object)this);
    }

    public A withTriggers(DeploymentTriggerPolicy ... triggers) {
        if (this.triggers != null) {
            this.triggers.clear();
            this._visitables.remove((Object)"triggers");
        }
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)((Object)this);
    }

    public class TriggersNested<N>
    extends DeploymentTriggerPolicyFluent<TriggersNested<N>>
    implements Nested<N> {
        DeploymentTriggerPolicyBuilder builder;
        int index;

        TriggersNested(int index, DeploymentTriggerPolicy item) {
            this.index = index;
            this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentConfigSpecFluent.this.setToTriggers(this.index, this.builder.build());
        }

        public N endTrigger() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        public N and() {
            return (N)DeploymentConfigSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class StrategyNested<N>
    extends DeploymentStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        DeploymentStrategyBuilder builder;

        StrategyNested(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentConfigSpecFluent.this.withStrategy(this.builder.build());
        }

        public N endStrategy() {
            return this.and();
        }
    }
}

