/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.UserIdentityMapping;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class UserIdentityMappingFluent<A extends UserIdentityMappingFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ObjectReferenceBuilder identity;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder user;
    private Map<String, Object> additionalProperties;

    public UserIdentityMappingFluent() {
    }

    public UserIdentityMappingFluent(UserIdentityMapping instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(UserIdentityMapping instance) {
        UserIdentityMapping userIdentityMapping = instance = instance != null ? instance : new UserIdentityMapping();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withIdentity(instance.getIdentity());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public ObjectReference buildIdentity() {
        return this.identity != null ? this.identity.build() : null;
    }

    public A withIdentity(ObjectReference identity) {
        this._visitables.remove((Object)"identity");
        if (identity != null) {
            this.identity = new ObjectReferenceBuilder(identity);
            this._visitables.get((Object)"identity").add(this.identity);
        } else {
            this.identity = null;
            this._visitables.get((Object)"identity").remove(this.identity);
        }
        return (A)((Object)this);
    }

    public boolean hasIdentity() {
        return this.identity != null;
    }

    public IdentityNested<A> withNewIdentity() {
        return new IdentityNested(null);
    }

    public IdentityNested<A> withNewIdentityLike(ObjectReference item) {
        return new IdentityNested(item);
    }

    public IdentityNested<A> editIdentity() {
        return this.withNewIdentityLike(Optional.ofNullable(this.buildIdentity()).orElse(null));
    }

    public IdentityNested<A> editOrNewIdentity() {
        return this.withNewIdentityLike(Optional.ofNullable(this.buildIdentity()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IdentityNested<A> editOrNewIdentityLike(ObjectReference item) {
        return this.withNewIdentityLike(Optional.ofNullable(this.buildIdentity()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public ObjectReference buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(ObjectReference user) {
        this._visitables.remove((Object)"user");
        if (user != null) {
            this.user = new ObjectReferenceBuilder(user);
            this._visitables.get((Object)"user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get((Object)"user").remove(this.user);
        }
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(ObjectReference item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new ObjectReferenceBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(ObjectReference item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserIdentityMappingFluent that = (UserIdentityMappingFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.identity, that.identity)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.identity, this.kind, this.metadata, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.identity != null) {
            sb.append("identity:");
            sb.append(String.valueOf(this.identity) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(String.valueOf(this.user) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserNested<N>
    extends ObjectReferenceFluent<UserNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        UserNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)UserIdentityMappingFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)UserIdentityMappingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class IdentityNested<N>
    extends ObjectReferenceFluent<IdentityNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IdentityNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)UserIdentityMappingFluent.this.withIdentity(this.builder.build());
        }

        public N endIdentity() {
            return this.and();
        }
    }
}

