package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamedRoleBuilder extends NamedRoleFluent<NamedRoleBuilder> implements VisitableBuilder<NamedRole,NamedRoleBuilder>{
  public NamedRoleBuilder() {
    this(new NamedRole());
  }
  
  public NamedRoleBuilder(NamedRoleFluent<?> fluent) {
    this(fluent, new NamedRole());
  }
  
  public NamedRoleBuilder(NamedRoleFluent<?> fluent,NamedRole instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamedRoleBuilder(NamedRole instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamedRoleFluent<?> fluent;
  
  public NamedRole build() {
    NamedRole buildable = new NamedRole(fluent.getName(),fluent.buildRole());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}