/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.internal.KubernetesDeserializerForList;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateDeserializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize(using=TemplateDeserializer.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "labels", "message", "objects", "parameters"})
@Version(value="v1")
@Group(value="template.openshift.io")
public class Template
implements Editable<TemplateBuilder>,
HasMetadata,
Namespaced {
    @JsonProperty(value="apiVersion")
    private String apiVersion = "template.openshift.io/v1";
    @JsonProperty(value="kind")
    private String kind = "Template";
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> labels = new LinkedHashMap<String, String>();
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="metadata")
    private ObjectMeta metadata;
    @JsonProperty(value="objects")
    @JsonDeserialize(using=KubernetesDeserializerForList.class)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Object> objects = new ArrayList<Object>();
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    public Template() {
    }

    public Template(String apiVersion, String kind, Map<String, String> labels, String message, ObjectMeta metadata, List<Object> objects, List<Parameter> parameters) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.labels = labels;
        this.message = message;
        this.metadata = metadata;
        this.objects = objects;
        this.parameters = parameters;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="objects")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Object> getObjects() {
        return this.objects;
    }

    @JsonProperty(value="objects")
    @JsonDeserialize(using=KubernetesDeserializerForList.class)
    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @JsonIgnore
    public TemplateBuilder edit() {
        return new TemplateBuilder(this);
    }

    @JsonIgnore
    public TemplateBuilder toBuilder() {
        return this.edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public String toString() {
        return "Template(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", labels=" + String.valueOf(this.getLabels()) + ", message=" + this.getMessage() + ", metadata=" + String.valueOf(this.getMetadata()) + ", objects=" + String.valueOf(this.getObjects()) + ", parameters=" + String.valueOf(this.getParameters()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        List<Object> this$objects = this.getObjects();
        List<Object> other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        List<Object> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

