package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressNetworkPolicyPeerBuilder extends EgressNetworkPolicyPeerFluent<EgressNetworkPolicyPeerBuilder> implements VisitableBuilder<EgressNetworkPolicyPeer,EgressNetworkPolicyPeerBuilder>{
  public EgressNetworkPolicyPeerBuilder() {
    this(new EgressNetworkPolicyPeer());
  }
  
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent) {
    this(fluent, new EgressNetworkPolicyPeer());
  }
  
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeerFluent<?> fluent,EgressNetworkPolicyPeer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressNetworkPolicyPeerBuilder(EgressNetworkPolicyPeer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressNetworkPolicyPeerFluent<?> fluent;
  
  public EgressNetworkPolicyPeer build() {
    EgressNetworkPolicyPeer buildable = new EgressNetworkPolicyPeer(fluent.getCidrSelector(),fluent.getDnsName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}