package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeploymentStrategyBuilder extends DeploymentStrategyFluent<DeploymentStrategyBuilder> implements VisitableBuilder<DeploymentStrategy,DeploymentStrategyBuilder>{
  public DeploymentStrategyBuilder() {
    this(new DeploymentStrategy());
  }
  
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent) {
    this(fluent, new DeploymentStrategy());
  }
  
  public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent,DeploymentStrategy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeploymentStrategyBuilder(DeploymentStrategy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeploymentStrategyFluent<?> fluent;
  
  public DeploymentStrategy build() {
    DeploymentStrategy buildable = new DeploymentStrategy(fluent.getActiveDeadlineSeconds(),fluent.getAnnotations(),fluent.buildCustomParams(),fluent.getLabels(),fluent.buildRecreateParams(),fluent.buildResources(),fluent.buildRollingParams(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}