/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.TLSProfileSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TLSProfileSpecFluent<A extends TLSProfileSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> ciphers = new ArrayList<String>();
    private String minTLSVersion;
    private Map<String, Object> additionalProperties;

    public TLSProfileSpecFluent() {
    }

    public TLSProfileSpecFluent(TLSProfileSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TLSProfileSpec instance) {
        TLSProfileSpec tLSProfileSpec = instance = instance != null ? instance : new TLSProfileSpec();
        if (instance != null) {
            this.withCiphers(instance.getCiphers());
            this.withMinTLSVersion(instance.getMinTLSVersion());
            this.withCiphers(instance.getCiphers());
            this.withMinTLSVersion(instance.getMinTLSVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCiphers(int index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.add(index, item);
        return (A)((Object)this);
    }

    public A setToCiphers(int index, String item) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        this.ciphers.set(index, item);
        return (A)((Object)this);
    }

    public A addToCiphers(String ... items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            this.ciphers = new ArrayList<String>();
        }
        for (String item : items) {
            this.ciphers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCiphers(String ... items) {
        if (this.ciphers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ciphers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCiphers(Collection<String> items) {
        if (this.ciphers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ciphers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public String getCipher(int index) {
        return this.ciphers.get(index);
    }

    public String getFirstCipher() {
        return this.ciphers.get(0);
    }

    public String getLastCipher() {
        return this.ciphers.get(this.ciphers.size() - 1);
    }

    public String getMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCipher(Predicate<String> predicate) {
        for (String item : this.ciphers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCiphers(List<String> ciphers) {
        if (ciphers != null) {
            this.ciphers = new ArrayList<String>();
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        } else {
            this.ciphers = null;
        }
        return (A)((Object)this);
    }

    public A withCiphers(String ... ciphers) {
        if (this.ciphers != null) {
            this.ciphers.clear();
            this._visitables.remove((Object)"ciphers");
        }
        if (ciphers != null) {
            for (String item : ciphers) {
                this.addToCiphers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCiphers() {
        return this.ciphers != null && !this.ciphers.isEmpty();
    }

    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)((Object)this);
    }

    public boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSProfileSpecFluent that = (TLSProfileSpecFluent)((Object)o);
        if (!Objects.equals(this.ciphers, that.ciphers)) {
            return false;
        }
        if (!Objects.equals(this.minTLSVersion, that.minTLSVersion)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.minTLSVersion, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ciphers != null && !this.ciphers.isEmpty()) {
            sb.append("ciphers:");
            sb.append(this.ciphers + ",");
        }
        if (this.minTLSVersion != null) {
            sb.append("minTLSVersion:");
            sb.append(this.minTLSVersion + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

