/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.APIServerEncryption;
import io.fabric8.openshift.api.model.config.v1.APIServerEncryptionBuilder;
import io.fabric8.openshift.api.model.config.v1.APIServerEncryptionFluent;
import io.fabric8.openshift.api.model.config.v1.APIServerServingCerts;
import io.fabric8.openshift.api.model.config.v1.APIServerServingCertsBuilder;
import io.fabric8.openshift.api.model.config.v1.APIServerServingCertsFluent;
import io.fabric8.openshift.api.model.config.v1.APIServerSpec;
import io.fabric8.openshift.api.model.config.v1.Audit;
import io.fabric8.openshift.api.model.config.v1.AuditBuilder;
import io.fabric8.openshift.api.model.config.v1.AuditFluent;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfileBuilder;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfileFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class APIServerSpecFluent<A extends APIServerSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> additionalCORSAllowedOrigins = new ArrayList<String>();
    private AuditBuilder audit;
    private ConfigMapNameReferenceBuilder clientCA;
    private APIServerEncryptionBuilder encryption;
    private APIServerServingCertsBuilder servingCerts;
    private TLSSecurityProfileBuilder tlsSecurityProfile;
    private Map<String, Object> additionalProperties;

    public APIServerSpecFluent() {
    }

    public APIServerSpecFluent(APIServerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIServerSpec instance) {
        APIServerSpec aPIServerSpec = instance = instance != null ? instance : new APIServerSpec();
        if (instance != null) {
            this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
            this.withAudit(instance.getAudit());
            this.withClientCA(instance.getClientCA());
            this.withEncryption(instance.getEncryption());
            this.withServingCerts(instance.getServingCerts());
            this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
            this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
            this.withAudit(instance.getAudit());
            this.withClientCA(instance.getClientCA());
            this.withEncryption(instance.getEncryption());
            this.withServingCerts(instance.getServingCerts());
            this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalCORSAllowedOrigins(int index, String item) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        this.additionalCORSAllowedOrigins.add(index, item);
        return (A)((Object)this);
    }

    public A setToAdditionalCORSAllowedOrigins(int index, String item) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        this.additionalCORSAllowedOrigins.set(index, item);
        return (A)((Object)this);
    }

    public A addToAdditionalCORSAllowedOrigins(String ... items) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalCORSAllowedOrigins.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalCORSAllowedOrigins(Collection<String> items) {
        if (this.additionalCORSAllowedOrigins == null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalCORSAllowedOrigins.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalCORSAllowedOrigins(String ... items) {
        if (this.additionalCORSAllowedOrigins == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalCORSAllowedOrigins.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalCORSAllowedOrigins(Collection<String> items) {
        if (this.additionalCORSAllowedOrigins == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalCORSAllowedOrigins.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAdditionalCORSAllowedOrigins() {
        return this.additionalCORSAllowedOrigins;
    }

    public String getAdditionalCORSAllowedOrigin(int index) {
        return this.additionalCORSAllowedOrigins.get(index);
    }

    public String getFirstAdditionalCORSAllowedOrigin() {
        return this.additionalCORSAllowedOrigins.get(0);
    }

    public String getLastAdditionalCORSAllowedOrigin() {
        return this.additionalCORSAllowedOrigins.get(this.additionalCORSAllowedOrigins.size() - 1);
    }

    public String getMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.additionalCORSAllowedOrigins) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
        for (String item : this.additionalCORSAllowedOrigins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalCORSAllowedOrigins(List<String> additionalCORSAllowedOrigins) {
        if (additionalCORSAllowedOrigins != null) {
            this.additionalCORSAllowedOrigins = new ArrayList<String>();
            for (String item : additionalCORSAllowedOrigins) {
                this.addToAdditionalCORSAllowedOrigins(item);
            }
        } else {
            this.additionalCORSAllowedOrigins = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalCORSAllowedOrigins(String ... additionalCORSAllowedOrigins) {
        if (this.additionalCORSAllowedOrigins != null) {
            this.additionalCORSAllowedOrigins.clear();
            this._visitables.remove((Object)"additionalCORSAllowedOrigins");
        }
        if (additionalCORSAllowedOrigins != null) {
            for (String item : additionalCORSAllowedOrigins) {
                this.addToAdditionalCORSAllowedOrigins(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalCORSAllowedOrigins() {
        return this.additionalCORSAllowedOrigins != null && !this.additionalCORSAllowedOrigins.isEmpty();
    }

    public Audit buildAudit() {
        return this.audit != null ? this.audit.build() : null;
    }

    public A withAudit(Audit audit) {
        this._visitables.remove((Object)this.audit);
        if (audit != null) {
            this.audit = new AuditBuilder(audit);
            this._visitables.get((Object)"audit").add(this.audit);
        } else {
            this.audit = null;
            this._visitables.get((Object)"audit").remove((Object)this.audit);
        }
        return (A)((Object)this);
    }

    public boolean hasAudit() {
        return this.audit != null;
    }

    public AuditNested<A> withNewAudit() {
        return new AuditNested(null);
    }

    public AuditNested<A> withNewAuditLike(Audit item) {
        return new AuditNested(item);
    }

    public AuditNested<A> editAudit() {
        return this.withNewAuditLike(Optional.ofNullable(this.buildAudit()).orElse(null));
    }

    public AuditNested<A> editOrNewAudit() {
        return this.withNewAuditLike(Optional.ofNullable(this.buildAudit()).orElse(new AuditBuilder().build()));
    }

    public AuditNested<A> editOrNewAuditLike(Audit item) {
        return this.withNewAuditLike(Optional.ofNullable(this.buildAudit()).orElse(item));
    }

    public ConfigMapNameReference buildClientCA() {
        return this.clientCA != null ? this.clientCA.build() : null;
    }

    public A withClientCA(ConfigMapNameReference clientCA) {
        this._visitables.remove((Object)this.clientCA);
        if (clientCA != null) {
            this.clientCA = new ConfigMapNameReferenceBuilder(clientCA);
            this._visitables.get((Object)"clientCA").add(this.clientCA);
        } else {
            this.clientCA = null;
            this._visitables.get((Object)"clientCA").remove((Object)this.clientCA);
        }
        return (A)((Object)this);
    }

    public boolean hasClientCA() {
        return this.clientCA != null;
    }

    public A withNewClientCA(String name) {
        return this.withClientCA(new ConfigMapNameReference(name));
    }

    public ClientCANested<A> withNewClientCA() {
        return new ClientCANested(null);
    }

    public ClientCANested<A> withNewClientCALike(ConfigMapNameReference item) {
        return new ClientCANested(item);
    }

    public ClientCANested<A> editClientCA() {
        return this.withNewClientCALike(Optional.ofNullable(this.buildClientCA()).orElse(null));
    }

    public ClientCANested<A> editOrNewClientCA() {
        return this.withNewClientCALike(Optional.ofNullable(this.buildClientCA()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item) {
        return this.withNewClientCALike(Optional.ofNullable(this.buildClientCA()).orElse(item));
    }

    public APIServerEncryption buildEncryption() {
        return this.encryption != null ? this.encryption.build() : null;
    }

    public A withEncryption(APIServerEncryption encryption) {
        this._visitables.remove((Object)this.encryption);
        if (encryption != null) {
            this.encryption = new APIServerEncryptionBuilder(encryption);
            this._visitables.get((Object)"encryption").add(this.encryption);
        } else {
            this.encryption = null;
            this._visitables.get((Object)"encryption").remove((Object)this.encryption);
        }
        return (A)((Object)this);
    }

    public boolean hasEncryption() {
        return this.encryption != null;
    }

    public A withNewEncryption(String type) {
        return this.withEncryption(new APIServerEncryption(type));
    }

    public EncryptionNested<A> withNewEncryption() {
        return new EncryptionNested(null);
    }

    public EncryptionNested<A> withNewEncryptionLike(APIServerEncryption item) {
        return new EncryptionNested(item);
    }

    public EncryptionNested<A> editEncryption() {
        return this.withNewEncryptionLike(Optional.ofNullable(this.buildEncryption()).orElse(null));
    }

    public EncryptionNested<A> editOrNewEncryption() {
        return this.withNewEncryptionLike(Optional.ofNullable(this.buildEncryption()).orElse(new APIServerEncryptionBuilder().build()));
    }

    public EncryptionNested<A> editOrNewEncryptionLike(APIServerEncryption item) {
        return this.withNewEncryptionLike(Optional.ofNullable(this.buildEncryption()).orElse(item));
    }

    public APIServerServingCerts buildServingCerts() {
        return this.servingCerts != null ? this.servingCerts.build() : null;
    }

    public A withServingCerts(APIServerServingCerts servingCerts) {
        this._visitables.remove((Object)this.servingCerts);
        if (servingCerts != null) {
            this.servingCerts = new APIServerServingCertsBuilder(servingCerts);
            this._visitables.get((Object)"servingCerts").add(this.servingCerts);
        } else {
            this.servingCerts = null;
            this._visitables.get((Object)"servingCerts").remove((Object)this.servingCerts);
        }
        return (A)((Object)this);
    }

    public boolean hasServingCerts() {
        return this.servingCerts != null;
    }

    public ServingCertsNested<A> withNewServingCerts() {
        return new ServingCertsNested(null);
    }

    public ServingCertsNested<A> withNewServingCertsLike(APIServerServingCerts item) {
        return new ServingCertsNested(item);
    }

    public ServingCertsNested<A> editServingCerts() {
        return this.withNewServingCertsLike(Optional.ofNullable(this.buildServingCerts()).orElse(null));
    }

    public ServingCertsNested<A> editOrNewServingCerts() {
        return this.withNewServingCertsLike(Optional.ofNullable(this.buildServingCerts()).orElse(new APIServerServingCertsBuilder().build()));
    }

    public ServingCertsNested<A> editOrNewServingCertsLike(APIServerServingCerts item) {
        return this.withNewServingCertsLike(Optional.ofNullable(this.buildServingCerts()).orElse(item));
    }

    public TLSSecurityProfile buildTlsSecurityProfile() {
        return this.tlsSecurityProfile != null ? this.tlsSecurityProfile.build() : null;
    }

    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
        this._visitables.remove((Object)this.tlsSecurityProfile);
        if (tlsSecurityProfile != null) {
            this.tlsSecurityProfile = new TLSSecurityProfileBuilder(tlsSecurityProfile);
            this._visitables.get((Object)"tlsSecurityProfile").add(this.tlsSecurityProfile);
        } else {
            this.tlsSecurityProfile = null;
            this._visitables.get((Object)"tlsSecurityProfile").remove((Object)this.tlsSecurityProfile);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    public TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
        return new TlsSecurityProfileNested(null);
    }

    public TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item) {
        return new TlsSecurityProfileNested(item);
    }

    public TlsSecurityProfileNested<A> editTlsSecurityProfile() {
        return this.withNewTlsSecurityProfileLike(Optional.ofNullable(this.buildTlsSecurityProfile()).orElse(null));
    }

    public TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
        return this.withNewTlsSecurityProfileLike(Optional.ofNullable(this.buildTlsSecurityProfile()).orElse(new TLSSecurityProfileBuilder().build()));
    }

    public TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item) {
        return this.withNewTlsSecurityProfileLike(Optional.ofNullable(this.buildTlsSecurityProfile()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerSpecFluent that = (APIServerSpecFluent)((Object)o);
        if (!Objects.equals(this.additionalCORSAllowedOrigins, that.additionalCORSAllowedOrigins)) {
            return false;
        }
        if (!Objects.equals((Object)this.audit, (Object)that.audit)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientCA, (Object)that.clientCA)) {
            return false;
        }
        if (!Objects.equals((Object)this.encryption, (Object)that.encryption)) {
            return false;
        }
        if (!Objects.equals((Object)this.servingCerts, (Object)that.servingCerts)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsSecurityProfile, (Object)that.tlsSecurityProfile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalCORSAllowedOrigins, this.audit, this.clientCA, this.encryption, this.servingCerts, this.tlsSecurityProfile, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalCORSAllowedOrigins != null && !this.additionalCORSAllowedOrigins.isEmpty()) {
            sb.append("additionalCORSAllowedOrigins:");
            sb.append(this.additionalCORSAllowedOrigins + ",");
        }
        if (this.audit != null) {
            sb.append("audit:");
            sb.append((Object)((Object)this.audit) + ",");
        }
        if (this.clientCA != null) {
            sb.append("clientCA:");
            sb.append((Object)((Object)this.clientCA) + ",");
        }
        if (this.encryption != null) {
            sb.append("encryption:");
            sb.append((Object)((Object)this.encryption) + ",");
        }
        if (this.servingCerts != null) {
            sb.append("servingCerts:");
            sb.append((Object)((Object)this.servingCerts) + ",");
        }
        if (this.tlsSecurityProfile != null) {
            sb.append("tlsSecurityProfile:");
            sb.append((Object)((Object)this.tlsSecurityProfile) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsSecurityProfileNested<N>
    extends TLSSecurityProfileFluent<TlsSecurityProfileNested<N>>
    implements Nested<N> {
        TLSSecurityProfileBuilder builder;

        TlsSecurityProfileNested(TLSSecurityProfile item) {
            this.builder = new TLSSecurityProfileBuilder(this, item);
        }

        public N and() {
            return (N)APIServerSpecFluent.this.withTlsSecurityProfile(this.builder.build());
        }

        public N endTlsSecurityProfile() {
            return this.and();
        }
    }

    public class ServingCertsNested<N>
    extends APIServerServingCertsFluent<ServingCertsNested<N>>
    implements Nested<N> {
        APIServerServingCertsBuilder builder;

        ServingCertsNested(APIServerServingCerts item) {
            this.builder = new APIServerServingCertsBuilder(this, item);
        }

        public N and() {
            return (N)APIServerSpecFluent.this.withServingCerts(this.builder.build());
        }

        public N endServingCerts() {
            return this.and();
        }
    }

    public class EncryptionNested<N>
    extends APIServerEncryptionFluent<EncryptionNested<N>>
    implements Nested<N> {
        APIServerEncryptionBuilder builder;

        EncryptionNested(APIServerEncryption item) {
            this.builder = new APIServerEncryptionBuilder(this, item);
        }

        public N and() {
            return (N)APIServerSpecFluent.this.withEncryption(this.builder.build());
        }

        public N endEncryption() {
            return this.and();
        }
    }

    public class ClientCANested<N>
    extends ConfigMapNameReferenceFluent<ClientCANested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        ClientCANested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)APIServerSpecFluent.this.withClientCA(this.builder.build());
        }

        public N endClientCA() {
            return this.and();
        }
    }

    public class AuditNested<N>
    extends AuditFluent<AuditNested<N>>
    implements Nested<N> {
        AuditBuilder builder;

        AuditNested(Audit item) {
            this.builder = new AuditBuilder(this, item);
        }

        public N and() {
            return (N)APIServerSpecFluent.this.withAudit(this.builder.build());
        }

        public N endAudit() {
            return this.and();
        }
    }
}

