/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.GoogleIdentityProvider;
import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.SecretNameReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GoogleIdentityProviderFluent<A extends GoogleIdentityProviderFluent<A>>
extends BaseFluent<A> {
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String hostedDomain;
    private Map<String, Object> additionalProperties;

    public GoogleIdentityProviderFluent() {
    }

    public GoogleIdentityProviderFluent(GoogleIdentityProvider instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GoogleIdentityProvider instance) {
        GoogleIdentityProvider googleIdentityProvider = instance = instance != null ? instance : new GoogleIdentityProvider();
        if (instance != null) {
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withHostedDomain(instance.getHostedDomain());
            this.withClientID(instance.getClientID());
            this.withClientSecret(instance.getClientSecret());
            this.withHostedDomain(instance.getHostedDomain());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)((Object)this);
    }

    public boolean hasClientID() {
        return this.clientID != null;
    }

    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.get((Object)"clientSecret").remove((Object)this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get((Object)"clientSecret").remove((Object)this.clientSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    public ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNested(null);
    }

    public ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNested(item);
    }

    public ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(null));
    }

    public ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(new SecretNameReferenceBuilder().build()));
    }

    public ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(item));
    }

    public String getHostedDomain() {
        return this.hostedDomain;
    }

    public A withHostedDomain(String hostedDomain) {
        this.hostedDomain = hostedDomain;
        return (A)((Object)this);
    }

    public boolean hasHostedDomain() {
        return this.hostedDomain != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GoogleIdentityProviderFluent that = (GoogleIdentityProviderFluent)((Object)o);
        if (!Objects.equals(this.clientID, that.clientID)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientSecret, (Object)that.clientSecret)) {
            return false;
        }
        if (!Objects.equals(this.hostedDomain, that.hostedDomain)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientID, this.clientSecret, this.hostedDomain, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientID != null) {
            sb.append("clientID:");
            sb.append(this.clientID + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append((Object)((Object)this.clientSecret) + ",");
        }
        if (this.hostedDomain != null) {
            sb.append("hostedDomain:");
            sb.append(this.hostedDomain + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientSecretNested<N>
    extends SecretNameReferenceFluent<ClientSecretNested<N>>
    implements Nested<N> {
        SecretNameReferenceBuilder builder;

        ClientSecretNested(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        public N and() {
            return (N)GoogleIdentityProviderFluent.this.withClientSecret(this.builder.build());
        }

        public N endClientSecret() {
            return this.and();
        }
    }
}

