package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerTemplateInstanceSpecBuilder extends BrokerTemplateInstanceSpecFluentImpl<BrokerTemplateInstanceSpecBuilder> implements VisitableBuilder<BrokerTemplateInstanceSpec,BrokerTemplateInstanceSpecBuilder>{
  public BrokerTemplateInstanceSpecBuilder() {
    this(false);
  }
  public BrokerTemplateInstanceSpecBuilder(Boolean validationEnabled) {
    this(new BrokerTemplateInstanceSpec(), validationEnabled);
  }
  public BrokerTemplateInstanceSpecBuilder(BrokerTemplateInstanceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerTemplateInstanceSpecBuilder(BrokerTemplateInstanceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerTemplateInstanceSpec(), validationEnabled);
  }
  public BrokerTemplateInstanceSpecBuilder(BrokerTemplateInstanceSpecFluent<?> fluent,BrokerTemplateInstanceSpec instance) {
    this(fluent, instance, false);
  }
  public BrokerTemplateInstanceSpecBuilder(BrokerTemplateInstanceSpecFluent<?> fluent,BrokerTemplateInstanceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBindingIDs(instance.getBindingIDs()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withTemplateInstance(instance.getTemplateInstance()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BrokerTemplateInstanceSpecBuilder(BrokerTemplateInstanceSpec instance) {
    this(instance,false);
  }
  public BrokerTemplateInstanceSpecBuilder(BrokerTemplateInstanceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBindingIDs(instance.getBindingIDs()); 
    this.withSecret(instance.getSecret()); 
    this.withTemplateInstance(instance.getTemplateInstance()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BrokerTemplateInstanceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerTemplateInstanceSpec build() {
    BrokerTemplateInstanceSpec buildable = new BrokerTemplateInstanceSpec(fluent.getBindingIDs(),fluent.getSecret(),fluent.getTemplateInstance());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}