package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSConfigBuilder extends TLSConfigFluentImpl<TLSConfigBuilder> implements VisitableBuilder<TLSConfig,TLSConfigBuilder>{
  public TLSConfigBuilder() {
    this(false);
  }
  public TLSConfigBuilder(Boolean validationEnabled) {
    this(new TLSConfig(), validationEnabled);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSConfig(), validationEnabled);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,TLSConfig instance) {
    this(fluent, instance, false);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,TLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCaCertificate(instance.getCaCertificate()); 
    fluent.withCertificate(instance.getCertificate()); 
    fluent.withDestinationCACertificate(instance.getDestinationCACertificate()); 
    fluent.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy()); 
    fluent.withKey(instance.getKey()); 
    fluent.withTermination(instance.getTermination()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TLSConfigBuilder(TLSConfig instance) {
    this(instance,false);
  }
  public TLSConfigBuilder(TLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCaCertificate(instance.getCaCertificate()); 
    this.withCertificate(instance.getCertificate()); 
    this.withDestinationCACertificate(instance.getDestinationCACertificate()); 
    this.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy()); 
    this.withKey(instance.getKey()); 
    this.withTermination(instance.getTermination()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public TLSConfig build() {
    TLSConfig buildable = new TLSConfig(fluent.getCaCertificate(),fluent.getCertificate(),fluent.getDestinationCACertificate(),fluent.getInsecureEdgeTerminationPolicy(),fluent.getKey(),fluent.getTermination());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}