package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSecurityPolicyReviewStatusFluentImpl<A extends PodSecurityPolicyReviewStatusFluent<A>> extends BaseFluent<A> implements PodSecurityPolicyReviewStatusFluent<A>{
  public PodSecurityPolicyReviewStatusFluentImpl() {
  }
  public PodSecurityPolicyReviewStatusFluentImpl(PodSecurityPolicyReviewStatus instance) {
    this.withAllowedServiceAccounts(instance.getAllowedServiceAccounts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder> allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAllowedServiceAccounts(Integer index,ServiceAccountPodSecurityPolicyReviewStatus item) {
    if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(index >= 0 ? index : _visitables.get("allowedServiceAccounts").size(), builder);this.allowedServiceAccounts.add(index >= 0 ? index : allowedServiceAccounts.size(), builder); return (A)this;
  }
  public A setToAllowedServiceAccounts(Integer index,ServiceAccountPodSecurityPolicyReviewStatus item) {
    if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedServiceAccounts").size()) { _visitables.get("allowedServiceAccounts").add(builder); } else { _visitables.get("allowedServiceAccounts").set(index, builder);}
    if (index < 0 || index >= allowedServiceAccounts.size()) { allowedServiceAccounts.add(builder); } else { allowedServiceAccounts.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedServiceAccounts(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus... items) {
    if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
    for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(builder);this.allowedServiceAccounts.add(builder);} return (A)this;
  }
  public A addAllToAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items) {
    if (this.allowedServiceAccounts == null) {this.allowedServiceAccounts = new ArrayList<ServiceAccountPodSecurityPolicyReviewStatusBuilder>();}
    for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").add(builder);this.allowedServiceAccounts.add(builder);} return (A)this;
  }
  public A removeFromAllowedServiceAccounts(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus... items) {
    for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").remove(builder);if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedServiceAccounts(Collection<ServiceAccountPodSecurityPolicyReviewStatus> items) {
    for (ServiceAccountPodSecurityPolicyReviewStatus item : items) {ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(item);_visitables.get("allowedServiceAccounts").remove(builder);if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedServiceAccounts(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
    if (allowedServiceAccounts == null) return (A) this;
    final Iterator<ServiceAccountPodSecurityPolicyReviewStatusBuilder> each = allowedServiceAccounts.iterator();
    final List visitables = _visitables.get("allowedServiceAccounts");
    while (each.hasNext()) {
      ServiceAccountPodSecurityPolicyReviewStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedServiceAccounts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceAccountPodSecurityPolicyReviewStatus> getAllowedServiceAccounts() {
    return allowedServiceAccounts != null ? build(allowedServiceAccounts) : null;
  }
  public List<ServiceAccountPodSecurityPolicyReviewStatus> buildAllowedServiceAccounts() {
    return allowedServiceAccounts != null ? build(allowedServiceAccounts) : null;
  }
  public ServiceAccountPodSecurityPolicyReviewStatus buildAllowedServiceAccount(Integer index) {
    return this.allowedServiceAccounts.get(index).build();
  }
  public ServiceAccountPodSecurityPolicyReviewStatus buildFirstAllowedServiceAccount() {
    return this.allowedServiceAccounts.get(0).build();
  }
  public ServiceAccountPodSecurityPolicyReviewStatus buildLastAllowedServiceAccount() {
    return this.allowedServiceAccounts.get(allowedServiceAccounts.size() - 1).build();
  }
  public ServiceAccountPodSecurityPolicyReviewStatus buildMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
    for (ServiceAccountPodSecurityPolicyReviewStatusBuilder item: allowedServiceAccounts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
    for (ServiceAccountPodSecurityPolicyReviewStatusBuilder item: allowedServiceAccounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedServiceAccounts(List<ServiceAccountPodSecurityPolicyReviewStatus> allowedServiceAccounts) {
    if (this.allowedServiceAccounts != null) { _visitables.get("allowedServiceAccounts").removeAll(this.allowedServiceAccounts);}
    if (allowedServiceAccounts != null) {this.allowedServiceAccounts = new ArrayList(); for (ServiceAccountPodSecurityPolicyReviewStatus item : allowedServiceAccounts){this.addToAllowedServiceAccounts(item);}} else { this.allowedServiceAccounts = null;} return (A) this;
  }
  public A withAllowedServiceAccounts(io.fabric8.openshift.api.model.ServiceAccountPodSecurityPolicyReviewStatus... allowedServiceAccounts) {
    if (this.allowedServiceAccounts != null) {this.allowedServiceAccounts.clear();}
    if (allowedServiceAccounts != null) {for (ServiceAccountPodSecurityPolicyReviewStatus item :allowedServiceAccounts){ this.addToAllowedServiceAccounts(item);}} return (A) this;
  }
  public Boolean hasAllowedServiceAccounts() {
    return allowedServiceAccounts != null && !allowedServiceAccounts.isEmpty();
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccount() {
    return new PodSecurityPolicyReviewStatusFluentImpl.AllowedServiceAccountsNestedImpl();
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> addNewAllowedServiceAccountLike(ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new PodSecurityPolicyReviewStatusFluentImpl.AllowedServiceAccountsNestedImpl(-1, item);
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> setNewAllowedServiceAccountLike(Integer index,ServiceAccountPodSecurityPolicyReviewStatus item) {
    return new PodSecurityPolicyReviewStatusFluentImpl.AllowedServiceAccountsNestedImpl(index, item);
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editAllowedServiceAccount(Integer index) {
    if (allowedServiceAccounts.size() <= index) throw new RuntimeException("Can't edit allowedServiceAccounts. Index exceeds size.");
    return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editFirstAllowedServiceAccount() {
    if (allowedServiceAccounts.size() == 0) throw new RuntimeException("Can't edit first allowedServiceAccounts. The list is empty.");
    return setNewAllowedServiceAccountLike(0, buildAllowedServiceAccount(0));
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editLastAllowedServiceAccount() {
    int index = allowedServiceAccounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedServiceAccounts. The list is empty.");
    return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
  }
  public PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<A> editMatchingAllowedServiceAccount(Predicate<ServiceAccountPodSecurityPolicyReviewStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedServiceAccounts.size();i++) { 
    if (predicate.test(allowedServiceAccounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedServiceAccounts. No match found.");
    return setNewAllowedServiceAccountLike(index, buildAllowedServiceAccount(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSecurityPolicyReviewStatusFluentImpl that = (PodSecurityPolicyReviewStatusFluentImpl) o;
    if (allowedServiceAccounts != null ? !allowedServiceAccounts.equals(that.allowedServiceAccounts) :that.allowedServiceAccounts != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowedServiceAccounts,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedServiceAccounts != null && !allowedServiceAccounts.isEmpty()) { sb.append("allowedServiceAccounts:"); sb.append(allowedServiceAccounts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AllowedServiceAccountsNestedImpl<N> extends ServiceAccountPodSecurityPolicyReviewStatusFluentImpl<PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>> implements PodSecurityPolicyReviewStatusFluent.AllowedServiceAccountsNested<N>,Nested<N>{
    AllowedServiceAccountsNestedImpl(Integer index,ServiceAccountPodSecurityPolicyReviewStatus item) {
      this.index = index;
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this, item);
    }
    AllowedServiceAccountsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceAccountPodSecurityPolicyReviewStatusBuilder(this);
    }
    ServiceAccountPodSecurityPolicyReviewStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSecurityPolicyReviewStatusFluentImpl.this.setToAllowedServiceAccounts(index,builder.build());
    }
    public N endAllowedServiceAccount() {
      return and();
    }
    
  }
  
}