package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OAuthAuthorizeTokenFluentImpl<A extends OAuthAuthorizeTokenFluent<A>> extends BaseFluent<A> implements OAuthAuthorizeTokenFluent<A>{
  public OAuthAuthorizeTokenFluentImpl() {
  }
  public OAuthAuthorizeTokenFluentImpl(OAuthAuthorizeToken instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withClientName(instance.getClientName()); 
    this.withCodeChallenge(instance.getCodeChallenge()); 
    this.withCodeChallengeMethod(instance.getCodeChallengeMethod()); 
    this.withExpiresIn(instance.getExpiresIn()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRedirectURI(instance.getRedirectURI()); 
    this.withScopes(instance.getScopes()); 
    this.withState(instance.getState()); 
    this.withUserName(instance.getUserName()); 
    this.withUserUID(instance.getUserUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String clientName;
  private String codeChallenge;
  private String codeChallengeMethod;
  private Long expiresIn;
  private String kind;
  private ObjectMetaBuilder metadata;
  private String redirectURI;
  private List<String> scopes = new ArrayList<String>();
  private String state;
  private String userName;
  private String userUID;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getClientName() {
    return this.clientName;
  }
  public A withClientName(String clientName) {
    this.clientName=clientName; return (A) this;
  }
  public Boolean hasClientName() {
    return this.clientName != null;
  }
  public String getCodeChallenge() {
    return this.codeChallenge;
  }
  public A withCodeChallenge(String codeChallenge) {
    this.codeChallenge=codeChallenge; return (A) this;
  }
  public Boolean hasCodeChallenge() {
    return this.codeChallenge != null;
  }
  public String getCodeChallengeMethod() {
    return this.codeChallengeMethod;
  }
  public A withCodeChallengeMethod(String codeChallengeMethod) {
    this.codeChallengeMethod=codeChallengeMethod; return (A) this;
  }
  public Boolean hasCodeChallengeMethod() {
    return this.codeChallengeMethod != null;
  }
  public Long getExpiresIn() {
    return this.expiresIn;
  }
  public A withExpiresIn(Long expiresIn) {
    this.expiresIn=expiresIn; return (A) this;
  }
  public Boolean hasExpiresIn() {
    return this.expiresIn != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadata() {
    return new OAuthAuthorizeTokenFluentImpl.MetadataNestedImpl();
  }
  public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new OAuthAuthorizeTokenFluentImpl.MetadataNestedImpl(item);
  }
  public OAuthAuthorizeTokenFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public String getRedirectURI() {
    return this.redirectURI;
  }
  public A withRedirectURI(String redirectURI) {
    this.redirectURI=redirectURI; return (A) this;
  }
  public Boolean hasRedirectURI() {
    return this.redirectURI != null;
  }
  public A addToScopes(Integer index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  public A setToScopes(Integer index,String item) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    this.scopes.set(index, item); return (A)this;
  }
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A addAllToScopes(Collection<String> items) {
    if (this.scopes == null) {this.scopes = new ArrayList<String>();}
    for (String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A removeFromScopes(java.lang.String... items) {
    for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public A removeAllFromScopes(Collection<String> items) {
    for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public List<String> getScopes() {
    return this.scopes;
  }
  public String getScope(Integer index) {
    return this.scopes.get(index);
  }
  public String getFirstScope() {
    return this.scopes.get(0);
  }
  public String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  public String getMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingScope(Predicate<String> predicate) {
    for (String item: scopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopes(List<String> scopes) {
    if (scopes != null) {this.scopes = new ArrayList(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
  }
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear();}
    if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  public Boolean hasScopes() {
    return scopes != null && !scopes.isEmpty();
  }
  public String getState() {
    return this.state;
  }
  public A withState(String state) {
    this.state=state; return (A) this;
  }
  public Boolean hasState() {
    return this.state != null;
  }
  public String getUserName() {
    return this.userName;
  }
  public A withUserName(String userName) {
    this.userName=userName; return (A) this;
  }
  public Boolean hasUserName() {
    return this.userName != null;
  }
  public String getUserUID() {
    return this.userUID;
  }
  public A withUserUID(String userUID) {
    this.userUID=userUID; return (A) this;
  }
  public Boolean hasUserUID() {
    return this.userUID != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuthAuthorizeTokenFluentImpl that = (OAuthAuthorizeTokenFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (clientName != null ? !clientName.equals(that.clientName) :that.clientName != null) return false;
    if (codeChallenge != null ? !codeChallenge.equals(that.codeChallenge) :that.codeChallenge != null) return false;
    if (codeChallengeMethod != null ? !codeChallengeMethod.equals(that.codeChallengeMethod) :that.codeChallengeMethod != null) return false;
    if (expiresIn != null ? !expiresIn.equals(that.expiresIn) :that.expiresIn != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (redirectURI != null ? !redirectURI.equals(that.redirectURI) :that.redirectURI != null) return false;
    if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
    if (state != null ? !state.equals(that.state) :that.state != null) return false;
    if (userName != null ? !userName.equals(that.userName) :that.userName != null) return false;
    if (userUID != null ? !userUID.equals(that.userUID) :that.userUID != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clientName,  codeChallenge,  codeChallengeMethod,  expiresIn,  kind,  metadata,  redirectURI,  scopes,  state,  userName,  userUID,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (clientName != null) { sb.append("clientName:"); sb.append(clientName + ","); }
    if (codeChallenge != null) { sb.append("codeChallenge:"); sb.append(codeChallenge + ","); }
    if (codeChallengeMethod != null) { sb.append("codeChallengeMethod:"); sb.append(codeChallengeMethod + ","); }
    if (expiresIn != null) { sb.append("expiresIn:"); sb.append(expiresIn + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (redirectURI != null) { sb.append("redirectURI:"); sb.append(redirectURI + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (userName != null) { sb.append("userName:"); sb.append(userName + ","); }
    if (userUID != null) { sb.append("userUID:"); sb.append(userUID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<OAuthAuthorizeTokenFluent.MetadataNested<N>> implements OAuthAuthorizeTokenFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) OAuthAuthorizeTokenFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}