package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomDeploymentStrategyParamsFluentImpl<A extends CustomDeploymentStrategyParamsFluent<A>> extends BaseFluent<A> implements CustomDeploymentStrategyParamsFluent<A>{
  public CustomDeploymentStrategyParamsFluentImpl() {
  }
  public CustomDeploymentStrategyParamsFluentImpl(CustomDeploymentStrategyParams instance) {
    this.withCommand(instance.getCommand()); 
    this.withEnvironment(instance.getEnvironment()); 
    this.withImage(instance.getImage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> command = new ArrayList<String>();
  private List<EnvVar> environment = new ArrayList<EnvVar>();
  private String image;
  private Map<String,Object> additionalProperties;
  public A addToCommand(Integer index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  public A setToCommand(Integer index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  public A removeFromCommand(java.lang.String... items) {
    for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public A removeAllFromCommand(Collection<String> items) {
    for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public List<String> getCommand() {
    return this.command;
  }
  public String getCommand(Integer index) {
    return this.command.get(index);
  }
  public String getFirstCommand() {
    return this.command.get(0);
  }
  public String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  public String getMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCommand(List<String> command) {
    if (command != null) {this.command = new ArrayList(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
  }
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {this.command.clear();}
    if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
  }
  public Boolean hasCommand() {
    return command != null && !command.isEmpty();
  }
  public A addToEnvironment(Integer index,EnvVar item) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
    this.environment.add(index, item);
    return (A)this;
  }
  public A setToEnvironment(Integer index,EnvVar item) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
    this.environment.set(index, item); return (A)this;
  }
  public A addToEnvironment(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.environment.add(item);} return (A)this;
  }
  public A addAllToEnvironment(Collection<EnvVar> items) {
    if (this.environment == null) {this.environment = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.environment.add(item);} return (A)this;
  }
  public A removeFromEnvironment(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {if (this.environment!= null){ this.environment.remove(item);}} return (A)this;
  }
  public A removeAllFromEnvironment(Collection<EnvVar> items) {
    for (EnvVar item : items) {if (this.environment!= null){ this.environment.remove(item);}} return (A)this;
  }
  public List<EnvVar> getEnvironment() {
    return this.environment;
  }
  public EnvVar getEnvironment(Integer index) {
    return this.environment.get(index);
  }
  public EnvVar getFirstEnvironment() {
    return this.environment.get(0);
  }
  public EnvVar getLastEnvironment() {
    return this.environment.get(environment.size() - 1);
  }
  public EnvVar getMatchingEnvironment(Predicate<EnvVar> predicate) {
    for (EnvVar item: environment) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnvironment(Predicate<EnvVar> predicate) {
    for (EnvVar item: environment) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnvironment(List<EnvVar> environment) {
    if (environment != null) {this.environment = new ArrayList(); for (EnvVar item : environment){this.addToEnvironment(item);}} else { this.environment = null;} return (A) this;
  }
  public A withEnvironment(io.fabric8.kubernetes.api.model.EnvVar... environment) {
    if (this.environment != null) {this.environment.clear();}
    if (environment != null) {for (EnvVar item :environment){ this.addToEnvironment(item);}} return (A) this;
  }
  public Boolean hasEnvironment() {
    return environment != null && !environment.isEmpty();
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomDeploymentStrategyParamsFluentImpl that = (CustomDeploymentStrategyParamsFluentImpl) o;
    if (command != null ? !command.equals(that.command) :that.command != null) return false;
    if (environment != null ? !environment.equals(that.environment) :that.environment != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(command,  environment,  image,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (environment != null && !environment.isEmpty()) { sb.append("environment:"); sb.append(environment + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}