package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomDeploymentStrategyParamsBuilder extends CustomDeploymentStrategyParamsFluentImpl<CustomDeploymentStrategyParamsBuilder> implements VisitableBuilder<CustomDeploymentStrategyParams,CustomDeploymentStrategyParamsBuilder>{
  public CustomDeploymentStrategyParamsBuilder() {
    this(false);
  }
  public CustomDeploymentStrategyParamsBuilder(Boolean validationEnabled) {
    this(new CustomDeploymentStrategyParams(), validationEnabled);
  }
  public CustomDeploymentStrategyParamsBuilder(CustomDeploymentStrategyParamsFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomDeploymentStrategyParamsBuilder(CustomDeploymentStrategyParamsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomDeploymentStrategyParams(), validationEnabled);
  }
  public CustomDeploymentStrategyParamsBuilder(CustomDeploymentStrategyParamsFluent<?> fluent,CustomDeploymentStrategyParams instance) {
    this(fluent, instance, false);
  }
  public CustomDeploymentStrategyParamsBuilder(CustomDeploymentStrategyParamsFluent<?> fluent,CustomDeploymentStrategyParams instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommand(instance.getCommand()); 
    fluent.withEnvironment(instance.getEnvironment()); 
    fluent.withImage(instance.getImage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomDeploymentStrategyParamsBuilder(CustomDeploymentStrategyParams instance) {
    this(instance,false);
  }
  public CustomDeploymentStrategyParamsBuilder(CustomDeploymentStrategyParams instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommand(instance.getCommand()); 
    this.withEnvironment(instance.getEnvironment()); 
    this.withImage(instance.getImage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomDeploymentStrategyParamsFluent<?> fluent;
  Boolean validationEnabled;
  public CustomDeploymentStrategyParams build() {
    CustomDeploymentStrategyParams buildable = new CustomDeploymentStrategyParams(fluent.getCommand(),fluent.getEnvironment(),fluent.getImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}