/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.config.v1.RegistrySources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RegistrySourcesFluent<A extends RegistrySourcesFluent<A>>
extends BaseFluent<A> {
    private List<String> allowedRegistries = new ArrayList<String>();
    private List<String> blockedRegistries = new ArrayList<String>();
    private List<String> containerRuntimeSearchRegistries = new ArrayList<String>();
    private List<String> insecureRegistries = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RegistrySourcesFluent() {
    }

    public RegistrySourcesFluent(RegistrySources instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RegistrySources instance) {
        RegistrySources registrySources = instance = instance != null ? instance : new RegistrySources();
        if (instance != null) {
            this.withAllowedRegistries(instance.getAllowedRegistries());
            this.withBlockedRegistries(instance.getBlockedRegistries());
            this.withContainerRuntimeSearchRegistries(instance.getContainerRuntimeSearchRegistries());
            this.withInsecureRegistries(instance.getInsecureRegistries());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAllowedRegistries(int index, String item) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        this.allowedRegistries.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedRegistries(int index, String item) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        this.allowedRegistries.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedRegistries(String ... items) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedRegistries(Collection<String> items) {
        if (this.allowedRegistries == null) {
            this.allowedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedRegistries(String ... items) {
        if (this.allowedRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedRegistries(Collection<String> items) {
        if (this.allowedRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedRegistries() {
        return this.allowedRegistries;
    }

    public String getAllowedRegistry(int index) {
        return this.allowedRegistries.get(index);
    }

    public String getFirstAllowedRegistry() {
        return this.allowedRegistries.get(0);
    }

    public String getLastAllowedRegistry() {
        return this.allowedRegistries.get(this.allowedRegistries.size() - 1);
    }

    public String getMatchingAllowedRegistry(Predicate<String> predicate) {
        for (String item : this.allowedRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedRegistry(Predicate<String> predicate) {
        for (String item : this.allowedRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedRegistries(List<String> allowedRegistries) {
        if (allowedRegistries != null) {
            this.allowedRegistries = new ArrayList<String>();
            for (String item : allowedRegistries) {
                this.addToAllowedRegistries(item);
            }
        } else {
            this.allowedRegistries = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedRegistries(String ... allowedRegistries) {
        if (this.allowedRegistries != null) {
            this.allowedRegistries.clear();
            this._visitables.remove((Object)"allowedRegistries");
        }
        if (allowedRegistries != null) {
            for (String item : allowedRegistries) {
                this.addToAllowedRegistries(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedRegistries() {
        return this.allowedRegistries != null && !this.allowedRegistries.isEmpty();
    }

    public A addToBlockedRegistries(int index, String item) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        this.blockedRegistries.add(index, item);
        return (A)((Object)this);
    }

    public A setToBlockedRegistries(int index, String item) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        this.blockedRegistries.set(index, item);
        return (A)((Object)this);
    }

    public A addToBlockedRegistries(String ... items) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.blockedRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBlockedRegistries(Collection<String> items) {
        if (this.blockedRegistries == null) {
            this.blockedRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.blockedRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBlockedRegistries(String ... items) {
        if (this.blockedRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.blockedRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBlockedRegistries(Collection<String> items) {
        if (this.blockedRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.blockedRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBlockedRegistries() {
        return this.blockedRegistries;
    }

    public String getBlockedRegistry(int index) {
        return this.blockedRegistries.get(index);
    }

    public String getFirstBlockedRegistry() {
        return this.blockedRegistries.get(0);
    }

    public String getLastBlockedRegistry() {
        return this.blockedRegistries.get(this.blockedRegistries.size() - 1);
    }

    public String getMatchingBlockedRegistry(Predicate<String> predicate) {
        for (String item : this.blockedRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBlockedRegistry(Predicate<String> predicate) {
        for (String item : this.blockedRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBlockedRegistries(List<String> blockedRegistries) {
        if (blockedRegistries != null) {
            this.blockedRegistries = new ArrayList<String>();
            for (String item : blockedRegistries) {
                this.addToBlockedRegistries(item);
            }
        } else {
            this.blockedRegistries = null;
        }
        return (A)((Object)this);
    }

    public A withBlockedRegistries(String ... blockedRegistries) {
        if (this.blockedRegistries != null) {
            this.blockedRegistries.clear();
            this._visitables.remove((Object)"blockedRegistries");
        }
        if (blockedRegistries != null) {
            for (String item : blockedRegistries) {
                this.addToBlockedRegistries(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBlockedRegistries() {
        return this.blockedRegistries != null && !this.blockedRegistries.isEmpty();
    }

    public A addToContainerRuntimeSearchRegistries(int index, String item) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        this.containerRuntimeSearchRegistries.add(index, item);
        return (A)((Object)this);
    }

    public A setToContainerRuntimeSearchRegistries(int index, String item) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        this.containerRuntimeSearchRegistries.set(index, item);
        return (A)((Object)this);
    }

    public A addToContainerRuntimeSearchRegistries(String ... items) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerRuntimeSearchRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToContainerRuntimeSearchRegistries(Collection<String> items) {
        if (this.containerRuntimeSearchRegistries == null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerRuntimeSearchRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromContainerRuntimeSearchRegistries(String ... items) {
        if (this.containerRuntimeSearchRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.containerRuntimeSearchRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainerRuntimeSearchRegistries(Collection<String> items) {
        if (this.containerRuntimeSearchRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.containerRuntimeSearchRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getContainerRuntimeSearchRegistries() {
        return this.containerRuntimeSearchRegistries;
    }

    public String getContainerRuntimeSearchRegistry(int index) {
        return this.containerRuntimeSearchRegistries.get(index);
    }

    public String getFirstContainerRuntimeSearchRegistry() {
        return this.containerRuntimeSearchRegistries.get(0);
    }

    public String getLastContainerRuntimeSearchRegistry() {
        return this.containerRuntimeSearchRegistries.get(this.containerRuntimeSearchRegistries.size() - 1);
    }

    public String getMatchingContainerRuntimeSearchRegistry(Predicate<String> predicate) {
        for (String item : this.containerRuntimeSearchRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingContainerRuntimeSearchRegistry(Predicate<String> predicate) {
        for (String item : this.containerRuntimeSearchRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerRuntimeSearchRegistries(List<String> containerRuntimeSearchRegistries) {
        if (containerRuntimeSearchRegistries != null) {
            this.containerRuntimeSearchRegistries = new ArrayList<String>();
            for (String item : containerRuntimeSearchRegistries) {
                this.addToContainerRuntimeSearchRegistries(item);
            }
        } else {
            this.containerRuntimeSearchRegistries = null;
        }
        return (A)((Object)this);
    }

    public A withContainerRuntimeSearchRegistries(String ... containerRuntimeSearchRegistries) {
        if (this.containerRuntimeSearchRegistries != null) {
            this.containerRuntimeSearchRegistries.clear();
            this._visitables.remove((Object)"containerRuntimeSearchRegistries");
        }
        if (containerRuntimeSearchRegistries != null) {
            for (String item : containerRuntimeSearchRegistries) {
                this.addToContainerRuntimeSearchRegistries(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainerRuntimeSearchRegistries() {
        return this.containerRuntimeSearchRegistries != null && !this.containerRuntimeSearchRegistries.isEmpty();
    }

    public A addToInsecureRegistries(int index, String item) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        this.insecureRegistries.add(index, item);
        return (A)((Object)this);
    }

    public A setToInsecureRegistries(int index, String item) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        this.insecureRegistries.set(index, item);
        return (A)((Object)this);
    }

    public A addToInsecureRegistries(String ... items) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.insecureRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToInsecureRegistries(Collection<String> items) {
        if (this.insecureRegistries == null) {
            this.insecureRegistries = new ArrayList<String>();
        }
        for (String item : items) {
            this.insecureRegistries.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromInsecureRegistries(String ... items) {
        if (this.insecureRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.insecureRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInsecureRegistries(Collection<String> items) {
        if (this.insecureRegistries == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.insecureRegistries.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getInsecureRegistries() {
        return this.insecureRegistries;
    }

    public String getInsecureRegistry(int index) {
        return this.insecureRegistries.get(index);
    }

    public String getFirstInsecureRegistry() {
        return this.insecureRegistries.get(0);
    }

    public String getLastInsecureRegistry() {
        return this.insecureRegistries.get(this.insecureRegistries.size() - 1);
    }

    public String getMatchingInsecureRegistry(Predicate<String> predicate) {
        for (String item : this.insecureRegistries) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingInsecureRegistry(Predicate<String> predicate) {
        for (String item : this.insecureRegistries) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInsecureRegistries(List<String> insecureRegistries) {
        if (insecureRegistries != null) {
            this.insecureRegistries = new ArrayList<String>();
            for (String item : insecureRegistries) {
                this.addToInsecureRegistries(item);
            }
        } else {
            this.insecureRegistries = null;
        }
        return (A)((Object)this);
    }

    public A withInsecureRegistries(String ... insecureRegistries) {
        if (this.insecureRegistries != null) {
            this.insecureRegistries.clear();
            this._visitables.remove((Object)"insecureRegistries");
        }
        if (insecureRegistries != null) {
            for (String item : insecureRegistries) {
                this.addToInsecureRegistries(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInsecureRegistries() {
        return this.insecureRegistries != null && !this.insecureRegistries.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrySourcesFluent that = (RegistrySourcesFluent)((Object)o);
        if (!Objects.equals(this.allowedRegistries, that.allowedRegistries)) {
            return false;
        }
        if (!Objects.equals(this.blockedRegistries, that.blockedRegistries)) {
            return false;
        }
        if (!Objects.equals(this.containerRuntimeSearchRegistries, that.containerRuntimeSearchRegistries)) {
            return false;
        }
        if (!Objects.equals(this.insecureRegistries, that.insecureRegistries)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.allowedRegistries, this.blockedRegistries, this.containerRuntimeSearchRegistries, this.insecureRegistries, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedRegistries != null && !this.allowedRegistries.isEmpty()) {
            sb.append("allowedRegistries:");
            sb.append(this.allowedRegistries + ",");
        }
        if (this.blockedRegistries != null && !this.blockedRegistries.isEmpty()) {
            sb.append("blockedRegistries:");
            sb.append(this.blockedRegistries + ",");
        }
        if (this.containerRuntimeSearchRegistries != null && !this.containerRuntimeSearchRegistries.isEmpty()) {
            sb.append("containerRuntimeSearchRegistries:");
            sb.append(this.containerRuntimeSearchRegistries + ",");
        }
        if (this.insecureRegistries != null && !this.insecureRegistries.isEmpty()) {
            sb.append("insecureRegistries:");
            sb.append(this.insecureRegistries + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

