package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BrokerTemplateInstanceListBuilder extends BrokerTemplateInstanceListFluent<BrokerTemplateInstanceListBuilder> implements VisitableBuilder<BrokerTemplateInstanceList,BrokerTemplateInstanceListBuilder>{
  public BrokerTemplateInstanceListBuilder() {
    this(new BrokerTemplateInstanceList());
  }
  
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent) {
    this(fluent, new BrokerTemplateInstanceList());
  }
  
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent,BrokerTemplateInstanceList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BrokerTemplateInstanceListFluent<?> fluent;
  
  public BrokerTemplateInstanceList build() {
    BrokerTemplateInstanceList buildable = new BrokerTemplateInstanceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}