/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.ScopeRestriction;
import io.fabric8.openshift.api.model.ScopeRestrictionBuilder;
import io.fabric8.openshift.api.model.ScopeRestrictionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OAuthClientFluentImpl<A extends OAuthClientFluent<A>>
extends BaseFluent<A>
implements OAuthClientFluent<A> {
    private Integer accessTokenInactivityTimeoutSeconds;
    private Integer accessTokenMaxAgeSeconds;
    private List<String> additionalSecrets = new ArrayList<String>();
    private String apiVersion;
    private String grantMethod;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> redirectURIs = new ArrayList<String>();
    private Boolean respondWithChallenges;
    private ArrayList<ScopeRestrictionBuilder> scopeRestrictions = new ArrayList();
    private String secret;
    private Map<String, Object> additionalProperties;

    public OAuthClientFluentImpl() {
    }

    public OAuthClientFluentImpl(OAuthClient instance) {
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        this.withAdditionalSecrets(instance.getAdditionalSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withGrantMethod(instance.getGrantMethod());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withScopeRestrictions(instance.getScopeRestrictions());
        this.withSecret(instance.getSecret());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getAccessTokenInactivityTimeoutSeconds() {
        return this.accessTokenInactivityTimeoutSeconds;
    }

    @Override
    public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds) {
        this.accessTokenInactivityTimeoutSeconds = accessTokenInactivityTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasAccessTokenInactivityTimeoutSeconds() {
        return this.accessTokenInactivityTimeoutSeconds != null;
    }

    @Override
    public Integer getAccessTokenMaxAgeSeconds() {
        return this.accessTokenMaxAgeSeconds;
    }

    @Override
    public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds) {
        this.accessTokenMaxAgeSeconds = accessTokenMaxAgeSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasAccessTokenMaxAgeSeconds() {
        return this.accessTokenMaxAgeSeconds != null;
    }

    @Override
    public A addToAdditionalSecrets(Integer index, String item) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        this.additionalSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalSecrets(Integer index, String item) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        this.additionalSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalSecrets(String ... items) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalSecrets(Collection<String> items) {
        if (this.additionalSecrets == null) {
            this.additionalSecrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalSecrets(String ... items) {
        for (String item : items) {
            if (this.additionalSecrets == null) continue;
            this.additionalSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalSecrets(Collection<String> items) {
        for (String item : items) {
            if (this.additionalSecrets == null) continue;
            this.additionalSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalSecrets() {
        return this.additionalSecrets;
    }

    @Override
    public String getAdditionalSecret(Integer index) {
        return this.additionalSecrets.get(index);
    }

    @Override
    public String getFirstAdditionalSecret() {
        return this.additionalSecrets.get(0);
    }

    @Override
    public String getLastAdditionalSecret() {
        return this.additionalSecrets.get(this.additionalSecrets.size() - 1);
    }

    @Override
    public String getMatchingAdditionalSecret(Predicate<String> predicate) {
        for (String item : this.additionalSecrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdditionalSecret(Predicate<String> predicate) {
        for (String item : this.additionalSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdditionalSecrets(List<String> additionalSecrets) {
        if (additionalSecrets != null) {
            this.additionalSecrets = new ArrayList<String>();
            for (String item : additionalSecrets) {
                this.addToAdditionalSecrets(item);
            }
        } else {
            this.additionalSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withAdditionalSecrets(String ... additionalSecrets) {
        if (this.additionalSecrets != null) {
            this.additionalSecrets.clear();
        }
        if (additionalSecrets != null) {
            for (String item : additionalSecrets) {
                this.addToAdditionalSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalSecrets() {
        return this.additionalSecrets != null && !this.additionalSecrets.isEmpty();
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getGrantMethod() {
        return this.grantMethod;
    }

    @Override
    public A withGrantMethod(String grantMethod) {
        this.grantMethod = grantMethod;
        return (A)this;
    }

    @Override
    public Boolean hasGrantMethod() {
        return this.grantMethod != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRedirectURIs(Integer index, String item) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        this.redirectURIs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRedirectURIs(Integer index, String item) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        this.redirectURIs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRedirectURIs(String ... items) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        for (String item : items) {
            this.redirectURIs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRedirectURIs(Collection<String> items) {
        if (this.redirectURIs == null) {
            this.redirectURIs = new ArrayList<String>();
        }
        for (String item : items) {
            this.redirectURIs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRedirectURIs(String ... items) {
        for (String item : items) {
            if (this.redirectURIs == null) continue;
            this.redirectURIs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRedirectURIs(Collection<String> items) {
        for (String item : items) {
            if (this.redirectURIs == null) continue;
            this.redirectURIs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRedirectURIs() {
        return this.redirectURIs;
    }

    @Override
    public String getRedirectURI(Integer index) {
        return this.redirectURIs.get(index);
    }

    @Override
    public String getFirstRedirectURI() {
        return this.redirectURIs.get(0);
    }

    @Override
    public String getLastRedirectURI() {
        return this.redirectURIs.get(this.redirectURIs.size() - 1);
    }

    @Override
    public String getMatchingRedirectURI(Predicate<String> predicate) {
        for (String item : this.redirectURIs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRedirectURI(Predicate<String> predicate) {
        for (String item : this.redirectURIs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRedirectURIs(List<String> redirectURIs) {
        if (redirectURIs != null) {
            this.redirectURIs = new ArrayList<String>();
            for (String item : redirectURIs) {
                this.addToRedirectURIs(item);
            }
        } else {
            this.redirectURIs = null;
        }
        return (A)this;
    }

    @Override
    public A withRedirectURIs(String ... redirectURIs) {
        if (this.redirectURIs != null) {
            this.redirectURIs.clear();
        }
        if (redirectURIs != null) {
            for (String item : redirectURIs) {
                this.addToRedirectURIs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedirectURIs() {
        return this.redirectURIs != null && !this.redirectURIs.isEmpty();
    }

    @Override
    public Boolean getRespondWithChallenges() {
        return this.respondWithChallenges;
    }

    @Override
    public A withRespondWithChallenges(Boolean respondWithChallenges) {
        this.respondWithChallenges = respondWithChallenges;
        return (A)this;
    }

    @Override
    public Boolean hasRespondWithChallenges() {
        return this.respondWithChallenges != null;
    }

    @Override
    public A addToScopeRestrictions(Integer index, ScopeRestriction item) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList();
        }
        ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
        this._visitables.get((Object)"scopeRestrictions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"scopeRestrictions").size(), builder);
        this.scopeRestrictions.add(index >= 0 ? index.intValue() : this.scopeRestrictions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToScopeRestrictions(Integer index, ScopeRestriction item) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList();
        }
        ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"scopeRestrictions").size()) {
            this._visitables.get((Object)"scopeRestrictions").add(builder);
        } else {
            this._visitables.get((Object)"scopeRestrictions").set(index, builder);
        }
        if (index < 0 || index >= this.scopeRestrictions.size()) {
            this.scopeRestrictions.add(builder);
        } else {
            this.scopeRestrictions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToScopeRestrictions(ScopeRestriction ... items) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList();
        }
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").add(builder);
            this.scopeRestrictions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopeRestrictions(Collection<ScopeRestriction> items) {
        if (this.scopeRestrictions == null) {
            this.scopeRestrictions = new ArrayList();
        }
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").add(builder);
            this.scopeRestrictions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopeRestrictions(ScopeRestriction ... items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").remove(builder);
            if (this.scopeRestrictions == null) continue;
            this.scopeRestrictions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.get((Object)"scopeRestrictions").remove(builder);
            if (this.scopeRestrictions == null) continue;
            this.scopeRestrictions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromScopeRestrictions(Predicate<ScopeRestrictionBuilder> predicate) {
        if (this.scopeRestrictions == null) {
            return (A)this;
        }
        Iterator<ScopeRestrictionBuilder> each = this.scopeRestrictions.iterator();
        List visitables = this._visitables.get((Object)"scopeRestrictions");
        while (each.hasNext()) {
            ScopeRestrictionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ScopeRestriction> getScopeRestrictions() {
        return this.scopeRestrictions != null ? OAuthClientFluentImpl.build(this.scopeRestrictions) : null;
    }

    @Override
    public List<ScopeRestriction> buildScopeRestrictions() {
        return this.scopeRestrictions != null ? OAuthClientFluentImpl.build(this.scopeRestrictions) : null;
    }

    @Override
    public ScopeRestriction buildScopeRestriction(Integer index) {
        return this.scopeRestrictions.get(index).build();
    }

    @Override
    public ScopeRestriction buildFirstScopeRestriction() {
        return this.scopeRestrictions.get(0).build();
    }

    @Override
    public ScopeRestriction buildLastScopeRestriction() {
        return this.scopeRestrictions.get(this.scopeRestrictions.size() - 1).build();
    }

    @Override
    public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        for (ScopeRestrictionBuilder item : this.scopeRestrictions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        for (ScopeRestrictionBuilder item : this.scopeRestrictions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions) {
        if (this.scopeRestrictions != null) {
            this._visitables.get((Object)"scopeRestrictions").removeAll(this.scopeRestrictions);
        }
        if (scopeRestrictions != null) {
            this.scopeRestrictions = new ArrayList();
            for (ScopeRestriction item : scopeRestrictions) {
                this.addToScopeRestrictions(item);
            }
        } else {
            this.scopeRestrictions = null;
        }
        return (A)this;
    }

    @Override
    public A withScopeRestrictions(ScopeRestriction ... scopeRestrictions) {
        if (this.scopeRestrictions != null) {
            this.scopeRestrictions.clear();
        }
        if (scopeRestrictions != null) {
            for (ScopeRestriction item : scopeRestrictions) {
                this.addToScopeRestrictions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopeRestrictions() {
        return this.scopeRestrictions != null && !this.scopeRestrictions.isEmpty();
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction() {
        return new ScopeRestrictionsNestedImpl();
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item) {
        return new ScopeRestrictionsNestedImpl(-1, item);
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(Integer index, ScopeRestriction item) {
        return new ScopeRestrictionsNestedImpl(index, item);
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(Integer index) {
        if (this.scopeRestrictions.size() <= index) {
            throw new RuntimeException("Can't edit scopeRestrictions. Index exceeds size.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction() {
        if (this.scopeRestrictions.size() == 0) {
            throw new RuntimeException("Can't edit first scopeRestrictions. The list is empty.");
        }
        return this.setNewScopeRestrictionLike(0, this.buildScopeRestriction(0));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction() {
        int index = this.scopeRestrictions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last scopeRestrictions. The list is empty.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.scopeRestrictions.size(); ++i) {
            if (!predicate.test(this.scopeRestrictions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching scopeRestrictions. No match found.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public A withSecret(String secret) {
        this.secret = secret;
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClientFluentImpl that = (OAuthClientFluentImpl)o;
        if (this.accessTokenInactivityTimeoutSeconds != null ? !this.accessTokenInactivityTimeoutSeconds.equals(that.accessTokenInactivityTimeoutSeconds) : that.accessTokenInactivityTimeoutSeconds != null) {
            return false;
        }
        if (this.accessTokenMaxAgeSeconds != null ? !this.accessTokenMaxAgeSeconds.equals(that.accessTokenMaxAgeSeconds) : that.accessTokenMaxAgeSeconds != null) {
            return false;
        }
        if (this.additionalSecrets != null ? !this.additionalSecrets.equals(that.additionalSecrets) : that.additionalSecrets != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.grantMethod != null ? !this.grantMethod.equals(that.grantMethod) : that.grantMethod != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.redirectURIs != null ? !this.redirectURIs.equals(that.redirectURIs) : that.redirectURIs != null) {
            return false;
        }
        if (this.respondWithChallenges != null ? !this.respondWithChallenges.equals(that.respondWithChallenges) : that.respondWithChallenges != null) {
            return false;
        }
        if (this.scopeRestrictions != null ? !this.scopeRestrictions.equals(that.scopeRestrictions) : that.scopeRestrictions != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.accessTokenInactivityTimeoutSeconds, this.accessTokenMaxAgeSeconds, this.additionalSecrets, this.apiVersion, this.grantMethod, this.kind, this.metadata, this.redirectURIs, this.respondWithChallenges, this.scopeRestrictions, this.secret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessTokenInactivityTimeoutSeconds != null) {
            sb.append("accessTokenInactivityTimeoutSeconds:");
            sb.append(this.accessTokenInactivityTimeoutSeconds + ",");
        }
        if (this.accessTokenMaxAgeSeconds != null) {
            sb.append("accessTokenMaxAgeSeconds:");
            sb.append(this.accessTokenMaxAgeSeconds + ",");
        }
        if (this.additionalSecrets != null && !this.additionalSecrets.isEmpty()) {
            sb.append("additionalSecrets:");
            sb.append(this.additionalSecrets + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.grantMethod != null) {
            sb.append("grantMethod:");
            sb.append(this.grantMethod + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.redirectURIs != null && !this.redirectURIs.isEmpty()) {
            sb.append("redirectURIs:");
            sb.append(this.redirectURIs + ",");
        }
        if (this.respondWithChallenges != null) {
            sb.append("respondWithChallenges:");
            sb.append(this.respondWithChallenges + ",");
        }
        if (this.scopeRestrictions != null && !this.scopeRestrictions.isEmpty()) {
            sb.append("scopeRestrictions:");
            sb.append(this.scopeRestrictions + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withRespondWithChallenges() {
        return this.withRespondWithChallenges(true);
    }

    class ScopeRestrictionsNestedImpl<N>
    extends ScopeRestrictionFluentImpl<OAuthClientFluent.ScopeRestrictionsNested<N>>
    implements OAuthClientFluent.ScopeRestrictionsNested<N>,
    Nested<N> {
        ScopeRestrictionBuilder builder;
        Integer index;

        ScopeRestrictionsNestedImpl(Integer index, ScopeRestriction item) {
            this.index = index;
            this.builder = new ScopeRestrictionBuilder(this, item);
        }

        ScopeRestrictionsNestedImpl() {
            this.index = -1;
            this.builder = new ScopeRestrictionBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientFluentImpl.this.setToScopeRestrictions(this.index, this.builder.build());
        }

        @Override
        public N endScopeRestriction() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthClientFluent.MetadataNested<N>>
    implements OAuthClientFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)OAuthClientFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

