/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageLayer;
import io.fabric8.openshift.api.model.ImageLayerBuilder;
import io.fabric8.openshift.api.model.ImageLayerFluentImpl;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.ImageSignatureFluentImpl;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import io.fabric8.openshift.api.model.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageFluentImpl<A extends ImageFluent<A>>
extends BaseFluent<A>
implements ImageFluent<A> {
    private String apiVersion;
    private String dockerImageConfig;
    private ArrayList<ImageLayerBuilder> dockerImageLayers = new ArrayList();
    private String dockerImageManifest;
    private String dockerImageManifestMediaType;
    private RawExtensionBuilder dockerImageMetadata;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private List<String> dockerImageSignatures = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<ImageSignatureBuilder> signatures = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ImageFluentImpl() {
    }

    public ImageFluentImpl(Image instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDockerImageConfig(instance.getDockerImageConfig());
        this.withDockerImageLayers(instance.getDockerImageLayers());
        this.withDockerImageManifest(instance.getDockerImageManifest());
        this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
        this.withDockerImageMetadata(instance.getDockerImageMetadata());
        this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withDockerImageSignatures(instance.getDockerImageSignatures());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignatures(instance.getSignatures());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getDockerImageConfig() {
        return this.dockerImageConfig;
    }

    @Override
    public A withDockerImageConfig(String dockerImageConfig) {
        this.dockerImageConfig = dockerImageConfig;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageConfig() {
        return this.dockerImageConfig != null;
    }

    @Override
    public A addToDockerImageLayers(Integer index, ImageLayer item) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        ImageLayerBuilder builder = new ImageLayerBuilder(item);
        this._visitables.get((Object)"dockerImageLayers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"dockerImageLayers").size(), builder);
        this.dockerImageLayers.add(index >= 0 ? index.intValue() : this.dockerImageLayers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDockerImageLayers(Integer index, ImageLayer item) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        ImageLayerBuilder builder = new ImageLayerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"dockerImageLayers").size()) {
            this._visitables.get((Object)"dockerImageLayers").add(builder);
        } else {
            this._visitables.get((Object)"dockerImageLayers").set(index, builder);
        }
        if (index < 0 || index >= this.dockerImageLayers.size()) {
            this.dockerImageLayers.add(builder);
        } else {
            this.dockerImageLayers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDockerImageLayers(ImageLayer ... items) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDockerImageLayers(Collection<ImageLayer> items) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageLayers(ImageLayer ... items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").remove(builder);
            if (this.dockerImageLayers == null) continue;
            this.dockerImageLayers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDockerImageLayers(Collection<ImageLayer> items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").remove(builder);
            if (this.dockerImageLayers == null) continue;
            this.dockerImageLayers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDockerImageLayers(Predicate<ImageLayerBuilder> predicate) {
        if (this.dockerImageLayers == null) {
            return (A)this;
        }
        Iterator<ImageLayerBuilder> each = this.dockerImageLayers.iterator();
        List visitables = this._visitables.get((Object)"dockerImageLayers");
        while (each.hasNext()) {
            ImageLayerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageLayer> getDockerImageLayers() {
        return this.dockerImageLayers != null ? ImageFluentImpl.build(this.dockerImageLayers) : null;
    }

    @Override
    public List<ImageLayer> buildDockerImageLayers() {
        return this.dockerImageLayers != null ? ImageFluentImpl.build(this.dockerImageLayers) : null;
    }

    @Override
    public ImageLayer buildDockerImageLayer(Integer index) {
        return this.dockerImageLayers.get(index).build();
    }

    @Override
    public ImageLayer buildFirstDockerImageLayer() {
        return this.dockerImageLayers.get(0).build();
    }

    @Override
    public ImageLayer buildLastDockerImageLayer() {
        return this.dockerImageLayers.get(this.dockerImageLayers.size() - 1).build();
    }

    @Override
    public ImageLayer buildMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        for (ImageLayerBuilder item : this.dockerImageLayers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        for (ImageLayerBuilder item : this.dockerImageLayers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers) {
        if (this.dockerImageLayers != null) {
            this._visitables.get((Object)"dockerImageLayers").removeAll(this.dockerImageLayers);
        }
        if (dockerImageLayers != null) {
            this.dockerImageLayers = new ArrayList();
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        } else {
            this.dockerImageLayers = null;
        }
        return (A)this;
    }

    @Override
    public A withDockerImageLayers(ImageLayer ... dockerImageLayers) {
        if (this.dockerImageLayers != null) {
            this.dockerImageLayers.clear();
        }
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageLayers() {
        return this.dockerImageLayers != null && !this.dockerImageLayers.isEmpty();
    }

    @Override
    public A addNewDockerImageLayer(String mediaType, String name, Long size) {
        return this.addToDockerImageLayers(new ImageLayer(mediaType, name, size));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer() {
        return new DockerImageLayersNestedImpl();
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item) {
        return new DockerImageLayersNestedImpl(-1, item);
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> setNewDockerImageLayerLike(Integer index, ImageLayer item) {
        return new DockerImageLayersNestedImpl(index, item);
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editDockerImageLayer(Integer index) {
        if (this.dockerImageLayers.size() <= index) {
            throw new RuntimeException("Can't edit dockerImageLayers. Index exceeds size.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editFirstDockerImageLayer() {
        if (this.dockerImageLayers.size() == 0) {
            throw new RuntimeException("Can't edit first dockerImageLayers. The list is empty.");
        }
        return this.setNewDockerImageLayerLike(0, this.buildDockerImageLayer(0));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editLastDockerImageLayer() {
        int index = this.dockerImageLayers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dockerImageLayers. The list is empty.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dockerImageLayers.size(); ++i) {
            if (!predicate.test(this.dockerImageLayers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dockerImageLayers. No match found.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    @Override
    public String getDockerImageManifest() {
        return this.dockerImageManifest;
    }

    @Override
    public A withDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageManifest() {
        return this.dockerImageManifest != null;
    }

    @Override
    public String getDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType;
    }

    @Override
    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType) {
        this.dockerImageManifestMediaType = dockerImageManifestMediaType;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType != null;
    }

    @Override
    @Deprecated
    public RawExtension getDockerImageMetadata() {
        return this.dockerImageMetadata != null ? this.dockerImageMetadata.build() : null;
    }

    @Override
    public RawExtension buildDockerImageMetadata() {
        return this.dockerImageMetadata != null ? this.dockerImageMetadata.build() : null;
    }

    @Override
    public A withDockerImageMetadata(RawExtension dockerImageMetadata) {
        this._visitables.get((Object)"dockerImageMetadata").remove(this.dockerImageMetadata);
        if (dockerImageMetadata != null) {
            this.dockerImageMetadata = new RawExtensionBuilder(dockerImageMetadata);
            this._visitables.get((Object)"dockerImageMetadata").add(this.dockerImageMetadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageMetadata() {
        return this.dockerImageMetadata != null;
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadata() {
        return new DockerImageMetadataNestedImpl();
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadataLike(RawExtension item) {
        return new DockerImageMetadataNestedImpl(item);
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> editDockerImageMetadata() {
        return this.withNewDockerImageMetadataLike(this.getDockerImageMetadata());
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadata() {
        return this.withNewDockerImageMetadataLike(this.getDockerImageMetadata() != null ? this.getDockerImageMetadata() : new RawExtensionBuilder().build());
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(RawExtension item) {
        return this.withNewDockerImageMetadataLike(this.getDockerImageMetadata() != null ? this.getDockerImageMetadata() : item);
    }

    @Override
    public String getDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion;
    }

    @Override
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion != null;
    }

    @Override
    public String getDockerImageReference() {
        return this.dockerImageReference;
    }

    @Override
    public A withDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageReference() {
        return this.dockerImageReference != null;
    }

    @Override
    public A addToDockerImageSignatures(Integer index, String item) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        this.dockerImageSignatures.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDockerImageSignatures(Integer index, String item) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        this.dockerImageSignatures.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDockerImageSignatures(String ... items) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDockerImageSignatures(Collection<String> items) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageSignatures(String ... items) {
        for (String item : items) {
            if (this.dockerImageSignatures == null) continue;
            this.dockerImageSignatures.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDockerImageSignatures(Collection<String> items) {
        for (String item : items) {
            if (this.dockerImageSignatures == null) continue;
            this.dockerImageSignatures.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDockerImageSignatures() {
        return this.dockerImageSignatures;
    }

    @Override
    public String getDockerImageSignature(Integer index) {
        return this.dockerImageSignatures.get(index);
    }

    @Override
    public String getFirstDockerImageSignature() {
        return this.dockerImageSignatures.get(0);
    }

    @Override
    public String getLastDockerImageSignature() {
        return this.dockerImageSignatures.get(this.dockerImageSignatures.size() - 1);
    }

    @Override
    public String getMatchingDockerImageSignature(Predicate<String> predicate) {
        for (String item : this.dockerImageSignatures) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDockerImageSignature(Predicate<String> predicate) {
        for (String item : this.dockerImageSignatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDockerImageSignatures(List<String> dockerImageSignatures) {
        if (dockerImageSignatures != null) {
            this.dockerImageSignatures = new ArrayList<String>();
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        } else {
            this.dockerImageSignatures = null;
        }
        return (A)this;
    }

    @Override
    public A withDockerImageSignatures(String ... dockerImageSignatures) {
        if (this.dockerImageSignatures != null) {
            this.dockerImageSignatures.clear();
        }
        if (dockerImageSignatures != null) {
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageSignatures() {
        return this.dockerImageSignatures != null && !this.dockerImageSignatures.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSignatures(Integer index, ImageSignature item) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
        this._visitables.get((Object)"signatures").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"signatures").size(), builder);
        this.signatures.add(index >= 0 ? index.intValue() : this.signatures.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSignatures(Integer index, ImageSignature item) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"signatures").size()) {
            this._visitables.get((Object)"signatures").add(builder);
        } else {
            this._visitables.get((Object)"signatures").set(index, builder);
        }
        if (index < 0 || index >= this.signatures.size()) {
            this.signatures.add(builder);
        } else {
            this.signatures.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSignatures(ImageSignature ... items) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").add(builder);
            this.signatures.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSignatures(Collection<ImageSignature> items) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").add(builder);
            this.signatures.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignatures(ImageSignature ... items) {
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").remove(builder);
            if (this.signatures == null) continue;
            this.signatures.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSignatures(Collection<ImageSignature> items) {
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").remove(builder);
            if (this.signatures == null) continue;
            this.signatures.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSignatures(Predicate<ImageSignatureBuilder> predicate) {
        if (this.signatures == null) {
            return (A)this;
        }
        Iterator<ImageSignatureBuilder> each = this.signatures.iterator();
        List visitables = this._visitables.get((Object)"signatures");
        while (each.hasNext()) {
            ImageSignatureBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSignature> getSignatures() {
        return this.signatures != null ? ImageFluentImpl.build(this.signatures) : null;
    }

    @Override
    public List<ImageSignature> buildSignatures() {
        return this.signatures != null ? ImageFluentImpl.build(this.signatures) : null;
    }

    @Override
    public ImageSignature buildSignature(Integer index) {
        return this.signatures.get(index).build();
    }

    @Override
    public ImageSignature buildFirstSignature() {
        return this.signatures.get(0).build();
    }

    @Override
    public ImageSignature buildLastSignature() {
        return this.signatures.get(this.signatures.size() - 1).build();
    }

    @Override
    public ImageSignature buildMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        for (ImageSignatureBuilder item : this.signatures) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        for (ImageSignatureBuilder item : this.signatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSignatures(List<ImageSignature> signatures) {
        if (this.signatures != null) {
            this._visitables.get((Object)"signatures").removeAll(this.signatures);
        }
        if (signatures != null) {
            this.signatures = new ArrayList();
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        } else {
            this.signatures = null;
        }
        return (A)this;
    }

    @Override
    public A withSignatures(ImageSignature ... signatures) {
        if (this.signatures != null) {
            this.signatures.clear();
        }
        if (signatures != null) {
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSignatures() {
        return this.signatures != null && !this.signatures.isEmpty();
    }

    @Override
    public ImageFluent.SignaturesNested<A> addNewSignature() {
        return new SignaturesNestedImpl();
    }

    @Override
    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item) {
        return new SignaturesNestedImpl(-1, item);
    }

    @Override
    public ImageFluent.SignaturesNested<A> setNewSignatureLike(Integer index, ImageSignature item) {
        return new SignaturesNestedImpl(index, item);
    }

    @Override
    public ImageFluent.SignaturesNested<A> editSignature(Integer index) {
        if (this.signatures.size() <= index) {
            throw new RuntimeException("Can't edit signatures. Index exceeds size.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    @Override
    public ImageFluent.SignaturesNested<A> editFirstSignature() {
        if (this.signatures.size() == 0) {
            throw new RuntimeException("Can't edit first signatures. The list is empty.");
        }
        return this.setNewSignatureLike(0, this.buildSignature(0));
    }

    @Override
    public ImageFluent.SignaturesNested<A> editLastSignature() {
        int index = this.signatures.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last signatures. The list is empty.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    @Override
    public ImageFluent.SignaturesNested<A> editMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.signatures.size(); ++i) {
            if (!predicate.test(this.signatures.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching signatures. No match found.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageFluentImpl that = (ImageFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dockerImageConfig != null ? !this.dockerImageConfig.equals(that.dockerImageConfig) : that.dockerImageConfig != null) {
            return false;
        }
        if (this.dockerImageLayers != null ? !this.dockerImageLayers.equals(that.dockerImageLayers) : that.dockerImageLayers != null) {
            return false;
        }
        if (this.dockerImageManifest != null ? !this.dockerImageManifest.equals(that.dockerImageManifest) : that.dockerImageManifest != null) {
            return false;
        }
        if (this.dockerImageManifestMediaType != null ? !this.dockerImageManifestMediaType.equals(that.dockerImageManifestMediaType) : that.dockerImageManifestMediaType != null) {
            return false;
        }
        if (this.dockerImageMetadata != null ? !this.dockerImageMetadata.equals(that.dockerImageMetadata) : that.dockerImageMetadata != null) {
            return false;
        }
        if (this.dockerImageMetadataVersion != null ? !this.dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) : that.dockerImageMetadataVersion != null) {
            return false;
        }
        if (this.dockerImageReference != null ? !this.dockerImageReference.equals(that.dockerImageReference) : that.dockerImageReference != null) {
            return false;
        }
        if (this.dockerImageSignatures != null ? !this.dockerImageSignatures.equals(that.dockerImageSignatures) : that.dockerImageSignatures != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.signatures != null ? !this.signatures.equals(that.signatures) : that.signatures != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dockerImageConfig, this.dockerImageLayers, this.dockerImageManifest, this.dockerImageManifestMediaType, this.dockerImageMetadata, this.dockerImageMetadataVersion, this.dockerImageReference, this.dockerImageSignatures, this.kind, this.metadata, this.signatures, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.dockerImageConfig != null) {
            sb.append("dockerImageConfig:");
            sb.append(this.dockerImageConfig + ",");
        }
        if (this.dockerImageLayers != null && !this.dockerImageLayers.isEmpty()) {
            sb.append("dockerImageLayers:");
            sb.append(this.dockerImageLayers + ",");
        }
        if (this.dockerImageManifest != null) {
            sb.append("dockerImageManifest:");
            sb.append(this.dockerImageManifest + ",");
        }
        if (this.dockerImageManifestMediaType != null) {
            sb.append("dockerImageManifestMediaType:");
            sb.append(this.dockerImageManifestMediaType + ",");
        }
        if (this.dockerImageMetadata != null) {
            sb.append("dockerImageMetadata:");
            sb.append(this.dockerImageMetadata + ",");
        }
        if (this.dockerImageMetadataVersion != null) {
            sb.append("dockerImageMetadataVersion:");
            sb.append(this.dockerImageMetadataVersion + ",");
        }
        if (this.dockerImageReference != null) {
            sb.append("dockerImageReference:");
            sb.append(this.dockerImageReference + ",");
        }
        if (this.dockerImageSignatures != null && !this.dockerImageSignatures.isEmpty()) {
            sb.append("dockerImageSignatures:");
            sb.append(this.dockerImageSignatures + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.signatures != null && !this.signatures.isEmpty()) {
            sb.append("signatures:");
            sb.append(this.signatures + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SignaturesNestedImpl<N>
    extends ImageSignatureFluentImpl<ImageFluent.SignaturesNested<N>>
    implements ImageFluent.SignaturesNested<N>,
    Nested<N> {
        ImageSignatureBuilder builder;
        Integer index;

        SignaturesNestedImpl(Integer index, ImageSignature item) {
            this.index = index;
            this.builder = new ImageSignatureBuilder(this, item);
        }

        SignaturesNestedImpl() {
            this.index = -1;
            this.builder = new ImageSignatureBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.setToSignatures(this.index, this.builder.build());
        }

        @Override
        public N endSignature() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageFluent.MetadataNested<N>>
    implements ImageFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class DockerImageMetadataNestedImpl<N>
    extends RawExtensionFluentImpl<ImageFluent.DockerImageMetadataNested<N>>
    implements ImageFluent.DockerImageMetadataNested<N>,
    Nested<N> {
        RawExtensionBuilder builder;

        DockerImageMetadataNestedImpl(RawExtension item) {
            this.builder = new RawExtensionBuilder(this, item);
        }

        DockerImageMetadataNestedImpl() {
            this.builder = new RawExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.withDockerImageMetadata(this.builder.build());
        }

        @Override
        public N endDockerImageMetadata() {
            return this.and();
        }
    }

    class DockerImageLayersNestedImpl<N>
    extends ImageLayerFluentImpl<ImageFluent.DockerImageLayersNested<N>>
    implements ImageFluent.DockerImageLayersNested<N>,
    Nested<N> {
        ImageLayerBuilder builder;
        Integer index;

        DockerImageLayersNestedImpl(Integer index, ImageLayer item) {
            this.index = index;
            this.builder = new ImageLayerBuilder(this, item);
        }

        DockerImageLayersNestedImpl() {
            this.index = -1;
            this.builder = new ImageLayerBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.setToDockerImageLayers(this.index, this.builder.build());
        }

        @Override
        public N endDockerImageLayer() {
            return this.and();
        }
    }
}

