/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagFluent;
import io.fabric8.openshift.api.model.ImageTagFluentImpl;
import java.util.Objects;

public class ImageTagBuilder
extends ImageTagFluentImpl<ImageTagBuilder>
implements VisitableBuilder<ImageTag, ImageTagBuilder> {
    ImageTagFluent<?> fluent;
    Boolean validationEnabled;

    public ImageTagBuilder() {
        this(false);
    }

    public ImageTagBuilder(Boolean validationEnabled) {
        this(new ImageTag(), validationEnabled);
    }

    public ImageTagBuilder(ImageTagFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ImageTagBuilder(ImageTagFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageTag(), validationEnabled);
    }

    public ImageTagBuilder(ImageTagFluent<?> fluent, ImageTag instance) {
        this(fluent, instance, false);
    }

    public ImageTagBuilder(ImageTagFluent<?> fluent, ImageTag instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withImage(instance.getImage());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ImageTagBuilder(ImageTag instance) {
        this(instance, (Boolean)false);
    }

    public ImageTagBuilder(ImageTag instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withImage(instance.getImage());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ImageTag build() {
        ImageTag buildable = new ImageTag(this.fluent.getApiVersion(), this.fluent.getImage(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageTagBuilder that = (ImageTagBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

