/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.TokenConfig;
import io.fabric8.openshift.api.model.TokenConfigFluent;
import io.fabric8.openshift.api.model.TokenConfigFluentImpl;
import java.util.Objects;

public class TokenConfigBuilder
extends TokenConfigFluentImpl<TokenConfigBuilder>
implements VisitableBuilder<TokenConfig, TokenConfigBuilder> {
    TokenConfigFluent<?> fluent;
    Boolean validationEnabled;

    public TokenConfigBuilder() {
        this(true);
    }

    public TokenConfigBuilder(Boolean validationEnabled) {
        this(new TokenConfig(), validationEnabled);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TokenConfig(), validationEnabled);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent, TokenConfig instance) {
        this(fluent, instance, true);
    }

    public TokenConfigBuilder(TokenConfigFluent<?> fluent, TokenConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
        fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        this.validationEnabled = validationEnabled;
    }

    public TokenConfigBuilder(TokenConfig instance) {
        this(instance, (Boolean)true);
    }

    public TokenConfigBuilder(TokenConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAccessTokenInactivityTimeout(instance.getAccessTokenInactivityTimeout());
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        this.validationEnabled = validationEnabled;
    }

    public TokenConfig build() {
        TokenConfig buildable = new TokenConfig(this.fluent.getAccessTokenInactivityTimeout(), this.fluent.getAccessTokenInactivityTimeoutSeconds(), this.fluent.getAccessTokenMaxAgeSeconds());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenConfigBuilder that = (TokenConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

