/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl;

public class DeploymentConfigSpecBuilder
extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder>
implements VisitableBuilder<DeploymentConfigSpec, DeploymentConfigSpecBuilder> {
    DeploymentConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigSpecBuilder() {
        this(true);
    }

    public DeploymentConfigSpecBuilder(Boolean validationEnabled) {
        this(new DeploymentConfigSpec(), validationEnabled);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentConfigSpec(), validationEnabled);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, DeploymentConfigSpec instance) {
        this(fluent, instance, true);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, DeploymentConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.getPaused());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTest(instance.getTest());
        fluent.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTest(instance.getTest());
        this.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigSpec build() {
        DeploymentConfigSpec buildable = new DeploymentConfigSpec(this.fluent.getMinReadySeconds(), this.fluent.isPaused(), this.fluent.getReplicas(), this.fluent.getRevisionHistoryLimit(), this.fluent.getSelector(), this.fluent.getStrategy(), this.fluent.getTemplate(), this.fluent.isTest(), this.fluent.getTriggers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigSpecBuilder that = (DeploymentConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

