package io.fabric8.openshift.api.model.operatorhub.packages.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeprecationBuilder extends DeprecationFluent<DeprecationBuilder> implements VisitableBuilder<Deprecation,DeprecationBuilder>{
  public DeprecationBuilder() {
    this(new Deprecation());
  }
  
  public DeprecationBuilder(DeprecationFluent<?> fluent) {
    this(fluent, new Deprecation());
  }
  
  public DeprecationBuilder(DeprecationFluent<?> fluent,Deprecation instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeprecationBuilder(Deprecation instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeprecationFluent<?> fluent;
  
  public Deprecation build() {
    Deprecation buildable = new Deprecation(fluent.getMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}