/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceSpec;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceSpecFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Icon;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.IconBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.IconFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.UpdateStrategy;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.UpdateStrategyBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.UpdateStrategyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CatalogSourceSpecFluentImpl<A extends CatalogSourceSpecFluent<A>>
extends BaseFluent<A>
implements CatalogSourceSpecFluent<A> {
    private String address;
    private String configMap;
    private String description;
    private String displayName;
    private IconBuilder icon;
    private String image;
    private Integer priority;
    private String publisher;
    private List<String> secrets = new ArrayList<String>();
    private String sourceType;
    private UpdateStrategyBuilder updateStrategy;
    private Map<String, Object> additionalProperties;

    public CatalogSourceSpecFluentImpl() {
    }

    public CatalogSourceSpecFluentImpl(CatalogSourceSpec instance) {
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withConfigMap(instance.getConfigMap());
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withIcon(instance.getIcon());
            this.withImage(instance.getImage());
            this.withPriority(instance.getPriority());
            this.withPublisher(instance.getPublisher());
            this.withSecrets(instance.getSecrets());
            this.withSourceType(instance.getSourceType());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public A withAddress(String address) {
        this.address = address;
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public String getConfigMap() {
        return this.configMap;
    }

    @Override
    public A withConfigMap(String configMap) {
        this.configMap = configMap;
        return (A)this;
    }

    @Override
    public Boolean hasConfigMap() {
        return this.configMap != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    @Override
    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Override
    @Deprecated
    public Icon getIcon() {
        return this.icon != null ? this.icon.build() : null;
    }

    @Override
    public Icon buildIcon() {
        return this.icon != null ? this.icon.build() : null;
    }

    @Override
    public A withIcon(Icon icon) {
        this._visitables.get((Object)"icon").remove(this.icon);
        if (icon != null) {
            this.icon = new IconBuilder(icon);
            this._visitables.get((Object)"icon").add(this.icon);
        } else {
            this.icon = null;
            this._visitables.get((Object)"icon").remove(this.icon);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public A withNewIcon(String base64data, String mediatype) {
        return this.withIcon(new Icon(base64data, mediatype));
    }

    @Override
    public CatalogSourceSpecFluent.IconNested<A> withNewIcon() {
        return new IconNestedImpl();
    }

    @Override
    public CatalogSourceSpecFluent.IconNested<A> withNewIconLike(Icon item) {
        return new IconNestedImpl(item);
    }

    @Override
    public CatalogSourceSpecFluent.IconNested<A> editIcon() {
        return this.withNewIconLike(this.getIcon());
    }

    @Override
    public CatalogSourceSpecFluent.IconNested<A> editOrNewIcon() {
        return this.withNewIconLike(this.getIcon() != null ? this.getIcon() : new IconBuilder().build());
    }

    @Override
    public CatalogSourceSpecFluent.IconNested<A> editOrNewIconLike(Icon item) {
        return this.withNewIconLike(this.getIcon() != null ? this.getIcon() : item);
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getPublisher() {
        return this.publisher;
    }

    @Override
    public A withPublisher(String publisher) {
        this.publisher = publisher;
        return (A)this;
    }

    @Override
    public Boolean hasPublisher() {
        return this.publisher != null;
    }

    @Override
    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(String ... items) {
        for (String item : items) {
            if (this.secrets == null) continue;
            this.secrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<String> items) {
        for (String item : items) {
            if (this.secrets == null) continue;
            this.secrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSecrets() {
        return this.secrets;
    }

    @Override
    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    @Override
    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    @Override
    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    @Override
    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<String> secrets) {
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove((Object)"secrets");
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    public A withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return (A)this;
    }

    @Override
    public Boolean hasSourceType() {
        return this.sourceType != null;
    }

    @Override
    @Deprecated
    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public UpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(UpdateStrategy updateStrategy) {
        this._visitables.get((Object)"updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new UpdateStrategyBuilder(updateStrategy);
            this._visitables.get((Object)"updateStrategy").add(this.updateStrategy);
        } else {
            this.updateStrategy = null;
            this._visitables.get((Object)"updateStrategy").remove(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new UpdateStrategyBuilder().build());
    }

    @Override
    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogSourceSpecFluentImpl that = (CatalogSourceSpecFluentImpl)o;
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.icon, that.icon)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.publisher, that.publisher)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.sourceType, that.sourceType)) {
            return false;
        }
        if (!Objects.equals(this.updateStrategy, that.updateStrategy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.configMap, this.description, this.displayName, this.icon, this.image, this.priority, this.publisher, this.secrets, this.sourceType, this.updateStrategy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(this.configMap + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.icon != null) {
            sb.append("icon:");
            sb.append(this.icon + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.publisher != null) {
            sb.append("publisher:");
            sb.append(this.publisher + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.sourceType != null) {
            sb.append("sourceType:");
            sb.append(this.sourceType + ",");
        }
        if (this.updateStrategy != null) {
            sb.append("updateStrategy:");
            sb.append(this.updateStrategy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class UpdateStrategyNestedImpl<N>
    extends UpdateStrategyFluentImpl<CatalogSourceSpecFluent.UpdateStrategyNested<N>>
    implements CatalogSourceSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        UpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(UpdateStrategy item) {
            this.builder = new UpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new UpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)CatalogSourceSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    class IconNestedImpl<N>
    extends IconFluentImpl<CatalogSourceSpecFluent.IconNested<N>>
    implements CatalogSourceSpecFluent.IconNested<N>,
    Nested<N> {
        IconBuilder builder;

        IconNestedImpl(Icon item) {
            this.builder = new IconBuilder(this, item);
        }

        IconNestedImpl() {
            this.builder = new IconBuilder(this);
        }

        @Override
        public N and() {
            return (N)CatalogSourceSpecFluentImpl.this.withIcon(this.builder.build());
        }

        @Override
        public N endIcon() {
            return this.and();
        }
    }
}

