package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RelatedImageBuilder extends RelatedImageFluentImpl<RelatedImageBuilder> implements VisitableBuilder<RelatedImage,RelatedImageBuilder>{
  public RelatedImageBuilder() {
    this(false);
  }
  public RelatedImageBuilder(Boolean validationEnabled) {
    this(new RelatedImage(), validationEnabled);
  }
  public RelatedImageBuilder(RelatedImageFluent<?> fluent) {
    this(fluent, false);
  }
  public RelatedImageBuilder(RelatedImageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RelatedImage(), validationEnabled);
  }
  public RelatedImageBuilder(RelatedImageFluent<?> fluent,RelatedImage instance) {
    this(fluent, instance, false);
  }
  public RelatedImageBuilder(RelatedImageFluent<?> fluent,RelatedImage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImage(instance.getImage()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RelatedImageBuilder(RelatedImage instance) {
    this(instance,false);
  }
  public RelatedImageBuilder(RelatedImage instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withImage(instance.getImage()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RelatedImageFluent<?> fluent;
  Boolean validationEnabled;
  public RelatedImage build() {
    RelatedImage buildable = new RelatedImage(fluent.getImage(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}