package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorGroupSpecBuilder extends OperatorGroupSpecFluentImpl<OperatorGroupSpecBuilder> implements VisitableBuilder<OperatorGroupSpec,OperatorGroupSpecBuilder>{
  public OperatorGroupSpecBuilder() {
    this(false);
  }
  public OperatorGroupSpecBuilder(Boolean validationEnabled) {
    this(new OperatorGroupSpec(), validationEnabled);
  }
  public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorGroupSpec(), validationEnabled);
  }
  public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,OperatorGroupSpec instance) {
    this(fluent, instance, false);
  }
  public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,OperatorGroupSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSelector(instance.getSelector()); 
    fluent.withServiceAccountName(instance.getServiceAccountName()); 
    fluent.withStaticProvidedAPIs(instance.getStaticProvidedAPIs()); 
    fluent.withTargetNamespaces(instance.getTargetNamespaces()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorGroupSpecBuilder(OperatorGroupSpec instance) {
    this(instance,false);
  }
  public OperatorGroupSpecBuilder(OperatorGroupSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSelector(instance.getSelector()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withStaticProvidedAPIs(instance.getStaticProvidedAPIs()); 
    this.withTargetNamespaces(instance.getTargetNamespaces()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorGroupSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorGroupSpec build() {
    OperatorGroupSpec buildable = new OperatorGroupSpec(fluent.getSelector(),fluent.getServiceAccountName(),fluent.getStaticProvidedAPIs(),fluent.getTargetNamespaces());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}