package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CatalogSourceBuilder extends CatalogSourceFluentImpl<CatalogSourceBuilder> implements VisitableBuilder<CatalogSource,CatalogSourceBuilder>{
  public CatalogSourceBuilder() {
    this(false);
  }
  public CatalogSourceBuilder(Boolean validationEnabled) {
    this(new CatalogSource(), validationEnabled);
  }
  public CatalogSourceBuilder(CatalogSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CatalogSourceBuilder(CatalogSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CatalogSource(), validationEnabled);
  }
  public CatalogSourceBuilder(CatalogSourceFluent<?> fluent,CatalogSource instance) {
    this(fluent, instance, false);
  }
  public CatalogSourceBuilder(CatalogSourceFluent<?> fluent,CatalogSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CatalogSourceBuilder(CatalogSource instance) {
    this(instance,false);
  }
  public CatalogSourceBuilder(CatalogSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CatalogSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CatalogSource build() {
    CatalogSource buildable = new CatalogSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}