package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenericOperatorConfigBuilder extends GenericOperatorConfigFluent<GenericOperatorConfigBuilder> implements VisitableBuilder<GenericOperatorConfig,GenericOperatorConfigBuilder>{
  public GenericOperatorConfigBuilder() {
    this(new GenericOperatorConfig());
  }
  
  public GenericOperatorConfigBuilder(GenericOperatorConfigFluent<?> fluent) {
    this(fluent, new GenericOperatorConfig());
  }
  
  public GenericOperatorConfigBuilder(GenericOperatorConfigFluent<?> fluent,GenericOperatorConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenericOperatorConfigBuilder(GenericOperatorConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenericOperatorConfigFluent<?> fluent;
  
  public GenericOperatorConfig build() {
    GenericOperatorConfig buildable = new GenericOperatorConfig(fluent.getApiVersion(),fluent.buildAuthentication(),fluent.buildAuthorization(),fluent.getKind(),fluent.getLeaderElection(),fluent.getServingInfo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}