package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NodeDisruptionPolicyStatusFluent<A extends NodeDisruptionPolicyStatusFluent<A>> extends BaseFluent<A>{
  public NodeDisruptionPolicyStatusFluent() {
  }
  
  public NodeDisruptionPolicyStatusFluent(NodeDisruptionPolicyStatus instance) {
    this.copyInstance(instance);
  }
  private NodeDisruptionPolicyClusterStatusBuilder clusterPolicies;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NodeDisruptionPolicyStatus instance) {
    instance = (instance != null ? instance : new NodeDisruptionPolicyStatus());
    if (instance != null) {
          this.withClusterPolicies(instance.getClusterPolicies());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public NodeDisruptionPolicyClusterStatus buildClusterPolicies() {
    return this.clusterPolicies != null ? this.clusterPolicies.build() : null;
  }
  
  public A withClusterPolicies(NodeDisruptionPolicyClusterStatus clusterPolicies) {
    this._visitables.remove("clusterPolicies");
    if (clusterPolicies != null) {
        this.clusterPolicies = new NodeDisruptionPolicyClusterStatusBuilder(clusterPolicies);
        this._visitables.get("clusterPolicies").add(this.clusterPolicies);
    } else {
        this.clusterPolicies = null;
        this._visitables.get("clusterPolicies").remove(this.clusterPolicies);
    }
    return (A) this;
  }
  
  public boolean hasClusterPolicies() {
    return this.clusterPolicies != null;
  }
  
  public ClusterPoliciesNested<A> withNewClusterPolicies() {
    return new ClusterPoliciesNested(null);
  }
  
  public ClusterPoliciesNested<A> withNewClusterPoliciesLike(NodeDisruptionPolicyClusterStatus item) {
    return new ClusterPoliciesNested(item);
  }
  
  public ClusterPoliciesNested<A> editClusterPolicies() {
    return withNewClusterPoliciesLike(java.util.Optional.ofNullable(buildClusterPolicies()).orElse(null));
  }
  
  public ClusterPoliciesNested<A> editOrNewClusterPolicies() {
    return withNewClusterPoliciesLike(java.util.Optional.ofNullable(buildClusterPolicies()).orElse(new NodeDisruptionPolicyClusterStatusBuilder().build()));
  }
  
  public ClusterPoliciesNested<A> editOrNewClusterPoliciesLike(NodeDisruptionPolicyClusterStatus item) {
    return withNewClusterPoliciesLike(java.util.Optional.ofNullable(buildClusterPolicies()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NodeDisruptionPolicyStatusFluent that = (NodeDisruptionPolicyStatusFluent) o;
    if (!java.util.Objects.equals(clusterPolicies, that.clusterPolicies)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterPolicies,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterPolicies != null) { sb.append("clusterPolicies:"); sb.append(clusterPolicies + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterPoliciesNested<N> extends NodeDisruptionPolicyClusterStatusFluent<ClusterPoliciesNested<N>> implements Nested<N>{
    ClusterPoliciesNested(NodeDisruptionPolicyClusterStatus item) {
      this.builder = new NodeDisruptionPolicyClusterStatusBuilder(this, item);
    }
    NodeDisruptionPolicyClusterStatusBuilder builder;
    
    public N and() {
      return (N) NodeDisruptionPolicyStatusFluent.this.withClusterPolicies(builder.build());
    }
    
    public N endClusterPolicies() {
      return and();
    }
    
  
  }

}