package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineConfigurationStatusFluent<A extends MachineConfigurationStatusFluent<A>> extends BaseFluent<A>{
  public MachineConfigurationStatusFluent() {
  }
  
  public MachineConfigurationStatusFluent(MachineConfigurationStatus instance) {
    this.copyInstance(instance);
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ManagedBootImagesBuilder managedBootImagesStatus;
  private NodeDisruptionPolicyStatusBuilder nodeDisruptionPolicyStatus;
  private Long observedGeneration;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineConfigurationStatus instance) {
    instance = (instance != null ? instance : new MachineConfigurationStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withManagedBootImagesStatus(instance.getManagedBootImagesStatus());
          this.withNodeDisruptionPolicyStatus(instance.getNodeDisruptionPolicyStatus());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ManagedBootImages buildManagedBootImagesStatus() {
    return this.managedBootImagesStatus != null ? this.managedBootImagesStatus.build() : null;
  }
  
  public A withManagedBootImagesStatus(ManagedBootImages managedBootImagesStatus) {
    this._visitables.remove("managedBootImagesStatus");
    if (managedBootImagesStatus != null) {
        this.managedBootImagesStatus = new ManagedBootImagesBuilder(managedBootImagesStatus);
        this._visitables.get("managedBootImagesStatus").add(this.managedBootImagesStatus);
    } else {
        this.managedBootImagesStatus = null;
        this._visitables.get("managedBootImagesStatus").remove(this.managedBootImagesStatus);
    }
    return (A) this;
  }
  
  public boolean hasManagedBootImagesStatus() {
    return this.managedBootImagesStatus != null;
  }
  
  public ManagedBootImagesStatusNested<A> withNewManagedBootImagesStatus() {
    return new ManagedBootImagesStatusNested(null);
  }
  
  public ManagedBootImagesStatusNested<A> withNewManagedBootImagesStatusLike(ManagedBootImages item) {
    return new ManagedBootImagesStatusNested(item);
  }
  
  public ManagedBootImagesStatusNested<A> editManagedBootImagesStatus() {
    return withNewManagedBootImagesStatusLike(java.util.Optional.ofNullable(buildManagedBootImagesStatus()).orElse(null));
  }
  
  public ManagedBootImagesStatusNested<A> editOrNewManagedBootImagesStatus() {
    return withNewManagedBootImagesStatusLike(java.util.Optional.ofNullable(buildManagedBootImagesStatus()).orElse(new ManagedBootImagesBuilder().build()));
  }
  
  public ManagedBootImagesStatusNested<A> editOrNewManagedBootImagesStatusLike(ManagedBootImages item) {
    return withNewManagedBootImagesStatusLike(java.util.Optional.ofNullable(buildManagedBootImagesStatus()).orElse(item));
  }
  
  public NodeDisruptionPolicyStatus buildNodeDisruptionPolicyStatus() {
    return this.nodeDisruptionPolicyStatus != null ? this.nodeDisruptionPolicyStatus.build() : null;
  }
  
  public A withNodeDisruptionPolicyStatus(NodeDisruptionPolicyStatus nodeDisruptionPolicyStatus) {
    this._visitables.remove("nodeDisruptionPolicyStatus");
    if (nodeDisruptionPolicyStatus != null) {
        this.nodeDisruptionPolicyStatus = new NodeDisruptionPolicyStatusBuilder(nodeDisruptionPolicyStatus);
        this._visitables.get("nodeDisruptionPolicyStatus").add(this.nodeDisruptionPolicyStatus);
    } else {
        this.nodeDisruptionPolicyStatus = null;
        this._visitables.get("nodeDisruptionPolicyStatus").remove(this.nodeDisruptionPolicyStatus);
    }
    return (A) this;
  }
  
  public boolean hasNodeDisruptionPolicyStatus() {
    return this.nodeDisruptionPolicyStatus != null;
  }
  
  public NodeDisruptionPolicyStatusNested<A> withNewNodeDisruptionPolicyStatus() {
    return new NodeDisruptionPolicyStatusNested(null);
  }
  
  public NodeDisruptionPolicyStatusNested<A> withNewNodeDisruptionPolicyStatusLike(NodeDisruptionPolicyStatus item) {
    return new NodeDisruptionPolicyStatusNested(item);
  }
  
  public NodeDisruptionPolicyStatusNested<A> editNodeDisruptionPolicyStatus() {
    return withNewNodeDisruptionPolicyStatusLike(java.util.Optional.ofNullable(buildNodeDisruptionPolicyStatus()).orElse(null));
  }
  
  public NodeDisruptionPolicyStatusNested<A> editOrNewNodeDisruptionPolicyStatus() {
    return withNewNodeDisruptionPolicyStatusLike(java.util.Optional.ofNullable(buildNodeDisruptionPolicyStatus()).orElse(new NodeDisruptionPolicyStatusBuilder().build()));
  }
  
  public NodeDisruptionPolicyStatusNested<A> editOrNewNodeDisruptionPolicyStatusLike(NodeDisruptionPolicyStatus item) {
    return withNewNodeDisruptionPolicyStatusLike(java.util.Optional.ofNullable(buildNodeDisruptionPolicyStatus()).orElse(item));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigurationStatusFluent that = (MachineConfigurationStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(managedBootImagesStatus, that.managedBootImagesStatus)) return false;
    if (!java.util.Objects.equals(nodeDisruptionPolicyStatus, that.nodeDisruptionPolicyStatus)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  managedBootImagesStatus,  nodeDisruptionPolicyStatus,  observedGeneration,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (managedBootImagesStatus != null) { sb.append("managedBootImagesStatus:"); sb.append(managedBootImagesStatus + ","); }
    if (nodeDisruptionPolicyStatus != null) { sb.append("nodeDisruptionPolicyStatus:"); sb.append(nodeDisruptionPolicyStatus + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ManagedBootImagesStatusNested<N> extends ManagedBootImagesFluent<ManagedBootImagesStatusNested<N>> implements Nested<N>{
    ManagedBootImagesStatusNested(ManagedBootImages item) {
      this.builder = new ManagedBootImagesBuilder(this, item);
    }
    ManagedBootImagesBuilder builder;
    
    public N and() {
      return (N) MachineConfigurationStatusFluent.this.withManagedBootImagesStatus(builder.build());
    }
    
    public N endManagedBootImagesStatus() {
      return and();
    }
    
  
  }
  public class NodeDisruptionPolicyStatusNested<N> extends NodeDisruptionPolicyStatusFluent<NodeDisruptionPolicyStatusNested<N>> implements Nested<N>{
    NodeDisruptionPolicyStatusNested(NodeDisruptionPolicyStatus item) {
      this.builder = new NodeDisruptionPolicyStatusBuilder(this, item);
    }
    NodeDisruptionPolicyStatusBuilder builder;
    
    public N and() {
      return (N) MachineConfigurationStatusFluent.this.withNodeDisruptionPolicyStatus(builder.build());
    }
    
    public N endNodeDisruptionPolicyStatus() {
      return and();
    }
    
  
  }

}