package io.fabric8.openshift.api.model.operator.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressControllerSpecFluent<A extends IngressControllerSpecFluent<A>> extends BaseFluent<A>{
  public IngressControllerSpecFluent() {
  }
  
  public IngressControllerSpecFluent(IngressControllerSpec instance) {
    this.copyInstance(instance);
  }
  private ClientTLSBuilder clientTLS;
  private LocalObjectReferenceBuilder defaultCertificate;
  private String domain;
  private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
  private HTTPCompressionPolicyBuilder httpCompression;
  private String httpEmptyRequestsPolicy;
  private ConfigMapNameReference httpErrorCodePages;
  private IngressControllerHTTPHeadersBuilder httpHeaders;
  private String idleConnectionTerminationPolicy;
  private IngressControllerLoggingBuilder logging;
  private LabelSelectorBuilder namespaceSelector;
  private NodePlacementBuilder nodePlacement;
  private Integer replicas;
  private RouteAdmissionPolicyBuilder routeAdmission;
  private LabelSelectorBuilder routeSelector;
  private TLSSecurityProfile tlsSecurityProfile;
  private IngressControllerTuningOptionsBuilder tuningOptions;
  private Object unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressControllerSpec instance) {
    instance = (instance != null ? instance : new IngressControllerSpec());
    if (instance != null) {
          this.withClientTLS(instance.getClientTLS());
          this.withDefaultCertificate(instance.getDefaultCertificate());
          this.withDomain(instance.getDomain());
          this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
          this.withHttpCompression(instance.getHttpCompression());
          this.withHttpEmptyRequestsPolicy(instance.getHttpEmptyRequestsPolicy());
          this.withHttpErrorCodePages(instance.getHttpErrorCodePages());
          this.withHttpHeaders(instance.getHttpHeaders());
          this.withIdleConnectionTerminationPolicy(instance.getIdleConnectionTerminationPolicy());
          this.withLogging(instance.getLogging());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withNodePlacement(instance.getNodePlacement());
          this.withReplicas(instance.getReplicas());
          this.withRouteAdmission(instance.getRouteAdmission());
          this.withRouteSelector(instance.getRouteSelector());
          this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
          this.withTuningOptions(instance.getTuningOptions());
          this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ClientTLS buildClientTLS() {
    return this.clientTLS != null ? this.clientTLS.build() : null;
  }
  
  public A withClientTLS(ClientTLS clientTLS) {
    this._visitables.remove("clientTLS");
    if (clientTLS != null) {
        this.clientTLS = new ClientTLSBuilder(clientTLS);
        this._visitables.get("clientTLS").add(this.clientTLS);
    } else {
        this.clientTLS = null;
        this._visitables.get("clientTLS").remove(this.clientTLS);
    }
    return (A) this;
  }
  
  public boolean hasClientTLS() {
    return this.clientTLS != null;
  }
  
  public ClientTLSNested<A> withNewClientTLS() {
    return new ClientTLSNested(null);
  }
  
  public ClientTLSNested<A> withNewClientTLSLike(ClientTLS item) {
    return new ClientTLSNested(item);
  }
  
  public ClientTLSNested<A> editClientTLS() {
    return withNewClientTLSLike(java.util.Optional.ofNullable(buildClientTLS()).orElse(null));
  }
  
  public ClientTLSNested<A> editOrNewClientTLS() {
    return withNewClientTLSLike(java.util.Optional.ofNullable(buildClientTLS()).orElse(new ClientTLSBuilder().build()));
  }
  
  public ClientTLSNested<A> editOrNewClientTLSLike(ClientTLS item) {
    return withNewClientTLSLike(java.util.Optional.ofNullable(buildClientTLS()).orElse(item));
  }
  
  public LocalObjectReference buildDefaultCertificate() {
    return this.defaultCertificate != null ? this.defaultCertificate.build() : null;
  }
  
  public A withDefaultCertificate(LocalObjectReference defaultCertificate) {
    this._visitables.remove("defaultCertificate");
    if (defaultCertificate != null) {
        this.defaultCertificate = new LocalObjectReferenceBuilder(defaultCertificate);
        this._visitables.get("defaultCertificate").add(this.defaultCertificate);
    } else {
        this.defaultCertificate = null;
        this._visitables.get("defaultCertificate").remove(this.defaultCertificate);
    }
    return (A) this;
  }
  
  public boolean hasDefaultCertificate() {
    return this.defaultCertificate != null;
  }
  
  public A withNewDefaultCertificate(String name) {
    return (A)withDefaultCertificate(new LocalObjectReference(name));
  }
  
  public DefaultCertificateNested<A> withNewDefaultCertificate() {
    return new DefaultCertificateNested(null);
  }
  
  public DefaultCertificateNested<A> withNewDefaultCertificateLike(LocalObjectReference item) {
    return new DefaultCertificateNested(item);
  }
  
  public DefaultCertificateNested<A> editDefaultCertificate() {
    return withNewDefaultCertificateLike(java.util.Optional.ofNullable(buildDefaultCertificate()).orElse(null));
  }
  
  public DefaultCertificateNested<A> editOrNewDefaultCertificate() {
    return withNewDefaultCertificateLike(java.util.Optional.ofNullable(buildDefaultCertificate()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public DefaultCertificateNested<A> editOrNewDefaultCertificateLike(LocalObjectReference item) {
    return withNewDefaultCertificateLike(java.util.Optional.ofNullable(buildDefaultCertificate()).orElse(item));
  }
  
  public String getDomain() {
    return this.domain;
  }
  
  public A withDomain(String domain) {
    this.domain = domain;
    return (A) this;
  }
  
  public boolean hasDomain() {
    return this.domain != null;
  }
  
  public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null ? this.endpointPublishingStrategy.build() : null;
  }
  
  public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
    this._visitables.remove("endpointPublishingStrategy");
    if (endpointPublishingStrategy != null) {
        this.endpointPublishingStrategy = new EndpointPublishingStrategyBuilder(endpointPublishingStrategy);
        this._visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);
    } else {
        this.endpointPublishingStrategy = null;
        this._visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
    }
    return (A) this;
  }
  
  public boolean hasEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null;
  }
  
  public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
    return new EndpointPublishingStrategyNested(null);
  }
  
  public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return new EndpointPublishingStrategyNested(item);
  }
  
  public EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(java.util.Optional.ofNullable(buildEndpointPublishingStrategy()).orElse(null));
  }
  
  public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(java.util.Optional.ofNullable(buildEndpointPublishingStrategy()).orElse(new EndpointPublishingStrategyBuilder().build()));
  }
  
  public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return withNewEndpointPublishingStrategyLike(java.util.Optional.ofNullable(buildEndpointPublishingStrategy()).orElse(item));
  }
  
  public HTTPCompressionPolicy buildHttpCompression() {
    return this.httpCompression != null ? this.httpCompression.build() : null;
  }
  
  public A withHttpCompression(HTTPCompressionPolicy httpCompression) {
    this._visitables.remove("httpCompression");
    if (httpCompression != null) {
        this.httpCompression = new HTTPCompressionPolicyBuilder(httpCompression);
        this._visitables.get("httpCompression").add(this.httpCompression);
    } else {
        this.httpCompression = null;
        this._visitables.get("httpCompression").remove(this.httpCompression);
    }
    return (A) this;
  }
  
  public boolean hasHttpCompression() {
    return this.httpCompression != null;
  }
  
  public HttpCompressionNested<A> withNewHttpCompression() {
    return new HttpCompressionNested(null);
  }
  
  public HttpCompressionNested<A> withNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return new HttpCompressionNested(item);
  }
  
  public HttpCompressionNested<A> editHttpCompression() {
    return withNewHttpCompressionLike(java.util.Optional.ofNullable(buildHttpCompression()).orElse(null));
  }
  
  public HttpCompressionNested<A> editOrNewHttpCompression() {
    return withNewHttpCompressionLike(java.util.Optional.ofNullable(buildHttpCompression()).orElse(new HTTPCompressionPolicyBuilder().build()));
  }
  
  public HttpCompressionNested<A> editOrNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return withNewHttpCompressionLike(java.util.Optional.ofNullable(buildHttpCompression()).orElse(item));
  }
  
  public String getHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy;
  }
  
  public A withHttpEmptyRequestsPolicy(String httpEmptyRequestsPolicy) {
    this.httpEmptyRequestsPolicy = httpEmptyRequestsPolicy;
    return (A) this;
  }
  
  public boolean hasHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy != null;
  }
  
  public ConfigMapNameReference getHttpErrorCodePages() {
    return this.httpErrorCodePages;
  }
  
  public A withHttpErrorCodePages(ConfigMapNameReference httpErrorCodePages) {
    this.httpErrorCodePages = httpErrorCodePages;
    return (A) this;
  }
  
  public boolean hasHttpErrorCodePages() {
    return this.httpErrorCodePages != null;
  }
  
  public A withNewHttpErrorCodePages(String name) {
    return (A)withHttpErrorCodePages(new ConfigMapNameReference(name));
  }
  
  public IngressControllerHTTPHeaders buildHttpHeaders() {
    return this.httpHeaders != null ? this.httpHeaders.build() : null;
  }
  
  public A withHttpHeaders(IngressControllerHTTPHeaders httpHeaders) {
    this._visitables.remove("httpHeaders");
    if (httpHeaders != null) {
        this.httpHeaders = new IngressControllerHTTPHeadersBuilder(httpHeaders);
        this._visitables.get("httpHeaders").add(this.httpHeaders);
    } else {
        this.httpHeaders = null;
        this._visitables.get("httpHeaders").remove(this.httpHeaders);
    }
    return (A) this;
  }
  
  public boolean hasHttpHeaders() {
    return this.httpHeaders != null;
  }
  
  public HttpHeadersNested<A> withNewHttpHeaders() {
    return new HttpHeadersNested(null);
  }
  
  public HttpHeadersNested<A> withNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return new HttpHeadersNested(item);
  }
  
  public HttpHeadersNested<A> editHttpHeaders() {
    return withNewHttpHeadersLike(java.util.Optional.ofNullable(buildHttpHeaders()).orElse(null));
  }
  
  public HttpHeadersNested<A> editOrNewHttpHeaders() {
    return withNewHttpHeadersLike(java.util.Optional.ofNullable(buildHttpHeaders()).orElse(new IngressControllerHTTPHeadersBuilder().build()));
  }
  
  public HttpHeadersNested<A> editOrNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return withNewHttpHeadersLike(java.util.Optional.ofNullable(buildHttpHeaders()).orElse(item));
  }
  
  public String getIdleConnectionTerminationPolicy() {
    return this.idleConnectionTerminationPolicy;
  }
  
  public A withIdleConnectionTerminationPolicy(String idleConnectionTerminationPolicy) {
    this.idleConnectionTerminationPolicy = idleConnectionTerminationPolicy;
    return (A) this;
  }
  
  public boolean hasIdleConnectionTerminationPolicy() {
    return this.idleConnectionTerminationPolicy != null;
  }
  
  public IngressControllerLogging buildLogging() {
    return this.logging != null ? this.logging.build() : null;
  }
  
  public A withLogging(IngressControllerLogging logging) {
    this._visitables.remove("logging");
    if (logging != null) {
        this.logging = new IngressControllerLoggingBuilder(logging);
        this._visitables.get("logging").add(this.logging);
    } else {
        this.logging = null;
        this._visitables.get("logging").remove(this.logging);
    }
    return (A) this;
  }
  
  public boolean hasLogging() {
    return this.logging != null;
  }
  
  public LoggingNested<A> withNewLogging() {
    return new LoggingNested(null);
  }
  
  public LoggingNested<A> withNewLoggingLike(IngressControllerLogging item) {
    return new LoggingNested(item);
  }
  
  public LoggingNested<A> editLogging() {
    return withNewLoggingLike(java.util.Optional.ofNullable(buildLogging()).orElse(null));
  }
  
  public LoggingNested<A> editOrNewLogging() {
    return withNewLoggingLike(java.util.Optional.ofNullable(buildLogging()).orElse(new IngressControllerLoggingBuilder().build()));
  }
  
  public LoggingNested<A> editOrNewLoggingLike(IngressControllerLogging item) {
    return withNewLoggingLike(java.util.Optional.ofNullable(buildLogging()).orElse(item));
  }
  
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    this._visitables.remove("namespaceSelector");
    if (namespaceSelector != null) {
        this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement != null ? this.nodePlacement.build() : null;
  }
  
  public A withNodePlacement(NodePlacement nodePlacement) {
    this._visitables.remove("nodePlacement");
    if (nodePlacement != null) {
        this.nodePlacement = new NodePlacementBuilder(nodePlacement);
        this._visitables.get("nodePlacement").add(this.nodePlacement);
    } else {
        this.nodePlacement = null;
        this._visitables.get("nodePlacement").remove(this.nodePlacement);
    }
    return (A) this;
  }
  
  public boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  
  public NodePlacementNested<A> withNewNodePlacement() {
    return new NodePlacementNested(null);
  }
  
  public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new NodePlacementNested(item);
  }
  
  public NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(null));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(item));
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public RouteAdmissionPolicy buildRouteAdmission() {
    return this.routeAdmission != null ? this.routeAdmission.build() : null;
  }
  
  public A withRouteAdmission(RouteAdmissionPolicy routeAdmission) {
    this._visitables.remove("routeAdmission");
    if (routeAdmission != null) {
        this.routeAdmission = new RouteAdmissionPolicyBuilder(routeAdmission);
        this._visitables.get("routeAdmission").add(this.routeAdmission);
    } else {
        this.routeAdmission = null;
        this._visitables.get("routeAdmission").remove(this.routeAdmission);
    }
    return (A) this;
  }
  
  public boolean hasRouteAdmission() {
    return this.routeAdmission != null;
  }
  
  public A withNewRouteAdmission(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  
  public RouteAdmissionNested<A> withNewRouteAdmission() {
    return new RouteAdmissionNested(null);
  }
  
  public RouteAdmissionNested<A> withNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return new RouteAdmissionNested(item);
  }
  
  public RouteAdmissionNested<A> editRouteAdmission() {
    return withNewRouteAdmissionLike(java.util.Optional.ofNullable(buildRouteAdmission()).orElse(null));
  }
  
  public RouteAdmissionNested<A> editOrNewRouteAdmission() {
    return withNewRouteAdmissionLike(java.util.Optional.ofNullable(buildRouteAdmission()).orElse(new RouteAdmissionPolicyBuilder().build()));
  }
  
  public RouteAdmissionNested<A> editOrNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return withNewRouteAdmissionLike(java.util.Optional.ofNullable(buildRouteAdmission()).orElse(item));
  }
  
  public LabelSelector buildRouteSelector() {
    return this.routeSelector != null ? this.routeSelector.build() : null;
  }
  
  public A withRouteSelector(LabelSelector routeSelector) {
    this._visitables.remove("routeSelector");
    if (routeSelector != null) {
        this.routeSelector = new LabelSelectorBuilder(routeSelector);
        this._visitables.get("routeSelector").add(this.routeSelector);
    } else {
        this.routeSelector = null;
        this._visitables.get("routeSelector").remove(this.routeSelector);
    }
    return (A) this;
  }
  
  public boolean hasRouteSelector() {
    return this.routeSelector != null;
  }
  
  public RouteSelectorNested<A> withNewRouteSelector() {
    return new RouteSelectorNested(null);
  }
  
  public RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
    return new RouteSelectorNested(item);
  }
  
  public RouteSelectorNested<A> editRouteSelector() {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(null));
  }
  
  public RouteSelectorNested<A> editOrNewRouteSelector() {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(item));
  }
  
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile;
  }
  
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this.tlsSecurityProfile = tlsSecurityProfile;
    return (A) this;
  }
  
  public boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  
  public IngressControllerTuningOptions buildTuningOptions() {
    return this.tuningOptions != null ? this.tuningOptions.build() : null;
  }
  
  public A withTuningOptions(IngressControllerTuningOptions tuningOptions) {
    this._visitables.remove("tuningOptions");
    if (tuningOptions != null) {
        this.tuningOptions = new IngressControllerTuningOptionsBuilder(tuningOptions);
        this._visitables.get("tuningOptions").add(this.tuningOptions);
    } else {
        this.tuningOptions = null;
        this._visitables.get("tuningOptions").remove(this.tuningOptions);
    }
    return (A) this;
  }
  
  public boolean hasTuningOptions() {
    return this.tuningOptions != null;
  }
  
  public TuningOptionsNested<A> withNewTuningOptions() {
    return new TuningOptionsNested(null);
  }
  
  public TuningOptionsNested<A> withNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return new TuningOptionsNested(item);
  }
  
  public TuningOptionsNested<A> editTuningOptions() {
    return withNewTuningOptionsLike(java.util.Optional.ofNullable(buildTuningOptions()).orElse(null));
  }
  
  public TuningOptionsNested<A> editOrNewTuningOptions() {
    return withNewTuningOptionsLike(java.util.Optional.ofNullable(buildTuningOptions()).orElse(new IngressControllerTuningOptionsBuilder().build()));
  }
  
  public TuningOptionsNested<A> editOrNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return withNewTuningOptionsLike(java.util.Optional.ofNullable(buildTuningOptions()).orElse(item));
  }
  
  public Object getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides;
  }
  
  public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
    this.unsupportedConfigOverrides = unsupportedConfigOverrides;
    return (A) this;
  }
  
  public boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressControllerSpecFluent that = (IngressControllerSpecFluent) o;
    if (!java.util.Objects.equals(clientTLS, that.clientTLS)) return false;
    if (!java.util.Objects.equals(defaultCertificate, that.defaultCertificate)) return false;
    if (!java.util.Objects.equals(domain, that.domain)) return false;
    if (!java.util.Objects.equals(endpointPublishingStrategy, that.endpointPublishingStrategy)) return false;
    if (!java.util.Objects.equals(httpCompression, that.httpCompression)) return false;
    if (!java.util.Objects.equals(httpEmptyRequestsPolicy, that.httpEmptyRequestsPolicy)) return false;
    if (!java.util.Objects.equals(httpErrorCodePages, that.httpErrorCodePages)) return false;
    if (!java.util.Objects.equals(httpHeaders, that.httpHeaders)) return false;
    if (!java.util.Objects.equals(idleConnectionTerminationPolicy, that.idleConnectionTerminationPolicy)) return false;
    if (!java.util.Objects.equals(logging, that.logging)) return false;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(routeAdmission, that.routeAdmission)) return false;
    if (!java.util.Objects.equals(routeSelector, that.routeSelector)) return false;
    if (!java.util.Objects.equals(tlsSecurityProfile, that.tlsSecurityProfile)) return false;
    if (!java.util.Objects.equals(tuningOptions, that.tuningOptions)) return false;
    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientTLS,  defaultCertificate,  domain,  endpointPublishingStrategy,  httpCompression,  httpEmptyRequestsPolicy,  httpErrorCodePages,  httpHeaders,  idleConnectionTerminationPolicy,  logging,  namespaceSelector,  nodePlacement,  replicas,  routeAdmission,  routeSelector,  tlsSecurityProfile,  tuningOptions,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientTLS != null) { sb.append("clientTLS:"); sb.append(clientTLS + ","); }
    if (defaultCertificate != null) { sb.append("defaultCertificate:"); sb.append(defaultCertificate + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (endpointPublishingStrategy != null) { sb.append("endpointPublishingStrategy:"); sb.append(endpointPublishingStrategy + ","); }
    if (httpCompression != null) { sb.append("httpCompression:"); sb.append(httpCompression + ","); }
    if (httpEmptyRequestsPolicy != null) { sb.append("httpEmptyRequestsPolicy:"); sb.append(httpEmptyRequestsPolicy + ","); }
    if (httpErrorCodePages != null) { sb.append("httpErrorCodePages:"); sb.append(httpErrorCodePages + ","); }
    if (httpHeaders != null) { sb.append("httpHeaders:"); sb.append(httpHeaders + ","); }
    if (idleConnectionTerminationPolicy != null) { sb.append("idleConnectionTerminationPolicy:"); sb.append(idleConnectionTerminationPolicy + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (routeAdmission != null) { sb.append("routeAdmission:"); sb.append(routeAdmission + ","); }
    if (routeSelector != null) { sb.append("routeSelector:"); sb.append(routeSelector + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (tuningOptions != null) { sb.append("tuningOptions:"); sb.append(tuningOptions + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientTLSNested<N> extends ClientTLSFluent<ClientTLSNested<N>> implements Nested<N>{
    ClientTLSNested(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withClientTLS(builder.build());
    }
    
    public N endClientTLS() {
      return and();
    }
    
  
  }
  public class DefaultCertificateNested<N> extends LocalObjectReferenceFluent<DefaultCertificateNested<N>> implements Nested<N>{
    DefaultCertificateNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withDefaultCertificate(builder.build());
    }
    
    public N endDefaultCertificate() {
      return and();
    }
    
  
  }
  public class EndpointPublishingStrategyNested<N> extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyNested<N>> implements Nested<N>{
    EndpointPublishingStrategyNested(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withEndpointPublishingStrategy(builder.build());
    }
    
    public N endEndpointPublishingStrategy() {
      return and();
    }
    
  
  }
  public class HttpCompressionNested<N> extends HTTPCompressionPolicyFluent<HttpCompressionNested<N>> implements Nested<N>{
    HttpCompressionNested(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withHttpCompression(builder.build());
    }
    
    public N endHttpCompression() {
      return and();
    }
    
  
  }
  public class HttpHeadersNested<N> extends IngressControllerHTTPHeadersFluent<HttpHeadersNested<N>> implements Nested<N>{
    HttpHeadersNested(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withHttpHeaders(builder.build());
    }
    
    public N endHttpHeaders() {
      return and();
    }
    
  
  }
  public class LoggingNested<N> extends IngressControllerLoggingFluent<LoggingNested<N>> implements Nested<N>{
    LoggingNested(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withLogging(builder.build());
    }
    
    public N endLogging() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class NodePlacementNested<N> extends NodePlacementFluent<NodePlacementNested<N>> implements Nested<N>{
    NodePlacementNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withNodePlacement(builder.build());
    }
    
    public N endNodePlacement() {
      return and();
    }
    
  
  }
  public class RouteAdmissionNested<N> extends RouteAdmissionPolicyFluent<RouteAdmissionNested<N>> implements Nested<N>{
    RouteAdmissionNested(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withRouteAdmission(builder.build());
    }
    
    public N endRouteAdmission() {
      return and();
    }
    
  
  }
  public class RouteSelectorNested<N> extends LabelSelectorFluent<RouteSelectorNested<N>> implements Nested<N>{
    RouteSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withRouteSelector(builder.build());
    }
    
    public N endRouteSelector() {
      return and();
    }
    
  
  }
  public class TuningOptionsNested<N> extends IngressControllerTuningOptionsFluent<TuningOptionsNested<N>> implements Nested<N>{
    TuningOptionsNested(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsBuilder builder;
    
    public N and() {
      return (N) IngressControllerSpecFluent.this.withTuningOptions(builder.build());
    }
    
    public N endTuningOptions() {
      return and();
    }
    
  
  }

}