package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HealthCheckBuilder extends HealthCheckFluent<HealthCheckBuilder> implements VisitableBuilder<HealthCheck,HealthCheckBuilder>{
  public HealthCheckBuilder() {
    this(new HealthCheck());
  }
  
  public HealthCheckBuilder(HealthCheckFluent<?> fluent) {
    this(fluent, new HealthCheck());
  }
  
  public HealthCheckBuilder(HealthCheckFluent<?> fluent,HealthCheck instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HealthCheckBuilder(HealthCheck instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HealthCheckFluent<?> fluent;
  
  public HealthCheck build() {
    HealthCheck buildable = new HealthCheck(fluent.getAdvisorURI(),fluent.getDescription(),fluent.getState(),fluent.getTotalRisk());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}