package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigMapFileReferenceBuilder extends ConfigMapFileReferenceFluent<ConfigMapFileReferenceBuilder> implements VisitableBuilder<ConfigMapFileReference,ConfigMapFileReferenceBuilder>{
  public ConfigMapFileReferenceBuilder() {
    this(new ConfigMapFileReference());
  }
  
  public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent) {
    this(fluent, new ConfigMapFileReference());
  }
  
  public ConfigMapFileReferenceBuilder(ConfigMapFileReferenceFluent<?> fluent,ConfigMapFileReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigMapFileReferenceBuilder(ConfigMapFileReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigMapFileReferenceFluent<?> fluent;
  
  public ConfigMapFileReference build() {
    ConfigMapFileReference buildable = new ConfigMapFileReference(fluent.getKey(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}