package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CapabilityFluent<A extends CapabilityFluent<A>> extends BaseFluent<A>{
  public CapabilityFluent() {
  }
  
  public CapabilityFluent(Capability instance) {
    this.copyInstance(instance);
  }
  private String name;
  private CapabilityVisibilityBuilder visibility;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Capability instance) {
    instance = (instance != null ? instance : new Capability());
    if (instance != null) {
          this.withName(instance.getName());
          this.withVisibility(instance.getVisibility());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public CapabilityVisibility buildVisibility() {
    return this.visibility != null ? this.visibility.build() : null;
  }
  
  public A withVisibility(CapabilityVisibility visibility) {
    this._visitables.remove("visibility");
    if (visibility != null) {
        this.visibility = new CapabilityVisibilityBuilder(visibility);
        this._visitables.get("visibility").add(this.visibility);
    } else {
        this.visibility = null;
        this._visitables.get("visibility").remove(this.visibility);
    }
    return (A) this;
  }
  
  public boolean hasVisibility() {
    return this.visibility != null;
  }
  
  public A withNewVisibility(String state) {
    return (A)withVisibility(new CapabilityVisibility(state));
  }
  
  public VisibilityNested<A> withNewVisibility() {
    return new VisibilityNested(null);
  }
  
  public VisibilityNested<A> withNewVisibilityLike(CapabilityVisibility item) {
    return new VisibilityNested(item);
  }
  
  public VisibilityNested<A> editVisibility() {
    return withNewVisibilityLike(java.util.Optional.ofNullable(buildVisibility()).orElse(null));
  }
  
  public VisibilityNested<A> editOrNewVisibility() {
    return withNewVisibilityLike(java.util.Optional.ofNullable(buildVisibility()).orElse(new CapabilityVisibilityBuilder().build()));
  }
  
  public VisibilityNested<A> editOrNewVisibilityLike(CapabilityVisibility item) {
    return withNewVisibilityLike(java.util.Optional.ofNullable(buildVisibility()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CapabilityFluent that = (CapabilityFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(visibility, that.visibility)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  visibility,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (visibility != null) { sb.append("visibility:"); sb.append(visibility + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class VisibilityNested<N> extends CapabilityVisibilityFluent<VisibilityNested<N>> implements Nested<N>{
    VisibilityNested(CapabilityVisibility item) {
      this.builder = new CapabilityVisibilityBuilder(this, item);
    }
    CapabilityVisibilityBuilder builder;
    
    public N and() {
      return (N) CapabilityFluent.this.withVisibility(builder.build());
    }
    
    public N endVisibility() {
      return and();
    }
    
  
  }

}