package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OVNKubernetesConfigBuilder extends OVNKubernetesConfigFluent<OVNKubernetesConfigBuilder> implements VisitableBuilder<OVNKubernetesConfig,OVNKubernetesConfigBuilder>{
  public OVNKubernetesConfigBuilder() {
    this(new OVNKubernetesConfig());
  }
  
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent) {
    this(fluent, new OVNKubernetesConfig());
  }
  
  public OVNKubernetesConfigBuilder(OVNKubernetesConfigFluent<?> fluent,OVNKubernetesConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OVNKubernetesConfigBuilder(OVNKubernetesConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OVNKubernetesConfigFluent<?> fluent;
  
  public OVNKubernetesConfig build() {
    OVNKubernetesConfig buildable = new OVNKubernetesConfig(fluent.buildEgressIPConfig(),fluent.buildGatewayConfig(),fluent.getGenevePort(),fluent.buildHybridOverlayConfig(),fluent.buildIpsecConfig(),fluent.getMtu(),fluent.buildPolicyAuditConfig(),fluent.getV4InternalSubnet(),fluent.getV6InternalSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}