package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GatewayConfigFluent<A extends GatewayConfigFluent<A>> extends BaseFluent<A>{
  public GatewayConfigFluent() {
  }
  
  public GatewayConfigFluent(GatewayConfig instance) {
    this.copyInstance(instance);
  }
  private String ipForwarding;
  private Boolean routingViaHost;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GatewayConfig instance) {
    instance = (instance != null ? instance : new GatewayConfig());
    if (instance != null) {
          this.withIpForwarding(instance.getIpForwarding());
          this.withRoutingViaHost(instance.getRoutingViaHost());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getIpForwarding() {
    return this.ipForwarding;
  }
  
  public A withIpForwarding(String ipForwarding) {
    this.ipForwarding = ipForwarding;
    return (A) this;
  }
  
  public boolean hasIpForwarding() {
    return this.ipForwarding != null;
  }
  
  public Boolean getRoutingViaHost() {
    return this.routingViaHost;
  }
  
  public A withRoutingViaHost(Boolean routingViaHost) {
    this.routingViaHost = routingViaHost;
    return (A) this;
  }
  
  public boolean hasRoutingViaHost() {
    return this.routingViaHost != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatewayConfigFluent that = (GatewayConfigFluent) o;
    if (!java.util.Objects.equals(ipForwarding, that.ipForwarding)) return false;
    if (!java.util.Objects.equals(routingViaHost, that.routingViaHost)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ipForwarding,  routingViaHost,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipForwarding != null) { sb.append("ipForwarding:"); sb.append(ipForwarding + ","); }
    if (routingViaHost != null) { sb.append("routingViaHost:"); sb.append(routingViaHost + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withRoutingViaHost() {
    return withRoutingViaHost(true);
  }
  

}