/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DNSCache;
import io.fabric8.openshift.api.model.operator.v1.DNSCacheBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSCacheFluent;
import io.fabric8.openshift.api.model.operator.v1.DNSNodePlacement;
import io.fabric8.openshift.api.model.operator.v1.DNSNodePlacementBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSNodePlacementFluent;
import io.fabric8.openshift.api.model.operator.v1.DNSSpec;
import io.fabric8.openshift.api.model.operator.v1.Server;
import io.fabric8.openshift.api.model.operator.v1.ServerBuilder;
import io.fabric8.openshift.api.model.operator.v1.ServerFluent;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolvers;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolversBuilder;
import io.fabric8.openshift.api.model.operator.v1.UpstreamResolversFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DNSSpecFluent<A extends DNSSpecFluent<A>>
extends BaseFluent<A> {
    private DNSCacheBuilder cache;
    private String logLevel;
    private String managementState;
    private DNSNodePlacementBuilder nodePlacement;
    private String operatorLogLevel;
    private ArrayList<ServerBuilder> servers = new ArrayList();
    private UpstreamResolversBuilder upstreamResolvers;
    private Map<String, Object> additionalProperties;

    public DNSSpecFluent() {
    }

    public DNSSpecFluent(DNSSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSSpec instance) {
        DNSSpec dNSSpec = instance = instance != null ? instance : new DNSSpec();
        if (instance != null) {
            this.withCache(instance.getCache());
            this.withLogLevel(instance.getLogLevel());
            this.withManagementState(instance.getManagementState());
            this.withNodePlacement(instance.getNodePlacement());
            this.withOperatorLogLevel(instance.getOperatorLogLevel());
            this.withServers(instance.getServers());
            this.withUpstreamResolvers(instance.getUpstreamResolvers());
            this.withCache(instance.getCache());
            this.withLogLevel(instance.getLogLevel());
            this.withManagementState(instance.getManagementState());
            this.withNodePlacement(instance.getNodePlacement());
            this.withOperatorLogLevel(instance.getOperatorLogLevel());
            this.withServers(instance.getServers());
            this.withUpstreamResolvers(instance.getUpstreamResolvers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DNSCache buildCache() {
        return this.cache != null ? this.cache.build() : null;
    }

    public A withCache(DNSCache cache) {
        this._visitables.remove((Object)this.cache);
        if (cache != null) {
            this.cache = new DNSCacheBuilder(cache);
            this._visitables.get((Object)"cache").add(this.cache);
        } else {
            this.cache = null;
            this._visitables.get((Object)"cache").remove((Object)this.cache);
        }
        return (A)((Object)this);
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public CacheNested<A> withNewCache() {
        return new CacheNested(null);
    }

    public CacheNested<A> withNewCacheLike(DNSCache item) {
        return new CacheNested(item);
    }

    public CacheNested<A> editCache() {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(null));
    }

    public CacheNested<A> editOrNewCache() {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(new DNSCacheBuilder().build()));
    }

    public CacheNested<A> editOrNewCacheLike(DNSCache item) {
        return this.withNewCacheLike(Optional.ofNullable(this.buildCache()).orElse(item));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)((Object)this);
    }

    public boolean hasManagementState() {
        return this.managementState != null;
    }

    public DNSNodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    public A withNodePlacement(DNSNodePlacement nodePlacement) {
        this._visitables.remove((Object)this.nodePlacement);
        if (nodePlacement != null) {
            this.nodePlacement = new DNSNodePlacementBuilder(nodePlacement);
            this._visitables.get((Object)"nodePlacement").add(this.nodePlacement);
        } else {
            this.nodePlacement = null;
            this._visitables.get((Object)"nodePlacement").remove((Object)this.nodePlacement);
        }
        return (A)((Object)this);
    }

    public boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNested(null);
    }

    public NodePlacementNested<A> withNewNodePlacementLike(DNSNodePlacement item) {
        return new NodePlacementNested(item);
    }

    public NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(null));
    }

    public NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(new DNSNodePlacementBuilder().build()));
    }

    public NodePlacementNested<A> editOrNewNodePlacementLike(DNSNodePlacement item) {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(item));
    }

    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel = operatorLogLevel;
        return (A)((Object)this);
    }

    public boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    public A addToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this.servers.size()) {
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        } else {
            this._visitables.get((Object)"servers").add(index, builder);
            this.servers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this.servers.size()) {
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        } else {
            this._visitables.get((Object)"servers").set(index, builder);
            this.servers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToServers(Server ... items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServers(Collection<Server> items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromServers(Server ... items) {
        if (this.servers == null) {
            return (A)((Object)this);
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove((Object)builder);
            this.servers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServers(Collection<Server> items) {
        if (this.servers == null) {
            return (A)((Object)this);
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove((Object)builder);
            this.servers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
        if (this.servers == null) {
            return (A)((Object)this);
        }
        Iterator<ServerBuilder> each = this.servers.iterator();
        List visitables = this._visitables.get((Object)"servers");
        while (each.hasNext()) {
            ServerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Server> buildServers() {
        return this.servers != null ? DNSSpecFluent.build(this.servers) : null;
    }

    public Server buildServer(int index) {
        return this.servers.get(index).build();
    }

    public Server buildFirstServer() {
        return this.servers.get(0).build();
    }

    public Server buildLastServer() {
        return this.servers.get(this.servers.size() - 1).build();
    }

    public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServers(List<Server> servers) {
        if (this.servers != null) {
            this._visitables.get((Object)"servers").clear();
        }
        if (servers != null) {
            this.servers = new ArrayList();
            for (Server item : servers) {
                this.addToServers(item);
            }
        } else {
            this.servers = null;
        }
        return (A)((Object)this);
    }

    public A withServers(Server ... servers) {
        if (this.servers != null) {
            this.servers.clear();
            this._visitables.remove((Object)"servers");
        }
        if (servers != null) {
            for (Server item : servers) {
                this.addToServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServers() {
        return this.servers != null && !this.servers.isEmpty();
    }

    public ServersNested<A> addNewServer() {
        return new ServersNested(-1, null);
    }

    public ServersNested<A> addNewServerLike(Server item) {
        return new ServersNested(-1, item);
    }

    public ServersNested<A> setNewServerLike(int index, Server item) {
        return new ServersNested(index, item);
    }

    public ServersNested<A> editServer(int index) {
        if (this.servers.size() <= index) {
            throw new RuntimeException("Can't edit servers. Index exceeds size.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public ServersNested<A> editFirstServer() {
        if (this.servers.size() == 0) {
            throw new RuntimeException("Can't edit first servers. The list is empty.");
        }
        return this.setNewServerLike(0, this.buildServer(0));
    }

    public ServersNested<A> editLastServer() {
        int index = this.servers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last servers. The list is empty.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!predicate.test(this.servers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching servers. No match found.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public UpstreamResolvers buildUpstreamResolvers() {
        return this.upstreamResolvers != null ? this.upstreamResolvers.build() : null;
    }

    public A withUpstreamResolvers(UpstreamResolvers upstreamResolvers) {
        this._visitables.remove((Object)this.upstreamResolvers);
        if (upstreamResolvers != null) {
            this.upstreamResolvers = new UpstreamResolversBuilder(upstreamResolvers);
            this._visitables.get((Object)"upstreamResolvers").add(this.upstreamResolvers);
        } else {
            this.upstreamResolvers = null;
            this._visitables.get((Object)"upstreamResolvers").remove((Object)this.upstreamResolvers);
        }
        return (A)((Object)this);
    }

    public boolean hasUpstreamResolvers() {
        return this.upstreamResolvers != null;
    }

    public UpstreamResolversNested<A> withNewUpstreamResolvers() {
        return new UpstreamResolversNested(null);
    }

    public UpstreamResolversNested<A> withNewUpstreamResolversLike(UpstreamResolvers item) {
        return new UpstreamResolversNested(item);
    }

    public UpstreamResolversNested<A> editUpstreamResolvers() {
        return this.withNewUpstreamResolversLike(Optional.ofNullable(this.buildUpstreamResolvers()).orElse(null));
    }

    public UpstreamResolversNested<A> editOrNewUpstreamResolvers() {
        return this.withNewUpstreamResolversLike(Optional.ofNullable(this.buildUpstreamResolvers()).orElse(new UpstreamResolversBuilder().build()));
    }

    public UpstreamResolversNested<A> editOrNewUpstreamResolversLike(UpstreamResolvers item) {
        return this.withNewUpstreamResolversLike(Optional.ofNullable(this.buildUpstreamResolvers()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSSpecFluent that = (DNSSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.cache, (Object)that.cache)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.managementState, that.managementState)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodePlacement, (Object)that.nodePlacement)) {
            return false;
        }
        if (!Objects.equals(this.operatorLogLevel, that.operatorLogLevel)) {
            return false;
        }
        if (!Objects.equals(this.servers, that.servers)) {
            return false;
        }
        if (!Objects.equals((Object)this.upstreamResolvers, (Object)that.upstreamResolvers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cache, this.logLevel, this.managementState, this.nodePlacement, this.operatorLogLevel, this.servers, this.upstreamResolvers, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cache != null) {
            sb.append("cache:");
            sb.append((Object)((Object)this.cache) + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.managementState != null) {
            sb.append("managementState:");
            sb.append(this.managementState + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append((Object)((Object)this.nodePlacement) + ",");
        }
        if (this.operatorLogLevel != null) {
            sb.append("operatorLogLevel:");
            sb.append(this.operatorLogLevel + ",");
        }
        if (this.servers != null && !this.servers.isEmpty()) {
            sb.append("servers:");
            sb.append(this.servers + ",");
        }
        if (this.upstreamResolvers != null) {
            sb.append("upstreamResolvers:");
            sb.append((Object)((Object)this.upstreamResolvers) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpstreamResolversNested<N>
    extends UpstreamResolversFluent<UpstreamResolversNested<N>>
    implements Nested<N> {
        UpstreamResolversBuilder builder;

        UpstreamResolversNested(UpstreamResolvers item) {
            this.builder = new UpstreamResolversBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.withUpstreamResolvers(this.builder.build());
        }

        public N endUpstreamResolvers() {
            return this.and();
        }
    }

    public class ServersNested<N>
    extends ServerFluent<ServersNested<N>>
    implements Nested<N> {
        ServerBuilder builder;
        int index;

        ServersNested(int index, Server item) {
            this.index = index;
            this.builder = new ServerBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.setToServers(this.index, this.builder.build());
        }

        public N endServer() {
            return this.and();
        }
    }

    public class NodePlacementNested<N>
    extends DNSNodePlacementFluent<NodePlacementNested<N>>
    implements Nested<N> {
        DNSNodePlacementBuilder builder;

        NodePlacementNested(DNSNodePlacement item) {
            this.builder = new DNSNodePlacementBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.withNodePlacement(this.builder.build());
        }

        public N endNodePlacement() {
            return this.and();
        }
    }

    public class CacheNested<N>
    extends DNSCacheFluent<CacheNested<N>>
    implements Nested<N> {
        DNSCacheBuilder builder;

        CacheNested(DNSCache item) {
            this.builder = new DNSCacheBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.withCache(this.builder.build());
        }

        public N endCache() {
            return this.and();
        }
    }
}

