package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftAPIServerSpecBuilder extends OpenShiftAPIServerSpecFluentImpl<OpenShiftAPIServerSpecBuilder> implements VisitableBuilder<OpenShiftAPIServerSpec,OpenShiftAPIServerSpecBuilder>{
  public OpenShiftAPIServerSpecBuilder() {
    this(false);
  }
  public OpenShiftAPIServerSpecBuilder(Boolean validationEnabled) {
    this(new OpenShiftAPIServerSpec(), validationEnabled);
  }
  public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftAPIServerSpec(), validationEnabled);
  }
  public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent,OpenShiftAPIServerSpec instance) {
    this(fluent, instance, false);
  }
  public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent,OpenShiftAPIServerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpec instance) {
    this(instance,false);
  }
  public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenShiftAPIServerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftAPIServerSpec build() {
    OpenShiftAPIServerSpec buildable = new OpenShiftAPIServerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}