package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryFluentImpl;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentImpl;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckList;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluentImpl;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatus;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckCondition;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntry;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpec;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryBuilder;
import java.util.function.Predicate;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrors;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsFluentImpl;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkSpecFluentImpl<A extends NetworkSpecFluent<A>> extends BaseFluent<A> implements NetworkSpecFluent<A>{
  public NetworkSpecFluentImpl() {
  }
  public NetworkSpecFluentImpl(NetworkSpec instance) {
    this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withDefaultNetwork(instance.getDefaultNetwork()); 
    this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
    this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
    this.withDisableNetworkDiagnostics(instance.getDisableNetworkDiagnostics()); 
    this.withExportNetworkFlows(instance.getExportNetworkFlows()); 
    this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withMigration(instance.getMigration()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withUseMultiNetworkPolicy(instance.getUseMultiNetworkPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<AdditionalNetworkDefinitionBuilder> additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private DefaultNetworkDefinitionBuilder defaultNetwork;
  private Boolean deployKubeProxy;
  private Boolean disableMultiNetwork;
  private Boolean disableNetworkDiagnostics;
  private ExportNetworkFlowsBuilder exportNetworkFlows;
  private ProxyConfigBuilder kubeProxyConfig;
  private String logLevel;
  private String managementState;
  private NetworkMigrationBuilder migration;
  private VisitableBuilder<? extends KubernetesResource,?> observedConfig;
  private String operatorLogLevel;
  private List<String> serviceNetwork = new ArrayList<String>();
  private VisitableBuilder<? extends KubernetesResource,?> unsupportedConfigOverrides;
  private Boolean useMultiNetworkPolicy;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalNetworks(Integer index,AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(index >= 0 ? index : _visitables.get("additionalNetworks").size(), builder);this.additionalNetworks.add(index >= 0 ? index : additionalNetworks.size(), builder); return (A)this;
  }
  public A setToAdditionalNetworks(Integer index,AdditionalNetworkDefinition item) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalNetworks").size()) { _visitables.get("additionalNetworks").add(builder); } else { _visitables.get("additionalNetworks").set(index, builder);}
    if (index < 0 || index >= additionalNetworks.size()) { additionalNetworks.add(builder); } else { additionalNetworks.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
    if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
  }
  public A removeFromAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
    for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    if (additionalNetworks == null) return (A) this;
    final Iterator<AdditionalNetworkDefinitionBuilder> each = additionalNetworks.iterator();
    final List visitables = _visitables.get("additionalNetworks");
    while (each.hasNext()) {
      AdditionalNetworkDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalNetworks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AdditionalNetworkDefinition> getAdditionalNetworks() {
    return additionalNetworks != null ? build(additionalNetworks) : null;
  }
  public List<AdditionalNetworkDefinition> buildAdditionalNetworks() {
    return additionalNetworks != null ? build(additionalNetworks) : null;
  }
  public AdditionalNetworkDefinition buildAdditionalNetwork(Integer index) {
    return this.additionalNetworks.get(index).build();
  }
  public AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
    return this.additionalNetworks.get(0).build();
  }
  public AdditionalNetworkDefinition buildLastAdditionalNetwork() {
    return this.additionalNetworks.get(additionalNetworks.size() - 1).build();
  }
  public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    for (AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    for (AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks) {
    if (this.additionalNetworks != null) { _visitables.get("additionalNetworks").removeAll(this.additionalNetworks);}
    if (additionalNetworks != null) {this.additionalNetworks = new ArrayList(); for (AdditionalNetworkDefinition item : additionalNetworks){this.addToAdditionalNetworks(item);}} else { this.additionalNetworks = null;} return (A) this;
  }
  public A withAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... additionalNetworks) {
    if (this.additionalNetworks != null) {this.additionalNetworks.clear();}
    if (additionalNetworks != null) {for (AdditionalNetworkDefinition item :additionalNetworks){ this.addToAdditionalNetworks(item);}} return (A) this;
  }
  public Boolean hasAdditionalNetworks() {
    return additionalNetworks != null && !additionalNetworks.isEmpty();
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork() {
    return new NetworkSpecFluentImpl.AdditionalNetworksNestedImpl();
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item) {
    return new NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(-1, item);
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(Integer index,AdditionalNetworkDefinition item) {
    return new NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(index, item);
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(Integer index) {
    if (additionalNetworks.size() <= index) throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
    if (additionalNetworks.size() == 0) throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(0, buildAdditionalNetwork(0));
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork() {
    int index = additionalNetworks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalNetworks.size();i++) { 
    if (predicate.test(additionalNetworks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
    return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
  }
  public A addToClusterNetwork(Integer index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
  }
  public A setToClusterNetwork(Integer index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
    if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public ClusterNetworkEntry buildClusterNetwork(Integer index) {
    return this.clusterNetwork.get(index).build();
  }
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
    if (clusterNetwork != null) {this.clusterNetwork = new ArrayList(); for (ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
    if (clusterNetwork != null) {for (ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(String cidr,Integer hostPrefix) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl();
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index,ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public DefaultNetworkDefinition getDefaultNetwork() {
    return this.defaultNetwork!=null ?this.defaultNetwork.build():null;
  }
  public DefaultNetworkDefinition buildDefaultNetwork() {
    return this.defaultNetwork!=null ?this.defaultNetwork.build():null;
  }
  public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork) {
    _visitables.get("defaultNetwork").remove(this.defaultNetwork);
    if (defaultNetwork!=null){ this.defaultNetwork= new DefaultNetworkDefinitionBuilder(defaultNetwork); _visitables.get("defaultNetwork").add(this.defaultNetwork);} else { this.defaultNetwork = null; _visitables.get("defaultNetwork").remove(this.defaultNetwork); } return (A) this;
  }
  public Boolean hasDefaultNetwork() {
    return this.defaultNetwork != null;
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork() {
    return new NetworkSpecFluentImpl.DefaultNetworkNestedImpl();
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item) {
    return new NetworkSpecFluentImpl.DefaultNetworkNestedImpl(item);
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork() {
    return withNewDefaultNetworkLike(getDefaultNetwork());
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork() {
    return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): new DefaultNetworkDefinitionBuilder().build());
  }
  public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item) {
    return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): item);
  }
  public Boolean getDeployKubeProxy() {
    return this.deployKubeProxy;
  }
  public A withDeployKubeProxy(Boolean deployKubeProxy) {
    this.deployKubeProxy=deployKubeProxy; return (A) this;
  }
  public Boolean hasDeployKubeProxy() {
    return this.deployKubeProxy != null;
  }
  public Boolean getDisableMultiNetwork() {
    return this.disableMultiNetwork;
  }
  public A withDisableMultiNetwork(Boolean disableMultiNetwork) {
    this.disableMultiNetwork=disableMultiNetwork; return (A) this;
  }
  public Boolean hasDisableMultiNetwork() {
    return this.disableMultiNetwork != null;
  }
  public Boolean getDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics;
  }
  public A withDisableNetworkDiagnostics(Boolean disableNetworkDiagnostics) {
    this.disableNetworkDiagnostics=disableNetworkDiagnostics; return (A) this;
  }
  public Boolean hasDisableNetworkDiagnostics() {
    return this.disableNetworkDiagnostics != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExportNetworkFlows instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExportNetworkFlows getExportNetworkFlows() {
    return this.exportNetworkFlows!=null ?this.exportNetworkFlows.build():null;
  }
  public ExportNetworkFlows buildExportNetworkFlows() {
    return this.exportNetworkFlows!=null ?this.exportNetworkFlows.build():null;
  }
  public A withExportNetworkFlows(ExportNetworkFlows exportNetworkFlows) {
    _visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows);
    if (exportNetworkFlows!=null){ this.exportNetworkFlows= new ExportNetworkFlowsBuilder(exportNetworkFlows); _visitables.get("exportNetworkFlows").add(this.exportNetworkFlows);} else { this.exportNetworkFlows = null; _visitables.get("exportNetworkFlows").remove(this.exportNetworkFlows); } return (A) this;
  }
  public Boolean hasExportNetworkFlows() {
    return this.exportNetworkFlows != null;
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlows() {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsNestedImpl();
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> withNewExportNetworkFlowsLike(ExportNetworkFlows item) {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsNestedImpl(item);
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows());
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlows() {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows() != null ? getExportNetworkFlows(): new ExportNetworkFlowsBuilder().build());
  }
  public NetworkSpecFluent.ExportNetworkFlowsNested<A> editOrNewExportNetworkFlowsLike(ExportNetworkFlows item) {
    return withNewExportNetworkFlowsLike(getExportNetworkFlows() != null ? getExportNetworkFlows(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubeProxyConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProxyConfig getKubeProxyConfig() {
    return this.kubeProxyConfig!=null ?this.kubeProxyConfig.build():null;
  }
  public ProxyConfig buildKubeProxyConfig() {
    return this.kubeProxyConfig!=null ?this.kubeProxyConfig.build():null;
  }
  public A withKubeProxyConfig(ProxyConfig kubeProxyConfig) {
    _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
    if (kubeProxyConfig!=null){ this.kubeProxyConfig= new ProxyConfigBuilder(kubeProxyConfig); _visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);} else { this.kubeProxyConfig = null; _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig); } return (A) this;
  }
  public Boolean hasKubeProxyConfig() {
    return this.kubeProxyConfig != null;
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig() {
    return new NetworkSpecFluentImpl.KubeProxyConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item) {
    return new NetworkSpecFluentImpl.KubeProxyConfigNestedImpl(item);
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig() {
    return withNewKubeProxyConfigLike(getKubeProxyConfig());
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
    return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): new ProxyConfigBuilder().build());
  }
  public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item) {
    return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): item);
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMigration instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkMigration getMigration() {
    return this.migration!=null ?this.migration.build():null;
  }
  public NetworkMigration buildMigration() {
    return this.migration!=null ?this.migration.build():null;
  }
  public A withMigration(NetworkMigration migration) {
    _visitables.get("migration").remove(this.migration);
    if (migration!=null){ this.migration= new NetworkMigrationBuilder(migration); _visitables.get("migration").add(this.migration);} else { this.migration = null; _visitables.get("migration").remove(this.migration); } return (A) this;
  }
  public Boolean hasMigration() {
    return this.migration != null;
  }
  public A withNewMigration(String networkType) {
    return (A)withMigration(new NetworkMigration(networkType));
  }
  public NetworkSpecFluent.MigrationNested<A> withNewMigration() {
    return new NetworkSpecFluentImpl.MigrationNestedImpl();
  }
  public NetworkSpecFluent.MigrationNested<A> withNewMigrationLike(NetworkMigration item) {
    return new NetworkSpecFluentImpl.MigrationNestedImpl(item);
  }
  public NetworkSpecFluent.MigrationNested<A> editMigration() {
    return withNewMigrationLike(getMigration());
  }
  public NetworkSpecFluent.MigrationNested<A> editOrNewMigration() {
    return withNewMigrationLike(getMigration() != null ? getMigration(): new NetworkMigrationBuilder().build());
  }
  public NetworkSpecFluent.MigrationNested<A> editOrNewMigrationLike(NetworkMigration item) {
    return withNewMigrationLike(getMigration() != null ? getMigration(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObservedConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public KubernetesResource buildObservedConfig() {
    return this.observedConfig!=null?this.observedConfig.build():null;
  }
  public A withObservedConfig(KubernetesResource observedConfig) {
    if (observedConfig instanceof ServiceCatalogAPIServerList){ this.observedConfig= new ServiceCatalogAPIServerListBuilder((ServiceCatalogAPIServerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof LabelSelector){ this.observedConfig= new LabelSelectorBuilder((LabelSelector)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImagePruner){ this.observedConfig= new ImagePrunerBuilder((ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManager){ this.observedConfig= new KubeControllerManagerBuilder((KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheckStatus){ this.observedConfig= new PodNetworkConnectivityCheckStatusBuilder((PodNetworkConnectivityCheckStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigratorList){ this.observedConfig= new KubeStorageVersionMigratorListBuilder((KubeStorageVersionMigratorList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Storage){ this.observedConfig= new StorageBuilder((Storage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodTemplateSpec){ this.observedConfig= new PodTemplateSpecBuilder((PodTemplateSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManagerStatus){ this.observedConfig= new KubeControllerManagerStatusBuilder((KubeControllerManagerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManagerList){ this.observedConfig= new ServiceCatalogControllerManagerListBuilder((ServiceCatalogControllerManagerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotControllerStatus){ this.observedConfig= new CSISnapshotControllerStatusBuilder((CSISnapshotControllerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IPsecConfig){ this.observedConfig= new IPsecConfigBuilder((IPsecConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicy){ this.observedConfig= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ResourceRequirements){ this.observedConfig= new ResourceRequirementsBuilder((ResourceRequirements)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OVNKubernetesConfig){ this.observedConfig= new OVNKubernetesConfigBuilder((OVNKubernetesConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DeveloperConsoleCatalogCategoryMeta){ this.observedConfig= new DeveloperConsoleCatalogCategoryMetaBuilder((DeveloperConsoleCatalogCategoryMeta)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigratorSpec){ this.observedConfig= new KubeStorageVersionMigratorSpecBuilder((KubeStorageVersionMigratorSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerSpec){ this.observedConfig= new IngressControllerSpecBuilder((IngressControllerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSSpec){ this.observedConfig= new DNSSpecBuilder((DNSSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftSDNConfig){ this.observedConfig= new OpenShiftSDNConfigBuilder((OpenShiftSDNConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OperatorCondition){ this.observedConfig= new OperatorConditionBuilder((OperatorCondition)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerHTTPHeaders){ this.observedConfig= new IngressControllerHTTPHeadersBuilder((IngressControllerHTTPHeaders)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ProxyConfig){ this.observedConfig= new ProxyConfigBuilder((ProxyConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConsoleList){ this.observedConfig= new ConsoleListBuilder((ConsoleList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KuryrConfig){ this.observedConfig= new KuryrConfigBuilder((KuryrConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DeveloperConsoleCatalogCategory){ this.observedConfig= new DeveloperConsoleCatalogCategoryBuilder((DeveloperConsoleCatalogCategory)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManagerSpec){ this.observedConfig= new OpenShiftControllerManagerSpecBuilder((OpenShiftControllerManagerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ExportNetworkFlows){ this.observedConfig= new ExportNetworkFlowsBuilder((ExportNetworkFlows)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriverSpec){ this.observedConfig= new ClusterCSIDriverSpecBuilder((ClusterCSIDriverSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServerSpec){ this.observedConfig= new ServiceCatalogAPIServerSpecBuilder((ServiceCatalogAPIServerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicySpec){ this.observedConfig= new ImageContentSourcePolicySpecBuilder((ImageContentSourcePolicySpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof RepositoryDigestMirrors){ this.observedConfig= new RepositoryDigestMirrorsBuilder((RepositoryDigestMirrors)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConsoleCustomization){ this.observedConfig= new ConsoleCustomizationBuilder((ConsoleCustomization)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotControllerSpec){ this.observedConfig= new CSISnapshotControllerSpecBuilder((CSISnapshotControllerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof UpstreamResolvers){ this.observedConfig= new UpstreamResolversBuilder((UpstreamResolvers)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSStatus){ this.observedConfig= new DNSStatusBuilder((DNSStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerHTTPUniqueIdHeaderPolicy){ this.observedConfig= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder((IngressControllerHTTPUniqueIdHeaderPolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof GCPLoadBalancerParameters){ this.observedConfig= new GCPLoadBalancerParametersBuilder((GCPLoadBalancerParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConfigStatus){ this.observedConfig= new ConfigStatusBuilder((ConfigStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServerList){ this.observedConfig= new KubeAPIServerListBuilder((KubeAPIServerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCA){ this.observedConfig= new ServiceCABuilder((ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManagerSpec){ this.observedConfig= new ServiceCatalogControllerManagerSpecBuilder((ServiceCatalogControllerManagerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Config){ this.observedConfig= new ConfigBuilder((Config)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerList){ this.observedConfig= new IngressControllerListBuilder((IngressControllerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSList){ this.observedConfig= new DNSListBuilder((DNSList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ObjectMeta){ this.observedConfig= new ObjectMetaBuilder((ObjectMeta)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriverList){ this.observedConfig= new ClusterCSIDriverListBuilder((ClusterCSIDriverList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof SimpleMacvlanConfig){ this.observedConfig= new SimpleMacvlanConfigBuilder((SimpleMacvlanConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PersistentVolumeClaim){ this.observedConfig= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServerStatus){ this.observedConfig= new KubeAPIServerStatusBuilder((KubeAPIServerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AWSClassicLoadBalancerParameters){ this.observedConfig= new AWSClassicLoadBalancerParametersBuilder((AWSClassicLoadBalancerParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServer){ this.observedConfig= new KubeAPIServerBuilder((KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressController){ this.observedConfig= new IngressControllerBuilder((IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConsoleConfigRoute){ this.observedConfig= new ConsoleConfigRouteBuilder((ConsoleConfigRoute)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredentialStatus){ this.observedConfig= new CloudCredentialStatusBuilder((CloudCredentialStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigrator){ this.observedConfig= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof GenericKubernetesResource){ this.observedConfig= new GenericKubernetesResourceBuilder((GenericKubernetesResource)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerStatus){ this.observedConfig= new IngressControllerStatusBuilder((IngressControllerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManagerStatus){ this.observedConfig= new ServiceCatalogControllerManagerStatusBuilder((ServiceCatalogControllerManagerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof HybridOverlayConfig){ this.observedConfig= new HybridOverlayConfigBuilder((HybridOverlayConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AWSLoadBalancerParameters){ this.observedConfig= new AWSLoadBalancerParametersBuilder((AWSLoadBalancerParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImagePrunerList){ this.observedConfig= new ImagePrunerListBuilder((ImagePrunerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotControllerList){ this.observedConfig= new CSISnapshotControllerListBuilder((CSISnapshotControllerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof LocalObjectReference){ this.observedConfig= new LocalObjectReferenceBuilder((LocalObjectReference)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Console){ this.observedConfig= new ConsoleBuilder((Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StaticIPAMRoutes){ this.observedConfig= new StaticIPAMRoutesBuilder((StaticIPAMRoutes)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSZoneCondition){ this.observedConfig= new DNSZoneConditionBuilder((DNSZoneCondition)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ContainerLoggingDestinationParameters){ this.observedConfig= new ContainerLoggingDestinationParametersBuilder((ContainerLoggingDestinationParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeSchedulerList){ this.observedConfig= new KubeSchedulerListBuilder((KubeSchedulerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeAPIServerSpec){ this.observedConfig= new KubeAPIServerSpecBuilder((KubeAPIServerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriver){ this.observedConfig= new ClusterCSIDriverBuilder((ClusterCSIDriver)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof QuickStarts){ this.observedConfig= new QuickStartsBuilder((QuickStarts)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSZoneStatus){ this.observedConfig= new DNSZoneStatusBuilder((DNSZoneStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManager){ this.observedConfig= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConfigSpec){ this.observedConfig= new ConfigSpecBuilder((ConfigSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OutageEntry){ this.observedConfig= new OutageEntryBuilder((OutageEntry)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManagerList){ this.observedConfig= new OpenShiftControllerManagerListBuilder((OpenShiftControllerManagerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Etcd){ this.observedConfig= new EtcdBuilder((Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof EndpointPublishingStrategy){ this.observedConfig= new EndpointPublishingStrategyBuilder((EndpointPublishingStrategy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IPFIXConfig){ this.observedConfig= new IPFIXConfigBuilder((IPFIXConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredential){ this.observedConfig= new CloudCredentialBuilder((CloudCredential)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeScheduler){ this.observedConfig= new KubeSchedulerBuilder((KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterCSIDriverStatus){ this.observedConfig= new ClusterCSIDriverStatusBuilder((ClusterCSIDriverStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NetworkStatus){ this.observedConfig= new NetworkStatusBuilder((NetworkStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof SFlowConfig){ this.observedConfig= new SFlowConfigBuilder((SFlowConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ForwardPlugin){ this.observedConfig= new ForwardPluginBuilder((ForwardPlugin)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof LogEntry){ this.observedConfig= new LogEntryBuilder((LogEntry)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NodeStatus){ this.observedConfig= new NodeStatusBuilder((NodeStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheckCondition){ this.observedConfig= new PodNetworkConnectivityCheckConditionBuilder((PodNetworkConnectivityCheckCondition)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AdditionalNetworkDefinition){ this.observedConfig= new AdditionalNetworkDefinitionBuilder((AdditionalNetworkDefinition)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof RouteAdmissionPolicy){ this.observedConfig= new RouteAdmissionPolicyBuilder((RouteAdmissionPolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof GenerationStatus){ this.observedConfig= new GenerationStatusBuilder((GenerationStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AuthenticationStatus){ this.observedConfig= new AuthenticationStatusBuilder((AuthenticationStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerCaptureHTTPHeaders){ this.observedConfig= new IngressControllerCaptureHTTPHeadersBuilder((IngressControllerCaptureHTTPHeaders)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof EtcdList){ this.observedConfig= new EtcdListBuilder((EtcdList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NodePortStrategy){ this.observedConfig= new NodePortStrategyBuilder((NodePortStrategy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DefaultNetworkDefinition){ this.observedConfig= new DefaultNetworkDefinitionBuilder((DefaultNetworkDefinition)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Network){ this.observedConfig= new NetworkBuilder((Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClientTLS){ this.observedConfig= new ClientTLSBuilder((ClientTLS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServerSpec){ this.observedConfig= new OpenShiftAPIServerSpecBuilder((OpenShiftAPIServerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImagePrunerStatus){ this.observedConfig= new ImagePrunerStatusBuilder((ImagePrunerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeSchedulerStatus){ this.observedConfig= new KubeSchedulerStatusBuilder((KubeSchedulerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof SyslogLoggingDestinationParameters){ this.observedConfig= new SyslogLoggingDestinationParametersBuilder((SyslogLoggingDestinationParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Upstream){ this.observedConfig= new UpstreamBuilder((Upstream)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AWSNetworkLoadBalancerParameters){ this.observedConfig= new AWSNetworkLoadBalancerParametersBuilder((AWSNetworkLoadBalancerParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCAList){ this.observedConfig= new ServiceCAListBuilder((ServiceCAList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServer){ this.observedConfig= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerCaptureHTTPHeader){ this.observedConfig= new IngressControllerCaptureHTTPHeaderBuilder((IngressControllerCaptureHTTPHeader)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NetworkMigration){ this.observedConfig= new NetworkMigrationBuilder((NetworkMigration)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecordList){ this.observedConfig= new DNSRecordListBuilder((DNSRecordList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof RawExtension){ this.observedConfig= new RawExtensionBuilder((RawExtension)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof EtcdSpec){ this.observedConfig= new EtcdSpecBuilder((EtcdSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheck){ this.observedConfig= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServerStatus){ this.observedConfig= new OpenShiftAPIServerStatusBuilder((OpenShiftAPIServerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof LoadBalancerStrategy){ this.observedConfig= new LoadBalancerStrategyBuilder((LoadBalancerStrategy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof EtcdStatus){ this.observedConfig= new EtcdStatusBuilder((EtcdStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredentialList){ this.observedConfig= new CloudCredentialListBuilder((CloudCredentialList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImagePrunerSpec){ this.observedConfig= new ImagePrunerSpecBuilder((ImagePrunerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StatuspageProvider){ this.observedConfig= new StatuspageProviderBuilder((StatuspageProvider)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeStorageVersionMigratorStatus){ this.observedConfig= new KubeStorageVersionMigratorStatusBuilder((KubeStorageVersionMigratorStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConfigList){ this.observedConfig= new ConfigListBuilder((ConfigList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConsoleProviders){ this.observedConfig= new ConsoleProvidersBuilder((ConsoleProviders)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerLogging){ this.observedConfig= new IngressControllerLoggingBuilder((IngressControllerLogging)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AuthenticationList){ this.observedConfig= new AuthenticationListBuilder((AuthenticationList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StorageStatus){ this.observedConfig= new StorageStatusBuilder((StorageStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManagerList){ this.observedConfig= new KubeControllerManagerListBuilder((KubeControllerManagerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AuthenticationSpec){ this.observedConfig= new AuthenticationSpecBuilder((AuthenticationSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IPAMConfig){ this.observedConfig= new IPAMConfigBuilder((IPAMConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Container){ this.observedConfig= new ContainerBuilder((Container)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CSISnapshotController){ this.observedConfig= new CSISnapshotControllerBuilder((CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheckSpec){ this.observedConfig= new PodNetworkConnectivityCheckSpecBuilder((PodNetworkConnectivityCheckSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AccessLogging){ this.observedConfig= new AccessLoggingBuilder((AccessLogging)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof HostNetworkStrategy){ this.observedConfig= new HostNetworkStrategyBuilder((HostNetworkStrategy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecordSpec){ this.observedConfig= new DNSRecordSpecBuilder((DNSRecordSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DeveloperConsoleCatalogCustomization){ this.observedConfig= new DeveloperConsoleCatalogCustomizationBuilder((DeveloperConsoleCatalogCustomization)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeSchedulerSpec){ this.observedConfig= new KubeSchedulerSpecBuilder((KubeSchedulerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof LoggingDestination){ this.observedConfig= new LoggingDestinationBuilder((LoggingDestination)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerTuningOptions){ this.observedConfig= new IngressControllerTuningOptionsBuilder((IngressControllerTuningOptions)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StaticIPAMConfig){ this.observedConfig= new StaticIPAMConfigBuilder((StaticIPAMConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ImageContentSourcePolicyList){ this.observedConfig= new ImageContentSourcePolicyListBuilder((ImageContentSourcePolicyList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftControllerManagerStatus){ this.observedConfig= new OpenShiftControllerManagerStatusBuilder((OpenShiftControllerManagerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogAPIServerStatus){ this.observedConfig= new ServiceCatalogAPIServerStatusBuilder((ServiceCatalogAPIServerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof KubeControllerManagerSpec){ this.observedConfig= new KubeControllerManagerSpecBuilder((KubeControllerManagerSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StaticIPAMDNS){ this.observedConfig= new StaticIPAMDNSBuilder((StaticIPAMDNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSNodePlacement){ this.observedConfig= new DNSNodePlacementBuilder((DNSNodePlacement)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StorageSpec){ this.observedConfig= new StorageSpecBuilder((StorageSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NetworkList){ this.observedConfig= new NetworkListBuilder((NetworkList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NodePlacement){ this.observedConfig= new NodePlacementBuilder((NodePlacement)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ProviderLoadBalancerParameters){ this.observedConfig= new ProviderLoadBalancerParametersBuilder((ProviderLoadBalancerParameters)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NetworkSpec){ this.observedConfig= new NetworkSpecBuilder((NetworkSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCASpec){ this.observedConfig= new ServiceCASpecBuilder((ServiceCASpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PrivateStrategy){ this.observedConfig= new PrivateStrategyBuilder((PrivateStrategy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConsoleStatus){ this.observedConfig= new ConsoleStatusBuilder((ConsoleStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PodNetworkConnectivityCheckList){ this.observedConfig= new PodNetworkConnectivityCheckListBuilder((PodNetworkConnectivityCheckList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ObjectReference){ this.observedConfig= new ObjectReferenceBuilder((ObjectReference)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServerList){ this.observedConfig= new OpenShiftAPIServerListBuilder((OpenShiftAPIServerList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Server){ this.observedConfig= new ServerBuilder((Server)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OAuthAPIServerStatus){ this.observedConfig= new OAuthAPIServerStatusBuilder((OAuthAPIServerStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof CloudCredentialSpec){ this.observedConfig= new CloudCredentialSpecBuilder((CloudCredentialSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecordStatus){ this.observedConfig= new DNSRecordStatusBuilder((DNSRecordStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCatalogControllerManager){ this.observedConfig= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ClusterNetworkEntry){ this.observedConfig= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof IngressControllerCaptureHTTPCookie){ this.observedConfig= new IngressControllerCaptureHTTPCookieBuilder((IngressControllerCaptureHTTPCookie)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof HTTPCompressionPolicy){ this.observedConfig= new HTTPCompressionPolicyBuilder((HTTPCompressionPolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ProjectAccess){ this.observedConfig= new ProjectAccessBuilder((ProjectAccess)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNS){ this.observedConfig= new DNSBuilder((DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof NetFlowConfig){ this.observedConfig= new NetFlowConfigBuilder((NetFlowConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof PolicyAuditConfig){ this.observedConfig= new PolicyAuditConfigBuilder((PolicyAuditConfig)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof AddPage){ this.observedConfig= new AddPageBuilder((AddPage)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StorageList){ this.observedConfig= new StorageListBuilder((StorageList)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof StaticIPAMAddresses){ this.observedConfig= new StaticIPAMAddressesBuilder((StaticIPAMAddresses)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof DNSRecord){ this.observedConfig= new DNSRecordBuilder((DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof OpenShiftAPIServer){ this.observedConfig= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof Authentication){ this.observedConfig= new AuthenticationBuilder((Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ConsoleSpec){ this.observedConfig= new ConsoleSpecBuilder((ConsoleSpec)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    if (observedConfig instanceof ServiceCAStatus){ this.observedConfig= new ServiceCAStatusBuilder((ServiceCAStatus)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
    return (A) this;
  }
  public Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public A withServiceCatalogAPIServerListObservedConfig(ServiceCatalogAPIServerList serviceCatalogAPIServerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerListObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerListBuilder(serviceCatalogAPIServerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerListObservedConfigNested<A> withNewServiceCatalogAPIServerListObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerListObservedConfigNested<A> withNewServiceCatalogAPIServerListObservedConfigLike(ServiceCatalogAPIServerList item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerListObservedConfigNestedImpl(item);
  }
  public A withLabelSelectorObservedConfig(LabelSelector labelSelectorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (labelSelectorObservedConfig!=null){ this.observedConfig= new LabelSelectorBuilder(labelSelectorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.LabelSelectorObservedConfigNested<A> withNewLabelSelectorObservedConfig() {
    return new NetworkSpecFluentImpl.LabelSelectorObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.LabelSelectorObservedConfigNested<A> withNewLabelSelectorObservedConfigLike(LabelSelector item) {
    return new NetworkSpecFluentImpl.LabelSelectorObservedConfigNestedImpl(item);
  }
  public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerObservedConfig!=null){ this.observedConfig= new ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
    return new NetworkSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
    return new NetworkSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
    return new NetworkSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckStatusObservedConfig(PodNetworkConnectivityCheckStatus podNetworkConnectivityCheckStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckStatusObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckStatusBuilder(podNetworkConnectivityCheckStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckStatusObservedConfigNested<A> withNewPodNetworkConnectivityCheckStatusObservedConfig() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckStatusObservedConfigNested<A> withNewPodNetworkConnectivityCheckStatusObservedConfigLike(PodNetworkConnectivityCheckStatus item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckStatusObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorListObservedConfig(KubeStorageVersionMigratorList kubeStorageVersionMigratorListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorListObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorListBuilder(kubeStorageVersionMigratorListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorListObservedConfigNested<A> withNewKubeStorageVersionMigratorListObservedConfig() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorListObservedConfigNested<A> withNewKubeStorageVersionMigratorListObservedConfigLike(KubeStorageVersionMigratorList item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorListObservedConfigNestedImpl(item);
  }
  public A withStorageObservedConfig(Storage storageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageObservedConfig!=null){ this.observedConfig= new StorageBuilder(storageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfig() {
    return new NetworkSpecFluentImpl.StorageObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StorageObservedConfigNested<A> withNewStorageObservedConfigLike(Storage item) {
    return new NetworkSpecFluentImpl.StorageObservedConfigNestedImpl(item);
  }
  public A withPodTemplateSpecObservedConfig(PodTemplateSpec podTemplateSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podTemplateSpecObservedConfig!=null){ this.observedConfig= new PodTemplateSpecBuilder(podTemplateSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodTemplateSpecObservedConfigNested<A> withNewPodTemplateSpecObservedConfig() {
    return new NetworkSpecFluentImpl.PodTemplateSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodTemplateSpecObservedConfigNested<A> withNewPodTemplateSpecObservedConfigLike(PodTemplateSpec item) {
    return new NetworkSpecFluentImpl.PodTemplateSpecObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerStatusObservedConfig(KubeControllerManagerStatus kubeControllerManagerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerStatusObservedConfig!=null){ this.observedConfig= new KubeControllerManagerStatusBuilder(kubeControllerManagerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerStatusObservedConfigNested<A> withNewKubeControllerManagerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.KubeControllerManagerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerStatusObservedConfigNested<A> withNewKubeControllerManagerStatusObservedConfigLike(KubeControllerManagerStatus item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerStatusObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerListObservedConfig(ServiceCatalogControllerManagerList serviceCatalogControllerManagerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerListObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerListBuilder(serviceCatalogControllerManagerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerListObservedConfigNested<A> withNewServiceCatalogControllerManagerListObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerListObservedConfigNested<A> withNewServiceCatalogControllerManagerListObservedConfigLike(ServiceCatalogControllerManagerList item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerListObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerStatusObservedConfig(CSISnapshotControllerStatus cSISnapshotControllerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerStatusObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerStatusBuilder(cSISnapshotControllerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerStatusObservedConfigNested<A> withNewCSISnapshotControllerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerStatusObservedConfigNested<A> withNewCSISnapshotControllerStatusObservedConfigLike(CSISnapshotControllerStatus item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerStatusObservedConfigNestedImpl(item);
  }
  public A withIPsecConfigObserved(IPsecConfig iPsecConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (iPsecConfigObserved!=null){ this.observedConfig= new IPsecConfigBuilder(iPsecConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IPsecConfigObservedNested<A> withNewIPsecConfigObserved() {
    return new NetworkSpecFluentImpl.IPsecConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.IPsecConfigObservedNested<A> withNewIPsecConfigObservedLike(IPsecConfig item) {
    return new NetworkSpecFluentImpl.IPsecConfigObservedNestedImpl(item);
  }
  public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
  }
  public A withResourceRequirementsObservedConfig(ResourceRequirements resourceRequirementsObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (resourceRequirementsObservedConfig!=null){ this.observedConfig= new ResourceRequirementsBuilder(resourceRequirementsObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ResourceRequirementsObservedConfigNested<A> withNewResourceRequirementsObservedConfig() {
    return new NetworkSpecFluentImpl.ResourceRequirementsObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ResourceRequirementsObservedConfigNested<A> withNewResourceRequirementsObservedConfigLike(ResourceRequirements item) {
    return new NetworkSpecFluentImpl.ResourceRequirementsObservedConfigNestedImpl(item);
  }
  public A withOVNKubernetesConfigObserved(OVNKubernetesConfig oVNKubernetesConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (oVNKubernetesConfigObserved!=null){ this.observedConfig= new OVNKubernetesConfigBuilder(oVNKubernetesConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OVNKubernetesConfigObservedNested<A> withNewOVNKubernetesConfigObserved() {
    return new NetworkSpecFluentImpl.OVNKubernetesConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.OVNKubernetesConfigObservedNested<A> withNewOVNKubernetesConfigObservedLike(OVNKubernetesConfig item) {
    return new NetworkSpecFluentImpl.OVNKubernetesConfigObservedNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCategoryMetaObservedConfig(DeveloperConsoleCatalogCategoryMeta developerConsoleCatalogCategoryMetaObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (developerConsoleCatalogCategoryMetaObservedConfig!=null){ this.observedConfig= new DeveloperConsoleCatalogCategoryMetaBuilder(developerConsoleCatalogCategoryMetaObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryMetaObservedConfig() {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryMetaObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryMetaObservedConfigLike(DeveloperConsoleCatalogCategoryMeta item) {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryMetaObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorSpecObservedConfig(KubeStorageVersionMigratorSpec kubeStorageVersionMigratorSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorSpecObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorSpecBuilder(kubeStorageVersionMigratorSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorSpecObservedConfigNested<A> withNewKubeStorageVersionMigratorSpecObservedConfig() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorSpecObservedConfigNested<A> withNewKubeStorageVersionMigratorSpecObservedConfigLike(KubeStorageVersionMigratorSpec item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorSpecObservedConfigNestedImpl(item);
  }
  public A withIngressControllerSpecObservedConfig(IngressControllerSpec ingressControllerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerSpecObservedConfig!=null){ this.observedConfig= new IngressControllerSpecBuilder(ingressControllerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerSpecObservedConfigNested<A> withNewIngressControllerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerSpecObservedConfigNested<A> withNewIngressControllerSpecObservedConfigLike(IngressControllerSpec item) {
    return new NetworkSpecFluentImpl.IngressControllerSpecObservedConfigNestedImpl(item);
  }
  public A withDNSSpecObservedConfig(DNSSpec dNSSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSSpecObservedConfig!=null){ this.observedConfig= new DNSSpecBuilder(dNSSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSSpecObservedConfigNested<A> withNewDNSSpecObservedConfig() {
    return new NetworkSpecFluentImpl.DNSSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSSpecObservedConfigNested<A> withNewDNSSpecObservedConfigLike(DNSSpec item) {
    return new NetworkSpecFluentImpl.DNSSpecObservedConfigNestedImpl(item);
  }
  public A withOpenShiftSDNConfigObserved(OpenShiftSDNConfig openShiftSDNConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftSDNConfigObserved!=null){ this.observedConfig= new OpenShiftSDNConfigBuilder(openShiftSDNConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftSDNConfigObservedNested<A> withNewOpenShiftSDNConfigObserved() {
    return new NetworkSpecFluentImpl.OpenShiftSDNConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftSDNConfigObservedNested<A> withNewOpenShiftSDNConfigObservedLike(OpenShiftSDNConfig item) {
    return new NetworkSpecFluentImpl.OpenShiftSDNConfigObservedNestedImpl(item);
  }
  public A withNewOpenShiftSDNConfigObserved(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withOpenShiftSDNConfigObserved(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  public A withOperatorConditionObservedConfig(OperatorCondition operatorConditionObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (operatorConditionObservedConfig!=null){ this.observedConfig= new OperatorConditionBuilder(operatorConditionObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OperatorConditionObservedConfigNested<A> withNewOperatorConditionObservedConfig() {
    return new NetworkSpecFluentImpl.OperatorConditionObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OperatorConditionObservedConfigNested<A> withNewOperatorConditionObservedConfigLike(OperatorCondition item) {
    return new NetworkSpecFluentImpl.OperatorConditionObservedConfigNestedImpl(item);
  }
  public A withNewOperatorConditionObservedConfig(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withOperatorConditionObservedConfig(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withIngressControllerHTTPHeadersObservedConfig(IngressControllerHTTPHeaders ingressControllerHTTPHeadersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerHTTPHeadersObservedConfig!=null){ this.observedConfig= new IngressControllerHTTPHeadersBuilder(ingressControllerHTTPHeadersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerHTTPHeadersObservedConfigNested<A> withNewIngressControllerHTTPHeadersObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerHTTPHeadersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerHTTPHeadersObservedConfigNested<A> withNewIngressControllerHTTPHeadersObservedConfigLike(IngressControllerHTTPHeaders item) {
    return new NetworkSpecFluentImpl.IngressControllerHTTPHeadersObservedConfigNestedImpl(item);
  }
  public A withProxyConfigObserved(ProxyConfig proxyConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (proxyConfigObserved!=null){ this.observedConfig= new ProxyConfigBuilder(proxyConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ProxyConfigObservedNested<A> withNewProxyConfigObserved() {
    return new NetworkSpecFluentImpl.ProxyConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.ProxyConfigObservedNested<A> withNewProxyConfigObservedLike(ProxyConfig item) {
    return new NetworkSpecFluentImpl.ProxyConfigObservedNestedImpl(item);
  }
  public A withConsoleListObservedConfig(ConsoleList consoleListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleListObservedConfig!=null){ this.observedConfig= new ConsoleListBuilder(consoleListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleListObservedConfigNested<A> withNewConsoleListObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleListObservedConfigNested<A> withNewConsoleListObservedConfigLike(ConsoleList item) {
    return new NetworkSpecFluentImpl.ConsoleListObservedConfigNestedImpl(item);
  }
  public A withKuryrConfigObserved(KuryrConfig kuryrConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kuryrConfigObserved!=null){ this.observedConfig= new KuryrConfigBuilder(kuryrConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KuryrConfigObservedNested<A> withNewKuryrConfigObserved() {
    return new NetworkSpecFluentImpl.KuryrConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.KuryrConfigObservedNested<A> withNewKuryrConfigObservedLike(KuryrConfig item) {
    return new NetworkSpecFluentImpl.KuryrConfigObservedNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCategoryObservedConfig(DeveloperConsoleCatalogCategory developerConsoleCatalogCategoryObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (developerConsoleCatalogCategoryObservedConfig!=null){ this.observedConfig= new DeveloperConsoleCatalogCategoryBuilder(developerConsoleCatalogCategoryObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryObservedConfig() {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryObservedConfigNested<A> withNewDeveloperConsoleCatalogCategoryObservedConfigLike(DeveloperConsoleCatalogCategory item) {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerSpecObservedConfig(OpenShiftControllerManagerSpec openShiftControllerManagerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerSpecObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerSpecBuilder(openShiftControllerManagerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerSpecObservedConfigNested<A> withNewOpenShiftControllerManagerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerSpecObservedConfigNested<A> withNewOpenShiftControllerManagerSpecObservedConfigLike(OpenShiftControllerManagerSpec item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerSpecObservedConfigNestedImpl(item);
  }
  public A withExportNetworkFlowsObservedConfig(ExportNetworkFlows exportNetworkFlowsObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (exportNetworkFlowsObservedConfig!=null){ this.observedConfig= new ExportNetworkFlowsBuilder(exportNetworkFlowsObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ExportNetworkFlowsObservedConfigNested<A> withNewExportNetworkFlowsObservedConfig() {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ExportNetworkFlowsObservedConfigNested<A> withNewExportNetworkFlowsObservedConfigLike(ExportNetworkFlows item) {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverSpecObservedConfig(ClusterCSIDriverSpec clusterCSIDriverSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverSpecObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverSpecBuilder(clusterCSIDriverSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverSpecObservedConfigNested<A> withNewClusterCSIDriverSpecObservedConfig() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverSpecObservedConfigNested<A> withNewClusterCSIDriverSpecObservedConfigLike(ClusterCSIDriverSpec item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverSpecObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerSpecObservedConfig(ServiceCatalogAPIServerSpec serviceCatalogAPIServerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerSpecObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerSpecBuilder(serviceCatalogAPIServerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerSpecObservedConfigNested<A> withNewServiceCatalogAPIServerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerSpecObservedConfigNested<A> withNewServiceCatalogAPIServerSpecObservedConfigLike(ServiceCatalogAPIServerSpec item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerSpecObservedConfigNestedImpl(item);
  }
  public A withImageContentSourcePolicySpecObservedConfig(ImageContentSourcePolicySpec imageContentSourcePolicySpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicySpecObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicySpecBuilder(imageContentSourcePolicySpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicySpecObservedConfigNested<A> withNewImageContentSourcePolicySpecObservedConfig() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicySpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicySpecObservedConfigNested<A> withNewImageContentSourcePolicySpecObservedConfigLike(ImageContentSourcePolicySpec item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicySpecObservedConfigNestedImpl(item);
  }
  public A withRepositoryDigestMirrorsObservedConfig(RepositoryDigestMirrors repositoryDigestMirrorsObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (repositoryDigestMirrorsObservedConfig!=null){ this.observedConfig= new RepositoryDigestMirrorsBuilder(repositoryDigestMirrorsObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.RepositoryDigestMirrorsObservedConfigNested<A> withNewRepositoryDigestMirrorsObservedConfig() {
    return new NetworkSpecFluentImpl.RepositoryDigestMirrorsObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.RepositoryDigestMirrorsObservedConfigNested<A> withNewRepositoryDigestMirrorsObservedConfigLike(RepositoryDigestMirrors item) {
    return new NetworkSpecFluentImpl.RepositoryDigestMirrorsObservedConfigNestedImpl(item);
  }
  public A withConsoleCustomizationObservedConfig(ConsoleCustomization consoleCustomizationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleCustomizationObservedConfig!=null){ this.observedConfig= new ConsoleCustomizationBuilder(consoleCustomizationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleCustomizationObservedConfigNested<A> withNewConsoleCustomizationObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleCustomizationObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleCustomizationObservedConfigNested<A> withNewConsoleCustomizationObservedConfigLike(ConsoleCustomization item) {
    return new NetworkSpecFluentImpl.ConsoleCustomizationObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerSpecObservedConfig(CSISnapshotControllerSpec cSISnapshotControllerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerSpecObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerSpecBuilder(cSISnapshotControllerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerSpecObservedConfigNested<A> withNewCSISnapshotControllerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerSpecObservedConfigNested<A> withNewCSISnapshotControllerSpecObservedConfigLike(CSISnapshotControllerSpec item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerSpecObservedConfigNestedImpl(item);
  }
  public A withUpstreamResolversObservedConfig(UpstreamResolvers upstreamResolversObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (upstreamResolversObservedConfig!=null){ this.observedConfig= new UpstreamResolversBuilder(upstreamResolversObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.UpstreamResolversObservedConfigNested<A> withNewUpstreamResolversObservedConfig() {
    return new NetworkSpecFluentImpl.UpstreamResolversObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.UpstreamResolversObservedConfigNested<A> withNewUpstreamResolversObservedConfigLike(UpstreamResolvers item) {
    return new NetworkSpecFluentImpl.UpstreamResolversObservedConfigNestedImpl(item);
  }
  public A withDNSStatusObservedConfig(DNSStatus dNSStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSStatusObservedConfig!=null){ this.observedConfig= new DNSStatusBuilder(dNSStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSStatusObservedConfigNested<A> withNewDNSStatusObservedConfig() {
    return new NetworkSpecFluentImpl.DNSStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSStatusObservedConfigNested<A> withNewDNSStatusObservedConfigLike(DNSStatus item) {
    return new NetworkSpecFluentImpl.DNSStatusObservedConfigNestedImpl(item);
  }
  public A withIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig(IngressControllerHTTPUniqueIdHeaderPolicy ingressControllerHTTPUniqueIdHeaderPolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerHTTPUniqueIdHeaderPolicyObservedConfig!=null){ this.observedConfig= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(ingressControllerHTTPUniqueIdHeaderPolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyObservedConfigLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new NetworkSpecFluentImpl.IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNestedImpl(item);
  }
  public A withNewIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig(String format,String name) {
    return (A)withIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  public A withGCPLoadBalancerParametersObservedConfig(GCPLoadBalancerParameters gCPLoadBalancerParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (gCPLoadBalancerParametersObservedConfig!=null){ this.observedConfig= new GCPLoadBalancerParametersBuilder(gCPLoadBalancerParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.GCPLoadBalancerParametersObservedConfigNested<A> withNewGCPLoadBalancerParametersObservedConfig() {
    return new NetworkSpecFluentImpl.GCPLoadBalancerParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.GCPLoadBalancerParametersObservedConfigNested<A> withNewGCPLoadBalancerParametersObservedConfigLike(GCPLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.GCPLoadBalancerParametersObservedConfigNestedImpl(item);
  }
  public A withNewGCPLoadBalancerParametersObservedConfig(String clientAccess) {
    return (A)withGCPLoadBalancerParametersObservedConfig(new GCPLoadBalancerParameters(clientAccess));
  }
  public A withConfigStatusObservedConfig(ConfigStatus configStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configStatusObservedConfig!=null){ this.observedConfig= new ConfigStatusBuilder(configStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConfigStatusObservedConfigNested<A> withNewConfigStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ConfigStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConfigStatusObservedConfigNested<A> withNewConfigStatusObservedConfigLike(ConfigStatus item) {
    return new NetworkSpecFluentImpl.ConfigStatusObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerListObservedConfig(KubeAPIServerList kubeAPIServerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerListObservedConfig!=null){ this.observedConfig= new KubeAPIServerListBuilder(kubeAPIServerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerListObservedConfigNested<A> withNewKubeAPIServerListObservedConfig() {
    return new NetworkSpecFluentImpl.KubeAPIServerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerListObservedConfigNested<A> withNewKubeAPIServerListObservedConfigLike(KubeAPIServerList item) {
    return new NetworkSpecFluentImpl.KubeAPIServerListObservedConfigNestedImpl(item);
  }
  public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAObservedConfig!=null){ this.observedConfig= new ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
    return new NetworkSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerSpecObservedConfig(ServiceCatalogControllerManagerSpec serviceCatalogControllerManagerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerSpecObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerSpecBuilder(serviceCatalogControllerManagerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerSpecObservedConfigNested<A> withNewServiceCatalogControllerManagerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerSpecObservedConfigNested<A> withNewServiceCatalogControllerManagerSpecObservedConfigLike(ServiceCatalogControllerManagerSpec item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerSpecObservedConfigNestedImpl(item);
  }
  public A withConfigObservedConfig(Config configObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configObservedConfig!=null){ this.observedConfig= new ConfigBuilder(configObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfig() {
    return new NetworkSpecFluentImpl.ConfigObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConfigObservedConfigNested<A> withNewConfigObservedConfigLike(Config item) {
    return new NetworkSpecFluentImpl.ConfigObservedConfigNestedImpl(item);
  }
  public A withIngressControllerListObservedConfig(IngressControllerList ingressControllerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerListObservedConfig!=null){ this.observedConfig= new IngressControllerListBuilder(ingressControllerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerListObservedConfigNested<A> withNewIngressControllerListObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerListObservedConfigNested<A> withNewIngressControllerListObservedConfigLike(IngressControllerList item) {
    return new NetworkSpecFluentImpl.IngressControllerListObservedConfigNestedImpl(item);
  }
  public A withDNSListObservedConfig(DNSList dNSListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSListObservedConfig!=null){ this.observedConfig= new DNSListBuilder(dNSListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSListObservedConfigNested<A> withNewDNSListObservedConfig() {
    return new NetworkSpecFluentImpl.DNSListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSListObservedConfigNested<A> withNewDNSListObservedConfigLike(DNSList item) {
    return new NetworkSpecFluentImpl.DNSListObservedConfigNestedImpl(item);
  }
  public A withObjectMetaObservedConfig(ObjectMeta objectMetaObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (objectMetaObservedConfig!=null){ this.observedConfig= new ObjectMetaBuilder(objectMetaObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ObjectMetaObservedConfigNested<A> withNewObjectMetaObservedConfig() {
    return new NetworkSpecFluentImpl.ObjectMetaObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ObjectMetaObservedConfigNested<A> withNewObjectMetaObservedConfigLike(ObjectMeta item) {
    return new NetworkSpecFluentImpl.ObjectMetaObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverListObservedConfig(ClusterCSIDriverList clusterCSIDriverListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverListObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverListBuilder(clusterCSIDriverListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverListObservedConfigNested<A> withNewClusterCSIDriverListObservedConfig() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverListObservedConfigNested<A> withNewClusterCSIDriverListObservedConfigLike(ClusterCSIDriverList item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverListObservedConfigNestedImpl(item);
  }
  public A withSimpleMacvlanConfigObserved(SimpleMacvlanConfig simpleMacvlanConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (simpleMacvlanConfigObserved!=null){ this.observedConfig= new SimpleMacvlanConfigBuilder(simpleMacvlanConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.SimpleMacvlanConfigObservedNested<A> withNewSimpleMacvlanConfigObserved() {
    return new NetworkSpecFluentImpl.SimpleMacvlanConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.SimpleMacvlanConfigObservedNested<A> withNewSimpleMacvlanConfigObservedLike(SimpleMacvlanConfig item) {
    return new NetworkSpecFluentImpl.SimpleMacvlanConfigObservedNestedImpl(item);
  }
  public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerStatusObservedConfig(KubeAPIServerStatus kubeAPIServerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerStatusObservedConfig!=null){ this.observedConfig= new KubeAPIServerStatusBuilder(kubeAPIServerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerStatusObservedConfigNested<A> withNewKubeAPIServerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.KubeAPIServerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerStatusObservedConfigNested<A> withNewKubeAPIServerStatusObservedConfigLike(KubeAPIServerStatus item) {
    return new NetworkSpecFluentImpl.KubeAPIServerStatusObservedConfigNestedImpl(item);
  }
  public A withAWSClassicLoadBalancerParametersObservedConfig(AWSClassicLoadBalancerParameters aWSClassicLoadBalancerParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (aWSClassicLoadBalancerParametersObservedConfig!=null){ this.observedConfig= new AWSClassicLoadBalancerParametersBuilder(aWSClassicLoadBalancerParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AWSClassicLoadBalancerParametersObservedConfigNested<A> withNewAWSClassicLoadBalancerParametersObservedConfig() {
    return new NetworkSpecFluentImpl.AWSClassicLoadBalancerParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AWSClassicLoadBalancerParametersObservedConfigNested<A> withNewAWSClassicLoadBalancerParametersObservedConfigLike(AWSClassicLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.AWSClassicLoadBalancerParametersObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
    return new NetworkSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
    return new NetworkSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerObservedConfig!=null){ this.observedConfig= new IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
    return new NetworkSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
  }
  public A withConsoleConfigRouteObserved(ConsoleConfigRoute consoleConfigRouteObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleConfigRouteObserved!=null){ this.observedConfig= new ConsoleConfigRouteBuilder(consoleConfigRouteObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleConfigRouteObservedNested<A> withNewConsoleConfigRouteObserved() {
    return new NetworkSpecFluentImpl.ConsoleConfigRouteObservedNestedImpl();
  }
  public NetworkSpecFluent.ConsoleConfigRouteObservedNested<A> withNewConsoleConfigRouteObservedLike(ConsoleConfigRoute item) {
    return new NetworkSpecFluentImpl.ConsoleConfigRouteObservedNestedImpl(item);
  }
  public A withCloudCredentialStatusObservedConfig(CloudCredentialStatus cloudCredentialStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialStatusObservedConfig!=null){ this.observedConfig= new CloudCredentialStatusBuilder(cloudCredentialStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialStatusObservedConfigNested<A> withNewCloudCredentialStatusObservedConfig() {
    return new NetworkSpecFluentImpl.CloudCredentialStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialStatusObservedConfigNested<A> withNewCloudCredentialStatusObservedConfigLike(CloudCredentialStatus item) {
    return new NetworkSpecFluentImpl.CloudCredentialStatusObservedConfigNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
  }
  public A withGenericKubernetesResourceObservedConfig(GenericKubernetesResource genericKubernetesResourceObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (genericKubernetesResourceObservedConfig!=null){ this.observedConfig= new GenericKubernetesResourceBuilder(genericKubernetesResourceObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.GenericKubernetesResourceObservedConfigNested<A> withNewGenericKubernetesResourceObservedConfig() {
    return new NetworkSpecFluentImpl.GenericKubernetesResourceObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.GenericKubernetesResourceObservedConfigNested<A> withNewGenericKubernetesResourceObservedConfigLike(GenericKubernetesResource item) {
    return new NetworkSpecFluentImpl.GenericKubernetesResourceObservedConfigNestedImpl(item);
  }
  public A withIngressControllerStatusObservedConfig(IngressControllerStatus ingressControllerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerStatusObservedConfig!=null){ this.observedConfig= new IngressControllerStatusBuilder(ingressControllerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerStatusObservedConfigNested<A> withNewIngressControllerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerStatusObservedConfigNested<A> withNewIngressControllerStatusObservedConfigLike(IngressControllerStatus item) {
    return new NetworkSpecFluentImpl.IngressControllerStatusObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerStatusObservedConfig(ServiceCatalogControllerManagerStatus serviceCatalogControllerManagerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerStatusObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerStatusBuilder(serviceCatalogControllerManagerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerStatusObservedConfigNested<A> withNewServiceCatalogControllerManagerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerStatusObservedConfigNested<A> withNewServiceCatalogControllerManagerStatusObservedConfigLike(ServiceCatalogControllerManagerStatus item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerStatusObservedConfigNestedImpl(item);
  }
  public A withHybridOverlayConfigObserved(HybridOverlayConfig hybridOverlayConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (hybridOverlayConfigObserved!=null){ this.observedConfig= new HybridOverlayConfigBuilder(hybridOverlayConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.HybridOverlayConfigObservedNested<A> withNewHybridOverlayConfigObserved() {
    return new NetworkSpecFluentImpl.HybridOverlayConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.HybridOverlayConfigObservedNested<A> withNewHybridOverlayConfigObservedLike(HybridOverlayConfig item) {
    return new NetworkSpecFluentImpl.HybridOverlayConfigObservedNestedImpl(item);
  }
  public A withAWSLoadBalancerParametersObservedConfig(AWSLoadBalancerParameters aWSLoadBalancerParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (aWSLoadBalancerParametersObservedConfig!=null){ this.observedConfig= new AWSLoadBalancerParametersBuilder(aWSLoadBalancerParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AWSLoadBalancerParametersObservedConfigNested<A> withNewAWSLoadBalancerParametersObservedConfig() {
    return new NetworkSpecFluentImpl.AWSLoadBalancerParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AWSLoadBalancerParametersObservedConfigNested<A> withNewAWSLoadBalancerParametersObservedConfigLike(AWSLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.AWSLoadBalancerParametersObservedConfigNestedImpl(item);
  }
  public A withImagePrunerListObservedConfig(ImagePrunerList imagePrunerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerListObservedConfig!=null){ this.observedConfig= new ImagePrunerListBuilder(imagePrunerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerListObservedConfigNested<A> withNewImagePrunerListObservedConfig() {
    return new NetworkSpecFluentImpl.ImagePrunerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerListObservedConfigNested<A> withNewImagePrunerListObservedConfigLike(ImagePrunerList item) {
    return new NetworkSpecFluentImpl.ImagePrunerListObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerListObservedConfig(CSISnapshotControllerList cSISnapshotControllerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerListObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerListBuilder(cSISnapshotControllerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerListObservedConfigNested<A> withNewCSISnapshotControllerListObservedConfig() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerListObservedConfigNested<A> withNewCSISnapshotControllerListObservedConfigLike(CSISnapshotControllerList item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerListObservedConfigNestedImpl(item);
  }
  public A withLocalObjectReferenceObservedConfig(LocalObjectReference localObjectReferenceObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (localObjectReferenceObservedConfig!=null){ this.observedConfig= new LocalObjectReferenceBuilder(localObjectReferenceObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.LocalObjectReferenceObservedConfigNested<A> withNewLocalObjectReferenceObservedConfig() {
    return new NetworkSpecFluentImpl.LocalObjectReferenceObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.LocalObjectReferenceObservedConfigNested<A> withNewLocalObjectReferenceObservedConfigLike(LocalObjectReference item) {
    return new NetworkSpecFluentImpl.LocalObjectReferenceObservedConfigNestedImpl(item);
  }
  public A withNewLocalObjectReferenceObservedConfig(String name) {
    return (A)withLocalObjectReferenceObservedConfig(new LocalObjectReference(name));
  }
  public A withConsoleObservedConfig(Console consoleObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleObservedConfig!=null){ this.observedConfig= new ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
    return new NetworkSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
  }
  public A withStaticIPAMRoutesObservedConfig(StaticIPAMRoutes staticIPAMRoutesObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (staticIPAMRoutesObservedConfig!=null){ this.observedConfig= new StaticIPAMRoutesBuilder(staticIPAMRoutesObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMRoutesObservedConfigNested<A> withNewStaticIPAMRoutesObservedConfig() {
    return new NetworkSpecFluentImpl.StaticIPAMRoutesObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMRoutesObservedConfigNested<A> withNewStaticIPAMRoutesObservedConfigLike(StaticIPAMRoutes item) {
    return new NetworkSpecFluentImpl.StaticIPAMRoutesObservedConfigNestedImpl(item);
  }
  public A withNewStaticIPAMRoutesObservedConfig(String destination,String gateway) {
    return (A)withStaticIPAMRoutesObservedConfig(new StaticIPAMRoutes(destination, gateway));
  }
  public A withDNSZoneConditionObservedConfig(DNSZoneCondition dNSZoneConditionObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSZoneConditionObservedConfig!=null){ this.observedConfig= new DNSZoneConditionBuilder(dNSZoneConditionObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSZoneConditionObservedConfigNested<A> withNewDNSZoneConditionObservedConfig() {
    return new NetworkSpecFluentImpl.DNSZoneConditionObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSZoneConditionObservedConfigNested<A> withNewDNSZoneConditionObservedConfigLike(DNSZoneCondition item) {
    return new NetworkSpecFluentImpl.DNSZoneConditionObservedConfigNestedImpl(item);
  }
  public A withNewDNSZoneConditionObservedConfig(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withDNSZoneConditionObservedConfig(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withContainerLoggingDestinationParametersObservedConfig(ContainerLoggingDestinationParameters containerLoggingDestinationParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (containerLoggingDestinationParametersObservedConfig!=null){ this.observedConfig= new ContainerLoggingDestinationParametersBuilder(containerLoggingDestinationParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ContainerLoggingDestinationParametersObservedConfigNested<A> withNewContainerLoggingDestinationParametersObservedConfig() {
    return new NetworkSpecFluentImpl.ContainerLoggingDestinationParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ContainerLoggingDestinationParametersObservedConfigNested<A> withNewContainerLoggingDestinationParametersObservedConfigLike(ContainerLoggingDestinationParameters item) {
    return new NetworkSpecFluentImpl.ContainerLoggingDestinationParametersObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerListObservedConfig(KubeSchedulerList kubeSchedulerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerListObservedConfig!=null){ this.observedConfig= new KubeSchedulerListBuilder(kubeSchedulerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerListObservedConfigNested<A> withNewKubeSchedulerListObservedConfig() {
    return new NetworkSpecFluentImpl.KubeSchedulerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerListObservedConfigNested<A> withNewKubeSchedulerListObservedConfigLike(KubeSchedulerList item) {
    return new NetworkSpecFluentImpl.KubeSchedulerListObservedConfigNestedImpl(item);
  }
  public A withKubeAPIServerSpecObservedConfig(KubeAPIServerSpec kubeAPIServerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeAPIServerSpecObservedConfig!=null){ this.observedConfig= new KubeAPIServerSpecBuilder(kubeAPIServerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerSpecObservedConfigNested<A> withNewKubeAPIServerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.KubeAPIServerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerSpecObservedConfigNested<A> withNewKubeAPIServerSpecObservedConfigLike(KubeAPIServerSpec item) {
    return new NetworkSpecFluentImpl.KubeAPIServerSpecObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverObservedConfig(ClusterCSIDriver clusterCSIDriverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverBuilder(clusterCSIDriverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfig() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<A> withNewClusterCSIDriverObservedConfigLike(ClusterCSIDriver item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverObservedConfigNestedImpl(item);
  }
  public A withQuickStartsObservedConfig(QuickStarts quickStartsObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (quickStartsObservedConfig!=null){ this.observedConfig= new QuickStartsBuilder(quickStartsObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.QuickStartsObservedConfigNested<A> withNewQuickStartsObservedConfig() {
    return new NetworkSpecFluentImpl.QuickStartsObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.QuickStartsObservedConfigNested<A> withNewQuickStartsObservedConfigLike(QuickStarts item) {
    return new NetworkSpecFluentImpl.QuickStartsObservedConfigNestedImpl(item);
  }
  public A withDNSZoneStatusObservedConfig(DNSZoneStatus dNSZoneStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSZoneStatusObservedConfig!=null){ this.observedConfig= new DNSZoneStatusBuilder(dNSZoneStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSZoneStatusObservedConfigNested<A> withNewDNSZoneStatusObservedConfig() {
    return new NetworkSpecFluentImpl.DNSZoneStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSZoneStatusObservedConfigNested<A> withNewDNSZoneStatusObservedConfigLike(DNSZoneStatus item) {
    return new NetworkSpecFluentImpl.DNSZoneStatusObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
  }
  public A withConfigSpecObservedConfig(ConfigSpec configSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configSpecObservedConfig!=null){ this.observedConfig= new ConfigSpecBuilder(configSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConfigSpecObservedConfigNested<A> withNewConfigSpecObservedConfig() {
    return new NetworkSpecFluentImpl.ConfigSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConfigSpecObservedConfigNested<A> withNewConfigSpecObservedConfigLike(ConfigSpec item) {
    return new NetworkSpecFluentImpl.ConfigSpecObservedConfigNestedImpl(item);
  }
  public A withOutageEntryObservedConfig(OutageEntry outageEntryObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (outageEntryObservedConfig!=null){ this.observedConfig= new OutageEntryBuilder(outageEntryObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OutageEntryObservedConfigNested<A> withNewOutageEntryObservedConfig() {
    return new NetworkSpecFluentImpl.OutageEntryObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OutageEntryObservedConfigNested<A> withNewOutageEntryObservedConfigLike(OutageEntry item) {
    return new NetworkSpecFluentImpl.OutageEntryObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerListObservedConfig(OpenShiftControllerManagerList openShiftControllerManagerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerListObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerListBuilder(openShiftControllerManagerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerListObservedConfigNested<A> withNewOpenShiftControllerManagerListObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerListObservedConfigNested<A> withNewOpenShiftControllerManagerListObservedConfigLike(OpenShiftControllerManagerList item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerListObservedConfigNestedImpl(item);
  }
  public A withEtcdObservedConfig(Etcd etcdObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdObservedConfig!=null){ this.observedConfig= new EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
    return new NetworkSpecFluentImpl.EtcdObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
    return new NetworkSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
  }
  public A withEndpointPublishingStrategyObservedConfig(EndpointPublishingStrategy endpointPublishingStrategyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (endpointPublishingStrategyObservedConfig!=null){ this.observedConfig= new EndpointPublishingStrategyBuilder(endpointPublishingStrategyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.EndpointPublishingStrategyObservedConfigNested<A> withNewEndpointPublishingStrategyObservedConfig() {
    return new NetworkSpecFluentImpl.EndpointPublishingStrategyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.EndpointPublishingStrategyObservedConfigNested<A> withNewEndpointPublishingStrategyObservedConfigLike(EndpointPublishingStrategy item) {
    return new NetworkSpecFluentImpl.EndpointPublishingStrategyObservedConfigNestedImpl(item);
  }
  public A withIPFIXConfigObserved(IPFIXConfig iPFIXConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (iPFIXConfigObserved!=null){ this.observedConfig= new IPFIXConfigBuilder(iPFIXConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IPFIXConfigObservedNested<A> withNewIPFIXConfigObserved() {
    return new NetworkSpecFluentImpl.IPFIXConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.IPFIXConfigObservedNested<A> withNewIPFIXConfigObservedLike(IPFIXConfig item) {
    return new NetworkSpecFluentImpl.IPFIXConfigObservedNestedImpl(item);
  }
  public A withCloudCredentialObservedConfig(CloudCredential cloudCredentialObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialObservedConfig!=null){ this.observedConfig= new CloudCredentialBuilder(cloudCredentialObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfig() {
    return new NetworkSpecFluentImpl.CloudCredentialObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialObservedConfigNested<A> withNewCloudCredentialObservedConfigLike(CloudCredential item) {
    return new NetworkSpecFluentImpl.CloudCredentialObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
    return new NetworkSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
    return new NetworkSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
  }
  public A withClusterCSIDriverStatusObservedConfig(ClusterCSIDriverStatus clusterCSIDriverStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterCSIDriverStatusObservedConfig!=null){ this.observedConfig= new ClusterCSIDriverStatusBuilder(clusterCSIDriverStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverStatusObservedConfigNested<A> withNewClusterCSIDriverStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverStatusObservedConfigNested<A> withNewClusterCSIDriverStatusObservedConfigLike(ClusterCSIDriverStatus item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverStatusObservedConfigNestedImpl(item);
  }
  public A withNetworkStatusObservedConfig(NetworkStatus networkStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkStatusObservedConfig!=null){ this.observedConfig= new NetworkStatusBuilder(networkStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetworkStatusObservedConfigNested<A> withNewNetworkStatusObservedConfig() {
    return new NetworkSpecFluentImpl.NetworkStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NetworkStatusObservedConfigNested<A> withNewNetworkStatusObservedConfigLike(NetworkStatus item) {
    return new NetworkSpecFluentImpl.NetworkStatusObservedConfigNestedImpl(item);
  }
  public A withSFlowConfigObserved(SFlowConfig sFlowConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (sFlowConfigObserved!=null){ this.observedConfig= new SFlowConfigBuilder(sFlowConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.SFlowConfigObservedNested<A> withNewSFlowConfigObserved() {
    return new NetworkSpecFluentImpl.SFlowConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.SFlowConfigObservedNested<A> withNewSFlowConfigObservedLike(SFlowConfig item) {
    return new NetworkSpecFluentImpl.SFlowConfigObservedNestedImpl(item);
  }
  public A withForwardPluginObservedConfig(ForwardPlugin forwardPluginObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (forwardPluginObservedConfig!=null){ this.observedConfig= new ForwardPluginBuilder(forwardPluginObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ForwardPluginObservedConfigNested<A> withNewForwardPluginObservedConfig() {
    return new NetworkSpecFluentImpl.ForwardPluginObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ForwardPluginObservedConfigNested<A> withNewForwardPluginObservedConfigLike(ForwardPlugin item) {
    return new NetworkSpecFluentImpl.ForwardPluginObservedConfigNestedImpl(item);
  }
  public A withLogEntryObservedConfig(LogEntry logEntryObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (logEntryObservedConfig!=null){ this.observedConfig= new LogEntryBuilder(logEntryObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.LogEntryObservedConfigNested<A> withNewLogEntryObservedConfig() {
    return new NetworkSpecFluentImpl.LogEntryObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.LogEntryObservedConfigNested<A> withNewLogEntryObservedConfigLike(LogEntry item) {
    return new NetworkSpecFluentImpl.LogEntryObservedConfigNestedImpl(item);
  }
  public A withNodeStatusObservedConfig(NodeStatus nodeStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (nodeStatusObservedConfig!=null){ this.observedConfig= new NodeStatusBuilder(nodeStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NodeStatusObservedConfigNested<A> withNewNodeStatusObservedConfig() {
    return new NetworkSpecFluentImpl.NodeStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NodeStatusObservedConfigNested<A> withNewNodeStatusObservedConfigLike(NodeStatus item) {
    return new NetworkSpecFluentImpl.NodeStatusObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckConditionObservedConfig(PodNetworkConnectivityCheckCondition podNetworkConnectivityCheckConditionObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckConditionObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckConditionBuilder(podNetworkConnectivityCheckConditionObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckConditionObservedConfigNested<A> withNewPodNetworkConnectivityCheckConditionObservedConfig() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckConditionObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckConditionObservedConfigNested<A> withNewPodNetworkConnectivityCheckConditionObservedConfigLike(PodNetworkConnectivityCheckCondition item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckConditionObservedConfigNestedImpl(item);
  }
  public A withNewPodNetworkConnectivityCheckConditionObservedConfig(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withPodNetworkConnectivityCheckConditionObservedConfig(new PodNetworkConnectivityCheckCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withAdditionalNetworkDefinitionObservedConfig(AdditionalNetworkDefinition additionalNetworkDefinitionObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (additionalNetworkDefinitionObservedConfig!=null){ this.observedConfig= new AdditionalNetworkDefinitionBuilder(additionalNetworkDefinitionObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AdditionalNetworkDefinitionObservedConfigNested<A> withNewAdditionalNetworkDefinitionObservedConfig() {
    return new NetworkSpecFluentImpl.AdditionalNetworkDefinitionObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AdditionalNetworkDefinitionObservedConfigNested<A> withNewAdditionalNetworkDefinitionObservedConfigLike(AdditionalNetworkDefinition item) {
    return new NetworkSpecFluentImpl.AdditionalNetworkDefinitionObservedConfigNestedImpl(item);
  }
  public A withRouteAdmissionPolicyObservedConfig(RouteAdmissionPolicy routeAdmissionPolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (routeAdmissionPolicyObservedConfig!=null){ this.observedConfig= new RouteAdmissionPolicyBuilder(routeAdmissionPolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.RouteAdmissionPolicyObservedConfigNested<A> withNewRouteAdmissionPolicyObservedConfig() {
    return new NetworkSpecFluentImpl.RouteAdmissionPolicyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.RouteAdmissionPolicyObservedConfigNested<A> withNewRouteAdmissionPolicyObservedConfigLike(RouteAdmissionPolicy item) {
    return new NetworkSpecFluentImpl.RouteAdmissionPolicyObservedConfigNestedImpl(item);
  }
  public A withNewRouteAdmissionPolicyObservedConfig(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmissionPolicyObservedConfig(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public A withGenerationStatusObservedConfig(GenerationStatus generationStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (generationStatusObservedConfig!=null){ this.observedConfig= new GenerationStatusBuilder(generationStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.GenerationStatusObservedConfigNested<A> withNewGenerationStatusObservedConfig() {
    return new NetworkSpecFluentImpl.GenerationStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.GenerationStatusObservedConfigNested<A> withNewGenerationStatusObservedConfigLike(GenerationStatus item) {
    return new NetworkSpecFluentImpl.GenerationStatusObservedConfigNestedImpl(item);
  }
  public A withAuthenticationStatusObservedConfig(AuthenticationStatus authenticationStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationStatusObservedConfig!=null){ this.observedConfig= new AuthenticationStatusBuilder(authenticationStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationStatusObservedConfigNested<A> withNewAuthenticationStatusObservedConfig() {
    return new NetworkSpecFluentImpl.AuthenticationStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationStatusObservedConfigNested<A> withNewAuthenticationStatusObservedConfigLike(AuthenticationStatus item) {
    return new NetworkSpecFluentImpl.AuthenticationStatusObservedConfigNestedImpl(item);
  }
  public A withIngressControllerCaptureHTTPHeadersObservedConfig(IngressControllerCaptureHTTPHeaders ingressControllerCaptureHTTPHeadersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerCaptureHTTPHeadersObservedConfig!=null){ this.observedConfig= new IngressControllerCaptureHTTPHeadersBuilder(ingressControllerCaptureHTTPHeadersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeadersObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeadersObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeadersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeadersObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeadersObservedConfigLike(IngressControllerCaptureHTTPHeaders item) {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeadersObservedConfigNestedImpl(item);
  }
  public A withEtcdListObservedConfig(EtcdList etcdListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdListObservedConfig!=null){ this.observedConfig= new EtcdListBuilder(etcdListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.EtcdListObservedConfigNested<A> withNewEtcdListObservedConfig() {
    return new NetworkSpecFluentImpl.EtcdListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.EtcdListObservedConfigNested<A> withNewEtcdListObservedConfigLike(EtcdList item) {
    return new NetworkSpecFluentImpl.EtcdListObservedConfigNestedImpl(item);
  }
  public A withNodePortStrategyObservedConfig(NodePortStrategy nodePortStrategyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (nodePortStrategyObservedConfig!=null){ this.observedConfig= new NodePortStrategyBuilder(nodePortStrategyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NodePortStrategyObservedConfigNested<A> withNewNodePortStrategyObservedConfig() {
    return new NetworkSpecFluentImpl.NodePortStrategyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NodePortStrategyObservedConfigNested<A> withNewNodePortStrategyObservedConfigLike(NodePortStrategy item) {
    return new NetworkSpecFluentImpl.NodePortStrategyObservedConfigNestedImpl(item);
  }
  public A withNewNodePortStrategyObservedConfig(String protocol) {
    return (A)withNodePortStrategyObservedConfig(new NodePortStrategy(protocol));
  }
  public A withDefaultNetworkDefinitionObservedConfig(DefaultNetworkDefinition defaultNetworkDefinitionObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (defaultNetworkDefinitionObservedConfig!=null){ this.observedConfig= new DefaultNetworkDefinitionBuilder(defaultNetworkDefinitionObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DefaultNetworkDefinitionObservedConfigNested<A> withNewDefaultNetworkDefinitionObservedConfig() {
    return new NetworkSpecFluentImpl.DefaultNetworkDefinitionObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DefaultNetworkDefinitionObservedConfigNested<A> withNewDefaultNetworkDefinitionObservedConfigLike(DefaultNetworkDefinition item) {
    return new NetworkSpecFluentImpl.DefaultNetworkDefinitionObservedConfigNestedImpl(item);
  }
  public A withNetworkObservedConfig(Network networkObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkObservedConfig!=null){ this.observedConfig= new NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
    return new NetworkSpecFluentImpl.NetworkObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
    return new NetworkSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
  }
  public A withClientTLSObservedConfig(ClientTLS clientTLSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clientTLSObservedConfig!=null){ this.observedConfig= new ClientTLSBuilder(clientTLSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClientTLSObservedConfigNested<A> withNewClientTLSObservedConfig() {
    return new NetworkSpecFluentImpl.ClientTLSObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClientTLSObservedConfigNested<A> withNewClientTLSObservedConfigLike(ClientTLS item) {
    return new NetworkSpecFluentImpl.ClientTLSObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerSpecObservedConfig(OpenShiftAPIServerSpec openShiftAPIServerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerSpecObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerSpecBuilder(openShiftAPIServerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerSpecObservedConfigNested<A> withNewOpenShiftAPIServerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerSpecObservedConfigNested<A> withNewOpenShiftAPIServerSpecObservedConfigLike(OpenShiftAPIServerSpec item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerSpecObservedConfigNestedImpl(item);
  }
  public A withImagePrunerStatusObservedConfig(ImagePrunerStatus imagePrunerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerStatusObservedConfig!=null){ this.observedConfig= new ImagePrunerStatusBuilder(imagePrunerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerStatusObservedConfigNested<A> withNewImagePrunerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ImagePrunerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerStatusObservedConfigNested<A> withNewImagePrunerStatusObservedConfigLike(ImagePrunerStatus item) {
    return new NetworkSpecFluentImpl.ImagePrunerStatusObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerStatusObservedConfig(KubeSchedulerStatus kubeSchedulerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerStatusObservedConfig!=null){ this.observedConfig= new KubeSchedulerStatusBuilder(kubeSchedulerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerStatusObservedConfigNested<A> withNewKubeSchedulerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.KubeSchedulerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerStatusObservedConfigNested<A> withNewKubeSchedulerStatusObservedConfigLike(KubeSchedulerStatus item) {
    return new NetworkSpecFluentImpl.KubeSchedulerStatusObservedConfigNestedImpl(item);
  }
  public A withSyslogLoggingDestinationParametersObservedConfig(SyslogLoggingDestinationParameters syslogLoggingDestinationParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (syslogLoggingDestinationParametersObservedConfig!=null){ this.observedConfig= new SyslogLoggingDestinationParametersBuilder(syslogLoggingDestinationParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.SyslogLoggingDestinationParametersObservedConfigNested<A> withNewSyslogLoggingDestinationParametersObservedConfig() {
    return new NetworkSpecFluentImpl.SyslogLoggingDestinationParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.SyslogLoggingDestinationParametersObservedConfigNested<A> withNewSyslogLoggingDestinationParametersObservedConfigLike(SyslogLoggingDestinationParameters item) {
    return new NetworkSpecFluentImpl.SyslogLoggingDestinationParametersObservedConfigNestedImpl(item);
  }
  public A withNewSyslogLoggingDestinationParametersObservedConfig(String address,String facility,Integer maxLength,Integer port) {
    return (A)withSyslogLoggingDestinationParametersObservedConfig(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  public A withUpstreamObservedConfig(Upstream upstreamObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (upstreamObservedConfig!=null){ this.observedConfig= new UpstreamBuilder(upstreamObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.UpstreamObservedConfigNested<A> withNewUpstreamObservedConfig() {
    return new NetworkSpecFluentImpl.UpstreamObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.UpstreamObservedConfigNested<A> withNewUpstreamObservedConfigLike(Upstream item) {
    return new NetworkSpecFluentImpl.UpstreamObservedConfigNestedImpl(item);
  }
  public A withNewUpstreamObservedConfig(String address,Integer port,String type) {
    return (A)withUpstreamObservedConfig(new Upstream(address, port, type));
  }
  public A withAWSNetworkLoadBalancerParametersObservedConfig(AWSNetworkLoadBalancerParameters aWSNetworkLoadBalancerParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (aWSNetworkLoadBalancerParametersObservedConfig!=null){ this.observedConfig= new AWSNetworkLoadBalancerParametersBuilder(aWSNetworkLoadBalancerParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AWSNetworkLoadBalancerParametersObservedConfigNested<A> withNewAWSNetworkLoadBalancerParametersObservedConfig() {
    return new NetworkSpecFluentImpl.AWSNetworkLoadBalancerParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AWSNetworkLoadBalancerParametersObservedConfigNested<A> withNewAWSNetworkLoadBalancerParametersObservedConfigLike(AWSNetworkLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.AWSNetworkLoadBalancerParametersObservedConfigNestedImpl(item);
  }
  public A withServiceCAListObservedConfig(ServiceCAList serviceCAListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAListObservedConfig!=null){ this.observedConfig= new ServiceCAListBuilder(serviceCAListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAListObservedConfigNested<A> withNewServiceCAListObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCAListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAListObservedConfigNested<A> withNewServiceCAListObservedConfigLike(ServiceCAList item) {
    return new NetworkSpecFluentImpl.ServiceCAListObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
  }
  public A withIngressControllerCaptureHTTPHeaderObservedConfig(IngressControllerCaptureHTTPHeader ingressControllerCaptureHTTPHeaderObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerCaptureHTTPHeaderObservedConfig!=null){ this.observedConfig= new IngressControllerCaptureHTTPHeaderBuilder(ingressControllerCaptureHTTPHeaderObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeaderObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeaderObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeaderObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeaderObservedConfigNested<A> withNewIngressControllerCaptureHTTPHeaderObservedConfigLike(IngressControllerCaptureHTTPHeader item) {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeaderObservedConfigNestedImpl(item);
  }
  public A withNewIngressControllerCaptureHTTPHeaderObservedConfig(Integer maxLength,String name) {
    return (A)withIngressControllerCaptureHTTPHeaderObservedConfig(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  public A withNetworkMigrationObservedConfig(NetworkMigration networkMigrationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkMigrationObservedConfig!=null){ this.observedConfig= new NetworkMigrationBuilder(networkMigrationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetworkMigrationObservedConfigNested<A> withNewNetworkMigrationObservedConfig() {
    return new NetworkSpecFluentImpl.NetworkMigrationObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NetworkMigrationObservedConfigNested<A> withNewNetworkMigrationObservedConfigLike(NetworkMigration item) {
    return new NetworkSpecFluentImpl.NetworkMigrationObservedConfigNestedImpl(item);
  }
  public A withNewNetworkMigrationObservedConfig(String networkType) {
    return (A)withNetworkMigrationObservedConfig(new NetworkMigration(networkType));
  }
  public A withDNSRecordListObservedConfig(DNSRecordList dNSRecordListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordListObservedConfig!=null){ this.observedConfig= new DNSRecordListBuilder(dNSRecordListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordListObservedConfigNested<A> withNewDNSRecordListObservedConfig() {
    return new NetworkSpecFluentImpl.DNSRecordListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordListObservedConfigNested<A> withNewDNSRecordListObservedConfigLike(DNSRecordList item) {
    return new NetworkSpecFluentImpl.DNSRecordListObservedConfigNestedImpl(item);
  }
  public A withRawExtensionObservedConfig(RawExtension rawExtensionObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (rawExtensionObservedConfig!=null){ this.observedConfig= new RawExtensionBuilder(rawExtensionObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.RawExtensionObservedConfigNested<A> withNewRawExtensionObservedConfig() {
    return new NetworkSpecFluentImpl.RawExtensionObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.RawExtensionObservedConfigNested<A> withNewRawExtensionObservedConfigLike(RawExtension item) {
    return new NetworkSpecFluentImpl.RawExtensionObservedConfigNestedImpl(item);
  }
  public A withNewRawExtensionObservedConfig(Object value) {
    return (A)withRawExtensionObservedConfig(new RawExtension(value));
  }
  public A withEtcdSpecObservedConfig(EtcdSpec etcdSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdSpecObservedConfig!=null){ this.observedConfig= new EtcdSpecBuilder(etcdSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.EtcdSpecObservedConfigNested<A> withNewEtcdSpecObservedConfig() {
    return new NetworkSpecFluentImpl.EtcdSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.EtcdSpecObservedConfigNested<A> withNewEtcdSpecObservedConfigLike(EtcdSpec item) {
    return new NetworkSpecFluentImpl.EtcdSpecObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckObservedConfig(PodNetworkConnectivityCheck podNetworkConnectivityCheckObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfig() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<A> withNewPodNetworkConnectivityCheckObservedConfigLike(PodNetworkConnectivityCheck item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerStatusObservedConfig(OpenShiftAPIServerStatus openShiftAPIServerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerStatusObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerStatusBuilder(openShiftAPIServerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerStatusObservedConfigNested<A> withNewOpenShiftAPIServerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerStatusObservedConfigNested<A> withNewOpenShiftAPIServerStatusObservedConfigLike(OpenShiftAPIServerStatus item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerStatusObservedConfigNestedImpl(item);
  }
  public A withLoadBalancerStrategyObservedConfig(LoadBalancerStrategy loadBalancerStrategyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (loadBalancerStrategyObservedConfig!=null){ this.observedConfig= new LoadBalancerStrategyBuilder(loadBalancerStrategyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.LoadBalancerStrategyObservedConfigNested<A> withNewLoadBalancerStrategyObservedConfig() {
    return new NetworkSpecFluentImpl.LoadBalancerStrategyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.LoadBalancerStrategyObservedConfigNested<A> withNewLoadBalancerStrategyObservedConfigLike(LoadBalancerStrategy item) {
    return new NetworkSpecFluentImpl.LoadBalancerStrategyObservedConfigNestedImpl(item);
  }
  public A withEtcdStatusObservedConfig(EtcdStatus etcdStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (etcdStatusObservedConfig!=null){ this.observedConfig= new EtcdStatusBuilder(etcdStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.EtcdStatusObservedConfigNested<A> withNewEtcdStatusObservedConfig() {
    return new NetworkSpecFluentImpl.EtcdStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.EtcdStatusObservedConfigNested<A> withNewEtcdStatusObservedConfigLike(EtcdStatus item) {
    return new NetworkSpecFluentImpl.EtcdStatusObservedConfigNestedImpl(item);
  }
  public A withCloudCredentialListObservedConfig(CloudCredentialList cloudCredentialListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialListObservedConfig!=null){ this.observedConfig= new CloudCredentialListBuilder(cloudCredentialListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialListObservedConfigNested<A> withNewCloudCredentialListObservedConfig() {
    return new NetworkSpecFluentImpl.CloudCredentialListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialListObservedConfigNested<A> withNewCloudCredentialListObservedConfigLike(CloudCredentialList item) {
    return new NetworkSpecFluentImpl.CloudCredentialListObservedConfigNestedImpl(item);
  }
  public A withImagePrunerSpecObservedConfig(ImagePrunerSpec imagePrunerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imagePrunerSpecObservedConfig!=null){ this.observedConfig= new ImagePrunerSpecBuilder(imagePrunerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerSpecObservedConfigNested<A> withNewImagePrunerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.ImagePrunerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerSpecObservedConfigNested<A> withNewImagePrunerSpecObservedConfigLike(ImagePrunerSpec item) {
    return new NetworkSpecFluentImpl.ImagePrunerSpecObservedConfigNestedImpl(item);
  }
  public A withStatuspageProviderObservedConfig(StatuspageProvider statuspageProviderObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (statuspageProviderObservedConfig!=null){ this.observedConfig= new StatuspageProviderBuilder(statuspageProviderObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StatuspageProviderObservedConfigNested<A> withNewStatuspageProviderObservedConfig() {
    return new NetworkSpecFluentImpl.StatuspageProviderObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StatuspageProviderObservedConfigNested<A> withNewStatuspageProviderObservedConfigLike(StatuspageProvider item) {
    return new NetworkSpecFluentImpl.StatuspageProviderObservedConfigNestedImpl(item);
  }
  public A withNewStatuspageProviderObservedConfig(String pageID) {
    return (A)withStatuspageProviderObservedConfig(new StatuspageProvider(pageID));
  }
  public A withKubeStorageVersionMigratorStatusObservedConfig(KubeStorageVersionMigratorStatus kubeStorageVersionMigratorStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeStorageVersionMigratorStatusObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorStatusBuilder(kubeStorageVersionMigratorStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorStatusObservedConfigNested<A> withNewKubeStorageVersionMigratorStatusObservedConfig() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorStatusObservedConfigNested<A> withNewKubeStorageVersionMigratorStatusObservedConfigLike(KubeStorageVersionMigratorStatus item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorStatusObservedConfigNestedImpl(item);
  }
  public A withConfigListObservedConfig(ConfigList configListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (configListObservedConfig!=null){ this.observedConfig= new ConfigListBuilder(configListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConfigListObservedConfigNested<A> withNewConfigListObservedConfig() {
    return new NetworkSpecFluentImpl.ConfigListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConfigListObservedConfigNested<A> withNewConfigListObservedConfigLike(ConfigList item) {
    return new NetworkSpecFluentImpl.ConfigListObservedConfigNestedImpl(item);
  }
  public A withConsoleProvidersObservedConfig(ConsoleProviders consoleProvidersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleProvidersObservedConfig!=null){ this.observedConfig= new ConsoleProvidersBuilder(consoleProvidersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleProvidersObservedConfigNested<A> withNewConsoleProvidersObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleProvidersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleProvidersObservedConfigNested<A> withNewConsoleProvidersObservedConfigLike(ConsoleProviders item) {
    return new NetworkSpecFluentImpl.ConsoleProvidersObservedConfigNestedImpl(item);
  }
  public A withIngressControllerLoggingObservedConfig(IngressControllerLogging ingressControllerLoggingObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerLoggingObservedConfig!=null){ this.observedConfig= new IngressControllerLoggingBuilder(ingressControllerLoggingObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerLoggingObservedConfigNested<A> withNewIngressControllerLoggingObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerLoggingObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerLoggingObservedConfigNested<A> withNewIngressControllerLoggingObservedConfigLike(IngressControllerLogging item) {
    return new NetworkSpecFluentImpl.IngressControllerLoggingObservedConfigNestedImpl(item);
  }
  public A withAuthenticationListObservedConfig(AuthenticationList authenticationListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationListObservedConfig!=null){ this.observedConfig= new AuthenticationListBuilder(authenticationListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationListObservedConfigNested<A> withNewAuthenticationListObservedConfig() {
    return new NetworkSpecFluentImpl.AuthenticationListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationListObservedConfigNested<A> withNewAuthenticationListObservedConfigLike(AuthenticationList item) {
    return new NetworkSpecFluentImpl.AuthenticationListObservedConfigNestedImpl(item);
  }
  public A withStorageStatusObservedConfig(StorageStatus storageStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageStatusObservedConfig!=null){ this.observedConfig= new StorageStatusBuilder(storageStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StorageStatusObservedConfigNested<A> withNewStorageStatusObservedConfig() {
    return new NetworkSpecFluentImpl.StorageStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StorageStatusObservedConfigNested<A> withNewStorageStatusObservedConfigLike(StorageStatus item) {
    return new NetworkSpecFluentImpl.StorageStatusObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerListObservedConfig(KubeControllerManagerList kubeControllerManagerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerListObservedConfig!=null){ this.observedConfig= new KubeControllerManagerListBuilder(kubeControllerManagerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerListObservedConfigNested<A> withNewKubeControllerManagerListObservedConfig() {
    return new NetworkSpecFluentImpl.KubeControllerManagerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerListObservedConfigNested<A> withNewKubeControllerManagerListObservedConfigLike(KubeControllerManagerList item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerListObservedConfigNestedImpl(item);
  }
  public A withAuthenticationSpecObservedConfig(AuthenticationSpec authenticationSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationSpecObservedConfig!=null){ this.observedConfig= new AuthenticationSpecBuilder(authenticationSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationSpecObservedConfigNested<A> withNewAuthenticationSpecObservedConfig() {
    return new NetworkSpecFluentImpl.AuthenticationSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationSpecObservedConfigNested<A> withNewAuthenticationSpecObservedConfigLike(AuthenticationSpec item) {
    return new NetworkSpecFluentImpl.AuthenticationSpecObservedConfigNestedImpl(item);
  }
  public A withIPAMConfigObserved(IPAMConfig iPAMConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (iPAMConfigObserved!=null){ this.observedConfig= new IPAMConfigBuilder(iPAMConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IPAMConfigObservedNested<A> withNewIPAMConfigObserved() {
    return new NetworkSpecFluentImpl.IPAMConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.IPAMConfigObservedNested<A> withNewIPAMConfigObservedLike(IPAMConfig item) {
    return new NetworkSpecFluentImpl.IPAMConfigObservedNestedImpl(item);
  }
  public A withContainerObservedConfig(Container containerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (containerObservedConfig!=null){ this.observedConfig= new ContainerBuilder(containerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ContainerObservedConfigNested<A> withNewContainerObservedConfig() {
    return new NetworkSpecFluentImpl.ContainerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ContainerObservedConfigNested<A> withNewContainerObservedConfigLike(Container item) {
    return new NetworkSpecFluentImpl.ContainerObservedConfigNestedImpl(item);
  }
  public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckSpecObservedConfig(PodNetworkConnectivityCheckSpec podNetworkConnectivityCheckSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckSpecObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckSpecBuilder(podNetworkConnectivityCheckSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckSpecObservedConfigNested<A> withNewPodNetworkConnectivityCheckSpecObservedConfig() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckSpecObservedConfigNested<A> withNewPodNetworkConnectivityCheckSpecObservedConfigLike(PodNetworkConnectivityCheckSpec item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckSpecObservedConfigNestedImpl(item);
  }
  public A withAccessLoggingObservedConfig(AccessLogging accessLoggingObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (accessLoggingObservedConfig!=null){ this.observedConfig= new AccessLoggingBuilder(accessLoggingObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AccessLoggingObservedConfigNested<A> withNewAccessLoggingObservedConfig() {
    return new NetworkSpecFluentImpl.AccessLoggingObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AccessLoggingObservedConfigNested<A> withNewAccessLoggingObservedConfigLike(AccessLogging item) {
    return new NetworkSpecFluentImpl.AccessLoggingObservedConfigNestedImpl(item);
  }
  public A withHostNetworkStrategyObservedConfig(HostNetworkStrategy hostNetworkStrategyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (hostNetworkStrategyObservedConfig!=null){ this.observedConfig= new HostNetworkStrategyBuilder(hostNetworkStrategyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.HostNetworkStrategyObservedConfigNested<A> withNewHostNetworkStrategyObservedConfig() {
    return new NetworkSpecFluentImpl.HostNetworkStrategyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.HostNetworkStrategyObservedConfigNested<A> withNewHostNetworkStrategyObservedConfigLike(HostNetworkStrategy item) {
    return new NetworkSpecFluentImpl.HostNetworkStrategyObservedConfigNestedImpl(item);
  }
  public A withNewHostNetworkStrategyObservedConfig(String protocol) {
    return (A)withHostNetworkStrategyObservedConfig(new HostNetworkStrategy(protocol));
  }
  public A withDNSRecordSpecObservedConfig(DNSRecordSpec dNSRecordSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordSpecObservedConfig!=null){ this.observedConfig= new DNSRecordSpecBuilder(dNSRecordSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordSpecObservedConfigNested<A> withNewDNSRecordSpecObservedConfig() {
    return new NetworkSpecFluentImpl.DNSRecordSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordSpecObservedConfigNested<A> withNewDNSRecordSpecObservedConfigLike(DNSRecordSpec item) {
    return new NetworkSpecFluentImpl.DNSRecordSpecObservedConfigNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCustomizationObservedConfig(DeveloperConsoleCatalogCustomization developerConsoleCatalogCustomizationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (developerConsoleCatalogCustomizationObservedConfig!=null){ this.observedConfig= new DeveloperConsoleCatalogCustomizationBuilder(developerConsoleCatalogCustomizationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCustomizationObservedConfigNested<A> withNewDeveloperConsoleCatalogCustomizationObservedConfig() {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCustomizationObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCustomizationObservedConfigNested<A> withNewDeveloperConsoleCatalogCustomizationObservedConfigLike(DeveloperConsoleCatalogCustomization item) {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCustomizationObservedConfigNestedImpl(item);
  }
  public A withKubeSchedulerSpecObservedConfig(KubeSchedulerSpec kubeSchedulerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeSchedulerSpecObservedConfig!=null){ this.observedConfig= new KubeSchedulerSpecBuilder(kubeSchedulerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerSpecObservedConfigNested<A> withNewKubeSchedulerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.KubeSchedulerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerSpecObservedConfigNested<A> withNewKubeSchedulerSpecObservedConfigLike(KubeSchedulerSpec item) {
    return new NetworkSpecFluentImpl.KubeSchedulerSpecObservedConfigNestedImpl(item);
  }
  public A withLoggingDestinationObservedConfig(LoggingDestination loggingDestinationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (loggingDestinationObservedConfig!=null){ this.observedConfig= new LoggingDestinationBuilder(loggingDestinationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.LoggingDestinationObservedConfigNested<A> withNewLoggingDestinationObservedConfig() {
    return new NetworkSpecFluentImpl.LoggingDestinationObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.LoggingDestinationObservedConfigNested<A> withNewLoggingDestinationObservedConfigLike(LoggingDestination item) {
    return new NetworkSpecFluentImpl.LoggingDestinationObservedConfigNestedImpl(item);
  }
  public A withIngressControllerTuningOptionsObservedConfig(IngressControllerTuningOptions ingressControllerTuningOptionsObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerTuningOptionsObservedConfig!=null){ this.observedConfig= new IngressControllerTuningOptionsBuilder(ingressControllerTuningOptionsObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerTuningOptionsObservedConfigNested<A> withNewIngressControllerTuningOptionsObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerTuningOptionsObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerTuningOptionsObservedConfigNested<A> withNewIngressControllerTuningOptionsObservedConfigLike(IngressControllerTuningOptions item) {
    return new NetworkSpecFluentImpl.IngressControllerTuningOptionsObservedConfigNestedImpl(item);
  }
  public A withStaticIPAMConfigObserved(StaticIPAMConfig staticIPAMConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (staticIPAMConfigObserved!=null){ this.observedConfig= new StaticIPAMConfigBuilder(staticIPAMConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMConfigObservedNested<A> withNewStaticIPAMConfigObserved() {
    return new NetworkSpecFluentImpl.StaticIPAMConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMConfigObservedNested<A> withNewStaticIPAMConfigObservedLike(StaticIPAMConfig item) {
    return new NetworkSpecFluentImpl.StaticIPAMConfigObservedNestedImpl(item);
  }
  public A withImageContentSourcePolicyListObservedConfig(ImageContentSourcePolicyList imageContentSourcePolicyListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (imageContentSourcePolicyListObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyListBuilder(imageContentSourcePolicyListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicyListObservedConfigNested<A> withNewImageContentSourcePolicyListObservedConfig() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicyListObservedConfigNested<A> withNewImageContentSourcePolicyListObservedConfigLike(ImageContentSourcePolicyList item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyListObservedConfigNestedImpl(item);
  }
  public A withOpenShiftControllerManagerStatusObservedConfig(OpenShiftControllerManagerStatus openShiftControllerManagerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftControllerManagerStatusObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerStatusBuilder(openShiftControllerManagerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerStatusObservedConfigNested<A> withNewOpenShiftControllerManagerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerStatusObservedConfigNested<A> withNewOpenShiftControllerManagerStatusObservedConfigLike(OpenShiftControllerManagerStatus item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerStatusObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogAPIServerStatusObservedConfig(ServiceCatalogAPIServerStatus serviceCatalogAPIServerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogAPIServerStatusObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerStatusBuilder(serviceCatalogAPIServerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerStatusObservedConfigNested<A> withNewServiceCatalogAPIServerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerStatusObservedConfigNested<A> withNewServiceCatalogAPIServerStatusObservedConfigLike(ServiceCatalogAPIServerStatus item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerStatusObservedConfigNestedImpl(item);
  }
  public A withKubeControllerManagerSpecObservedConfig(KubeControllerManagerSpec kubeControllerManagerSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (kubeControllerManagerSpecObservedConfig!=null){ this.observedConfig= new KubeControllerManagerSpecBuilder(kubeControllerManagerSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerSpecObservedConfigNested<A> withNewKubeControllerManagerSpecObservedConfig() {
    return new NetworkSpecFluentImpl.KubeControllerManagerSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerSpecObservedConfigNested<A> withNewKubeControllerManagerSpecObservedConfigLike(KubeControllerManagerSpec item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerSpecObservedConfigNestedImpl(item);
  }
  public A withStaticIPAMDNSObservedConfig(StaticIPAMDNS staticIPAMDNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (staticIPAMDNSObservedConfig!=null){ this.observedConfig= new StaticIPAMDNSBuilder(staticIPAMDNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMDNSObservedConfigNested<A> withNewStaticIPAMDNSObservedConfig() {
    return new NetworkSpecFluentImpl.StaticIPAMDNSObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMDNSObservedConfigNested<A> withNewStaticIPAMDNSObservedConfigLike(StaticIPAMDNS item) {
    return new NetworkSpecFluentImpl.StaticIPAMDNSObservedConfigNestedImpl(item);
  }
  public A withDNSNodePlacementObservedConfig(DNSNodePlacement dNSNodePlacementObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSNodePlacementObservedConfig!=null){ this.observedConfig= new DNSNodePlacementBuilder(dNSNodePlacementObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSNodePlacementObservedConfigNested<A> withNewDNSNodePlacementObservedConfig() {
    return new NetworkSpecFluentImpl.DNSNodePlacementObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSNodePlacementObservedConfigNested<A> withNewDNSNodePlacementObservedConfigLike(DNSNodePlacement item) {
    return new NetworkSpecFluentImpl.DNSNodePlacementObservedConfigNestedImpl(item);
  }
  public A withStorageSpecObservedConfig(StorageSpec storageSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageSpecObservedConfig!=null){ this.observedConfig= new StorageSpecBuilder(storageSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StorageSpecObservedConfigNested<A> withNewStorageSpecObservedConfig() {
    return new NetworkSpecFluentImpl.StorageSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StorageSpecObservedConfigNested<A> withNewStorageSpecObservedConfigLike(StorageSpec item) {
    return new NetworkSpecFluentImpl.StorageSpecObservedConfigNestedImpl(item);
  }
  public A withNetworkListObservedConfig(NetworkList networkListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkListObservedConfig!=null){ this.observedConfig= new NetworkListBuilder(networkListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetworkListObservedConfigNested<A> withNewNetworkListObservedConfig() {
    return new NetworkSpecFluentImpl.NetworkListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NetworkListObservedConfigNested<A> withNewNetworkListObservedConfigLike(NetworkList item) {
    return new NetworkSpecFluentImpl.NetworkListObservedConfigNestedImpl(item);
  }
  public A withNodePlacementObservedConfig(NodePlacement nodePlacementObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (nodePlacementObservedConfig!=null){ this.observedConfig= new NodePlacementBuilder(nodePlacementObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NodePlacementObservedConfigNested<A> withNewNodePlacementObservedConfig() {
    return new NetworkSpecFluentImpl.NodePlacementObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NodePlacementObservedConfigNested<A> withNewNodePlacementObservedConfigLike(NodePlacement item) {
    return new NetworkSpecFluentImpl.NodePlacementObservedConfigNestedImpl(item);
  }
  public A withProviderLoadBalancerParametersObservedConfig(ProviderLoadBalancerParameters providerLoadBalancerParametersObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (providerLoadBalancerParametersObservedConfig!=null){ this.observedConfig= new ProviderLoadBalancerParametersBuilder(providerLoadBalancerParametersObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ProviderLoadBalancerParametersObservedConfigNested<A> withNewProviderLoadBalancerParametersObservedConfig() {
    return new NetworkSpecFluentImpl.ProviderLoadBalancerParametersObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ProviderLoadBalancerParametersObservedConfigNested<A> withNewProviderLoadBalancerParametersObservedConfigLike(ProviderLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.ProviderLoadBalancerParametersObservedConfigNestedImpl(item);
  }
  public A withNetworkSpecObservedConfig(NetworkSpec networkSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (networkSpecObservedConfig!=null){ this.observedConfig= new NetworkSpecBuilder(networkSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetworkSpecObservedConfigNested<A> withNewNetworkSpecObservedConfig() {
    return new NetworkSpecFluentImpl.NetworkSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.NetworkSpecObservedConfigNested<A> withNewNetworkSpecObservedConfigLike(NetworkSpec item) {
    return new NetworkSpecFluentImpl.NetworkSpecObservedConfigNestedImpl(item);
  }
  public A withServiceCASpecObservedConfig(ServiceCASpec serviceCASpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCASpecObservedConfig!=null){ this.observedConfig= new ServiceCASpecBuilder(serviceCASpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCASpecObservedConfigNested<A> withNewServiceCASpecObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCASpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCASpecObservedConfigNested<A> withNewServiceCASpecObservedConfigLike(ServiceCASpec item) {
    return new NetworkSpecFluentImpl.ServiceCASpecObservedConfigNestedImpl(item);
  }
  public A withPrivateStrategyObservedConfig(PrivateStrategy privateStrategyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (privateStrategyObservedConfig!=null){ this.observedConfig= new PrivateStrategyBuilder(privateStrategyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PrivateStrategyObservedConfigNested<A> withNewPrivateStrategyObservedConfig() {
    return new NetworkSpecFluentImpl.PrivateStrategyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PrivateStrategyObservedConfigNested<A> withNewPrivateStrategyObservedConfigLike(PrivateStrategy item) {
    return new NetworkSpecFluentImpl.PrivateStrategyObservedConfigNestedImpl(item);
  }
  public A withConsoleStatusObservedConfig(ConsoleStatus consoleStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleStatusObservedConfig!=null){ this.observedConfig= new ConsoleStatusBuilder(consoleStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleStatusObservedConfigNested<A> withNewConsoleStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleStatusObservedConfigNested<A> withNewConsoleStatusObservedConfigLike(ConsoleStatus item) {
    return new NetworkSpecFluentImpl.ConsoleStatusObservedConfigNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckListObservedConfig(PodNetworkConnectivityCheckList podNetworkConnectivityCheckListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (podNetworkConnectivityCheckListObservedConfig!=null){ this.observedConfig= new PodNetworkConnectivityCheckListBuilder(podNetworkConnectivityCheckListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckListObservedConfigNested<A> withNewPodNetworkConnectivityCheckListObservedConfig() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckListObservedConfigNested<A> withNewPodNetworkConnectivityCheckListObservedConfigLike(PodNetworkConnectivityCheckList item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckListObservedConfigNestedImpl(item);
  }
  public A withObjectReferenceObservedConfig(ObjectReference objectReferenceObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (objectReferenceObservedConfig!=null){ this.observedConfig= new ObjectReferenceBuilder(objectReferenceObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ObjectReferenceObservedConfigNested<A> withNewObjectReferenceObservedConfig() {
    return new NetworkSpecFluentImpl.ObjectReferenceObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ObjectReferenceObservedConfigNested<A> withNewObjectReferenceObservedConfigLike(ObjectReference item) {
    return new NetworkSpecFluentImpl.ObjectReferenceObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerListObservedConfig(OpenShiftAPIServerList openShiftAPIServerListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerListObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerListBuilder(openShiftAPIServerListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerListObservedConfigNested<A> withNewOpenShiftAPIServerListObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerListObservedConfigNested<A> withNewOpenShiftAPIServerListObservedConfigLike(OpenShiftAPIServerList item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerListObservedConfigNestedImpl(item);
  }
  public A withServerObservedConfig(Server serverObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serverObservedConfig!=null){ this.observedConfig= new ServerBuilder(serverObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServerObservedConfigNested<A> withNewServerObservedConfig() {
    return new NetworkSpecFluentImpl.ServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServerObservedConfigNested<A> withNewServerObservedConfigLike(Server item) {
    return new NetworkSpecFluentImpl.ServerObservedConfigNestedImpl(item);
  }
  public A withOAuthAPIServerStatusObservedConfig(OAuthAPIServerStatus oAuthAPIServerStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (oAuthAPIServerStatusObservedConfig!=null){ this.observedConfig= new OAuthAPIServerStatusBuilder(oAuthAPIServerStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OAuthAPIServerStatusObservedConfigNested<A> withNewOAuthAPIServerStatusObservedConfig() {
    return new NetworkSpecFluentImpl.OAuthAPIServerStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OAuthAPIServerStatusObservedConfigNested<A> withNewOAuthAPIServerStatusObservedConfigLike(OAuthAPIServerStatus item) {
    return new NetworkSpecFluentImpl.OAuthAPIServerStatusObservedConfigNestedImpl(item);
  }
  public A withNewOAuthAPIServerStatusObservedConfig(Integer latestAvailableRevision) {
    return (A)withOAuthAPIServerStatusObservedConfig(new OAuthAPIServerStatus(latestAvailableRevision));
  }
  public A withCloudCredentialSpecObservedConfig(CloudCredentialSpec cloudCredentialSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (cloudCredentialSpecObservedConfig!=null){ this.observedConfig= new CloudCredentialSpecBuilder(cloudCredentialSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialSpecObservedConfigNested<A> withNewCloudCredentialSpecObservedConfig() {
    return new NetworkSpecFluentImpl.CloudCredentialSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialSpecObservedConfigNested<A> withNewCloudCredentialSpecObservedConfigLike(CloudCredentialSpec item) {
    return new NetworkSpecFluentImpl.CloudCredentialSpecObservedConfigNestedImpl(item);
  }
  public A withDNSRecordStatusObservedConfig(DNSRecordStatus dNSRecordStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordStatusObservedConfig!=null){ this.observedConfig= new DNSRecordStatusBuilder(dNSRecordStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordStatusObservedConfigNested<A> withNewDNSRecordStatusObservedConfig() {
    return new NetworkSpecFluentImpl.DNSRecordStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordStatusObservedConfigNested<A> withNewDNSRecordStatusObservedConfigLike(DNSRecordStatus item) {
    return new NetworkSpecFluentImpl.DNSRecordStatusObservedConfigNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
  }
  public A withClusterNetworkEntryObservedConfig(ClusterNetworkEntry clusterNetworkEntryObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (clusterNetworkEntryObservedConfig!=null){ this.observedConfig= new ClusterNetworkEntryBuilder(clusterNetworkEntryObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ClusterNetworkEntryObservedConfigNested<A> withNewClusterNetworkEntryObservedConfig() {
    return new NetworkSpecFluentImpl.ClusterNetworkEntryObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ClusterNetworkEntryObservedConfigNested<A> withNewClusterNetworkEntryObservedConfigLike(ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkEntryObservedConfigNestedImpl(item);
  }
  public A withNewClusterNetworkEntryObservedConfig(String cidr,Integer hostPrefix) {
    return (A)withClusterNetworkEntryObservedConfig(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public A withIngressControllerCaptureHTTPCookieObservedConfig(IngressControllerCaptureHTTPCookie ingressControllerCaptureHTTPCookieObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (ingressControllerCaptureHTTPCookieObservedConfig!=null){ this.observedConfig= new IngressControllerCaptureHTTPCookieBuilder(ingressControllerCaptureHTTPCookieObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPCookieObservedConfigNested<A> withNewIngressControllerCaptureHTTPCookieObservedConfig() {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPCookieObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPCookieObservedConfigNested<A> withNewIngressControllerCaptureHTTPCookieObservedConfigLike(IngressControllerCaptureHTTPCookie item) {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPCookieObservedConfigNestedImpl(item);
  }
  public A withNewIngressControllerCaptureHTTPCookieObservedConfig(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)withIngressControllerCaptureHTTPCookieObservedConfig(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  public A withHTTPCompressionPolicyObservedConfig(HTTPCompressionPolicy hTTPCompressionPolicyObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (hTTPCompressionPolicyObservedConfig!=null){ this.observedConfig= new HTTPCompressionPolicyBuilder(hTTPCompressionPolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.HTTPCompressionPolicyObservedConfigNested<A> withNewHTTPCompressionPolicyObservedConfig() {
    return new NetworkSpecFluentImpl.HTTPCompressionPolicyObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.HTTPCompressionPolicyObservedConfigNested<A> withNewHTTPCompressionPolicyObservedConfigLike(HTTPCompressionPolicy item) {
    return new NetworkSpecFluentImpl.HTTPCompressionPolicyObservedConfigNestedImpl(item);
  }
  public A withProjectAccessObservedConfig(ProjectAccess projectAccessObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (projectAccessObservedConfig!=null){ this.observedConfig= new ProjectAccessBuilder(projectAccessObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ProjectAccessObservedConfigNested<A> withNewProjectAccessObservedConfig() {
    return new NetworkSpecFluentImpl.ProjectAccessObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ProjectAccessObservedConfigNested<A> withNewProjectAccessObservedConfigLike(ProjectAccess item) {
    return new NetworkSpecFluentImpl.ProjectAccessObservedConfigNestedImpl(item);
  }
  public A withDNSObservedConfig(DNS dNSObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSObservedConfig!=null){ this.observedConfig= new DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
    return new NetworkSpecFluentImpl.DNSObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
    return new NetworkSpecFluentImpl.DNSObservedConfigNestedImpl(item);
  }
  public A withNetFlowConfigObserved(NetFlowConfig netFlowConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (netFlowConfigObserved!=null){ this.observedConfig= new NetFlowConfigBuilder(netFlowConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.NetFlowConfigObservedNested<A> withNewNetFlowConfigObserved() {
    return new NetworkSpecFluentImpl.NetFlowConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.NetFlowConfigObservedNested<A> withNewNetFlowConfigObservedLike(NetFlowConfig item) {
    return new NetworkSpecFluentImpl.NetFlowConfigObservedNestedImpl(item);
  }
  public A withPolicyAuditConfigObserved(PolicyAuditConfig policyAuditConfigObserved) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (policyAuditConfigObserved!=null){ this.observedConfig= new PolicyAuditConfigBuilder(policyAuditConfigObserved); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.PolicyAuditConfigObservedNested<A> withNewPolicyAuditConfigObserved() {
    return new NetworkSpecFluentImpl.PolicyAuditConfigObservedNestedImpl();
  }
  public NetworkSpecFluent.PolicyAuditConfigObservedNested<A> withNewPolicyAuditConfigObservedLike(PolicyAuditConfig item) {
    return new NetworkSpecFluentImpl.PolicyAuditConfigObservedNestedImpl(item);
  }
  public A withNewPolicyAuditConfigObserved(String destination,Integer maxFileSize,Integer rateLimit,String syslogFacility) {
    return (A)withPolicyAuditConfigObserved(new PolicyAuditConfig(destination, maxFileSize, rateLimit, syslogFacility));
  }
  public A withAddPageObservedConfig(AddPage addPageObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (addPageObservedConfig!=null){ this.observedConfig= new AddPageBuilder(addPageObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AddPageObservedConfigNested<A> withNewAddPageObservedConfig() {
    return new NetworkSpecFluentImpl.AddPageObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AddPageObservedConfigNested<A> withNewAddPageObservedConfigLike(AddPage item) {
    return new NetworkSpecFluentImpl.AddPageObservedConfigNestedImpl(item);
  }
  public A withStorageListObservedConfig(StorageList storageListObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (storageListObservedConfig!=null){ this.observedConfig= new StorageListBuilder(storageListObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StorageListObservedConfigNested<A> withNewStorageListObservedConfig() {
    return new NetworkSpecFluentImpl.StorageListObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StorageListObservedConfigNested<A> withNewStorageListObservedConfigLike(StorageList item) {
    return new NetworkSpecFluentImpl.StorageListObservedConfigNestedImpl(item);
  }
  public A withStaticIPAMAddressesObservedConfig(StaticIPAMAddresses staticIPAMAddressesObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (staticIPAMAddressesObservedConfig!=null){ this.observedConfig= new StaticIPAMAddressesBuilder(staticIPAMAddressesObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMAddressesObservedConfigNested<A> withNewStaticIPAMAddressesObservedConfig() {
    return new NetworkSpecFluentImpl.StaticIPAMAddressesObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMAddressesObservedConfigNested<A> withNewStaticIPAMAddressesObservedConfigLike(StaticIPAMAddresses item) {
    return new NetworkSpecFluentImpl.StaticIPAMAddressesObservedConfigNestedImpl(item);
  }
  public A withNewStaticIPAMAddressesObservedConfig(String address,String gateway) {
    return (A)withStaticIPAMAddressesObservedConfig(new StaticIPAMAddresses(address, gateway));
  }
  public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (dNSRecordObservedConfig!=null){ this.observedConfig= new DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
    return new NetworkSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
    return new NetworkSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
  }
  public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
  }
  public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (authenticationObservedConfig!=null){ this.observedConfig= new AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
    return new NetworkSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
    return new NetworkSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
  }
  public A withConsoleSpecObservedConfig(ConsoleSpec consoleSpecObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (consoleSpecObservedConfig!=null){ this.observedConfig= new ConsoleSpecBuilder(consoleSpecObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleSpecObservedConfigNested<A> withNewConsoleSpecObservedConfig() {
    return new NetworkSpecFluentImpl.ConsoleSpecObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ConsoleSpecObservedConfigNested<A> withNewConsoleSpecObservedConfigLike(ConsoleSpec item) {
    return new NetworkSpecFluentImpl.ConsoleSpecObservedConfigNestedImpl(item);
  }
  public A withServiceCAStatusObservedConfig(ServiceCAStatus serviceCAStatusObservedConfig) {
    _visitables.get("observedConfig").remove(this.observedConfig);
    if (serviceCAStatusObservedConfig!=null){ this.observedConfig= new ServiceCAStatusBuilder(serviceCAStatusObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} else { this.observedConfig = null; _visitables.get("observedConfig").remove(this.observedConfig); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAStatusObservedConfigNested<A> withNewServiceCAStatusObservedConfig() {
    return new NetworkSpecFluentImpl.ServiceCAStatusObservedConfigNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAStatusObservedConfigNested<A> withNewServiceCAStatusObservedConfigLike(ServiceCAStatus item) {
    return new NetworkSpecFluentImpl.ServiceCAStatusObservedConfigNestedImpl(item);
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  public A addToServiceNetwork(Integer index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(Integer index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(Collection<String> items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public String getServiceNetwork(Integer index) {
    return this.serviceNetwork.get(index);
  }
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new ArrayList(); for (String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
    if (serviceNetwork != null) {for (String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubernetesResource getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public KubernetesResource buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(KubernetesResource unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServerList){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerListBuilder((ServiceCatalogAPIServerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LabelSelector){ this.unsupportedConfigOverrides= new LabelSelectorBuilder((LabelSelector)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckStatus){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckStatusBuilder((PodNetworkConnectivityCheckStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigratorList){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorListBuilder((KubeStorageVersionMigratorList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Storage){ this.unsupportedConfigOverrides= new StorageBuilder((Storage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodTemplateSpec){ this.unsupportedConfigOverrides= new PodTemplateSpecBuilder((PodTemplateSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManagerStatus){ this.unsupportedConfigOverrides= new KubeControllerManagerStatusBuilder((KubeControllerManagerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManagerList){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerListBuilder((ServiceCatalogControllerManagerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotControllerStatus){ this.unsupportedConfigOverrides= new CSISnapshotControllerStatusBuilder((CSISnapshotControllerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IPsecConfig){ this.unsupportedConfigOverrides= new IPsecConfigBuilder((IPsecConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ResourceRequirements){ this.unsupportedConfigOverrides= new ResourceRequirementsBuilder((ResourceRequirements)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OVNKubernetesConfig){ this.unsupportedConfigOverrides= new OVNKubernetesConfigBuilder((OVNKubernetesConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DeveloperConsoleCatalogCategoryMeta){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryMetaBuilder((DeveloperConsoleCatalogCategoryMeta)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigratorSpec){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorSpecBuilder((KubeStorageVersionMigratorSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerSpec){ this.unsupportedConfigOverrides= new IngressControllerSpecBuilder((IngressControllerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSSpec){ this.unsupportedConfigOverrides= new DNSSpecBuilder((DNSSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftSDNConfig){ this.unsupportedConfigOverrides= new OpenShiftSDNConfigBuilder((OpenShiftSDNConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OperatorCondition){ this.unsupportedConfigOverrides= new OperatorConditionBuilder((OperatorCondition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerHTTPHeaders){ this.unsupportedConfigOverrides= new IngressControllerHTTPHeadersBuilder((IngressControllerHTTPHeaders)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ProxyConfig){ this.unsupportedConfigOverrides= new ProxyConfigBuilder((ProxyConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleList){ this.unsupportedConfigOverrides= new ConsoleListBuilder((ConsoleList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KuryrConfig){ this.unsupportedConfigOverrides= new KuryrConfigBuilder((KuryrConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DeveloperConsoleCatalogCategory){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryBuilder((DeveloperConsoleCatalogCategory)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManagerSpec){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerSpecBuilder((OpenShiftControllerManagerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ExportNetworkFlows){ this.unsupportedConfigOverrides= new ExportNetworkFlowsBuilder((ExportNetworkFlows)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriverSpec){ this.unsupportedConfigOverrides= new ClusterCSIDriverSpecBuilder((ClusterCSIDriverSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServerSpec){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerSpecBuilder((ServiceCatalogAPIServerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicySpec){ this.unsupportedConfigOverrides= new ImageContentSourcePolicySpecBuilder((ImageContentSourcePolicySpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof RepositoryDigestMirrors){ this.unsupportedConfigOverrides= new RepositoryDigestMirrorsBuilder((RepositoryDigestMirrors)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleCustomization){ this.unsupportedConfigOverrides= new ConsoleCustomizationBuilder((ConsoleCustomization)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotControllerSpec){ this.unsupportedConfigOverrides= new CSISnapshotControllerSpecBuilder((CSISnapshotControllerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof UpstreamResolvers){ this.unsupportedConfigOverrides= new UpstreamResolversBuilder((UpstreamResolvers)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSStatus){ this.unsupportedConfigOverrides= new DNSStatusBuilder((DNSStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerHTTPUniqueIdHeaderPolicy){ this.unsupportedConfigOverrides= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder((IngressControllerHTTPUniqueIdHeaderPolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof GCPLoadBalancerParameters){ this.unsupportedConfigOverrides= new GCPLoadBalancerParametersBuilder((GCPLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConfigStatus){ this.unsupportedConfigOverrides= new ConfigStatusBuilder((ConfigStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServerList){ this.unsupportedConfigOverrides= new KubeAPIServerListBuilder((KubeAPIServerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManagerSpec){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerSpecBuilder((ServiceCatalogControllerManagerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Config){ this.unsupportedConfigOverrides= new ConfigBuilder((Config)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerList){ this.unsupportedConfigOverrides= new IngressControllerListBuilder((IngressControllerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSList){ this.unsupportedConfigOverrides= new DNSListBuilder((DNSList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ObjectMeta){ this.unsupportedConfigOverrides= new ObjectMetaBuilder((ObjectMeta)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriverList){ this.unsupportedConfigOverrides= new ClusterCSIDriverListBuilder((ClusterCSIDriverList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof SimpleMacvlanConfig){ this.unsupportedConfigOverrides= new SimpleMacvlanConfigBuilder((SimpleMacvlanConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServerStatus){ this.unsupportedConfigOverrides= new KubeAPIServerStatusBuilder((KubeAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AWSClassicLoadBalancerParameters){ this.unsupportedConfigOverrides= new AWSClassicLoadBalancerParametersBuilder((AWSClassicLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleConfigRoute){ this.unsupportedConfigOverrides= new ConsoleConfigRouteBuilder((ConsoleConfigRoute)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredentialStatus){ this.unsupportedConfigOverrides= new CloudCredentialStatusBuilder((CloudCredentialStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof GenericKubernetesResource){ this.unsupportedConfigOverrides= new GenericKubernetesResourceBuilder((GenericKubernetesResource)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerStatus){ this.unsupportedConfigOverrides= new IngressControllerStatusBuilder((IngressControllerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManagerStatus){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerStatusBuilder((ServiceCatalogControllerManagerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof HybridOverlayConfig){ this.unsupportedConfigOverrides= new HybridOverlayConfigBuilder((HybridOverlayConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AWSLoadBalancerParameters){ this.unsupportedConfigOverrides= new AWSLoadBalancerParametersBuilder((AWSLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePrunerList){ this.unsupportedConfigOverrides= new ImagePrunerListBuilder((ImagePrunerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotControllerList){ this.unsupportedConfigOverrides= new CSISnapshotControllerListBuilder((CSISnapshotControllerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LocalObjectReference){ this.unsupportedConfigOverrides= new LocalObjectReferenceBuilder((LocalObjectReference)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMRoutes){ this.unsupportedConfigOverrides= new StaticIPAMRoutesBuilder((StaticIPAMRoutes)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSZoneCondition){ this.unsupportedConfigOverrides= new DNSZoneConditionBuilder((DNSZoneCondition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ContainerLoggingDestinationParameters){ this.unsupportedConfigOverrides= new ContainerLoggingDestinationParametersBuilder((ContainerLoggingDestinationParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeSchedulerList){ this.unsupportedConfigOverrides= new KubeSchedulerListBuilder((KubeSchedulerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeAPIServerSpec){ this.unsupportedConfigOverrides= new KubeAPIServerSpecBuilder((KubeAPIServerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriver){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder((ClusterCSIDriver)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof QuickStarts){ this.unsupportedConfigOverrides= new QuickStartsBuilder((QuickStarts)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSZoneStatus){ this.unsupportedConfigOverrides= new DNSZoneStatusBuilder((DNSZoneStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConfigSpec){ this.unsupportedConfigOverrides= new ConfigSpecBuilder((ConfigSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OutageEntry){ this.unsupportedConfigOverrides= new OutageEntryBuilder((OutageEntry)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManagerList){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerListBuilder((OpenShiftControllerManagerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EndpointPublishingStrategy){ this.unsupportedConfigOverrides= new EndpointPublishingStrategyBuilder((EndpointPublishingStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IPFIXConfig){ this.unsupportedConfigOverrides= new IPFIXConfigBuilder((IPFIXConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredential){ this.unsupportedConfigOverrides= new CloudCredentialBuilder((CloudCredential)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterCSIDriverStatus){ this.unsupportedConfigOverrides= new ClusterCSIDriverStatusBuilder((ClusterCSIDriverStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkStatus){ this.unsupportedConfigOverrides= new NetworkStatusBuilder((NetworkStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof SFlowConfig){ this.unsupportedConfigOverrides= new SFlowConfigBuilder((SFlowConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ForwardPlugin){ this.unsupportedConfigOverrides= new ForwardPluginBuilder((ForwardPlugin)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LogEntry){ this.unsupportedConfigOverrides= new LogEntryBuilder((LogEntry)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NodeStatus){ this.unsupportedConfigOverrides= new NodeStatusBuilder((NodeStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckCondition){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckConditionBuilder((PodNetworkConnectivityCheckCondition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AdditionalNetworkDefinition){ this.unsupportedConfigOverrides= new AdditionalNetworkDefinitionBuilder((AdditionalNetworkDefinition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof RouteAdmissionPolicy){ this.unsupportedConfigOverrides= new RouteAdmissionPolicyBuilder((RouteAdmissionPolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof GenerationStatus){ this.unsupportedConfigOverrides= new GenerationStatusBuilder((GenerationStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AuthenticationStatus){ this.unsupportedConfigOverrides= new AuthenticationStatusBuilder((AuthenticationStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerCaptureHTTPHeaders){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeadersBuilder((IngressControllerCaptureHTTPHeaders)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EtcdList){ this.unsupportedConfigOverrides= new EtcdListBuilder((EtcdList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NodePortStrategy){ this.unsupportedConfigOverrides= new NodePortStrategyBuilder((NodePortStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DefaultNetworkDefinition){ this.unsupportedConfigOverrides= new DefaultNetworkDefinitionBuilder((DefaultNetworkDefinition)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClientTLS){ this.unsupportedConfigOverrides= new ClientTLSBuilder((ClientTLS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServerSpec){ this.unsupportedConfigOverrides= new OpenShiftAPIServerSpecBuilder((OpenShiftAPIServerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePrunerStatus){ this.unsupportedConfigOverrides= new ImagePrunerStatusBuilder((ImagePrunerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeSchedulerStatus){ this.unsupportedConfigOverrides= new KubeSchedulerStatusBuilder((KubeSchedulerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof SyslogLoggingDestinationParameters){ this.unsupportedConfigOverrides= new SyslogLoggingDestinationParametersBuilder((SyslogLoggingDestinationParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Upstream){ this.unsupportedConfigOverrides= new UpstreamBuilder((Upstream)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AWSNetworkLoadBalancerParameters){ this.unsupportedConfigOverrides= new AWSNetworkLoadBalancerParametersBuilder((AWSNetworkLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCAList){ this.unsupportedConfigOverrides= new ServiceCAListBuilder((ServiceCAList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerCaptureHTTPHeader){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeaderBuilder((IngressControllerCaptureHTTPHeader)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkMigration){ this.unsupportedConfigOverrides= new NetworkMigrationBuilder((NetworkMigration)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecordList){ this.unsupportedConfigOverrides= new DNSRecordListBuilder((DNSRecordList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof RawExtension){ this.unsupportedConfigOverrides= new RawExtensionBuilder((RawExtension)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EtcdSpec){ this.unsupportedConfigOverrides= new EtcdSpecBuilder((EtcdSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheck){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServerStatus){ this.unsupportedConfigOverrides= new OpenShiftAPIServerStatusBuilder((OpenShiftAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LoadBalancerStrategy){ this.unsupportedConfigOverrides= new LoadBalancerStrategyBuilder((LoadBalancerStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof EtcdStatus){ this.unsupportedConfigOverrides= new EtcdStatusBuilder((EtcdStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredentialList){ this.unsupportedConfigOverrides= new CloudCredentialListBuilder((CloudCredentialList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImagePrunerSpec){ this.unsupportedConfigOverrides= new ImagePrunerSpecBuilder((ImagePrunerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StatuspageProvider){ this.unsupportedConfigOverrides= new StatuspageProviderBuilder((StatuspageProvider)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeStorageVersionMigratorStatus){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorStatusBuilder((KubeStorageVersionMigratorStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConfigList){ this.unsupportedConfigOverrides= new ConfigListBuilder((ConfigList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleProviders){ this.unsupportedConfigOverrides= new ConsoleProvidersBuilder((ConsoleProviders)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerLogging){ this.unsupportedConfigOverrides= new IngressControllerLoggingBuilder((IngressControllerLogging)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AuthenticationList){ this.unsupportedConfigOverrides= new AuthenticationListBuilder((AuthenticationList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StorageStatus){ this.unsupportedConfigOverrides= new StorageStatusBuilder((StorageStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManagerList){ this.unsupportedConfigOverrides= new KubeControllerManagerListBuilder((KubeControllerManagerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AuthenticationSpec){ this.unsupportedConfigOverrides= new AuthenticationSpecBuilder((AuthenticationSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IPAMConfig){ this.unsupportedConfigOverrides= new IPAMConfigBuilder((IPAMConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Container){ this.unsupportedConfigOverrides= new ContainerBuilder((Container)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckSpec){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckSpecBuilder((PodNetworkConnectivityCheckSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AccessLogging){ this.unsupportedConfigOverrides= new AccessLoggingBuilder((AccessLogging)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof HostNetworkStrategy){ this.unsupportedConfigOverrides= new HostNetworkStrategyBuilder((HostNetworkStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecordSpec){ this.unsupportedConfigOverrides= new DNSRecordSpecBuilder((DNSRecordSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DeveloperConsoleCatalogCustomization){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCustomizationBuilder((DeveloperConsoleCatalogCustomization)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeSchedulerSpec){ this.unsupportedConfigOverrides= new KubeSchedulerSpecBuilder((KubeSchedulerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof LoggingDestination){ this.unsupportedConfigOverrides= new LoggingDestinationBuilder((LoggingDestination)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerTuningOptions){ this.unsupportedConfigOverrides= new IngressControllerTuningOptionsBuilder((IngressControllerTuningOptions)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMConfig){ this.unsupportedConfigOverrides= new StaticIPAMConfigBuilder((StaticIPAMConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ImageContentSourcePolicyList){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyListBuilder((ImageContentSourcePolicyList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftControllerManagerStatus){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerStatusBuilder((OpenShiftControllerManagerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServerStatus){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerStatusBuilder((ServiceCatalogAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof KubeControllerManagerSpec){ this.unsupportedConfigOverrides= new KubeControllerManagerSpecBuilder((KubeControllerManagerSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMDNS){ this.unsupportedConfigOverrides= new StaticIPAMDNSBuilder((StaticIPAMDNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSNodePlacement){ this.unsupportedConfigOverrides= new DNSNodePlacementBuilder((DNSNodePlacement)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StorageSpec){ this.unsupportedConfigOverrides= new StorageSpecBuilder((StorageSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkList){ this.unsupportedConfigOverrides= new NetworkListBuilder((NetworkList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NodePlacement){ this.unsupportedConfigOverrides= new NodePlacementBuilder((NodePlacement)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ProviderLoadBalancerParameters){ this.unsupportedConfigOverrides= new ProviderLoadBalancerParametersBuilder((ProviderLoadBalancerParameters)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetworkSpec){ this.unsupportedConfigOverrides= new NetworkSpecBuilder((NetworkSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCASpec){ this.unsupportedConfigOverrides= new ServiceCASpecBuilder((ServiceCASpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PrivateStrategy){ this.unsupportedConfigOverrides= new PrivateStrategyBuilder((PrivateStrategy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleStatus){ this.unsupportedConfigOverrides= new ConsoleStatusBuilder((ConsoleStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PodNetworkConnectivityCheckList){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckListBuilder((PodNetworkConnectivityCheckList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ObjectReference){ this.unsupportedConfigOverrides= new ObjectReferenceBuilder((ObjectReference)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServerList){ this.unsupportedConfigOverrides= new OpenShiftAPIServerListBuilder((OpenShiftAPIServerList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Server){ this.unsupportedConfigOverrides= new ServerBuilder((Server)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OAuthAPIServerStatus){ this.unsupportedConfigOverrides= new OAuthAPIServerStatusBuilder((OAuthAPIServerStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof CloudCredentialSpec){ this.unsupportedConfigOverrides= new CloudCredentialSpecBuilder((CloudCredentialSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecordStatus){ this.unsupportedConfigOverrides= new DNSRecordStatusBuilder((DNSRecordStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ClusterNetworkEntry){ this.unsupportedConfigOverrides= new ClusterNetworkEntryBuilder((ClusterNetworkEntry)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof IngressControllerCaptureHTTPCookie){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPCookieBuilder((IngressControllerCaptureHTTPCookie)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof HTTPCompressionPolicy){ this.unsupportedConfigOverrides= new HTTPCompressionPolicyBuilder((HTTPCompressionPolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ProjectAccess){ this.unsupportedConfigOverrides= new ProjectAccessBuilder((ProjectAccess)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof NetFlowConfig){ this.unsupportedConfigOverrides= new NetFlowConfigBuilder((NetFlowConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof PolicyAuditConfig){ this.unsupportedConfigOverrides= new PolicyAuditConfigBuilder((PolicyAuditConfig)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof AddPage){ this.unsupportedConfigOverrides= new AddPageBuilder((AddPage)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StorageList){ this.unsupportedConfigOverrides= new StorageListBuilder((StorageList)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof StaticIPAMAddresses){ this.unsupportedConfigOverrides= new StaticIPAMAddressesBuilder((StaticIPAMAddresses)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ConsoleSpec){ this.unsupportedConfigOverrides= new ConsoleSpecBuilder((ConsoleSpec)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    if (unsupportedConfigOverrides instanceof ServiceCAStatus){ this.unsupportedConfigOverrides= new ServiceCAStatusBuilder((ServiceCAStatus)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
    return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A withServiceCatalogAPIServerListUnsupportedConfigOverrides(ServiceCatalogAPIServerList serviceCatalogAPIServerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerListBuilder(serviceCatalogAPIServerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverridesLike(ServiceCatalogAPIServerList item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLabelSelectorUnsupportedConfigOverrides(LabelSelector labelSelectorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (labelSelectorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LabelSelectorBuilder(labelSelectorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.LabelSelectorUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverridesLike(LabelSelector item) {
    return new NetworkSpecFluentImpl.LabelSelectorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new NetworkSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides(PodNetworkConnectivityCheckStatus podNetworkConnectivityCheckStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckStatusBuilder(podNetworkConnectivityCheckStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckStatus item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorListUnsupportedConfigOverrides(KubeStorageVersionMigratorList kubeStorageVersionMigratorListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorListBuilder(kubeStorageVersionMigratorListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverridesLike(KubeStorageVersionMigratorList item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageUnsupportedConfigOverrides(Storage storageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageBuilder(storageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new NetworkSpecFluentImpl.StorageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodTemplateSpecUnsupportedConfigOverrides(PodTemplateSpec podTemplateSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podTemplateSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodTemplateSpecBuilder(podTemplateSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodTemplateSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverridesLike(PodTemplateSpec item) {
    return new NetworkSpecFluentImpl.PodTemplateSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerStatusUnsupportedConfigOverrides(KubeControllerManagerStatus kubeControllerManagerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerStatusBuilder(kubeControllerManagerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverridesLike(KubeControllerManagerStatus item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerListUnsupportedConfigOverrides(ServiceCatalogControllerManagerList serviceCatalogControllerManagerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerListBuilder(serviceCatalogControllerManagerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerList item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerStatusUnsupportedConfigOverrides(CSISnapshotControllerStatus cSISnapshotControllerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerStatusBuilder(cSISnapshotControllerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverridesLike(CSISnapshotControllerStatus item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIPsecConfigUnsupportedOverrides(IPsecConfig iPsecConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (iPsecConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new IPsecConfigBuilder(iPsecConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.IPsecConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverridesLike(IPsecConfig item) {
    return new NetworkSpecFluentImpl.IPsecConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withResourceRequirementsUnsupportedConfigOverrides(ResourceRequirements resourceRequirementsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (resourceRequirementsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ResourceRequirementsBuilder(resourceRequirementsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ResourceRequirementsUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverridesLike(ResourceRequirements item) {
    return new NetworkSpecFluentImpl.ResourceRequirementsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOVNKubernetesConfigUnsupportedOverrides(OVNKubernetesConfig oVNKubernetesConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (oVNKubernetesConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new OVNKubernetesConfigBuilder(oVNKubernetesConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.OVNKubernetesConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverridesLike(OVNKubernetesConfig item) {
    return new NetworkSpecFluentImpl.OVNKubernetesConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides(DeveloperConsoleCatalogCategoryMeta developerConsoleCatalogCategoryMetaUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (developerConsoleCatalogCategoryMetaUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryMetaBuilder(developerConsoleCatalogCategoryMetaUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategoryMeta item) {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorSpecUnsupportedConfigOverrides(KubeStorageVersionMigratorSpec kubeStorageVersionMigratorSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorSpecBuilder(kubeStorageVersionMigratorSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverridesLike(KubeStorageVersionMigratorSpec item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerSpecUnsupportedConfigOverrides(IngressControllerSpec ingressControllerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerSpecBuilder(ingressControllerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverridesLike(IngressControllerSpec item) {
    return new NetworkSpecFluentImpl.IngressControllerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSSpecUnsupportedConfigOverrides(DNSSpec dNSSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSSpecBuilder(dNSSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverridesLike(DNSSpec item) {
    return new NetworkSpecFluentImpl.DNSSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftSDNConfigUnsupportedOverrides(OpenShiftSDNConfig openShiftSDNConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftSDNConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftSDNConfigBuilder(openShiftSDNConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftSDNConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverridesLike(OpenShiftSDNConfig item) {
    return new NetworkSpecFluentImpl.OpenShiftSDNConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withNewOpenShiftSDNConfigUnsupportedOverrides(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withOpenShiftSDNConfigUnsupportedOverrides(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  public A withOperatorConditionUnsupportedConfigOverrides(OperatorCondition operatorConditionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (operatorConditionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OperatorConditionBuilder(operatorConditionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OperatorConditionUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverridesLike(OperatorCondition item) {
    return new NetworkSpecFluentImpl.OperatorConditionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewOperatorConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withOperatorConditionUnsupportedConfigOverrides(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withIngressControllerHTTPHeadersUnsupportedConfigOverrides(IngressControllerHTTPHeaders ingressControllerHTTPHeadersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerHTTPHeadersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerHTTPHeadersBuilder(ingressControllerHTTPHeadersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerHTTPHeaders item) {
    return new NetworkSpecFluentImpl.IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withProxyConfigUnsupportedOverrides(ProxyConfig proxyConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (proxyConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new ProxyConfigBuilder(proxyConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.ProxyConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverridesLike(ProxyConfig item) {
    return new NetworkSpecFluentImpl.ProxyConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withConsoleListUnsupportedConfigOverrides(ConsoleList consoleListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleListBuilder(consoleListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverridesLike(ConsoleList item) {
    return new NetworkSpecFluentImpl.ConsoleListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKuryrConfigUnsupportedOverrides(KuryrConfig kuryrConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kuryrConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new KuryrConfigBuilder(kuryrConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.KuryrConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverridesLike(KuryrConfig item) {
    return new NetworkSpecFluentImpl.KuryrConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides(DeveloperConsoleCatalogCategory developerConsoleCatalogCategoryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (developerConsoleCatalogCategoryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCategoryBuilder(developerConsoleCatalogCategoryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategory item) {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerSpecUnsupportedConfigOverrides(OpenShiftControllerManagerSpec openShiftControllerManagerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerSpecBuilder(openShiftControllerManagerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverridesLike(OpenShiftControllerManagerSpec item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withExportNetworkFlowsUnsupportedConfigOverrides(ExportNetworkFlows exportNetworkFlowsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (exportNetworkFlowsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ExportNetworkFlowsBuilder(exportNetworkFlowsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverridesLike(ExportNetworkFlows item) {
    return new NetworkSpecFluentImpl.ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverSpecUnsupportedConfigOverrides(ClusterCSIDriverSpec clusterCSIDriverSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverSpecBuilder(clusterCSIDriverSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverridesLike(ClusterCSIDriverSpec item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerSpecUnsupportedConfigOverrides(ServiceCatalogAPIServerSpec serviceCatalogAPIServerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerSpecBuilder(serviceCatalogAPIServerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverridesLike(ServiceCatalogAPIServerSpec item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicySpecUnsupportedConfigOverrides(ImageContentSourcePolicySpec imageContentSourcePolicySpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicySpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicySpecBuilder(imageContentSourcePolicySpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverridesLike(ImageContentSourcePolicySpec item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withRepositoryDigestMirrorsUnsupportedConfigOverrides(RepositoryDigestMirrors repositoryDigestMirrorsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (repositoryDigestMirrorsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new RepositoryDigestMirrorsBuilder(repositoryDigestMirrorsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverridesLike(RepositoryDigestMirrors item) {
    return new NetworkSpecFluentImpl.RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleCustomizationUnsupportedConfigOverrides(ConsoleCustomization consoleCustomizationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleCustomizationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleCustomizationBuilder(consoleCustomizationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleCustomizationUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverridesLike(ConsoleCustomization item) {
    return new NetworkSpecFluentImpl.ConsoleCustomizationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerSpecUnsupportedConfigOverrides(CSISnapshotControllerSpec cSISnapshotControllerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerSpecBuilder(cSISnapshotControllerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverridesLike(CSISnapshotControllerSpec item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withUpstreamResolversUnsupportedConfigOverrides(UpstreamResolvers upstreamResolversUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (upstreamResolversUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new UpstreamResolversBuilder(upstreamResolversUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.UpstreamResolversUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverridesLike(UpstreamResolvers item) {
    return new NetworkSpecFluentImpl.UpstreamResolversUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSStatusUnsupportedConfigOverrides(DNSStatus dNSStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSStatusBuilder(dNSStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverridesLike(DNSStatus item) {
    return new NetworkSpecFluentImpl.DNSStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(IngressControllerHTTPUniqueIdHeaderPolicy ingressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(ingressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new NetworkSpecFluentImpl.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(String format,String name) {
    return (A)withIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  public A withGCPLoadBalancerParametersUnsupportedConfigOverrides(GCPLoadBalancerParameters gCPLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (gCPLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new GCPLoadBalancerParametersBuilder(gCPLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverridesLike(GCPLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewGCPLoadBalancerParametersUnsupportedConfigOverrides(String clientAccess) {
    return (A)withGCPLoadBalancerParametersUnsupportedConfigOverrides(new GCPLoadBalancerParameters(clientAccess));
  }
  public A withConfigStatusUnsupportedConfigOverrides(ConfigStatus configStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigStatusBuilder(configStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConfigStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverridesLike(ConfigStatus item) {
    return new NetworkSpecFluentImpl.ConfigStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerListUnsupportedConfigOverrides(KubeAPIServerList kubeAPIServerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerListBuilder(kubeAPIServerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeAPIServerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverridesLike(KubeAPIServerList item) {
    return new NetworkSpecFluentImpl.KubeAPIServerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new NetworkSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerSpecUnsupportedConfigOverrides(ServiceCatalogControllerManagerSpec serviceCatalogControllerManagerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerSpecBuilder(serviceCatalogControllerManagerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerSpec item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigUnsupportedConfigOverrides(Config configUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigBuilder(configUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new NetworkSpecFluentImpl.ConfigUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerListUnsupportedConfigOverrides(IngressControllerList ingressControllerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerListBuilder(ingressControllerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverridesLike(IngressControllerList item) {
    return new NetworkSpecFluentImpl.IngressControllerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSListUnsupportedConfigOverrides(DNSList dNSListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSListBuilder(dNSListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverridesLike(DNSList item) {
    return new NetworkSpecFluentImpl.DNSListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withObjectMetaUnsupportedConfigOverrides(ObjectMeta objectMetaUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (objectMetaUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ObjectMetaBuilder(objectMetaUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ObjectMetaUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverridesLike(ObjectMeta item) {
    return new NetworkSpecFluentImpl.ObjectMetaUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverListUnsupportedConfigOverrides(ClusterCSIDriverList clusterCSIDriverListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverListBuilder(clusterCSIDriverListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverridesLike(ClusterCSIDriverList item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withSimpleMacvlanConfigUnsupportedOverrides(SimpleMacvlanConfig simpleMacvlanConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (simpleMacvlanConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new SimpleMacvlanConfigBuilder(simpleMacvlanConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.SimpleMacvlanConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverridesLike(SimpleMacvlanConfig item) {
    return new NetworkSpecFluentImpl.SimpleMacvlanConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new NetworkSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerStatusUnsupportedConfigOverrides(KubeAPIServerStatus kubeAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerStatusBuilder(kubeAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverridesLike(KubeAPIServerStatus item) {
    return new NetworkSpecFluentImpl.KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAWSClassicLoadBalancerParametersUnsupportedConfigOverrides(AWSClassicLoadBalancerParameters aWSClassicLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (aWSClassicLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AWSClassicLoadBalancerParametersBuilder(aWSClassicLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverridesLike(AWSClassicLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new NetworkSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new NetworkSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleConfigRouteUnsupportedOverrides(ConsoleConfigRoute consoleConfigRouteUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleConfigRouteUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleConfigRouteBuilder(consoleConfigRouteUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.ConsoleConfigRouteUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverridesLike(ConsoleConfigRoute item) {
    return new NetworkSpecFluentImpl.ConsoleConfigRouteUnsupportedOverridesNestedImpl(item);
  }
  public A withCloudCredentialStatusUnsupportedConfigOverrides(CloudCredentialStatus cloudCredentialStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialStatusBuilder(cloudCredentialStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CloudCredentialStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverridesLike(CloudCredentialStatus item) {
    return new NetworkSpecFluentImpl.CloudCredentialStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withGenericKubernetesResourceUnsupportedConfigOverrides(GenericKubernetesResource genericKubernetesResourceUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (genericKubernetesResourceUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new GenericKubernetesResourceBuilder(genericKubernetesResourceUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverridesLike(GenericKubernetesResource item) {
    return new NetworkSpecFluentImpl.GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerStatusUnsupportedConfigOverrides(IngressControllerStatus ingressControllerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerStatusBuilder(ingressControllerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverridesLike(IngressControllerStatus item) {
    return new NetworkSpecFluentImpl.IngressControllerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerStatusUnsupportedConfigOverrides(ServiceCatalogControllerManagerStatus serviceCatalogControllerManagerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerStatusBuilder(serviceCatalogControllerManagerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerStatus item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withHybridOverlayConfigUnsupportedOverrides(HybridOverlayConfig hybridOverlayConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (hybridOverlayConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new HybridOverlayConfigBuilder(hybridOverlayConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.HybridOverlayConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverridesLike(HybridOverlayConfig item) {
    return new NetworkSpecFluentImpl.HybridOverlayConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withAWSLoadBalancerParametersUnsupportedConfigOverrides(AWSLoadBalancerParameters aWSLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (aWSLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AWSLoadBalancerParametersBuilder(aWSLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverridesLike(AWSLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerListUnsupportedConfigOverrides(ImagePrunerList imagePrunerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerListBuilder(imagePrunerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImagePrunerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverridesLike(ImagePrunerList item) {
    return new NetworkSpecFluentImpl.ImagePrunerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerListUnsupportedConfigOverrides(CSISnapshotControllerList cSISnapshotControllerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerListBuilder(cSISnapshotControllerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverridesLike(CSISnapshotControllerList item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLocalObjectReferenceUnsupportedConfigOverrides(LocalObjectReference localObjectReferenceUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (localObjectReferenceUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LocalObjectReferenceBuilder(localObjectReferenceUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.LocalObjectReferenceUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverridesLike(LocalObjectReference item) {
    return new NetworkSpecFluentImpl.LocalObjectReferenceUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewLocalObjectReferenceUnsupportedConfigOverrides(String name) {
    return (A)withLocalObjectReferenceUnsupportedConfigOverrides(new LocalObjectReference(name));
  }
  public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new NetworkSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMRoutesUnsupportedConfigOverrides(StaticIPAMRoutes staticIPAMRoutesUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMRoutesUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMRoutesBuilder(staticIPAMRoutesUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverridesLike(StaticIPAMRoutes item) {
    return new NetworkSpecFluentImpl.StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewStaticIPAMRoutesUnsupportedConfigOverrides(String destination,String gateway) {
    return (A)withStaticIPAMRoutesUnsupportedConfigOverrides(new StaticIPAMRoutes(destination, gateway));
  }
  public A withDNSZoneConditionUnsupportedConfigOverrides(DNSZoneCondition dNSZoneConditionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSZoneConditionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSZoneConditionBuilder(dNSZoneConditionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSZoneConditionUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverridesLike(DNSZoneCondition item) {
    return new NetworkSpecFluentImpl.DNSZoneConditionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewDNSZoneConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withDNSZoneConditionUnsupportedConfigOverrides(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withContainerLoggingDestinationParametersUnsupportedConfigOverrides(ContainerLoggingDestinationParameters containerLoggingDestinationParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (containerLoggingDestinationParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ContainerLoggingDestinationParametersBuilder(containerLoggingDestinationParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverridesLike(ContainerLoggingDestinationParameters item) {
    return new NetworkSpecFluentImpl.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerListUnsupportedConfigOverrides(KubeSchedulerList kubeSchedulerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerListBuilder(kubeSchedulerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeSchedulerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverridesLike(KubeSchedulerList item) {
    return new NetworkSpecFluentImpl.KubeSchedulerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeAPIServerSpecUnsupportedConfigOverrides(KubeAPIServerSpec kubeAPIServerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeAPIServerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerSpecBuilder(kubeAPIServerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverridesLike(KubeAPIServerSpec item) {
    return new NetworkSpecFluentImpl.KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverUnsupportedConfigOverrides(ClusterCSIDriver clusterCSIDriverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverBuilder(clusterCSIDriverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withQuickStartsUnsupportedConfigOverrides(QuickStarts quickStartsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (quickStartsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new QuickStartsBuilder(quickStartsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.QuickStartsUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverridesLike(QuickStarts item) {
    return new NetworkSpecFluentImpl.QuickStartsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSZoneStatusUnsupportedConfigOverrides(DNSZoneStatus dNSZoneStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSZoneStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSZoneStatusBuilder(dNSZoneStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSZoneStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverridesLike(DNSZoneStatus item) {
    return new NetworkSpecFluentImpl.DNSZoneStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigSpecUnsupportedConfigOverrides(ConfigSpec configSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigSpecBuilder(configSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConfigSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverridesLike(ConfigSpec item) {
    return new NetworkSpecFluentImpl.ConfigSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOutageEntryUnsupportedConfigOverrides(OutageEntry outageEntryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (outageEntryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OutageEntryBuilder(outageEntryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OutageEntryUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverridesLike(OutageEntry item) {
    return new NetworkSpecFluentImpl.OutageEntryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerListUnsupportedConfigOverrides(OpenShiftControllerManagerList openShiftControllerManagerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerListBuilder(openShiftControllerManagerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverridesLike(OpenShiftControllerManagerList item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new NetworkSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEndpointPublishingStrategyUnsupportedConfigOverrides(EndpointPublishingStrategy endpointPublishingStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (endpointPublishingStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EndpointPublishingStrategyBuilder(endpointPublishingStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverridesLike(EndpointPublishingStrategy item) {
    return new NetworkSpecFluentImpl.EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIPFIXConfigUnsupportedOverrides(IPFIXConfig iPFIXConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (iPFIXConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new IPFIXConfigBuilder(iPFIXConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.IPFIXConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverridesLike(IPFIXConfig item) {
    return new NetworkSpecFluentImpl.IPFIXConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withCloudCredentialUnsupportedConfigOverrides(CloudCredential cloudCredentialUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialBuilder(cloudCredentialUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new NetworkSpecFluentImpl.CloudCredentialUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new NetworkSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterCSIDriverStatusUnsupportedConfigOverrides(ClusterCSIDriverStatus clusterCSIDriverStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterCSIDriverStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterCSIDriverStatusBuilder(clusterCSIDriverStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverridesLike(ClusterCSIDriverStatus item) {
    return new NetworkSpecFluentImpl.ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkStatusUnsupportedConfigOverrides(NetworkStatus networkStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkStatusBuilder(networkStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NetworkStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverridesLike(NetworkStatus item) {
    return new NetworkSpecFluentImpl.NetworkStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withSFlowConfigUnsupportedOverrides(SFlowConfig sFlowConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (sFlowConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new SFlowConfigBuilder(sFlowConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.SFlowConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverridesLike(SFlowConfig item) {
    return new NetworkSpecFluentImpl.SFlowConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withForwardPluginUnsupportedConfigOverrides(ForwardPlugin forwardPluginUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (forwardPluginUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ForwardPluginBuilder(forwardPluginUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ForwardPluginUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverridesLike(ForwardPlugin item) {
    return new NetworkSpecFluentImpl.ForwardPluginUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLogEntryUnsupportedConfigOverrides(LogEntry logEntryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (logEntryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LogEntryBuilder(logEntryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.LogEntryUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverridesLike(LogEntry item) {
    return new NetworkSpecFluentImpl.LogEntryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNodeStatusUnsupportedConfigOverrides(NodeStatus nodeStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (nodeStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NodeStatusBuilder(nodeStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NodeStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverridesLike(NodeStatus item) {
    return new NetworkSpecFluentImpl.NodeStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(PodNetworkConnectivityCheckCondition podNetworkConnectivityCheckConditionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckConditionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckConditionBuilder(podNetworkConnectivityCheckConditionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckCondition item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(new PodNetworkConnectivityCheckCondition(lastTransitionTime, message, reason, status, type));
  }
  public A withAdditionalNetworkDefinitionUnsupportedConfigOverrides(AdditionalNetworkDefinition additionalNetworkDefinitionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (additionalNetworkDefinitionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AdditionalNetworkDefinitionBuilder(additionalNetworkDefinitionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverridesLike(AdditionalNetworkDefinition item) {
    return new NetworkSpecFluentImpl.AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withRouteAdmissionPolicyUnsupportedConfigOverrides(RouteAdmissionPolicy routeAdmissionPolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (routeAdmissionPolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new RouteAdmissionPolicyBuilder(routeAdmissionPolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverridesLike(RouteAdmissionPolicy item) {
    return new NetworkSpecFluentImpl.RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewRouteAdmissionPolicyUnsupportedConfigOverrides(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmissionPolicyUnsupportedConfigOverrides(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public A withGenerationStatusUnsupportedConfigOverrides(GenerationStatus generationStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (generationStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new GenerationStatusBuilder(generationStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.GenerationStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverridesLike(GenerationStatus item) {
    return new NetworkSpecFluentImpl.GenerationStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationStatusUnsupportedConfigOverrides(AuthenticationStatus authenticationStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationStatusBuilder(authenticationStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AuthenticationStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverridesLike(AuthenticationStatus item) {
    return new NetworkSpecFluentImpl.AuthenticationStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides(IngressControllerCaptureHTTPHeaders ingressControllerCaptureHTTPHeadersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerCaptureHTTPHeadersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeadersBuilder(ingressControllerCaptureHTTPHeadersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeaders item) {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdListUnsupportedConfigOverrides(EtcdList etcdListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdListBuilder(etcdListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.EtcdListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverridesLike(EtcdList item) {
    return new NetworkSpecFluentImpl.EtcdListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNodePortStrategyUnsupportedConfigOverrides(NodePortStrategy nodePortStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (nodePortStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NodePortStrategyBuilder(nodePortStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NodePortStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverridesLike(NodePortStrategy item) {
    return new NetworkSpecFluentImpl.NodePortStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewNodePortStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withNodePortStrategyUnsupportedConfigOverrides(new NodePortStrategy(protocol));
  }
  public A withDefaultNetworkDefinitionUnsupportedConfigOverrides(DefaultNetworkDefinition defaultNetworkDefinitionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (defaultNetworkDefinitionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DefaultNetworkDefinitionBuilder(defaultNetworkDefinitionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverridesLike(DefaultNetworkDefinition item) {
    return new NetworkSpecFluentImpl.DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new NetworkSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClientTLSUnsupportedConfigOverrides(ClientTLS clientTLSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clientTLSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClientTLSBuilder(clientTLSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClientTLSUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverridesLike(ClientTLS item) {
    return new NetworkSpecFluentImpl.ClientTLSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerSpecUnsupportedConfigOverrides(OpenShiftAPIServerSpec openShiftAPIServerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerSpecBuilder(openShiftAPIServerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverridesLike(OpenShiftAPIServerSpec item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerStatusUnsupportedConfigOverrides(ImagePrunerStatus imagePrunerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerStatusBuilder(imagePrunerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImagePrunerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverridesLike(ImagePrunerStatus item) {
    return new NetworkSpecFluentImpl.ImagePrunerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerStatusUnsupportedConfigOverrides(KubeSchedulerStatus kubeSchedulerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerStatusBuilder(kubeSchedulerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverridesLike(KubeSchedulerStatus item) {
    return new NetworkSpecFluentImpl.KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withSyslogLoggingDestinationParametersUnsupportedConfigOverrides(SyslogLoggingDestinationParameters syslogLoggingDestinationParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (syslogLoggingDestinationParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new SyslogLoggingDestinationParametersBuilder(syslogLoggingDestinationParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverridesLike(SyslogLoggingDestinationParameters item) {
    return new NetworkSpecFluentImpl.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides(String address,String facility,Integer maxLength,Integer port) {
    return (A)withSyslogLoggingDestinationParametersUnsupportedConfigOverrides(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  public A withUpstreamUnsupportedConfigOverrides(Upstream upstreamUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (upstreamUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new UpstreamBuilder(upstreamUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.UpstreamUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverridesLike(Upstream item) {
    return new NetworkSpecFluentImpl.UpstreamUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewUpstreamUnsupportedConfigOverrides(String address,Integer port,String type) {
    return (A)withUpstreamUnsupportedConfigOverrides(new Upstream(address, port, type));
  }
  public A withAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides(AWSNetworkLoadBalancerParameters aWSNetworkLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (aWSNetworkLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AWSNetworkLoadBalancerParametersBuilder(aWSNetworkLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverridesLike(AWSNetworkLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAListUnsupportedConfigOverrides(ServiceCAList serviceCAListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCAListBuilder(serviceCAListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCAListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverridesLike(ServiceCAList item) {
    return new NetworkSpecFluentImpl.ServiceCAListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(IngressControllerCaptureHTTPHeader ingressControllerCaptureHTTPHeaderUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerCaptureHTTPHeaderUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPHeaderBuilder(ingressControllerCaptureHTTPHeaderUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeader item) {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(Integer maxLength,String name) {
    return (A)withIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  public A withNetworkMigrationUnsupportedConfigOverrides(NetworkMigration networkMigrationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkMigrationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkMigrationBuilder(networkMigrationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NetworkMigrationUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverridesLike(NetworkMigration item) {
    return new NetworkSpecFluentImpl.NetworkMigrationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewNetworkMigrationUnsupportedConfigOverrides(String networkType) {
    return (A)withNetworkMigrationUnsupportedConfigOverrides(new NetworkMigration(networkType));
  }
  public A withDNSRecordListUnsupportedConfigOverrides(DNSRecordList dNSRecordListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordListBuilder(dNSRecordListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSRecordListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverridesLike(DNSRecordList item) {
    return new NetworkSpecFluentImpl.DNSRecordListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withRawExtensionUnsupportedConfigOverrides(RawExtension rawExtensionUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (rawExtensionUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new RawExtensionBuilder(rawExtensionUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.RawExtensionUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverridesLike(RawExtension item) {
    return new NetworkSpecFluentImpl.RawExtensionUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewRawExtensionUnsupportedConfigOverrides(Object value) {
    return (A)withRawExtensionUnsupportedConfigOverrides(new RawExtension(value));
  }
  public A withEtcdSpecUnsupportedConfigOverrides(EtcdSpec etcdSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdSpecBuilder(etcdSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.EtcdSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverridesLike(EtcdSpec item) {
    return new NetworkSpecFluentImpl.EtcdSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckUnsupportedConfigOverrides(PodNetworkConnectivityCheck podNetworkConnectivityCheckUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckBuilder(podNetworkConnectivityCheckUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerStatusUnsupportedConfigOverrides(OpenShiftAPIServerStatus openShiftAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerStatusBuilder(openShiftAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverridesLike(OpenShiftAPIServerStatus item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLoadBalancerStrategyUnsupportedConfigOverrides(LoadBalancerStrategy loadBalancerStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (loadBalancerStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LoadBalancerStrategyBuilder(loadBalancerStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverridesLike(LoadBalancerStrategy item) {
    return new NetworkSpecFluentImpl.LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withEtcdStatusUnsupportedConfigOverrides(EtcdStatus etcdStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (etcdStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdStatusBuilder(etcdStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.EtcdStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverridesLike(EtcdStatus item) {
    return new NetworkSpecFluentImpl.EtcdStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCloudCredentialListUnsupportedConfigOverrides(CloudCredentialList cloudCredentialListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialListBuilder(cloudCredentialListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CloudCredentialListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverridesLike(CloudCredentialList item) {
    return new NetworkSpecFluentImpl.CloudCredentialListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withImagePrunerSpecUnsupportedConfigOverrides(ImagePrunerSpec imagePrunerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imagePrunerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerSpecBuilder(imagePrunerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImagePrunerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverridesLike(ImagePrunerSpec item) {
    return new NetworkSpecFluentImpl.ImagePrunerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStatuspageProviderUnsupportedConfigOverrides(StatuspageProvider statuspageProviderUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (statuspageProviderUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StatuspageProviderBuilder(statuspageProviderUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StatuspageProviderUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverridesLike(StatuspageProvider item) {
    return new NetworkSpecFluentImpl.StatuspageProviderUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewStatuspageProviderUnsupportedConfigOverrides(String pageID) {
    return (A)withStatuspageProviderUnsupportedConfigOverrides(new StatuspageProvider(pageID));
  }
  public A withKubeStorageVersionMigratorStatusUnsupportedConfigOverrides(KubeStorageVersionMigratorStatus kubeStorageVersionMigratorStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeStorageVersionMigratorStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorStatusBuilder(kubeStorageVersionMigratorStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverridesLike(KubeStorageVersionMigratorStatus item) {
    return new NetworkSpecFluentImpl.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConfigListUnsupportedConfigOverrides(ConfigList configListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (configListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConfigListBuilder(configListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConfigListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverridesLike(ConfigList item) {
    return new NetworkSpecFluentImpl.ConfigListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleProvidersUnsupportedConfigOverrides(ConsoleProviders consoleProvidersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleProvidersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleProvidersBuilder(consoleProvidersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleProvidersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverridesLike(ConsoleProviders item) {
    return new NetworkSpecFluentImpl.ConsoleProvidersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerLoggingUnsupportedConfigOverrides(IngressControllerLogging ingressControllerLoggingUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerLoggingUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerLoggingBuilder(ingressControllerLoggingUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerLoggingUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverridesLike(IngressControllerLogging item) {
    return new NetworkSpecFluentImpl.IngressControllerLoggingUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationListUnsupportedConfigOverrides(AuthenticationList authenticationListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationListBuilder(authenticationListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AuthenticationListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverridesLike(AuthenticationList item) {
    return new NetworkSpecFluentImpl.AuthenticationListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageStatusUnsupportedConfigOverrides(StorageStatus storageStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageStatusBuilder(storageStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StorageStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverridesLike(StorageStatus item) {
    return new NetworkSpecFluentImpl.StorageStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerListUnsupportedConfigOverrides(KubeControllerManagerList kubeControllerManagerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerListBuilder(kubeControllerManagerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeControllerManagerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverridesLike(KubeControllerManagerList item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationSpecUnsupportedConfigOverrides(AuthenticationSpec authenticationSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationSpecBuilder(authenticationSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AuthenticationSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverridesLike(AuthenticationSpec item) {
    return new NetworkSpecFluentImpl.AuthenticationSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIPAMConfigUnsupportedOverrides(IPAMConfig iPAMConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (iPAMConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new IPAMConfigBuilder(iPAMConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.IPAMConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverridesLike(IPAMConfig item) {
    return new NetworkSpecFluentImpl.IPAMConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withContainerUnsupportedConfigOverrides(Container containerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (containerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ContainerBuilder(containerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ContainerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverridesLike(Container item) {
    return new NetworkSpecFluentImpl.ContainerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new NetworkSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides(PodNetworkConnectivityCheckSpec podNetworkConnectivityCheckSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckSpecBuilder(podNetworkConnectivityCheckSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckSpec item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAccessLoggingUnsupportedConfigOverrides(AccessLogging accessLoggingUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (accessLoggingUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AccessLoggingBuilder(accessLoggingUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AccessLoggingUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverridesLike(AccessLogging item) {
    return new NetworkSpecFluentImpl.AccessLoggingUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withHostNetworkStrategyUnsupportedConfigOverrides(HostNetworkStrategy hostNetworkStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (hostNetworkStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new HostNetworkStrategyBuilder(hostNetworkStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.HostNetworkStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverridesLike(HostNetworkStrategy item) {
    return new NetworkSpecFluentImpl.HostNetworkStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewHostNetworkStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withHostNetworkStrategyUnsupportedConfigOverrides(new HostNetworkStrategy(protocol));
  }
  public A withDNSRecordSpecUnsupportedConfigOverrides(DNSRecordSpec dNSRecordSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordSpecBuilder(dNSRecordSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSRecordSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverridesLike(DNSRecordSpec item) {
    return new NetworkSpecFluentImpl.DNSRecordSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides(DeveloperConsoleCatalogCustomization developerConsoleCatalogCustomizationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (developerConsoleCatalogCustomizationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DeveloperConsoleCatalogCustomizationBuilder(developerConsoleCatalogCustomizationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCustomization item) {
    return new NetworkSpecFluentImpl.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeSchedulerSpecUnsupportedConfigOverrides(KubeSchedulerSpec kubeSchedulerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeSchedulerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerSpecBuilder(kubeSchedulerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverridesLike(KubeSchedulerSpec item) {
    return new NetworkSpecFluentImpl.KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withLoggingDestinationUnsupportedConfigOverrides(LoggingDestination loggingDestinationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (loggingDestinationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new LoggingDestinationBuilder(loggingDestinationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.LoggingDestinationUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverridesLike(LoggingDestination item) {
    return new NetworkSpecFluentImpl.LoggingDestinationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withIngressControllerTuningOptionsUnsupportedConfigOverrides(IngressControllerTuningOptions ingressControllerTuningOptionsUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerTuningOptionsUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerTuningOptionsBuilder(ingressControllerTuningOptionsUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverridesLike(IngressControllerTuningOptions item) {
    return new NetworkSpecFluentImpl.IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMConfigUnsupportedOverrides(StaticIPAMConfig staticIPAMConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMConfigBuilder(staticIPAMConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.StaticIPAMConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverridesLike(StaticIPAMConfig item) {
    return new NetworkSpecFluentImpl.StaticIPAMConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withImageContentSourcePolicyListUnsupportedConfigOverrides(ImageContentSourcePolicyList imageContentSourcePolicyListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (imageContentSourcePolicyListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyListBuilder(imageContentSourcePolicyListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverridesLike(ImageContentSourcePolicyList item) {
    return new NetworkSpecFluentImpl.ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftControllerManagerStatusUnsupportedConfigOverrides(OpenShiftControllerManagerStatus openShiftControllerManagerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftControllerManagerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerStatusBuilder(openShiftControllerManagerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverridesLike(OpenShiftControllerManagerStatus item) {
    return new NetworkSpecFluentImpl.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogAPIServerStatusUnsupportedConfigOverrides(ServiceCatalogAPIServerStatus serviceCatalogAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerStatusBuilder(serviceCatalogAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverridesLike(ServiceCatalogAPIServerStatus item) {
    return new NetworkSpecFluentImpl.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withKubeControllerManagerSpecUnsupportedConfigOverrides(KubeControllerManagerSpec kubeControllerManagerSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (kubeControllerManagerSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerSpecBuilder(kubeControllerManagerSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverridesLike(KubeControllerManagerSpec item) {
    return new NetworkSpecFluentImpl.KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMDNSUnsupportedConfigOverrides(StaticIPAMDNS staticIPAMDNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMDNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMDNSBuilder(staticIPAMDNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StaticIPAMDNSUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverridesLike(StaticIPAMDNS item) {
    return new NetworkSpecFluentImpl.StaticIPAMDNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSNodePlacementUnsupportedConfigOverrides(DNSNodePlacement dNSNodePlacementUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSNodePlacementUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSNodePlacementBuilder(dNSNodePlacementUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSNodePlacementUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverridesLike(DNSNodePlacement item) {
    return new NetworkSpecFluentImpl.DNSNodePlacementUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageSpecUnsupportedConfigOverrides(StorageSpec storageSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageSpecBuilder(storageSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StorageSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverridesLike(StorageSpec item) {
    return new NetworkSpecFluentImpl.StorageSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkListUnsupportedConfigOverrides(NetworkList networkListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkListBuilder(networkListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NetworkListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverridesLike(NetworkList item) {
    return new NetworkSpecFluentImpl.NetworkListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNodePlacementUnsupportedConfigOverrides(NodePlacement nodePlacementUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (nodePlacementUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NodePlacementBuilder(nodePlacementUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NodePlacementUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverridesLike(NodePlacement item) {
    return new NetworkSpecFluentImpl.NodePlacementUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withProviderLoadBalancerParametersUnsupportedConfigOverrides(ProviderLoadBalancerParameters providerLoadBalancerParametersUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (providerLoadBalancerParametersUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ProviderLoadBalancerParametersBuilder(providerLoadBalancerParametersUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverridesLike(ProviderLoadBalancerParameters item) {
    return new NetworkSpecFluentImpl.ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetworkSpecUnsupportedConfigOverrides(NetworkSpec networkSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (networkSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkSpecBuilder(networkSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.NetworkSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverridesLike(NetworkSpec item) {
    return new NetworkSpecFluentImpl.NetworkSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCASpecUnsupportedConfigOverrides(ServiceCASpec serviceCASpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCASpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCASpecBuilder(serviceCASpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCASpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverridesLike(ServiceCASpec item) {
    return new NetworkSpecFluentImpl.ServiceCASpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPrivateStrategyUnsupportedConfigOverrides(PrivateStrategy privateStrategyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (privateStrategyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PrivateStrategyBuilder(privateStrategyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PrivateStrategyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverridesLike(PrivateStrategy item) {
    return new NetworkSpecFluentImpl.PrivateStrategyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleStatusUnsupportedConfigOverrides(ConsoleStatus consoleStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleStatusBuilder(consoleStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverridesLike(ConsoleStatus item) {
    return new NetworkSpecFluentImpl.ConsoleStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withPodNetworkConnectivityCheckListUnsupportedConfigOverrides(PodNetworkConnectivityCheckList podNetworkConnectivityCheckListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (podNetworkConnectivityCheckListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PodNetworkConnectivityCheckListBuilder(podNetworkConnectivityCheckListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckList item) {
    return new NetworkSpecFluentImpl.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withObjectReferenceUnsupportedConfigOverrides(ObjectReference objectReferenceUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (objectReferenceUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ObjectReferenceBuilder(objectReferenceUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ObjectReferenceUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverridesLike(ObjectReference item) {
    return new NetworkSpecFluentImpl.ObjectReferenceUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerListUnsupportedConfigOverrides(OpenShiftAPIServerList openShiftAPIServerListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerListBuilder(openShiftAPIServerListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverridesLike(OpenShiftAPIServerList item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServerUnsupportedConfigOverrides(Server serverUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serverUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServerBuilder(serverUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverridesLike(Server item) {
    return new NetworkSpecFluentImpl.ServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOAuthAPIServerStatusUnsupportedConfigOverrides(OAuthAPIServerStatus oAuthAPIServerStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (oAuthAPIServerStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OAuthAPIServerStatusBuilder(oAuthAPIServerStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverridesLike(OAuthAPIServerStatus item) {
    return new NetworkSpecFluentImpl.OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewOAuthAPIServerStatusUnsupportedConfigOverrides(Integer latestAvailableRevision) {
    return (A)withOAuthAPIServerStatusUnsupportedConfigOverrides(new OAuthAPIServerStatus(latestAvailableRevision));
  }
  public A withCloudCredentialSpecUnsupportedConfigOverrides(CloudCredentialSpec cloudCredentialSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (cloudCredentialSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CloudCredentialSpecBuilder(cloudCredentialSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.CloudCredentialSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverridesLike(CloudCredentialSpec item) {
    return new NetworkSpecFluentImpl.CloudCredentialSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSRecordStatusUnsupportedConfigOverrides(DNSRecordStatus dNSRecordStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordStatusBuilder(dNSRecordStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSRecordStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverridesLike(DNSRecordStatus item) {
    return new NetworkSpecFluentImpl.DNSRecordStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new NetworkSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withClusterNetworkEntryUnsupportedConfigOverrides(ClusterNetworkEntry clusterNetworkEntryUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (clusterNetworkEntryUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ClusterNetworkEntryBuilder(clusterNetworkEntryUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverridesLike(ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewClusterNetworkEntryUnsupportedConfigOverrides(String cidr,Integer hostPrefix) {
    return (A)withClusterNetworkEntryUnsupportedConfigOverrides(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public A withIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(IngressControllerCaptureHTTPCookie ingressControllerCaptureHTTPCookieUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (ingressControllerCaptureHTTPCookieUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerCaptureHTTPCookieBuilder(ingressControllerCaptureHTTPCookieUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPCookie item) {
    return new NetworkSpecFluentImpl.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)withIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  public A withHTTPCompressionPolicyUnsupportedConfigOverrides(HTTPCompressionPolicy hTTPCompressionPolicyUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (hTTPCompressionPolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new HTTPCompressionPolicyBuilder(hTTPCompressionPolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverridesLike(HTTPCompressionPolicy item) {
    return new NetworkSpecFluentImpl.HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withProjectAccessUnsupportedConfigOverrides(ProjectAccess projectAccessUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (projectAccessUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ProjectAccessBuilder(projectAccessUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ProjectAccessUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverridesLike(ProjectAccess item) {
    return new NetworkSpecFluentImpl.ProjectAccessUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new NetworkSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNetFlowConfigUnsupportedOverrides(NetFlowConfig netFlowConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (netFlowConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new NetFlowConfigBuilder(netFlowConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.NetFlowConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverridesLike(NetFlowConfig item) {
    return new NetworkSpecFluentImpl.NetFlowConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withPolicyAuditConfigUnsupportedOverrides(PolicyAuditConfig policyAuditConfigUnsupportedOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (policyAuditConfigUnsupportedOverrides!=null){ this.unsupportedConfigOverrides= new PolicyAuditConfigBuilder(policyAuditConfigUnsupportedOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverrides() {
    return new NetworkSpecFluentImpl.PolicyAuditConfigUnsupportedOverridesNestedImpl();
  }
  public NetworkSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverridesLike(PolicyAuditConfig item) {
    return new NetworkSpecFluentImpl.PolicyAuditConfigUnsupportedOverridesNestedImpl(item);
  }
  public A withNewPolicyAuditConfigUnsupportedOverrides(String destination,Integer maxFileSize,Integer rateLimit,String syslogFacility) {
    return (A)withPolicyAuditConfigUnsupportedOverrides(new PolicyAuditConfig(destination, maxFileSize, rateLimit, syslogFacility));
  }
  public A withAddPageUnsupportedConfigOverrides(AddPage addPageUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (addPageUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AddPageBuilder(addPageUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AddPageUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverridesLike(AddPage item) {
    return new NetworkSpecFluentImpl.AddPageUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStorageListUnsupportedConfigOverrides(StorageList storageListUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (storageListUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StorageListBuilder(storageListUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StorageListUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverridesLike(StorageList item) {
    return new NetworkSpecFluentImpl.StorageListUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withStaticIPAMAddressesUnsupportedConfigOverrides(StaticIPAMAddresses staticIPAMAddressesUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (staticIPAMAddressesUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new StaticIPAMAddressesBuilder(staticIPAMAddressesUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverridesLike(StaticIPAMAddresses item) {
    return new NetworkSpecFluentImpl.StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withNewStaticIPAMAddressesUnsupportedConfigOverrides(String address,String gateway) {
    return (A)withStaticIPAMAddressesUnsupportedConfigOverrides(new StaticIPAMAddresses(address, gateway));
  }
  public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new NetworkSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new NetworkSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new NetworkSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withConsoleSpecUnsupportedConfigOverrides(ConsoleSpec consoleSpecUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (consoleSpecUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleSpecBuilder(consoleSpecUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ConsoleSpecUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverridesLike(ConsoleSpec item) {
    return new NetworkSpecFluentImpl.ConsoleSpecUnsupportedConfigOverridesNestedImpl(item);
  }
  public A withServiceCAStatusUnsupportedConfigOverrides(ServiceCAStatus serviceCAStatusUnsupportedConfigOverrides) {
    _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
    if (serviceCAStatusUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCAStatusBuilder(serviceCAStatusUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} else { this.unsupportedConfigOverrides = null; _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides); } return (A) this;
  }
  public NetworkSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverrides() {
    return new NetworkSpecFluentImpl.ServiceCAStatusUnsupportedConfigOverridesNestedImpl();
  }
  public NetworkSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverridesLike(ServiceCAStatus item) {
    return new NetworkSpecFluentImpl.ServiceCAStatusUnsupportedConfigOverridesNestedImpl(item);
  }
  public Boolean getUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy;
  }
  public A withUseMultiNetworkPolicy(Boolean useMultiNetworkPolicy) {
    this.useMultiNetworkPolicy=useMultiNetworkPolicy; return (A) this;
  }
  public Boolean hasUseMultiNetworkPolicy() {
    return this.useMultiNetworkPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
    if (additionalNetworks != null ? !additionalNetworks.equals(that.additionalNetworks) :that.additionalNetworks != null) return false;
    if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
    if (defaultNetwork != null ? !defaultNetwork.equals(that.defaultNetwork) :that.defaultNetwork != null) return false;
    if (deployKubeProxy != null ? !deployKubeProxy.equals(that.deployKubeProxy) :that.deployKubeProxy != null) return false;
    if (disableMultiNetwork != null ? !disableMultiNetwork.equals(that.disableMultiNetwork) :that.disableMultiNetwork != null) return false;
    if (disableNetworkDiagnostics != null ? !disableNetworkDiagnostics.equals(that.disableNetworkDiagnostics) :that.disableNetworkDiagnostics != null) return false;
    if (exportNetworkFlows != null ? !exportNetworkFlows.equals(that.exportNetworkFlows) :that.exportNetworkFlows != null) return false;
    if (kubeProxyConfig != null ? !kubeProxyConfig.equals(that.kubeProxyConfig) :that.kubeProxyConfig != null) return false;
    if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (migration != null ? !migration.equals(that.migration) :that.migration != null) return false;
    if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
    if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
    if (useMultiNetworkPolicy != null ? !useMultiNetworkPolicy.equals(that.useMultiNetworkPolicy) :that.useMultiNetworkPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalNetworks,  clusterNetwork,  defaultNetwork,  deployKubeProxy,  disableMultiNetwork,  disableNetworkDiagnostics,  exportNetworkFlows,  kubeProxyConfig,  logLevel,  managementState,  migration,  observedConfig,  operatorLogLevel,  serviceNetwork,  unsupportedConfigOverrides,  useMultiNetworkPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalNetworks != null && !additionalNetworks.isEmpty()) { sb.append("additionalNetworks:"); sb.append(additionalNetworks + ","); }
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (defaultNetwork != null) { sb.append("defaultNetwork:"); sb.append(defaultNetwork + ","); }
    if (deployKubeProxy != null) { sb.append("deployKubeProxy:"); sb.append(deployKubeProxy + ","); }
    if (disableMultiNetwork != null) { sb.append("disableMultiNetwork:"); sb.append(disableMultiNetwork + ","); }
    if (disableNetworkDiagnostics != null) { sb.append("disableNetworkDiagnostics:"); sb.append(disableNetworkDiagnostics + ","); }
    if (exportNetworkFlows != null) { sb.append("exportNetworkFlows:"); sb.append(exportNetworkFlows + ","); }
    if (kubeProxyConfig != null) { sb.append("kubeProxyConfig:"); sb.append(kubeProxyConfig + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (migration != null) { sb.append("migration:"); sb.append(migration + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (useMultiNetworkPolicy != null) { sb.append("useMultiNetworkPolicy:"); sb.append(useMultiNetworkPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDeployKubeProxy() {
    return withDeployKubeProxy(true);
  }
  public A withDisableMultiNetwork() {
    return withDisableMultiNetwork(true);
  }
  public A withDisableNetworkDiagnostics() {
    return withDisableNetworkDiagnostics(true);
  }
  public A withUseMultiNetworkPolicy() {
    return withUseMultiNetworkPolicy(true);
  }
  class AdditionalNetworksNestedImpl<N> extends AdditionalNetworkDefinitionFluentImpl<NetworkSpecFluent.AdditionalNetworksNested<N>> implements NetworkSpecFluent.AdditionalNetworksNested<N>,Nested<N>{
    AdditionalNetworksNestedImpl(Integer index,AdditionalNetworkDefinition item) {
      this.index = index;
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworksNestedImpl() {
      this.index = -1;
      this.builder = new AdditionalNetworkDefinitionBuilder(this);
    }
    AdditionalNetworkDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToAdditionalNetworks(index,builder.build());
    }
    public N endAdditionalNetwork() {
      return and();
    }
    
  }
  class ClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkSpecFluent.ClusterNetworkNested<N>> implements NetworkSpecFluent.ClusterNetworkNested<N>,Nested<N>{
    ClusterNetworkNestedImpl(Integer index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  class DefaultNetworkNestedImpl<N> extends DefaultNetworkDefinitionFluentImpl<NetworkSpecFluent.DefaultNetworkNested<N>> implements NetworkSpecFluent.DefaultNetworkNested<N>,Nested<N>{
    DefaultNetworkNestedImpl(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkNestedImpl() {
      this.builder = new DefaultNetworkDefinitionBuilder(this);
    }
    DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withDefaultNetwork(builder.build());
    }
    public N endDefaultNetwork() {
      return and();
    }
    
  }
  class ExportNetworkFlowsNestedImpl<N> extends ExportNetworkFlowsFluentImpl<NetworkSpecFluent.ExportNetworkFlowsNested<N>> implements NetworkSpecFluent.ExportNetworkFlowsNested<N>,Nested<N>{
    ExportNetworkFlowsNestedImpl(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsNestedImpl() {
      this.builder = new ExportNetworkFlowsBuilder(this);
    }
    ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withExportNetworkFlows(builder.build());
    }
    public N endExportNetworkFlows() {
      return and();
    }
    
  }
  class KubeProxyConfigNestedImpl<N> extends ProxyConfigFluentImpl<NetworkSpecFluent.KubeProxyConfigNested<N>> implements NetworkSpecFluent.KubeProxyConfigNested<N>,Nested<N>{
    KubeProxyConfigNestedImpl(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    KubeProxyConfigNestedImpl() {
      this.builder = new ProxyConfigBuilder(this);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withKubeProxyConfig(builder.build());
    }
    public N endKubeProxyConfig() {
      return and();
    }
    
  }
  class MigrationNestedImpl<N> extends NetworkMigrationFluentImpl<NetworkSpecFluent.MigrationNested<N>> implements NetworkSpecFluent.MigrationNested<N>,Nested<N>{
    MigrationNestedImpl(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    MigrationNestedImpl() {
      this.builder = new NetworkMigrationBuilder(this);
    }
    NetworkMigrationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withMigration(builder.build());
    }
    public N endMigration() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerListObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerListFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerListObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerListObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerListObservedConfigNestedImpl(ServiceCatalogAPIServerList item) {
      this.builder = new ServiceCatalogAPIServerListBuilder(this, item);
    }
    ServiceCatalogAPIServerListObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerListBuilder(this);
    }
    ServiceCatalogAPIServerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerListObservedConfig() {
      return and();
    }
    
  }
  class LabelSelectorObservedConfigNestedImpl<N> extends LabelSelectorFluentImpl<NetworkSpecFluent.LabelSelectorObservedConfigNested<N>> implements NetworkSpecFluent.LabelSelectorObservedConfigNested<N>,Nested<N>{
    LabelSelectorObservedConfigNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorObservedConfigNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endLabelSelectorObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerObservedConfigNestedImpl<N> extends ImagePrunerFluentImpl<NetworkSpecFluent.ImagePrunerObservedConfigNested<N>> implements NetworkSpecFluent.ImagePrunerObservedConfigNested<N>,Nested<N>{
    ImagePrunerObservedConfigNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerObservedConfigNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerObservedConfigNestedImpl<N> extends KubeControllerManagerFluentImpl<NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements NetworkSpecFluent.KubeControllerManagerObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerObservedConfigNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckStatusObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckStatusFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckStatusObservedConfigNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckStatusObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckStatusObservedConfigNestedImpl(PodNetworkConnectivityCheckStatus item) {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this, item);
    }
    PodNetworkConnectivityCheckStatusObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this);
    }
    PodNetworkConnectivityCheckStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckStatusObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorListObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorListFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorListObservedConfigNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorListObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorListObservedConfigNestedImpl(KubeStorageVersionMigratorList item) {
      this.builder = new KubeStorageVersionMigratorListBuilder(this, item);
    }
    KubeStorageVersionMigratorListObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorListBuilder(this);
    }
    KubeStorageVersionMigratorListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorListObservedConfig() {
      return and();
    }
    
  }
  class StorageObservedConfigNestedImpl<N> extends StorageFluentImpl<NetworkSpecFluent.StorageObservedConfigNested<N>> implements NetworkSpecFluent.StorageObservedConfigNested<N>,Nested<N>{
    StorageObservedConfigNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageObservedConfigNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageObservedConfig() {
      return and();
    }
    
  }
  class PodTemplateSpecObservedConfigNestedImpl<N> extends PodTemplateSpecFluentImpl<NetworkSpecFluent.PodTemplateSpecObservedConfigNested<N>> implements NetworkSpecFluent.PodTemplateSpecObservedConfigNested<N>,Nested<N>{
    PodTemplateSpecObservedConfigNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecObservedConfigNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodTemplateSpecObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerStatusObservedConfigNestedImpl<N> extends KubeControllerManagerStatusFluentImpl<NetworkSpecFluent.KubeControllerManagerStatusObservedConfigNested<N>> implements NetworkSpecFluent.KubeControllerManagerStatusObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerStatusObservedConfigNestedImpl(KubeControllerManagerStatus item) {
      this.builder = new KubeControllerManagerStatusBuilder(this, item);
    }
    KubeControllerManagerStatusObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerStatusBuilder(this);
    }
    KubeControllerManagerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerStatusObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerListObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerListFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerListObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerListObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerListObservedConfigNestedImpl(ServiceCatalogControllerManagerList item) {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this, item);
    }
    ServiceCatalogControllerManagerListObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this);
    }
    ServiceCatalogControllerManagerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerListObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerStatusObservedConfigNestedImpl<N> extends CSISnapshotControllerStatusFluentImpl<NetworkSpecFluent.CSISnapshotControllerStatusObservedConfigNested<N>> implements NetworkSpecFluent.CSISnapshotControllerStatusObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerStatusObservedConfigNestedImpl(CSISnapshotControllerStatus item) {
      this.builder = new CSISnapshotControllerStatusBuilder(this, item);
    }
    CSISnapshotControllerStatusObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerStatusBuilder(this);
    }
    CSISnapshotControllerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerStatusObservedConfig() {
      return and();
    }
    
  }
  class IPsecConfigObservedNestedImpl<N> extends IPsecConfigFluentImpl<NetworkSpecFluent.IPsecConfigObservedNested<N>> implements NetworkSpecFluent.IPsecConfigObservedNested<N>,Nested<N>{
    IPsecConfigObservedNestedImpl(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigObservedNestedImpl() {
      this.builder = new IPsecConfigBuilder(this);
    }
    IPsecConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIPsecConfigObserved() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicyObservedConfigNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyObservedConfig() {
      return and();
    }
    
  }
  class ResourceRequirementsObservedConfigNestedImpl<N> extends ResourceRequirementsFluentImpl<NetworkSpecFluent.ResourceRequirementsObservedConfigNested<N>> implements NetworkSpecFluent.ResourceRequirementsObservedConfigNested<N>,Nested<N>{
    ResourceRequirementsObservedConfigNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsObservedConfigNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endResourceRequirementsObservedConfig() {
      return and();
    }
    
  }
  class OVNKubernetesConfigObservedNestedImpl<N> extends OVNKubernetesConfigFluentImpl<NetworkSpecFluent.OVNKubernetesConfigObservedNested<N>> implements NetworkSpecFluent.OVNKubernetesConfigObservedNested<N>,Nested<N>{
    OVNKubernetesConfigObservedNestedImpl(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigObservedNestedImpl() {
      this.builder = new OVNKubernetesConfigBuilder(this);
    }
    OVNKubernetesConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOVNKubernetesConfigObserved() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCategoryMetaObservedConfigNestedImpl<N> extends DeveloperConsoleCatalogCategoryMetaFluentImpl<NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaObservedConfigNested<N>> implements NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaObservedConfigNested<N>,Nested<N>{
    DeveloperConsoleCatalogCategoryMetaObservedConfigNestedImpl(DeveloperConsoleCatalogCategoryMeta item) {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryMetaObservedConfigNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this);
    }
    DeveloperConsoleCatalogCategoryMetaBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryMetaObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorSpecObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorSpecFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorSpecObservedConfigNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorSpecObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorSpecObservedConfigNestedImpl(KubeStorageVersionMigratorSpec item) {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this, item);
    }
    KubeStorageVersionMigratorSpecObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this);
    }
    KubeStorageVersionMigratorSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorSpecObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerSpecObservedConfigNestedImpl<N> extends IngressControllerSpecFluentImpl<NetworkSpecFluent.IngressControllerSpecObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerSpecObservedConfigNested<N>,Nested<N>{
    IngressControllerSpecObservedConfigNestedImpl(IngressControllerSpec item) {
      this.builder = new IngressControllerSpecBuilder(this, item);
    }
    IngressControllerSpecObservedConfigNestedImpl() {
      this.builder = new IngressControllerSpecBuilder(this);
    }
    IngressControllerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerSpecObservedConfig() {
      return and();
    }
    
  }
  class DNSSpecObservedConfigNestedImpl<N> extends DNSSpecFluentImpl<NetworkSpecFluent.DNSSpecObservedConfigNested<N>> implements NetworkSpecFluent.DNSSpecObservedConfigNested<N>,Nested<N>{
    DNSSpecObservedConfigNestedImpl(DNSSpec item) {
      this.builder = new DNSSpecBuilder(this, item);
    }
    DNSSpecObservedConfigNestedImpl() {
      this.builder = new DNSSpecBuilder(this);
    }
    DNSSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSSpecObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftSDNConfigObservedNestedImpl<N> extends OpenShiftSDNConfigFluentImpl<NetworkSpecFluent.OpenShiftSDNConfigObservedNested<N>> implements NetworkSpecFluent.OpenShiftSDNConfigObservedNested<N>,Nested<N>{
    OpenShiftSDNConfigObservedNestedImpl(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenShiftSDNConfigObservedNestedImpl() {
      this.builder = new OpenShiftSDNConfigBuilder(this);
    }
    OpenShiftSDNConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftSDNConfigObserved() {
      return and();
    }
    
  }
  class OperatorConditionObservedConfigNestedImpl<N> extends OperatorConditionFluentImpl<NetworkSpecFluent.OperatorConditionObservedConfigNested<N>> implements NetworkSpecFluent.OperatorConditionObservedConfigNested<N>,Nested<N>{
    OperatorConditionObservedConfigNestedImpl(OperatorCondition item) {
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionObservedConfigNestedImpl() {
      this.builder = new OperatorConditionBuilder(this);
    }
    OperatorConditionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOperatorConditionObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerHTTPHeadersObservedConfigNestedImpl<N> extends IngressControllerHTTPHeadersFluentImpl<NetworkSpecFluent.IngressControllerHTTPHeadersObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerHTTPHeadersObservedConfigNested<N>,Nested<N>{
    IngressControllerHTTPHeadersObservedConfigNestedImpl(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersObservedConfigNestedImpl() {
      this.builder = new IngressControllerHTTPHeadersBuilder(this);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerHTTPHeadersObservedConfig() {
      return and();
    }
    
  }
  class ProxyConfigObservedNestedImpl<N> extends ProxyConfigFluentImpl<NetworkSpecFluent.ProxyConfigObservedNested<N>> implements NetworkSpecFluent.ProxyConfigObservedNested<N>,Nested<N>{
    ProxyConfigObservedNestedImpl(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigObservedNestedImpl() {
      this.builder = new ProxyConfigBuilder(this);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endProxyConfigObserved() {
      return and();
    }
    
  }
  class ConsoleListObservedConfigNestedImpl<N> extends ConsoleListFluentImpl<NetworkSpecFluent.ConsoleListObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleListObservedConfigNested<N>,Nested<N>{
    ConsoleListObservedConfigNestedImpl(ConsoleList item) {
      this.builder = new ConsoleListBuilder(this, item);
    }
    ConsoleListObservedConfigNestedImpl() {
      this.builder = new ConsoleListBuilder(this);
    }
    ConsoleListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleListObservedConfig() {
      return and();
    }
    
  }
  class KuryrConfigObservedNestedImpl<N> extends KuryrConfigFluentImpl<NetworkSpecFluent.KuryrConfigObservedNested<N>> implements NetworkSpecFluent.KuryrConfigObservedNested<N>,Nested<N>{
    KuryrConfigObservedNestedImpl(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigObservedNestedImpl() {
      this.builder = new KuryrConfigBuilder(this);
    }
    KuryrConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKuryrConfigObserved() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCategoryObservedConfigNestedImpl<N> extends DeveloperConsoleCatalogCategoryFluentImpl<NetworkSpecFluent.DeveloperConsoleCatalogCategoryObservedConfigNested<N>> implements NetworkSpecFluent.DeveloperConsoleCatalogCategoryObservedConfigNested<N>,Nested<N>{
    DeveloperConsoleCatalogCategoryObservedConfigNestedImpl(DeveloperConsoleCatalogCategory item) {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryObservedConfigNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerSpecObservedConfigNestedImpl<N> extends OpenShiftControllerManagerSpecFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerSpecObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerSpecObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerSpecObservedConfigNestedImpl(OpenShiftControllerManagerSpec item) {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this, item);
    }
    OpenShiftControllerManagerSpecObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this);
    }
    OpenShiftControllerManagerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerSpecObservedConfig() {
      return and();
    }
    
  }
  class ExportNetworkFlowsObservedConfigNestedImpl<N> extends ExportNetworkFlowsFluentImpl<NetworkSpecFluent.ExportNetworkFlowsObservedConfigNested<N>> implements NetworkSpecFluent.ExportNetworkFlowsObservedConfigNested<N>,Nested<N>{
    ExportNetworkFlowsObservedConfigNestedImpl(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsObservedConfigNestedImpl() {
      this.builder = new ExportNetworkFlowsBuilder(this);
    }
    ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endExportNetworkFlowsObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverSpecObservedConfigNestedImpl<N> extends ClusterCSIDriverSpecFluentImpl<NetworkSpecFluent.ClusterCSIDriverSpecObservedConfigNested<N>> implements NetworkSpecFluent.ClusterCSIDriverSpecObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverSpecObservedConfigNestedImpl(ClusterCSIDriverSpec item) {
      this.builder = new ClusterCSIDriverSpecBuilder(this, item);
    }
    ClusterCSIDriverSpecObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverSpecBuilder(this);
    }
    ClusterCSIDriverSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverSpecObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerSpecObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerSpecFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerSpecObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerSpecObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerSpecObservedConfigNestedImpl(ServiceCatalogAPIServerSpec item) {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this, item);
    }
    ServiceCatalogAPIServerSpecObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this);
    }
    ServiceCatalogAPIServerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerSpecObservedConfig() {
      return and();
    }
    
  }
  class ImageContentSourcePolicySpecObservedConfigNestedImpl<N> extends ImageContentSourcePolicySpecFluentImpl<NetworkSpecFluent.ImageContentSourcePolicySpecObservedConfigNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicySpecObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicySpecObservedConfigNestedImpl(ImageContentSourcePolicySpec item) {
      this.builder = new ImageContentSourcePolicySpecBuilder(this, item);
    }
    ImageContentSourcePolicySpecObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicySpecBuilder(this);
    }
    ImageContentSourcePolicySpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicySpecObservedConfig() {
      return and();
    }
    
  }
  class RepositoryDigestMirrorsObservedConfigNestedImpl<N> extends RepositoryDigestMirrorsFluentImpl<NetworkSpecFluent.RepositoryDigestMirrorsObservedConfigNested<N>> implements NetworkSpecFluent.RepositoryDigestMirrorsObservedConfigNested<N>,Nested<N>{
    RepositoryDigestMirrorsObservedConfigNestedImpl(RepositoryDigestMirrors item) {
      this.builder = new RepositoryDigestMirrorsBuilder(this, item);
    }
    RepositoryDigestMirrorsObservedConfigNestedImpl() {
      this.builder = new RepositoryDigestMirrorsBuilder(this);
    }
    RepositoryDigestMirrorsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endRepositoryDigestMirrorsObservedConfig() {
      return and();
    }
    
  }
  class ConsoleCustomizationObservedConfigNestedImpl<N> extends ConsoleCustomizationFluentImpl<NetworkSpecFluent.ConsoleCustomizationObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleCustomizationObservedConfigNested<N>,Nested<N>{
    ConsoleCustomizationObservedConfigNestedImpl(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationObservedConfigNestedImpl() {
      this.builder = new ConsoleCustomizationBuilder(this);
    }
    ConsoleCustomizationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleCustomizationObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerSpecObservedConfigNestedImpl<N> extends CSISnapshotControllerSpecFluentImpl<NetworkSpecFluent.CSISnapshotControllerSpecObservedConfigNested<N>> implements NetworkSpecFluent.CSISnapshotControllerSpecObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerSpecObservedConfigNestedImpl(CSISnapshotControllerSpec item) {
      this.builder = new CSISnapshotControllerSpecBuilder(this, item);
    }
    CSISnapshotControllerSpecObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerSpecBuilder(this);
    }
    CSISnapshotControllerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerSpecObservedConfig() {
      return and();
    }
    
  }
  class UpstreamResolversObservedConfigNestedImpl<N> extends UpstreamResolversFluentImpl<NetworkSpecFluent.UpstreamResolversObservedConfigNested<N>> implements NetworkSpecFluent.UpstreamResolversObservedConfigNested<N>,Nested<N>{
    UpstreamResolversObservedConfigNestedImpl(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversObservedConfigNestedImpl() {
      this.builder = new UpstreamResolversBuilder(this);
    }
    UpstreamResolversBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endUpstreamResolversObservedConfig() {
      return and();
    }
    
  }
  class DNSStatusObservedConfigNestedImpl<N> extends DNSStatusFluentImpl<NetworkSpecFluent.DNSStatusObservedConfigNested<N>> implements NetworkSpecFluent.DNSStatusObservedConfigNested<N>,Nested<N>{
    DNSStatusObservedConfigNestedImpl(DNSStatus item) {
      this.builder = new DNSStatusBuilder(this, item);
    }
    DNSStatusObservedConfigNestedImpl() {
      this.builder = new DNSStatusBuilder(this);
    }
    DNSStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSStatusObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNestedImpl<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNested<N>,Nested<N>{
    IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNestedImpl(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyObservedConfigNestedImpl() {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerHTTPUniqueIdHeaderPolicyObservedConfig() {
      return and();
    }
    
  }
  class GCPLoadBalancerParametersObservedConfigNestedImpl<N> extends GCPLoadBalancerParametersFluentImpl<NetworkSpecFluent.GCPLoadBalancerParametersObservedConfigNested<N>> implements NetworkSpecFluent.GCPLoadBalancerParametersObservedConfigNested<N>,Nested<N>{
    GCPLoadBalancerParametersObservedConfigNestedImpl(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersObservedConfigNestedImpl() {
      this.builder = new GCPLoadBalancerParametersBuilder(this);
    }
    GCPLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endGCPLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  }
  class ConfigStatusObservedConfigNestedImpl<N> extends ConfigStatusFluentImpl<NetworkSpecFluent.ConfigStatusObservedConfigNested<N>> implements NetworkSpecFluent.ConfigStatusObservedConfigNested<N>,Nested<N>{
    ConfigStatusObservedConfigNestedImpl(ConfigStatus item) {
      this.builder = new ConfigStatusBuilder(this, item);
    }
    ConfigStatusObservedConfigNestedImpl() {
      this.builder = new ConfigStatusBuilder(this);
    }
    ConfigStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigStatusObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerListObservedConfigNestedImpl<N> extends KubeAPIServerListFluentImpl<NetworkSpecFluent.KubeAPIServerListObservedConfigNested<N>> implements NetworkSpecFluent.KubeAPIServerListObservedConfigNested<N>,Nested<N>{
    KubeAPIServerListObservedConfigNestedImpl(KubeAPIServerList item) {
      this.builder = new KubeAPIServerListBuilder(this, item);
    }
    KubeAPIServerListObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerListBuilder(this);
    }
    KubeAPIServerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerListObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAObservedConfigNestedImpl<N> extends ServiceCAFluentImpl<NetworkSpecFluent.ServiceCAObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCAObservedConfigNested<N>,Nested<N>{
    ServiceCAObservedConfigNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAObservedConfigNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerSpecObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerSpecFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerSpecObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerSpecObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerSpecObservedConfigNestedImpl(ServiceCatalogControllerManagerSpec item) {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this, item);
    }
    ServiceCatalogControllerManagerSpecObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this);
    }
    ServiceCatalogControllerManagerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerSpecObservedConfig() {
      return and();
    }
    
  }
  class ConfigObservedConfigNestedImpl<N> extends ConfigFluentImpl<NetworkSpecFluent.ConfigObservedConfigNested<N>> implements NetworkSpecFluent.ConfigObservedConfigNested<N>,Nested<N>{
    ConfigObservedConfigNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigObservedConfigNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerListObservedConfigNestedImpl<N> extends IngressControllerListFluentImpl<NetworkSpecFluent.IngressControllerListObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerListObservedConfigNested<N>,Nested<N>{
    IngressControllerListObservedConfigNestedImpl(IngressControllerList item) {
      this.builder = new IngressControllerListBuilder(this, item);
    }
    IngressControllerListObservedConfigNestedImpl() {
      this.builder = new IngressControllerListBuilder(this);
    }
    IngressControllerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerListObservedConfig() {
      return and();
    }
    
  }
  class DNSListObservedConfigNestedImpl<N> extends DNSListFluentImpl<NetworkSpecFluent.DNSListObservedConfigNested<N>> implements NetworkSpecFluent.DNSListObservedConfigNested<N>,Nested<N>{
    DNSListObservedConfigNestedImpl(DNSList item) {
      this.builder = new DNSListBuilder(this, item);
    }
    DNSListObservedConfigNestedImpl() {
      this.builder = new DNSListBuilder(this);
    }
    DNSListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSListObservedConfig() {
      return and();
    }
    
  }
  class ObjectMetaObservedConfigNestedImpl<N> extends ObjectMetaFluentImpl<NetworkSpecFluent.ObjectMetaObservedConfigNested<N>> implements NetworkSpecFluent.ObjectMetaObservedConfigNested<N>,Nested<N>{
    ObjectMetaObservedConfigNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaObservedConfigNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endObjectMetaObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverListObservedConfigNestedImpl<N> extends ClusterCSIDriverListFluentImpl<NetworkSpecFluent.ClusterCSIDriverListObservedConfigNested<N>> implements NetworkSpecFluent.ClusterCSIDriverListObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverListObservedConfigNestedImpl(ClusterCSIDriverList item) {
      this.builder = new ClusterCSIDriverListBuilder(this, item);
    }
    ClusterCSIDriverListObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverListBuilder(this);
    }
    ClusterCSIDriverListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverListObservedConfig() {
      return and();
    }
    
  }
  class SimpleMacvlanConfigObservedNestedImpl<N> extends SimpleMacvlanConfigFluentImpl<NetworkSpecFluent.SimpleMacvlanConfigObservedNested<N>> implements NetworkSpecFluent.SimpleMacvlanConfigObservedNested<N>,Nested<N>{
    SimpleMacvlanConfigObservedNestedImpl(SimpleMacvlanConfig item) {
      this.builder = new SimpleMacvlanConfigBuilder(this, item);
    }
    SimpleMacvlanConfigObservedNestedImpl() {
      this.builder = new SimpleMacvlanConfigBuilder(this);
    }
    SimpleMacvlanConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endSimpleMacvlanConfigObserved() {
      return and();
    }
    
  }
  class PersistentVolumeClaimObservedConfigNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements NetworkSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,Nested<N>{
    PersistentVolumeClaimObservedConfigNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimObservedConfigNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPersistentVolumeClaimObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerStatusObservedConfigNestedImpl<N> extends KubeAPIServerStatusFluentImpl<NetworkSpecFluent.KubeAPIServerStatusObservedConfigNested<N>> implements NetworkSpecFluent.KubeAPIServerStatusObservedConfigNested<N>,Nested<N>{
    KubeAPIServerStatusObservedConfigNestedImpl(KubeAPIServerStatus item) {
      this.builder = new KubeAPIServerStatusBuilder(this, item);
    }
    KubeAPIServerStatusObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerStatusBuilder(this);
    }
    KubeAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerStatusObservedConfig() {
      return and();
    }
    
  }
  class AWSClassicLoadBalancerParametersObservedConfigNestedImpl<N> extends AWSClassicLoadBalancerParametersFluentImpl<NetworkSpecFluent.AWSClassicLoadBalancerParametersObservedConfigNested<N>> implements NetworkSpecFluent.AWSClassicLoadBalancerParametersObservedConfigNested<N>,Nested<N>{
    AWSClassicLoadBalancerParametersObservedConfigNestedImpl(AWSClassicLoadBalancerParameters item) {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
    }
    AWSClassicLoadBalancerParametersObservedConfigNestedImpl() {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this);
    }
    AWSClassicLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAWSClassicLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerObservedConfigNestedImpl<N> extends KubeAPIServerFluentImpl<NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>> implements NetworkSpecFluent.KubeAPIServerObservedConfigNested<N>,Nested<N>{
    KubeAPIServerObservedConfigNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerObservedConfigNestedImpl<N> extends IngressControllerFluentImpl<NetworkSpecFluent.IngressControllerObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerObservedConfigNested<N>,Nested<N>{
    IngressControllerObservedConfigNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerObservedConfigNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerObservedConfig() {
      return and();
    }
    
  }
  class ConsoleConfigRouteObservedNestedImpl<N> extends ConsoleConfigRouteFluentImpl<NetworkSpecFluent.ConsoleConfigRouteObservedNested<N>> implements NetworkSpecFluent.ConsoleConfigRouteObservedNested<N>,Nested<N>{
    ConsoleConfigRouteObservedNestedImpl(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteObservedNestedImpl() {
      this.builder = new ConsoleConfigRouteBuilder(this);
    }
    ConsoleConfigRouteBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleConfigRouteObserved() {
      return and();
    }
    
  }
  class CloudCredentialStatusObservedConfigNestedImpl<N> extends CloudCredentialStatusFluentImpl<NetworkSpecFluent.CloudCredentialStatusObservedConfigNested<N>> implements NetworkSpecFluent.CloudCredentialStatusObservedConfigNested<N>,Nested<N>{
    CloudCredentialStatusObservedConfigNestedImpl(CloudCredentialStatus item) {
      this.builder = new CloudCredentialStatusBuilder(this, item);
    }
    CloudCredentialStatusObservedConfigNestedImpl() {
      this.builder = new CloudCredentialStatusBuilder(this);
    }
    CloudCredentialStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialStatusObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorObservedConfigNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorObservedConfig() {
      return and();
    }
    
  }
  class GenericKubernetesResourceObservedConfigNestedImpl<N> extends GenericKubernetesResourceFluentImpl<NetworkSpecFluent.GenericKubernetesResourceObservedConfigNested<N>> implements NetworkSpecFluent.GenericKubernetesResourceObservedConfigNested<N>,Nested<N>{
    GenericKubernetesResourceObservedConfigNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceObservedConfigNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endGenericKubernetesResourceObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerStatusObservedConfigNestedImpl<N> extends IngressControllerStatusFluentImpl<NetworkSpecFluent.IngressControllerStatusObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerStatusObservedConfigNested<N>,Nested<N>{
    IngressControllerStatusObservedConfigNestedImpl(IngressControllerStatus item) {
      this.builder = new IngressControllerStatusBuilder(this, item);
    }
    IngressControllerStatusObservedConfigNestedImpl() {
      this.builder = new IngressControllerStatusBuilder(this);
    }
    IngressControllerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerStatusObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerStatusObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerStatusFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerStatusObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerStatusObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerStatusObservedConfigNestedImpl(ServiceCatalogControllerManagerStatus item) {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this, item);
    }
    ServiceCatalogControllerManagerStatusObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this);
    }
    ServiceCatalogControllerManagerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerStatusObservedConfig() {
      return and();
    }
    
  }
  class HybridOverlayConfigObservedNestedImpl<N> extends HybridOverlayConfigFluentImpl<NetworkSpecFluent.HybridOverlayConfigObservedNested<N>> implements NetworkSpecFluent.HybridOverlayConfigObservedNested<N>,Nested<N>{
    HybridOverlayConfigObservedNestedImpl(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigObservedNestedImpl() {
      this.builder = new HybridOverlayConfigBuilder(this);
    }
    HybridOverlayConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endHybridOverlayConfigObserved() {
      return and();
    }
    
  }
  class AWSLoadBalancerParametersObservedConfigNestedImpl<N> extends AWSLoadBalancerParametersFluentImpl<NetworkSpecFluent.AWSLoadBalancerParametersObservedConfigNested<N>> implements NetworkSpecFluent.AWSLoadBalancerParametersObservedConfigNested<N>,Nested<N>{
    AWSLoadBalancerParametersObservedConfigNestedImpl(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersObservedConfigNestedImpl() {
      this.builder = new AWSLoadBalancerParametersBuilder(this);
    }
    AWSLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAWSLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerListObservedConfigNestedImpl<N> extends ImagePrunerListFluentImpl<NetworkSpecFluent.ImagePrunerListObservedConfigNested<N>> implements NetworkSpecFluent.ImagePrunerListObservedConfigNested<N>,Nested<N>{
    ImagePrunerListObservedConfigNestedImpl(ImagePrunerList item) {
      this.builder = new ImagePrunerListBuilder(this, item);
    }
    ImagePrunerListObservedConfigNestedImpl() {
      this.builder = new ImagePrunerListBuilder(this);
    }
    ImagePrunerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerListObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerListObservedConfigNestedImpl<N> extends CSISnapshotControllerListFluentImpl<NetworkSpecFluent.CSISnapshotControllerListObservedConfigNested<N>> implements NetworkSpecFluent.CSISnapshotControllerListObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerListObservedConfigNestedImpl(CSISnapshotControllerList item) {
      this.builder = new CSISnapshotControllerListBuilder(this, item);
    }
    CSISnapshotControllerListObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerListBuilder(this);
    }
    CSISnapshotControllerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerListObservedConfig() {
      return and();
    }
    
  }
  class LocalObjectReferenceObservedConfigNestedImpl<N> extends LocalObjectReferenceFluentImpl<NetworkSpecFluent.LocalObjectReferenceObservedConfigNested<N>> implements NetworkSpecFluent.LocalObjectReferenceObservedConfigNested<N>,Nested<N>{
    LocalObjectReferenceObservedConfigNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceObservedConfigNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endLocalObjectReferenceObservedConfig() {
      return and();
    }
    
  }
  class ConsoleObservedConfigNestedImpl<N> extends ConsoleFluentImpl<NetworkSpecFluent.ConsoleObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleObservedConfigNested<N>,Nested<N>{
    ConsoleObservedConfigNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleObservedConfigNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleObservedConfig() {
      return and();
    }
    
  }
  class StaticIPAMRoutesObservedConfigNestedImpl<N> extends StaticIPAMRoutesFluentImpl<NetworkSpecFluent.StaticIPAMRoutesObservedConfigNested<N>> implements NetworkSpecFluent.StaticIPAMRoutesObservedConfigNested<N>,Nested<N>{
    StaticIPAMRoutesObservedConfigNestedImpl(StaticIPAMRoutes item) {
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    StaticIPAMRoutesObservedConfigNestedImpl() {
      this.builder = new StaticIPAMRoutesBuilder(this);
    }
    StaticIPAMRoutesBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStaticIPAMRoutesObservedConfig() {
      return and();
    }
    
  }
  class DNSZoneConditionObservedConfigNestedImpl<N> extends DNSZoneConditionFluentImpl<NetworkSpecFluent.DNSZoneConditionObservedConfigNested<N>> implements NetworkSpecFluent.DNSZoneConditionObservedConfigNested<N>,Nested<N>{
    DNSZoneConditionObservedConfigNestedImpl(DNSZoneCondition item) {
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    DNSZoneConditionObservedConfigNestedImpl() {
      this.builder = new DNSZoneConditionBuilder(this);
    }
    DNSZoneConditionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSZoneConditionObservedConfig() {
      return and();
    }
    
  }
  class ContainerLoggingDestinationParametersObservedConfigNestedImpl<N> extends ContainerLoggingDestinationParametersFluentImpl<NetworkSpecFluent.ContainerLoggingDestinationParametersObservedConfigNested<N>> implements NetworkSpecFluent.ContainerLoggingDestinationParametersObservedConfigNested<N>,Nested<N>{
    ContainerLoggingDestinationParametersObservedConfigNestedImpl(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersObservedConfigNestedImpl() {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endContainerLoggingDestinationParametersObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerListObservedConfigNestedImpl<N> extends KubeSchedulerListFluentImpl<NetworkSpecFluent.KubeSchedulerListObservedConfigNested<N>> implements NetworkSpecFluent.KubeSchedulerListObservedConfigNested<N>,Nested<N>{
    KubeSchedulerListObservedConfigNestedImpl(KubeSchedulerList item) {
      this.builder = new KubeSchedulerListBuilder(this, item);
    }
    KubeSchedulerListObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerListBuilder(this);
    }
    KubeSchedulerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerListObservedConfig() {
      return and();
    }
    
  }
  class KubeAPIServerSpecObservedConfigNestedImpl<N> extends KubeAPIServerSpecFluentImpl<NetworkSpecFluent.KubeAPIServerSpecObservedConfigNested<N>> implements NetworkSpecFluent.KubeAPIServerSpecObservedConfigNested<N>,Nested<N>{
    KubeAPIServerSpecObservedConfigNestedImpl(KubeAPIServerSpec item) {
      this.builder = new KubeAPIServerSpecBuilder(this, item);
    }
    KubeAPIServerSpecObservedConfigNestedImpl() {
      this.builder = new KubeAPIServerSpecBuilder(this);
    }
    KubeAPIServerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeAPIServerSpecObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverObservedConfigNestedImpl<N> extends ClusterCSIDriverFluentImpl<NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>> implements NetworkSpecFluent.ClusterCSIDriverObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverObservedConfigNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverObservedConfig() {
      return and();
    }
    
  }
  class QuickStartsObservedConfigNestedImpl<N> extends QuickStartsFluentImpl<NetworkSpecFluent.QuickStartsObservedConfigNested<N>> implements NetworkSpecFluent.QuickStartsObservedConfigNested<N>,Nested<N>{
    QuickStartsObservedConfigNestedImpl(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsObservedConfigNestedImpl() {
      this.builder = new QuickStartsBuilder(this);
    }
    QuickStartsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endQuickStartsObservedConfig() {
      return and();
    }
    
  }
  class DNSZoneStatusObservedConfigNestedImpl<N> extends DNSZoneStatusFluentImpl<NetworkSpecFluent.DNSZoneStatusObservedConfigNested<N>> implements NetworkSpecFluent.DNSZoneStatusObservedConfigNested<N>,Nested<N>{
    DNSZoneStatusObservedConfigNestedImpl(DNSZoneStatus item) {
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    DNSZoneStatusObservedConfigNestedImpl() {
      this.builder = new DNSZoneStatusBuilder(this);
    }
    DNSZoneStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSZoneStatusObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerObservedConfigNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class ConfigSpecObservedConfigNestedImpl<N> extends ConfigSpecFluentImpl<NetworkSpecFluent.ConfigSpecObservedConfigNested<N>> implements NetworkSpecFluent.ConfigSpecObservedConfigNested<N>,Nested<N>{
    ConfigSpecObservedConfigNestedImpl(ConfigSpec item) {
      this.builder = new ConfigSpecBuilder(this, item);
    }
    ConfigSpecObservedConfigNestedImpl() {
      this.builder = new ConfigSpecBuilder(this);
    }
    ConfigSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigSpecObservedConfig() {
      return and();
    }
    
  }
  class OutageEntryObservedConfigNestedImpl<N> extends OutageEntryFluentImpl<NetworkSpecFluent.OutageEntryObservedConfigNested<N>> implements NetworkSpecFluent.OutageEntryObservedConfigNested<N>,Nested<N>{
    OutageEntryObservedConfigNestedImpl(OutageEntry item) {
      this.builder = new OutageEntryBuilder(this, item);
    }
    OutageEntryObservedConfigNestedImpl() {
      this.builder = new OutageEntryBuilder(this);
    }
    OutageEntryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOutageEntryObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerListObservedConfigNestedImpl<N> extends OpenShiftControllerManagerListFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerListObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerListObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerListObservedConfigNestedImpl(OpenShiftControllerManagerList item) {
      this.builder = new OpenShiftControllerManagerListBuilder(this, item);
    }
    OpenShiftControllerManagerListObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerListBuilder(this);
    }
    OpenShiftControllerManagerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerListObservedConfig() {
      return and();
    }
    
  }
  class EtcdObservedConfigNestedImpl<N> extends EtcdFluentImpl<NetworkSpecFluent.EtcdObservedConfigNested<N>> implements NetworkSpecFluent.EtcdObservedConfigNested<N>,Nested<N>{
    EtcdObservedConfigNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdObservedConfigNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdObservedConfig() {
      return and();
    }
    
  }
  class EndpointPublishingStrategyObservedConfigNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<NetworkSpecFluent.EndpointPublishingStrategyObservedConfigNested<N>> implements NetworkSpecFluent.EndpointPublishingStrategyObservedConfigNested<N>,Nested<N>{
    EndpointPublishingStrategyObservedConfigNestedImpl(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyObservedConfigNestedImpl() {
      this.builder = new EndpointPublishingStrategyBuilder(this);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEndpointPublishingStrategyObservedConfig() {
      return and();
    }
    
  }
  class IPFIXConfigObservedNestedImpl<N> extends IPFIXConfigFluentImpl<NetworkSpecFluent.IPFIXConfigObservedNested<N>> implements NetworkSpecFluent.IPFIXConfigObservedNested<N>,Nested<N>{
    IPFIXConfigObservedNestedImpl(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigObservedNestedImpl() {
      this.builder = new IPFIXConfigBuilder(this);
    }
    IPFIXConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIPFIXConfigObserved() {
      return and();
    }
    
  }
  class CloudCredentialObservedConfigNestedImpl<N> extends CloudCredentialFluentImpl<NetworkSpecFluent.CloudCredentialObservedConfigNested<N>> implements NetworkSpecFluent.CloudCredentialObservedConfigNested<N>,Nested<N>{
    CloudCredentialObservedConfigNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialObservedConfigNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerObservedConfigNestedImpl<N> extends KubeSchedulerFluentImpl<NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>> implements NetworkSpecFluent.KubeSchedulerObservedConfigNested<N>,Nested<N>{
    KubeSchedulerObservedConfigNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerObservedConfig() {
      return and();
    }
    
  }
  class ClusterCSIDriverStatusObservedConfigNestedImpl<N> extends ClusterCSIDriverStatusFluentImpl<NetworkSpecFluent.ClusterCSIDriverStatusObservedConfigNested<N>> implements NetworkSpecFluent.ClusterCSIDriverStatusObservedConfigNested<N>,Nested<N>{
    ClusterCSIDriverStatusObservedConfigNestedImpl(ClusterCSIDriverStatus item) {
      this.builder = new ClusterCSIDriverStatusBuilder(this, item);
    }
    ClusterCSIDriverStatusObservedConfigNestedImpl() {
      this.builder = new ClusterCSIDriverStatusBuilder(this);
    }
    ClusterCSIDriverStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterCSIDriverStatusObservedConfig() {
      return and();
    }
    
  }
  class NetworkStatusObservedConfigNestedImpl<N> extends NetworkStatusFluentImpl<NetworkSpecFluent.NetworkStatusObservedConfigNested<N>> implements NetworkSpecFluent.NetworkStatusObservedConfigNested<N>,Nested<N>{
    NetworkStatusObservedConfigNestedImpl(NetworkStatus item) {
      this.builder = new NetworkStatusBuilder(this, item);
    }
    NetworkStatusObservedConfigNestedImpl() {
      this.builder = new NetworkStatusBuilder(this);
    }
    NetworkStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkStatusObservedConfig() {
      return and();
    }
    
  }
  class SFlowConfigObservedNestedImpl<N> extends SFlowConfigFluentImpl<NetworkSpecFluent.SFlowConfigObservedNested<N>> implements NetworkSpecFluent.SFlowConfigObservedNested<N>,Nested<N>{
    SFlowConfigObservedNestedImpl(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigObservedNestedImpl() {
      this.builder = new SFlowConfigBuilder(this);
    }
    SFlowConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endSFlowConfigObserved() {
      return and();
    }
    
  }
  class ForwardPluginObservedConfigNestedImpl<N> extends ForwardPluginFluentImpl<NetworkSpecFluent.ForwardPluginObservedConfigNested<N>> implements NetworkSpecFluent.ForwardPluginObservedConfigNested<N>,Nested<N>{
    ForwardPluginObservedConfigNestedImpl(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginObservedConfigNestedImpl() {
      this.builder = new ForwardPluginBuilder(this);
    }
    ForwardPluginBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endForwardPluginObservedConfig() {
      return and();
    }
    
  }
  class LogEntryObservedConfigNestedImpl<N> extends LogEntryFluentImpl<NetworkSpecFluent.LogEntryObservedConfigNested<N>> implements NetworkSpecFluent.LogEntryObservedConfigNested<N>,Nested<N>{
    LogEntryObservedConfigNestedImpl(LogEntry item) {
      this.builder = new LogEntryBuilder(this, item);
    }
    LogEntryObservedConfigNestedImpl() {
      this.builder = new LogEntryBuilder(this);
    }
    LogEntryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endLogEntryObservedConfig() {
      return and();
    }
    
  }
  class NodeStatusObservedConfigNestedImpl<N> extends NodeStatusFluentImpl<NetworkSpecFluent.NodeStatusObservedConfigNested<N>> implements NetworkSpecFluent.NodeStatusObservedConfigNested<N>,Nested<N>{
    NodeStatusObservedConfigNestedImpl(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusObservedConfigNestedImpl() {
      this.builder = new NodeStatusBuilder(this);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNodeStatusObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckConditionObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckConditionFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckConditionObservedConfigNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckConditionObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckConditionObservedConfigNestedImpl(PodNetworkConnectivityCheckCondition item) {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this, item);
    }
    PodNetworkConnectivityCheckConditionObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this);
    }
    PodNetworkConnectivityCheckConditionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckConditionObservedConfig() {
      return and();
    }
    
  }
  class AdditionalNetworkDefinitionObservedConfigNestedImpl<N> extends AdditionalNetworkDefinitionFluentImpl<NetworkSpecFluent.AdditionalNetworkDefinitionObservedConfigNested<N>> implements NetworkSpecFluent.AdditionalNetworkDefinitionObservedConfigNested<N>,Nested<N>{
    AdditionalNetworkDefinitionObservedConfigNestedImpl(AdditionalNetworkDefinition item) {
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionObservedConfigNestedImpl() {
      this.builder = new AdditionalNetworkDefinitionBuilder(this);
    }
    AdditionalNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAdditionalNetworkDefinitionObservedConfig() {
      return and();
    }
    
  }
  class RouteAdmissionPolicyObservedConfigNestedImpl<N> extends RouteAdmissionPolicyFluentImpl<NetworkSpecFluent.RouteAdmissionPolicyObservedConfigNested<N>> implements NetworkSpecFluent.RouteAdmissionPolicyObservedConfigNested<N>,Nested<N>{
    RouteAdmissionPolicyObservedConfigNestedImpl(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyObservedConfigNestedImpl() {
      this.builder = new RouteAdmissionPolicyBuilder(this);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endRouteAdmissionPolicyObservedConfig() {
      return and();
    }
    
  }
  class GenerationStatusObservedConfigNestedImpl<N> extends GenerationStatusFluentImpl<NetworkSpecFluent.GenerationStatusObservedConfigNested<N>> implements NetworkSpecFluent.GenerationStatusObservedConfigNested<N>,Nested<N>{
    GenerationStatusObservedConfigNestedImpl(GenerationStatus item) {
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusObservedConfigNestedImpl() {
      this.builder = new GenerationStatusBuilder(this);
    }
    GenerationStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endGenerationStatusObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationStatusObservedConfigNestedImpl<N> extends AuthenticationStatusFluentImpl<NetworkSpecFluent.AuthenticationStatusObservedConfigNested<N>> implements NetworkSpecFluent.AuthenticationStatusObservedConfigNested<N>,Nested<N>{
    AuthenticationStatusObservedConfigNestedImpl(AuthenticationStatus item) {
      this.builder = new AuthenticationStatusBuilder(this, item);
    }
    AuthenticationStatusObservedConfigNestedImpl() {
      this.builder = new AuthenticationStatusBuilder(this);
    }
    AuthenticationStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationStatusObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPHeadersObservedConfigNestedImpl<N> extends IngressControllerCaptureHTTPHeadersFluentImpl<NetworkSpecFluent.IngressControllerCaptureHTTPHeadersObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerCaptureHTTPHeadersObservedConfigNested<N>,Nested<N>{
    IngressControllerCaptureHTTPHeadersObservedConfigNestedImpl(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeadersObservedConfigNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeadersObservedConfig() {
      return and();
    }
    
  }
  class EtcdListObservedConfigNestedImpl<N> extends EtcdListFluentImpl<NetworkSpecFluent.EtcdListObservedConfigNested<N>> implements NetworkSpecFluent.EtcdListObservedConfigNested<N>,Nested<N>{
    EtcdListObservedConfigNestedImpl(EtcdList item) {
      this.builder = new EtcdListBuilder(this, item);
    }
    EtcdListObservedConfigNestedImpl() {
      this.builder = new EtcdListBuilder(this);
    }
    EtcdListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdListObservedConfig() {
      return and();
    }
    
  }
  class NodePortStrategyObservedConfigNestedImpl<N> extends NodePortStrategyFluentImpl<NetworkSpecFluent.NodePortStrategyObservedConfigNested<N>> implements NetworkSpecFluent.NodePortStrategyObservedConfigNested<N>,Nested<N>{
    NodePortStrategyObservedConfigNestedImpl(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyObservedConfigNestedImpl() {
      this.builder = new NodePortStrategyBuilder(this);
    }
    NodePortStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNodePortStrategyObservedConfig() {
      return and();
    }
    
  }
  class DefaultNetworkDefinitionObservedConfigNestedImpl<N> extends DefaultNetworkDefinitionFluentImpl<NetworkSpecFluent.DefaultNetworkDefinitionObservedConfigNested<N>> implements NetworkSpecFluent.DefaultNetworkDefinitionObservedConfigNested<N>,Nested<N>{
    DefaultNetworkDefinitionObservedConfigNestedImpl(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionObservedConfigNestedImpl() {
      this.builder = new DefaultNetworkDefinitionBuilder(this);
    }
    DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDefaultNetworkDefinitionObservedConfig() {
      return and();
    }
    
  }
  class NetworkObservedConfigNestedImpl<N> extends NetworkFluentImpl<NetworkSpecFluent.NetworkObservedConfigNested<N>> implements NetworkSpecFluent.NetworkObservedConfigNested<N>,Nested<N>{
    NetworkObservedConfigNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkObservedConfigNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkObservedConfig() {
      return and();
    }
    
  }
  class ClientTLSObservedConfigNestedImpl<N> extends ClientTLSFluentImpl<NetworkSpecFluent.ClientTLSObservedConfigNested<N>> implements NetworkSpecFluent.ClientTLSObservedConfigNested<N>,Nested<N>{
    ClientTLSObservedConfigNestedImpl(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSObservedConfigNestedImpl() {
      this.builder = new ClientTLSBuilder(this);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClientTLSObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerSpecObservedConfigNestedImpl<N> extends OpenShiftAPIServerSpecFluentImpl<NetworkSpecFluent.OpenShiftAPIServerSpecObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerSpecObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerSpecObservedConfigNestedImpl(OpenShiftAPIServerSpec item) {
      this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
    }
    OpenShiftAPIServerSpecObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerSpecBuilder(this);
    }
    OpenShiftAPIServerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerSpecObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerStatusObservedConfigNestedImpl<N> extends ImagePrunerStatusFluentImpl<NetworkSpecFluent.ImagePrunerStatusObservedConfigNested<N>> implements NetworkSpecFluent.ImagePrunerStatusObservedConfigNested<N>,Nested<N>{
    ImagePrunerStatusObservedConfigNestedImpl(ImagePrunerStatus item) {
      this.builder = new ImagePrunerStatusBuilder(this, item);
    }
    ImagePrunerStatusObservedConfigNestedImpl() {
      this.builder = new ImagePrunerStatusBuilder(this);
    }
    ImagePrunerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerStatusObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerStatusObservedConfigNestedImpl<N> extends KubeSchedulerStatusFluentImpl<NetworkSpecFluent.KubeSchedulerStatusObservedConfigNested<N>> implements NetworkSpecFluent.KubeSchedulerStatusObservedConfigNested<N>,Nested<N>{
    KubeSchedulerStatusObservedConfigNestedImpl(KubeSchedulerStatus item) {
      this.builder = new KubeSchedulerStatusBuilder(this, item);
    }
    KubeSchedulerStatusObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerStatusBuilder(this);
    }
    KubeSchedulerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerStatusObservedConfig() {
      return and();
    }
    
  }
  class SyslogLoggingDestinationParametersObservedConfigNestedImpl<N> extends SyslogLoggingDestinationParametersFluentImpl<NetworkSpecFluent.SyslogLoggingDestinationParametersObservedConfigNested<N>> implements NetworkSpecFluent.SyslogLoggingDestinationParametersObservedConfigNested<N>,Nested<N>{
    SyslogLoggingDestinationParametersObservedConfigNestedImpl(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersObservedConfigNestedImpl() {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endSyslogLoggingDestinationParametersObservedConfig() {
      return and();
    }
    
  }
  class UpstreamObservedConfigNestedImpl<N> extends UpstreamFluentImpl<NetworkSpecFluent.UpstreamObservedConfigNested<N>> implements NetworkSpecFluent.UpstreamObservedConfigNested<N>,Nested<N>{
    UpstreamObservedConfigNestedImpl(Upstream item) {
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamObservedConfigNestedImpl() {
      this.builder = new UpstreamBuilder(this);
    }
    UpstreamBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endUpstreamObservedConfig() {
      return and();
    }
    
  }
  class AWSNetworkLoadBalancerParametersObservedConfigNestedImpl<N> extends AWSNetworkLoadBalancerParametersFluentImpl<NetworkSpecFluent.AWSNetworkLoadBalancerParametersObservedConfigNested<N>> implements NetworkSpecFluent.AWSNetworkLoadBalancerParametersObservedConfigNested<N>,Nested<N>{
    AWSNetworkLoadBalancerParametersObservedConfigNestedImpl(AWSNetworkLoadBalancerParameters item) {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
    }
    AWSNetworkLoadBalancerParametersObservedConfigNestedImpl() {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this);
    }
    AWSNetworkLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAWSNetworkLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAListObservedConfigNestedImpl<N> extends ServiceCAListFluentImpl<NetworkSpecFluent.ServiceCAListObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCAListObservedConfigNested<N>,Nested<N>{
    ServiceCAListObservedConfigNestedImpl(ServiceCAList item) {
      this.builder = new ServiceCAListBuilder(this, item);
    }
    ServiceCAListObservedConfigNestedImpl() {
      this.builder = new ServiceCAListBuilder(this);
    }
    ServiceCAListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAListObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerObservedConfigNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPHeaderObservedConfigNestedImpl<N> extends IngressControllerCaptureHTTPHeaderFluentImpl<NetworkSpecFluent.IngressControllerCaptureHTTPHeaderObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerCaptureHTTPHeaderObservedConfigNested<N>,Nested<N>{
    IngressControllerCaptureHTTPHeaderObservedConfigNestedImpl(IngressControllerCaptureHTTPHeader item) {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderObservedConfigNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeaderObservedConfig() {
      return and();
    }
    
  }
  class NetworkMigrationObservedConfigNestedImpl<N> extends NetworkMigrationFluentImpl<NetworkSpecFluent.NetworkMigrationObservedConfigNested<N>> implements NetworkSpecFluent.NetworkMigrationObservedConfigNested<N>,Nested<N>{
    NetworkMigrationObservedConfigNestedImpl(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationObservedConfigNestedImpl() {
      this.builder = new NetworkMigrationBuilder(this);
    }
    NetworkMigrationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkMigrationObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordListObservedConfigNestedImpl<N> extends DNSRecordListFluentImpl<NetworkSpecFluent.DNSRecordListObservedConfigNested<N>> implements NetworkSpecFluent.DNSRecordListObservedConfigNested<N>,Nested<N>{
    DNSRecordListObservedConfigNestedImpl(DNSRecordList item) {
      this.builder = new DNSRecordListBuilder(this, item);
    }
    DNSRecordListObservedConfigNestedImpl() {
      this.builder = new DNSRecordListBuilder(this);
    }
    DNSRecordListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordListObservedConfig() {
      return and();
    }
    
  }
  class RawExtensionObservedConfigNestedImpl<N> extends RawExtensionFluentImpl<NetworkSpecFluent.RawExtensionObservedConfigNested<N>> implements NetworkSpecFluent.RawExtensionObservedConfigNested<N>,Nested<N>{
    RawExtensionObservedConfigNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionObservedConfigNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endRawExtensionObservedConfig() {
      return and();
    }
    
  }
  class EtcdSpecObservedConfigNestedImpl<N> extends EtcdSpecFluentImpl<NetworkSpecFluent.EtcdSpecObservedConfigNested<N>> implements NetworkSpecFluent.EtcdSpecObservedConfigNested<N>,Nested<N>{
    EtcdSpecObservedConfigNestedImpl(EtcdSpec item) {
      this.builder = new EtcdSpecBuilder(this, item);
    }
    EtcdSpecObservedConfigNestedImpl() {
      this.builder = new EtcdSpecBuilder(this);
    }
    EtcdSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdSpecObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckObservedConfigNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerStatusObservedConfigNestedImpl<N> extends OpenShiftAPIServerStatusFluentImpl<NetworkSpecFluent.OpenShiftAPIServerStatusObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerStatusObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerStatusObservedConfigNestedImpl(OpenShiftAPIServerStatus item) {
      this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
    }
    OpenShiftAPIServerStatusObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerStatusBuilder(this);
    }
    OpenShiftAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerStatusObservedConfig() {
      return and();
    }
    
  }
  class LoadBalancerStrategyObservedConfigNestedImpl<N> extends LoadBalancerStrategyFluentImpl<NetworkSpecFluent.LoadBalancerStrategyObservedConfigNested<N>> implements NetworkSpecFluent.LoadBalancerStrategyObservedConfigNested<N>,Nested<N>{
    LoadBalancerStrategyObservedConfigNestedImpl(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyObservedConfigNestedImpl() {
      this.builder = new LoadBalancerStrategyBuilder(this);
    }
    LoadBalancerStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endLoadBalancerStrategyObservedConfig() {
      return and();
    }
    
  }
  class EtcdStatusObservedConfigNestedImpl<N> extends EtcdStatusFluentImpl<NetworkSpecFluent.EtcdStatusObservedConfigNested<N>> implements NetworkSpecFluent.EtcdStatusObservedConfigNested<N>,Nested<N>{
    EtcdStatusObservedConfigNestedImpl(EtcdStatus item) {
      this.builder = new EtcdStatusBuilder(this, item);
    }
    EtcdStatusObservedConfigNestedImpl() {
      this.builder = new EtcdStatusBuilder(this);
    }
    EtcdStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endEtcdStatusObservedConfig() {
      return and();
    }
    
  }
  class CloudCredentialListObservedConfigNestedImpl<N> extends CloudCredentialListFluentImpl<NetworkSpecFluent.CloudCredentialListObservedConfigNested<N>> implements NetworkSpecFluent.CloudCredentialListObservedConfigNested<N>,Nested<N>{
    CloudCredentialListObservedConfigNestedImpl(CloudCredentialList item) {
      this.builder = new CloudCredentialListBuilder(this, item);
    }
    CloudCredentialListObservedConfigNestedImpl() {
      this.builder = new CloudCredentialListBuilder(this);
    }
    CloudCredentialListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialListObservedConfig() {
      return and();
    }
    
  }
  class ImagePrunerSpecObservedConfigNestedImpl<N> extends ImagePrunerSpecFluentImpl<NetworkSpecFluent.ImagePrunerSpecObservedConfigNested<N>> implements NetworkSpecFluent.ImagePrunerSpecObservedConfigNested<N>,Nested<N>{
    ImagePrunerSpecObservedConfigNestedImpl(ImagePrunerSpec item) {
      this.builder = new ImagePrunerSpecBuilder(this, item);
    }
    ImagePrunerSpecObservedConfigNestedImpl() {
      this.builder = new ImagePrunerSpecBuilder(this);
    }
    ImagePrunerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImagePrunerSpecObservedConfig() {
      return and();
    }
    
  }
  class StatuspageProviderObservedConfigNestedImpl<N> extends StatuspageProviderFluentImpl<NetworkSpecFluent.StatuspageProviderObservedConfigNested<N>> implements NetworkSpecFluent.StatuspageProviderObservedConfigNested<N>,Nested<N>{
    StatuspageProviderObservedConfigNestedImpl(StatuspageProvider item) {
      this.builder = new StatuspageProviderBuilder(this, item);
    }
    StatuspageProviderObservedConfigNestedImpl() {
      this.builder = new StatuspageProviderBuilder(this);
    }
    StatuspageProviderBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStatuspageProviderObservedConfig() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorStatusObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorStatusFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorStatusObservedConfigNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorStatusObservedConfigNested<N>,Nested<N>{
    KubeStorageVersionMigratorStatusObservedConfigNestedImpl(KubeStorageVersionMigratorStatus item) {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this, item);
    }
    KubeStorageVersionMigratorStatusObservedConfigNestedImpl() {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this);
    }
    KubeStorageVersionMigratorStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeStorageVersionMigratorStatusObservedConfig() {
      return and();
    }
    
  }
  class ConfigListObservedConfigNestedImpl<N> extends ConfigListFluentImpl<NetworkSpecFluent.ConfigListObservedConfigNested<N>> implements NetworkSpecFluent.ConfigListObservedConfigNested<N>,Nested<N>{
    ConfigListObservedConfigNestedImpl(ConfigList item) {
      this.builder = new ConfigListBuilder(this, item);
    }
    ConfigListObservedConfigNestedImpl() {
      this.builder = new ConfigListBuilder(this);
    }
    ConfigListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConfigListObservedConfig() {
      return and();
    }
    
  }
  class ConsoleProvidersObservedConfigNestedImpl<N> extends ConsoleProvidersFluentImpl<NetworkSpecFluent.ConsoleProvidersObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleProvidersObservedConfigNested<N>,Nested<N>{
    ConsoleProvidersObservedConfigNestedImpl(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersObservedConfigNestedImpl() {
      this.builder = new ConsoleProvidersBuilder(this);
    }
    ConsoleProvidersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleProvidersObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerLoggingObservedConfigNestedImpl<N> extends IngressControllerLoggingFluentImpl<NetworkSpecFluent.IngressControllerLoggingObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerLoggingObservedConfigNested<N>,Nested<N>{
    IngressControllerLoggingObservedConfigNestedImpl(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingObservedConfigNestedImpl() {
      this.builder = new IngressControllerLoggingBuilder(this);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerLoggingObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationListObservedConfigNestedImpl<N> extends AuthenticationListFluentImpl<NetworkSpecFluent.AuthenticationListObservedConfigNested<N>> implements NetworkSpecFluent.AuthenticationListObservedConfigNested<N>,Nested<N>{
    AuthenticationListObservedConfigNestedImpl(AuthenticationList item) {
      this.builder = new AuthenticationListBuilder(this, item);
    }
    AuthenticationListObservedConfigNestedImpl() {
      this.builder = new AuthenticationListBuilder(this);
    }
    AuthenticationListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationListObservedConfig() {
      return and();
    }
    
  }
  class StorageStatusObservedConfigNestedImpl<N> extends StorageStatusFluentImpl<NetworkSpecFluent.StorageStatusObservedConfigNested<N>> implements NetworkSpecFluent.StorageStatusObservedConfigNested<N>,Nested<N>{
    StorageStatusObservedConfigNestedImpl(StorageStatus item) {
      this.builder = new StorageStatusBuilder(this, item);
    }
    StorageStatusObservedConfigNestedImpl() {
      this.builder = new StorageStatusBuilder(this);
    }
    StorageStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageStatusObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerListObservedConfigNestedImpl<N> extends KubeControllerManagerListFluentImpl<NetworkSpecFluent.KubeControllerManagerListObservedConfigNested<N>> implements NetworkSpecFluent.KubeControllerManagerListObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerListObservedConfigNestedImpl(KubeControllerManagerList item) {
      this.builder = new KubeControllerManagerListBuilder(this, item);
    }
    KubeControllerManagerListObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerListBuilder(this);
    }
    KubeControllerManagerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerListObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationSpecObservedConfigNestedImpl<N> extends AuthenticationSpecFluentImpl<NetworkSpecFluent.AuthenticationSpecObservedConfigNested<N>> implements NetworkSpecFluent.AuthenticationSpecObservedConfigNested<N>,Nested<N>{
    AuthenticationSpecObservedConfigNestedImpl(AuthenticationSpec item) {
      this.builder = new AuthenticationSpecBuilder(this, item);
    }
    AuthenticationSpecObservedConfigNestedImpl() {
      this.builder = new AuthenticationSpecBuilder(this);
    }
    AuthenticationSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationSpecObservedConfig() {
      return and();
    }
    
  }
  class IPAMConfigObservedNestedImpl<N> extends IPAMConfigFluentImpl<NetworkSpecFluent.IPAMConfigObservedNested<N>> implements NetworkSpecFluent.IPAMConfigObservedNested<N>,Nested<N>{
    IPAMConfigObservedNestedImpl(IPAMConfig item) {
      this.builder = new IPAMConfigBuilder(this, item);
    }
    IPAMConfigObservedNestedImpl() {
      this.builder = new IPAMConfigBuilder(this);
    }
    IPAMConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIPAMConfigObserved() {
      return and();
    }
    
  }
  class ContainerObservedConfigNestedImpl<N> extends ContainerFluentImpl<NetworkSpecFluent.ContainerObservedConfigNested<N>> implements NetworkSpecFluent.ContainerObservedConfigNested<N>,Nested<N>{
    ContainerObservedConfigNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerObservedConfigNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endContainerObservedConfig() {
      return and();
    }
    
  }
  class CSISnapshotControllerObservedConfigNestedImpl<N> extends CSISnapshotControllerFluentImpl<NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements NetworkSpecFluent.CSISnapshotControllerObservedConfigNested<N>,Nested<N>{
    CSISnapshotControllerObservedConfigNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerObservedConfigNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCSISnapshotControllerObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckSpecObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckSpecFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckSpecObservedConfigNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckSpecObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckSpecObservedConfigNestedImpl(PodNetworkConnectivityCheckSpec item) {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this, item);
    }
    PodNetworkConnectivityCheckSpecObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this);
    }
    PodNetworkConnectivityCheckSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckSpecObservedConfig() {
      return and();
    }
    
  }
  class AccessLoggingObservedConfigNestedImpl<N> extends AccessLoggingFluentImpl<NetworkSpecFluent.AccessLoggingObservedConfigNested<N>> implements NetworkSpecFluent.AccessLoggingObservedConfigNested<N>,Nested<N>{
    AccessLoggingObservedConfigNestedImpl(AccessLogging item) {
      this.builder = new AccessLoggingBuilder(this, item);
    }
    AccessLoggingObservedConfigNestedImpl() {
      this.builder = new AccessLoggingBuilder(this);
    }
    AccessLoggingBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAccessLoggingObservedConfig() {
      return and();
    }
    
  }
  class HostNetworkStrategyObservedConfigNestedImpl<N> extends HostNetworkStrategyFluentImpl<NetworkSpecFluent.HostNetworkStrategyObservedConfigNested<N>> implements NetworkSpecFluent.HostNetworkStrategyObservedConfigNested<N>,Nested<N>{
    HostNetworkStrategyObservedConfigNestedImpl(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyObservedConfigNestedImpl() {
      this.builder = new HostNetworkStrategyBuilder(this);
    }
    HostNetworkStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endHostNetworkStrategyObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordSpecObservedConfigNestedImpl<N> extends DNSRecordSpecFluentImpl<NetworkSpecFluent.DNSRecordSpecObservedConfigNested<N>> implements NetworkSpecFluent.DNSRecordSpecObservedConfigNested<N>,Nested<N>{
    DNSRecordSpecObservedConfigNestedImpl(DNSRecordSpec item) {
      this.builder = new DNSRecordSpecBuilder(this, item);
    }
    DNSRecordSpecObservedConfigNestedImpl() {
      this.builder = new DNSRecordSpecBuilder(this);
    }
    DNSRecordSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordSpecObservedConfig() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCustomizationObservedConfigNestedImpl<N> extends DeveloperConsoleCatalogCustomizationFluentImpl<NetworkSpecFluent.DeveloperConsoleCatalogCustomizationObservedConfigNested<N>> implements NetworkSpecFluent.DeveloperConsoleCatalogCustomizationObservedConfigNested<N>,Nested<N>{
    DeveloperConsoleCatalogCustomizationObservedConfigNestedImpl(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperConsoleCatalogCustomizationObservedConfigNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDeveloperConsoleCatalogCustomizationObservedConfig() {
      return and();
    }
    
  }
  class KubeSchedulerSpecObservedConfigNestedImpl<N> extends KubeSchedulerSpecFluentImpl<NetworkSpecFluent.KubeSchedulerSpecObservedConfigNested<N>> implements NetworkSpecFluent.KubeSchedulerSpecObservedConfigNested<N>,Nested<N>{
    KubeSchedulerSpecObservedConfigNestedImpl(KubeSchedulerSpec item) {
      this.builder = new KubeSchedulerSpecBuilder(this, item);
    }
    KubeSchedulerSpecObservedConfigNestedImpl() {
      this.builder = new KubeSchedulerSpecBuilder(this);
    }
    KubeSchedulerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeSchedulerSpecObservedConfig() {
      return and();
    }
    
  }
  class LoggingDestinationObservedConfigNestedImpl<N> extends LoggingDestinationFluentImpl<NetworkSpecFluent.LoggingDestinationObservedConfigNested<N>> implements NetworkSpecFluent.LoggingDestinationObservedConfigNested<N>,Nested<N>{
    LoggingDestinationObservedConfigNestedImpl(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    LoggingDestinationObservedConfigNestedImpl() {
      this.builder = new LoggingDestinationBuilder(this);
    }
    LoggingDestinationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endLoggingDestinationObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerTuningOptionsObservedConfigNestedImpl<N> extends IngressControllerTuningOptionsFluentImpl<NetworkSpecFluent.IngressControllerTuningOptionsObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerTuningOptionsObservedConfigNested<N>,Nested<N>{
    IngressControllerTuningOptionsObservedConfigNestedImpl(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsObservedConfigNestedImpl() {
      this.builder = new IngressControllerTuningOptionsBuilder(this);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerTuningOptionsObservedConfig() {
      return and();
    }
    
  }
  class StaticIPAMConfigObservedNestedImpl<N> extends StaticIPAMConfigFluentImpl<NetworkSpecFluent.StaticIPAMConfigObservedNested<N>> implements NetworkSpecFluent.StaticIPAMConfigObservedNested<N>,Nested<N>{
    StaticIPAMConfigObservedNestedImpl(StaticIPAMConfig item) {
      this.builder = new StaticIPAMConfigBuilder(this, item);
    }
    StaticIPAMConfigObservedNestedImpl() {
      this.builder = new StaticIPAMConfigBuilder(this);
    }
    StaticIPAMConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStaticIPAMConfigObserved() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyListObservedConfigNestedImpl<N> extends ImageContentSourcePolicyListFluentImpl<NetworkSpecFluent.ImageContentSourcePolicyListObservedConfigNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicyListObservedConfigNested<N>,Nested<N>{
    ImageContentSourcePolicyListObservedConfigNestedImpl(ImageContentSourcePolicyList item) {
      this.builder = new ImageContentSourcePolicyListBuilder(this, item);
    }
    ImageContentSourcePolicyListObservedConfigNestedImpl() {
      this.builder = new ImageContentSourcePolicyListBuilder(this);
    }
    ImageContentSourcePolicyListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endImageContentSourcePolicyListObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerStatusObservedConfigNestedImpl<N> extends OpenShiftControllerManagerStatusFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerStatusObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerStatusObservedConfigNested<N>,Nested<N>{
    OpenShiftControllerManagerStatusObservedConfigNestedImpl(OpenShiftControllerManagerStatus item) {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this, item);
    }
    OpenShiftControllerManagerStatusObservedConfigNestedImpl() {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this);
    }
    OpenShiftControllerManagerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftControllerManagerStatusObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerStatusObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerStatusFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerStatusObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerStatusObservedConfigNested<N>,Nested<N>{
    ServiceCatalogAPIServerStatusObservedConfigNestedImpl(ServiceCatalogAPIServerStatus item) {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this, item);
    }
    ServiceCatalogAPIServerStatusObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this);
    }
    ServiceCatalogAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogAPIServerStatusObservedConfig() {
      return and();
    }
    
  }
  class KubeControllerManagerSpecObservedConfigNestedImpl<N> extends KubeControllerManagerSpecFluentImpl<NetworkSpecFluent.KubeControllerManagerSpecObservedConfigNested<N>> implements NetworkSpecFluent.KubeControllerManagerSpecObservedConfigNested<N>,Nested<N>{
    KubeControllerManagerSpecObservedConfigNestedImpl(KubeControllerManagerSpec item) {
      this.builder = new KubeControllerManagerSpecBuilder(this, item);
    }
    KubeControllerManagerSpecObservedConfigNestedImpl() {
      this.builder = new KubeControllerManagerSpecBuilder(this);
    }
    KubeControllerManagerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endKubeControllerManagerSpecObservedConfig() {
      return and();
    }
    
  }
  class StaticIPAMDNSObservedConfigNestedImpl<N> extends StaticIPAMDNSFluentImpl<NetworkSpecFluent.StaticIPAMDNSObservedConfigNested<N>> implements NetworkSpecFluent.StaticIPAMDNSObservedConfigNested<N>,Nested<N>{
    StaticIPAMDNSObservedConfigNestedImpl(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    StaticIPAMDNSObservedConfigNestedImpl() {
      this.builder = new StaticIPAMDNSBuilder(this);
    }
    StaticIPAMDNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStaticIPAMDNSObservedConfig() {
      return and();
    }
    
  }
  class DNSNodePlacementObservedConfigNestedImpl<N> extends DNSNodePlacementFluentImpl<NetworkSpecFluent.DNSNodePlacementObservedConfigNested<N>> implements NetworkSpecFluent.DNSNodePlacementObservedConfigNested<N>,Nested<N>{
    DNSNodePlacementObservedConfigNestedImpl(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementObservedConfigNestedImpl() {
      this.builder = new DNSNodePlacementBuilder(this);
    }
    DNSNodePlacementBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSNodePlacementObservedConfig() {
      return and();
    }
    
  }
  class StorageSpecObservedConfigNestedImpl<N> extends StorageSpecFluentImpl<NetworkSpecFluent.StorageSpecObservedConfigNested<N>> implements NetworkSpecFluent.StorageSpecObservedConfigNested<N>,Nested<N>{
    StorageSpecObservedConfigNestedImpl(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecObservedConfigNestedImpl() {
      this.builder = new StorageSpecBuilder(this);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageSpecObservedConfig() {
      return and();
    }
    
  }
  class NetworkListObservedConfigNestedImpl<N> extends NetworkListFluentImpl<NetworkSpecFluent.NetworkListObservedConfigNested<N>> implements NetworkSpecFluent.NetworkListObservedConfigNested<N>,Nested<N>{
    NetworkListObservedConfigNestedImpl(NetworkList item) {
      this.builder = new NetworkListBuilder(this, item);
    }
    NetworkListObservedConfigNestedImpl() {
      this.builder = new NetworkListBuilder(this);
    }
    NetworkListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkListObservedConfig() {
      return and();
    }
    
  }
  class NodePlacementObservedConfigNestedImpl<N> extends NodePlacementFluentImpl<NetworkSpecFluent.NodePlacementObservedConfigNested<N>> implements NetworkSpecFluent.NodePlacementObservedConfigNested<N>,Nested<N>{
    NodePlacementObservedConfigNestedImpl(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementObservedConfigNestedImpl() {
      this.builder = new NodePlacementBuilder(this);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNodePlacementObservedConfig() {
      return and();
    }
    
  }
  class ProviderLoadBalancerParametersObservedConfigNestedImpl<N> extends ProviderLoadBalancerParametersFluentImpl<NetworkSpecFluent.ProviderLoadBalancerParametersObservedConfigNested<N>> implements NetworkSpecFluent.ProviderLoadBalancerParametersObservedConfigNested<N>,Nested<N>{
    ProviderLoadBalancerParametersObservedConfigNestedImpl(ProviderLoadBalancerParameters item) {
      this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
    }
    ProviderLoadBalancerParametersObservedConfigNestedImpl() {
      this.builder = new ProviderLoadBalancerParametersBuilder(this);
    }
    ProviderLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endProviderLoadBalancerParametersObservedConfig() {
      return and();
    }
    
  }
  class NetworkSpecObservedConfigNestedImpl<N> extends NetworkSpecFluentImpl<NetworkSpecFluent.NetworkSpecObservedConfigNested<N>> implements NetworkSpecFluent.NetworkSpecObservedConfigNested<N>,Nested<N>{
    NetworkSpecObservedConfigNestedImpl(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecObservedConfigNestedImpl() {
      this.builder = new NetworkSpecBuilder(this);
    }
    NetworkSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetworkSpecObservedConfig() {
      return and();
    }
    
  }
  class ServiceCASpecObservedConfigNestedImpl<N> extends ServiceCASpecFluentImpl<NetworkSpecFluent.ServiceCASpecObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCASpecObservedConfigNested<N>,Nested<N>{
    ServiceCASpecObservedConfigNestedImpl(ServiceCASpec item) {
      this.builder = new ServiceCASpecBuilder(this, item);
    }
    ServiceCASpecObservedConfigNestedImpl() {
      this.builder = new ServiceCASpecBuilder(this);
    }
    ServiceCASpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCASpecObservedConfig() {
      return and();
    }
    
  }
  class PrivateStrategyObservedConfigNestedImpl<N> extends PrivateStrategyFluentImpl<NetworkSpecFluent.PrivateStrategyObservedConfigNested<N>> implements NetworkSpecFluent.PrivateStrategyObservedConfigNested<N>,Nested<N>{
    PrivateStrategyObservedConfigNestedImpl(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyObservedConfigNestedImpl() {
      this.builder = new PrivateStrategyBuilder(this);
    }
    PrivateStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPrivateStrategyObservedConfig() {
      return and();
    }
    
  }
  class ConsoleStatusObservedConfigNestedImpl<N> extends ConsoleStatusFluentImpl<NetworkSpecFluent.ConsoleStatusObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleStatusObservedConfigNested<N>,Nested<N>{
    ConsoleStatusObservedConfigNestedImpl(ConsoleStatus item) {
      this.builder = new ConsoleStatusBuilder(this, item);
    }
    ConsoleStatusObservedConfigNestedImpl() {
      this.builder = new ConsoleStatusBuilder(this);
    }
    ConsoleStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleStatusObservedConfig() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckListObservedConfigNestedImpl<N> extends PodNetworkConnectivityCheckListFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckListObservedConfigNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckListObservedConfigNested<N>,Nested<N>{
    PodNetworkConnectivityCheckListObservedConfigNestedImpl(PodNetworkConnectivityCheckList item) {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this, item);
    }
    PodNetworkConnectivityCheckListObservedConfigNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this);
    }
    PodNetworkConnectivityCheckListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPodNetworkConnectivityCheckListObservedConfig() {
      return and();
    }
    
  }
  class ObjectReferenceObservedConfigNestedImpl<N> extends ObjectReferenceFluentImpl<NetworkSpecFluent.ObjectReferenceObservedConfigNested<N>> implements NetworkSpecFluent.ObjectReferenceObservedConfigNested<N>,Nested<N>{
    ObjectReferenceObservedConfigNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceObservedConfigNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endObjectReferenceObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerListObservedConfigNestedImpl<N> extends OpenShiftAPIServerListFluentImpl<NetworkSpecFluent.OpenShiftAPIServerListObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerListObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerListObservedConfigNestedImpl(OpenShiftAPIServerList item) {
      this.builder = new OpenShiftAPIServerListBuilder(this, item);
    }
    OpenShiftAPIServerListObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerListBuilder(this);
    }
    OpenShiftAPIServerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerListObservedConfig() {
      return and();
    }
    
  }
  class ServerObservedConfigNestedImpl<N> extends ServerFluentImpl<NetworkSpecFluent.ServerObservedConfigNested<N>> implements NetworkSpecFluent.ServerObservedConfigNested<N>,Nested<N>{
    ServerObservedConfigNestedImpl(Server item) {
      this.builder = new ServerBuilder(this, item);
    }
    ServerObservedConfigNestedImpl() {
      this.builder = new ServerBuilder(this);
    }
    ServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServerObservedConfig() {
      return and();
    }
    
  }
  class OAuthAPIServerStatusObservedConfigNestedImpl<N> extends OAuthAPIServerStatusFluentImpl<NetworkSpecFluent.OAuthAPIServerStatusObservedConfigNested<N>> implements NetworkSpecFluent.OAuthAPIServerStatusObservedConfigNested<N>,Nested<N>{
    OAuthAPIServerStatusObservedConfigNestedImpl(OAuthAPIServerStatus item) {
      this.builder = new OAuthAPIServerStatusBuilder(this, item);
    }
    OAuthAPIServerStatusObservedConfigNestedImpl() {
      this.builder = new OAuthAPIServerStatusBuilder(this);
    }
    OAuthAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOAuthAPIServerStatusObservedConfig() {
      return and();
    }
    
  }
  class CloudCredentialSpecObservedConfigNestedImpl<N> extends CloudCredentialSpecFluentImpl<NetworkSpecFluent.CloudCredentialSpecObservedConfigNested<N>> implements NetworkSpecFluent.CloudCredentialSpecObservedConfigNested<N>,Nested<N>{
    CloudCredentialSpecObservedConfigNestedImpl(CloudCredentialSpec item) {
      this.builder = new CloudCredentialSpecBuilder(this, item);
    }
    CloudCredentialSpecObservedConfigNestedImpl() {
      this.builder = new CloudCredentialSpecBuilder(this);
    }
    CloudCredentialSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endCloudCredentialSpecObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordStatusObservedConfigNestedImpl<N> extends DNSRecordStatusFluentImpl<NetworkSpecFluent.DNSRecordStatusObservedConfigNested<N>> implements NetworkSpecFluent.DNSRecordStatusObservedConfigNested<N>,Nested<N>{
    DNSRecordStatusObservedConfigNestedImpl(DNSRecordStatus item) {
      this.builder = new DNSRecordStatusBuilder(this, item);
    }
    DNSRecordStatusObservedConfigNestedImpl() {
      this.builder = new DNSRecordStatusBuilder(this);
    }
    DNSRecordStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordStatusObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,Nested<N>{
    ServiceCatalogControllerManagerObservedConfigNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerObservedConfigNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCatalogControllerManagerObservedConfig() {
      return and();
    }
    
  }
  class ClusterNetworkEntryObservedConfigNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkSpecFluent.ClusterNetworkEntryObservedConfigNested<N>> implements NetworkSpecFluent.ClusterNetworkEntryObservedConfigNested<N>,Nested<N>{
    ClusterNetworkEntryObservedConfigNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryObservedConfigNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endClusterNetworkEntryObservedConfig() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPCookieObservedConfigNestedImpl<N> extends IngressControllerCaptureHTTPCookieFluentImpl<NetworkSpecFluent.IngressControllerCaptureHTTPCookieObservedConfigNested<N>> implements NetworkSpecFluent.IngressControllerCaptureHTTPCookieObservedConfigNested<N>,Nested<N>{
    IngressControllerCaptureHTTPCookieObservedConfigNestedImpl(IngressControllerCaptureHTTPCookie item) {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    IngressControllerCaptureHTTPCookieObservedConfigNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endIngressControllerCaptureHTTPCookieObservedConfig() {
      return and();
    }
    
  }
  class HTTPCompressionPolicyObservedConfigNestedImpl<N> extends HTTPCompressionPolicyFluentImpl<NetworkSpecFluent.HTTPCompressionPolicyObservedConfigNested<N>> implements NetworkSpecFluent.HTTPCompressionPolicyObservedConfigNested<N>,Nested<N>{
    HTTPCompressionPolicyObservedConfigNestedImpl(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyObservedConfigNestedImpl() {
      this.builder = new HTTPCompressionPolicyBuilder(this);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endHTTPCompressionPolicyObservedConfig() {
      return and();
    }
    
  }
  class ProjectAccessObservedConfigNestedImpl<N> extends ProjectAccessFluentImpl<NetworkSpecFluent.ProjectAccessObservedConfigNested<N>> implements NetworkSpecFluent.ProjectAccessObservedConfigNested<N>,Nested<N>{
    ProjectAccessObservedConfigNestedImpl(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessObservedConfigNestedImpl() {
      this.builder = new ProjectAccessBuilder(this);
    }
    ProjectAccessBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endProjectAccessObservedConfig() {
      return and();
    }
    
  }
  class DNSObservedConfigNestedImpl<N> extends DNSFluentImpl<NetworkSpecFluent.DNSObservedConfigNested<N>> implements NetworkSpecFluent.DNSObservedConfigNested<N>,Nested<N>{
    DNSObservedConfigNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSObservedConfigNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSObservedConfig() {
      return and();
    }
    
  }
  class NetFlowConfigObservedNestedImpl<N> extends NetFlowConfigFluentImpl<NetworkSpecFluent.NetFlowConfigObservedNested<N>> implements NetworkSpecFluent.NetFlowConfigObservedNested<N>,Nested<N>{
    NetFlowConfigObservedNestedImpl(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigObservedNestedImpl() {
      this.builder = new NetFlowConfigBuilder(this);
    }
    NetFlowConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endNetFlowConfigObserved() {
      return and();
    }
    
  }
  class PolicyAuditConfigObservedNestedImpl<N> extends PolicyAuditConfigFluentImpl<NetworkSpecFluent.PolicyAuditConfigObservedNested<N>> implements NetworkSpecFluent.PolicyAuditConfigObservedNested<N>,Nested<N>{
    PolicyAuditConfigObservedNestedImpl(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigObservedNestedImpl() {
      this.builder = new PolicyAuditConfigBuilder(this);
    }
    PolicyAuditConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endPolicyAuditConfigObserved() {
      return and();
    }
    
  }
  class AddPageObservedConfigNestedImpl<N> extends AddPageFluentImpl<NetworkSpecFluent.AddPageObservedConfigNested<N>> implements NetworkSpecFluent.AddPageObservedConfigNested<N>,Nested<N>{
    AddPageObservedConfigNestedImpl(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageObservedConfigNestedImpl() {
      this.builder = new AddPageBuilder(this);
    }
    AddPageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAddPageObservedConfig() {
      return and();
    }
    
  }
  class StorageListObservedConfigNestedImpl<N> extends StorageListFluentImpl<NetworkSpecFluent.StorageListObservedConfigNested<N>> implements NetworkSpecFluent.StorageListObservedConfigNested<N>,Nested<N>{
    StorageListObservedConfigNestedImpl(StorageList item) {
      this.builder = new StorageListBuilder(this, item);
    }
    StorageListObservedConfigNestedImpl() {
      this.builder = new StorageListBuilder(this);
    }
    StorageListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStorageListObservedConfig() {
      return and();
    }
    
  }
  class StaticIPAMAddressesObservedConfigNestedImpl<N> extends StaticIPAMAddressesFluentImpl<NetworkSpecFluent.StaticIPAMAddressesObservedConfigNested<N>> implements NetworkSpecFluent.StaticIPAMAddressesObservedConfigNested<N>,Nested<N>{
    StaticIPAMAddressesObservedConfigNestedImpl(StaticIPAMAddresses item) {
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    StaticIPAMAddressesObservedConfigNestedImpl() {
      this.builder = new StaticIPAMAddressesBuilder(this);
    }
    StaticIPAMAddressesBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endStaticIPAMAddressesObservedConfig() {
      return and();
    }
    
  }
  class DNSRecordObservedConfigNestedImpl<N> extends DNSRecordFluentImpl<NetworkSpecFluent.DNSRecordObservedConfigNested<N>> implements NetworkSpecFluent.DNSRecordObservedConfigNested<N>,Nested<N>{
    DNSRecordObservedConfigNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordObservedConfigNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endDNSRecordObservedConfig() {
      return and();
    }
    
  }
  class OpenShiftAPIServerObservedConfigNestedImpl<N> extends OpenShiftAPIServerFluentImpl<NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,Nested<N>{
    OpenShiftAPIServerObservedConfigNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerObservedConfigNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endOpenShiftAPIServerObservedConfig() {
      return and();
    }
    
  }
  class AuthenticationObservedConfigNestedImpl<N> extends AuthenticationFluentImpl<NetworkSpecFluent.AuthenticationObservedConfigNested<N>> implements NetworkSpecFluent.AuthenticationObservedConfigNested<N>,Nested<N>{
    AuthenticationObservedConfigNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationObservedConfigNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endAuthenticationObservedConfig() {
      return and();
    }
    
  }
  class ConsoleSpecObservedConfigNestedImpl<N> extends ConsoleSpecFluentImpl<NetworkSpecFluent.ConsoleSpecObservedConfigNested<N>> implements NetworkSpecFluent.ConsoleSpecObservedConfigNested<N>,Nested<N>{
    ConsoleSpecObservedConfigNestedImpl(ConsoleSpec item) {
      this.builder = new ConsoleSpecBuilder(this, item);
    }
    ConsoleSpecObservedConfigNestedImpl() {
      this.builder = new ConsoleSpecBuilder(this);
    }
    ConsoleSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endConsoleSpecObservedConfig() {
      return and();
    }
    
  }
  class ServiceCAStatusObservedConfigNestedImpl<N> extends ServiceCAStatusFluentImpl<NetworkSpecFluent.ServiceCAStatusObservedConfigNested<N>> implements NetworkSpecFluent.ServiceCAStatusObservedConfigNested<N>,Nested<N>{
    ServiceCAStatusObservedConfigNestedImpl(ServiceCAStatus item) {
      this.builder = new ServiceCAStatusBuilder(this, item);
    }
    ServiceCAStatusObservedConfigNestedImpl() {
      this.builder = new ServiceCAStatusBuilder(this);
    }
    ServiceCAStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withObservedConfig(builder.build());
    }
    public N endServiceCAStatusObservedConfig() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerListFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServerList item) {
      this.builder = new ServiceCatalogAPIServerListBuilder(this, item);
    }
    ServiceCatalogAPIServerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerListBuilder(this);
    }
    ServiceCatalogAPIServerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LabelSelectorUnsupportedConfigOverridesNestedImpl<N> extends LabelSelectorFluentImpl<NetworkSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.LabelSelectorUnsupportedConfigOverridesNested<N>,Nested<N>{
    LabelSelectorUnsupportedConfigOverridesNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLabelSelectorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerBuilder(this);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerBuilder(this);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckStatusFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckStatus item) {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this, item);
    }
    PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this);
    }
    PodNetworkConnectivityCheckStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorListFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigratorList item) {
      this.builder = new KubeStorageVersionMigratorListBuilder(this, item);
    }
    KubeStorageVersionMigratorListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorListBuilder(this);
    }
    KubeStorageVersionMigratorListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageUnsupportedConfigOverridesNestedImpl<N> extends StorageFluentImpl<NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StorageUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageUnsupportedConfigOverridesNestedImpl(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageBuilder(this);
    }
    StorageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodTemplateSpecUnsupportedConfigOverridesNestedImpl<N> extends PodTemplateSpecFluentImpl<NetworkSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodTemplateSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodTemplateSpecUnsupportedConfigOverridesNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodTemplateSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerStatusFluentImpl<NetworkSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeControllerManagerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl(KubeControllerManagerStatus item) {
      this.builder = new KubeControllerManagerStatusBuilder(this, item);
    }
    KubeControllerManagerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerStatusBuilder(this);
    }
    KubeControllerManagerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerListFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManagerList item) {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this, item);
    }
    ServiceCatalogControllerManagerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this);
    }
    ServiceCatalogControllerManagerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerStatusFluentImpl<NetworkSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl(CSISnapshotControllerStatus item) {
      this.builder = new CSISnapshotControllerStatusBuilder(this, item);
    }
    CSISnapshotControllerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerStatusBuilder(this);
    }
    CSISnapshotControllerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IPsecConfigUnsupportedOverridesNestedImpl<N> extends IPsecConfigFluentImpl<NetworkSpecFluent.IPsecConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.IPsecConfigUnsupportedOverridesNested<N>,Nested<N>{
    IPsecConfigUnsupportedOverridesNestedImpl(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigUnsupportedOverridesNestedImpl() {
      this.builder = new IPsecConfigBuilder(this);
    }
    IPsecConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPsecConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyBuilder(this);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ResourceRequirementsUnsupportedConfigOverridesNestedImpl<N> extends ResourceRequirementsFluentImpl<NetworkSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ResourceRequirementsUnsupportedConfigOverridesNested<N>,Nested<N>{
    ResourceRequirementsUnsupportedConfigOverridesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endResourceRequirementsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OVNKubernetesConfigUnsupportedOverridesNestedImpl<N> extends OVNKubernetesConfigFluentImpl<NetworkSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.OVNKubernetesConfigUnsupportedOverridesNested<N>,Nested<N>{
    OVNKubernetesConfigUnsupportedOverridesNestedImpl(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigUnsupportedOverridesNestedImpl() {
      this.builder = new OVNKubernetesConfigBuilder(this);
    }
    OVNKubernetesConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOVNKubernetesConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl<N> extends DeveloperConsoleCatalogCategoryMetaFluentImpl<NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N>,Nested<N>{
    DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl(DeveloperConsoleCatalogCategoryMeta item) {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this);
    }
    DeveloperConsoleCatalogCategoryMetaBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorSpecFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigratorSpec item) {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this, item);
    }
    KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this);
    }
    KubeStorageVersionMigratorSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerSpecUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerSpecFluentImpl<NetworkSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerSpecUnsupportedConfigOverridesNestedImpl(IngressControllerSpec item) {
      this.builder = new IngressControllerSpecBuilder(this, item);
    }
    IngressControllerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerSpecBuilder(this);
    }
    IngressControllerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSSpecUnsupportedConfigOverridesNestedImpl<N> extends DNSSpecFluentImpl<NetworkSpecFluent.DNSSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSSpecUnsupportedConfigOverridesNestedImpl(DNSSpec item) {
      this.builder = new DNSSpecBuilder(this, item);
    }
    DNSSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSSpecBuilder(this);
    }
    DNSSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftSDNConfigUnsupportedOverridesNestedImpl<N> extends OpenShiftSDNConfigFluentImpl<NetworkSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.OpenShiftSDNConfigUnsupportedOverridesNested<N>,Nested<N>{
    OpenShiftSDNConfigUnsupportedOverridesNestedImpl(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenShiftSDNConfigUnsupportedOverridesNestedImpl() {
      this.builder = new OpenShiftSDNConfigBuilder(this);
    }
    OpenShiftSDNConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftSDNConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class OperatorConditionUnsupportedConfigOverridesNestedImpl<N> extends OperatorConditionFluentImpl<NetworkSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OperatorConditionUnsupportedConfigOverridesNested<N>,Nested<N>{
    OperatorConditionUnsupportedConfigOverridesNestedImpl(OperatorCondition item) {
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OperatorConditionBuilder(this);
    }
    OperatorConditionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOperatorConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerHTTPHeadersFluentImpl<NetworkSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerHTTPHeadersBuilder(this);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ProxyConfigUnsupportedOverridesNestedImpl<N> extends ProxyConfigFluentImpl<NetworkSpecFluent.ProxyConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.ProxyConfigUnsupportedOverridesNested<N>,Nested<N>{
    ProxyConfigUnsupportedOverridesNestedImpl(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigUnsupportedOverridesNestedImpl() {
      this.builder = new ProxyConfigBuilder(this);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProxyConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ConsoleListUnsupportedConfigOverridesNestedImpl<N> extends ConsoleListFluentImpl<NetworkSpecFluent.ConsoleListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleListUnsupportedConfigOverridesNestedImpl(ConsoleList item) {
      this.builder = new ConsoleListBuilder(this, item);
    }
    ConsoleListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleListBuilder(this);
    }
    ConsoleListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KuryrConfigUnsupportedOverridesNestedImpl<N> extends KuryrConfigFluentImpl<NetworkSpecFluent.KuryrConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.KuryrConfigUnsupportedOverridesNested<N>,Nested<N>{
    KuryrConfigUnsupportedOverridesNestedImpl(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigUnsupportedOverridesNestedImpl() {
      this.builder = new KuryrConfigBuilder(this);
    }
    KuryrConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKuryrConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl<N> extends DeveloperConsoleCatalogCategoryFluentImpl<NetworkSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N>,Nested<N>{
    DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl(DeveloperConsoleCatalogCategory item) {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerSpecFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManagerSpec item) {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this, item);
    }
    OpenShiftControllerManagerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this);
    }
    OpenShiftControllerManagerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl<N> extends ExportNetworkFlowsFluentImpl<NetworkSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ExportNetworkFlowsUnsupportedConfigOverridesNested<N>,Nested<N>{
    ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ExportNetworkFlowsBuilder(this);
    }
    ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endExportNetworkFlowsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverSpecFluentImpl<NetworkSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl(ClusterCSIDriverSpec item) {
      this.builder = new ClusterCSIDriverSpecBuilder(this, item);
    }
    ClusterCSIDriverSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverSpecBuilder(this);
    }
    ClusterCSIDriverSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerSpecFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServerSpec item) {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this, item);
    }
    ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this);
    }
    ServiceCatalogAPIServerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicySpecFluentImpl<NetworkSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicySpec item) {
      this.builder = new ImageContentSourcePolicySpecBuilder(this, item);
    }
    ImageContentSourcePolicySpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicySpecBuilder(this);
    }
    ImageContentSourcePolicySpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicySpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl<N> extends RepositoryDigestMirrorsFluentImpl<NetworkSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N>,Nested<N>{
    RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl(RepositoryDigestMirrors item) {
      this.builder = new RepositoryDigestMirrorsBuilder(this, item);
    }
    RepositoryDigestMirrorsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new RepositoryDigestMirrorsBuilder(this);
    }
    RepositoryDigestMirrorsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRepositoryDigestMirrorsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleCustomizationUnsupportedConfigOverridesNestedImpl<N> extends ConsoleCustomizationFluentImpl<NetworkSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleCustomizationUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleCustomizationUnsupportedConfigOverridesNestedImpl(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleCustomizationBuilder(this);
    }
    ConsoleCustomizationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerSpecFluentImpl<NetworkSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl(CSISnapshotControllerSpec item) {
      this.builder = new CSISnapshotControllerSpecBuilder(this, item);
    }
    CSISnapshotControllerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerSpecBuilder(this);
    }
    CSISnapshotControllerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class UpstreamResolversUnsupportedConfigOverridesNestedImpl<N> extends UpstreamResolversFluentImpl<NetworkSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.UpstreamResolversUnsupportedConfigOverridesNested<N>,Nested<N>{
    UpstreamResolversUnsupportedConfigOverridesNestedImpl(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversUnsupportedConfigOverridesNestedImpl() {
      this.builder = new UpstreamResolversBuilder(this);
    }
    UpstreamResolversBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endUpstreamResolversUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSStatusUnsupportedConfigOverridesNestedImpl<N> extends DNSStatusFluentImpl<NetworkSpecFluent.DNSStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSStatusUnsupportedConfigOverridesNestedImpl(DNSStatus item) {
      this.builder = new DNSStatusBuilder(this, item);
    }
    DNSStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSStatusBuilder(this);
    }
    DNSStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends GCPLoadBalancerParametersFluentImpl<NetworkSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new GCPLoadBalancerParametersBuilder(this);
    }
    GCPLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGCPLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigStatusUnsupportedConfigOverridesNestedImpl<N> extends ConfigStatusFluentImpl<NetworkSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConfigStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigStatusUnsupportedConfigOverridesNestedImpl(ConfigStatus item) {
      this.builder = new ConfigStatusBuilder(this, item);
    }
    ConfigStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigStatusBuilder(this);
    }
    ConfigStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerListUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerListFluentImpl<NetworkSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeAPIServerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerListUnsupportedConfigOverridesNestedImpl(KubeAPIServerList item) {
      this.builder = new KubeAPIServerListBuilder(this, item);
    }
    KubeAPIServerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerListBuilder(this);
    }
    KubeAPIServerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCAUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCABuilder(this);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerSpecFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManagerSpec item) {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this, item);
    }
    ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this);
    }
    ServiceCatalogControllerManagerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigUnsupportedConfigOverridesNestedImpl<N> extends ConfigFluentImpl<NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConfigUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigUnsupportedConfigOverridesNestedImpl(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigBuilder(this);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerListUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerListFluentImpl<NetworkSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerListUnsupportedConfigOverridesNestedImpl(IngressControllerList item) {
      this.builder = new IngressControllerListBuilder(this, item);
    }
    IngressControllerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerListBuilder(this);
    }
    IngressControllerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSListUnsupportedConfigOverridesNestedImpl<N> extends DNSListFluentImpl<NetworkSpecFluent.DNSListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSListUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSListUnsupportedConfigOverridesNestedImpl(DNSList item) {
      this.builder = new DNSListBuilder(this, item);
    }
    DNSListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSListBuilder(this);
    }
    DNSListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ObjectMetaUnsupportedConfigOverridesNestedImpl<N> extends ObjectMetaFluentImpl<NetworkSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ObjectMetaUnsupportedConfigOverridesNested<N>,Nested<N>{
    ObjectMetaUnsupportedConfigOverridesNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endObjectMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverListFluentImpl<NetworkSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClusterCSIDriverListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl(ClusterCSIDriverList item) {
      this.builder = new ClusterCSIDriverListBuilder(this, item);
    }
    ClusterCSIDriverListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverListBuilder(this);
    }
    ClusterCSIDriverListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class SimpleMacvlanConfigUnsupportedOverridesNestedImpl<N> extends SimpleMacvlanConfigFluentImpl<NetworkSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.SimpleMacvlanConfigUnsupportedOverridesNested<N>,Nested<N>{
    SimpleMacvlanConfigUnsupportedOverridesNestedImpl(SimpleMacvlanConfig item) {
      this.builder = new SimpleMacvlanConfigBuilder(this, item);
    }
    SimpleMacvlanConfigUnsupportedOverridesNestedImpl() {
      this.builder = new SimpleMacvlanConfigBuilder(this);
    }
    SimpleMacvlanConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSimpleMacvlanConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerStatusFluentImpl<NetworkSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl(KubeAPIServerStatus item) {
      this.builder = new KubeAPIServerStatusBuilder(this, item);
    }
    KubeAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerStatusBuilder(this);
    }
    KubeAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends AWSClassicLoadBalancerParametersFluentImpl<NetworkSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(AWSClassicLoadBalancerParameters item) {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
    }
    AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this);
    }
    AWSClassicLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerBuilder(this);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerBuilder(this);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleConfigRouteUnsupportedOverridesNestedImpl<N> extends ConsoleConfigRouteFluentImpl<NetworkSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<N>> implements NetworkSpecFluent.ConsoleConfigRouteUnsupportedOverridesNested<N>,Nested<N>{
    ConsoleConfigRouteUnsupportedOverridesNestedImpl(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteUnsupportedOverridesNestedImpl() {
      this.builder = new ConsoleConfigRouteBuilder(this);
    }
    ConsoleConfigRouteBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleConfigRouteUnsupportedOverrides() {
      return and();
    }
    
  }
  class CloudCredentialStatusUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialStatusFluentImpl<NetworkSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CloudCredentialStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialStatusUnsupportedConfigOverridesNestedImpl(CloudCredentialStatus item) {
      this.builder = new CloudCredentialStatusBuilder(this, item);
    }
    CloudCredentialStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialStatusBuilder(this);
    }
    CloudCredentialStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorBuilder(this);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl<N> extends GenericKubernetesResourceFluentImpl<NetworkSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.GenericKubernetesResourceUnsupportedConfigOverridesNested<N>,Nested<N>{
    GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceUnsupportedConfigOverridesNestedImpl() {
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGenericKubernetesResourceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerStatusUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerStatusFluentImpl<NetworkSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerStatusUnsupportedConfigOverridesNestedImpl(IngressControllerStatus item) {
      this.builder = new IngressControllerStatusBuilder(this, item);
    }
    IngressControllerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerStatusBuilder(this);
    }
    IngressControllerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerStatusFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManagerStatus item) {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this, item);
    }
    ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this);
    }
    ServiceCatalogControllerManagerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class HybridOverlayConfigUnsupportedOverridesNestedImpl<N> extends HybridOverlayConfigFluentImpl<NetworkSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.HybridOverlayConfigUnsupportedOverridesNested<N>,Nested<N>{
    HybridOverlayConfigUnsupportedOverridesNestedImpl(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigUnsupportedOverridesNestedImpl() {
      this.builder = new HybridOverlayConfigBuilder(this);
    }
    HybridOverlayConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHybridOverlayConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends AWSLoadBalancerParametersFluentImpl<NetworkSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AWSLoadBalancerParametersBuilder(this);
    }
    AWSLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerListUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerListFluentImpl<NetworkSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImagePrunerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerListUnsupportedConfigOverridesNestedImpl(ImagePrunerList item) {
      this.builder = new ImagePrunerListBuilder(this, item);
    }
    ImagePrunerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerListBuilder(this);
    }
    ImagePrunerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerListFluentImpl<NetworkSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CSISnapshotControllerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl(CSISnapshotControllerList item) {
      this.builder = new CSISnapshotControllerListBuilder(this, item);
    }
    CSISnapshotControllerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerListBuilder(this);
    }
    CSISnapshotControllerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LocalObjectReferenceUnsupportedConfigOverridesNestedImpl<N> extends LocalObjectReferenceFluentImpl<NetworkSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.LocalObjectReferenceUnsupportedConfigOverridesNested<N>,Nested<N>{
    LocalObjectReferenceUnsupportedConfigOverridesNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLocalObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleBuilder(this);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl<N> extends StaticIPAMRoutesFluentImpl<NetworkSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StaticIPAMRoutesUnsupportedConfigOverridesNested<N>,Nested<N>{
    StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl(StaticIPAMRoutes item) {
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    StaticIPAMRoutesUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StaticIPAMRoutesBuilder(this);
    }
    StaticIPAMRoutesBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMRoutesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSZoneConditionUnsupportedConfigOverridesNestedImpl<N> extends DNSZoneConditionFluentImpl<NetworkSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSZoneConditionUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSZoneConditionUnsupportedConfigOverridesNestedImpl(DNSZoneCondition item) {
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    DNSZoneConditionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSZoneConditionBuilder(this);
    }
    DNSZoneConditionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSZoneConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl<N> extends ContainerLoggingDestinationParametersFluentImpl<NetworkSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerListUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerListFluentImpl<NetworkSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeSchedulerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerListUnsupportedConfigOverridesNestedImpl(KubeSchedulerList item) {
      this.builder = new KubeSchedulerListBuilder(this, item);
    }
    KubeSchedulerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerListBuilder(this);
    }
    KubeSchedulerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerSpecFluentImpl<NetworkSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeAPIServerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl(KubeAPIServerSpec item) {
      this.builder = new KubeAPIServerSpecBuilder(this, item);
    }
    KubeAPIServerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeAPIServerSpecBuilder(this);
    }
    KubeAPIServerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverFluentImpl<NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClusterCSIDriverUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverBuilder(this);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class QuickStartsUnsupportedConfigOverridesNestedImpl<N> extends QuickStartsFluentImpl<NetworkSpecFluent.QuickStartsUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.QuickStartsUnsupportedConfigOverridesNested<N>,Nested<N>{
    QuickStartsUnsupportedConfigOverridesNestedImpl(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new QuickStartsBuilder(this);
    }
    QuickStartsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endQuickStartsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSZoneStatusUnsupportedConfigOverridesNestedImpl<N> extends DNSZoneStatusFluentImpl<NetworkSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSZoneStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSZoneStatusUnsupportedConfigOverridesNestedImpl(DNSZoneStatus item) {
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    DNSZoneStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSZoneStatusBuilder(this);
    }
    DNSZoneStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSZoneStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerBuilder(this);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigSpecUnsupportedConfigOverridesNestedImpl<N> extends ConfigSpecFluentImpl<NetworkSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConfigSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigSpecUnsupportedConfigOverridesNestedImpl(ConfigSpec item) {
      this.builder = new ConfigSpecBuilder(this, item);
    }
    ConfigSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigSpecBuilder(this);
    }
    ConfigSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OutageEntryUnsupportedConfigOverridesNestedImpl<N> extends OutageEntryFluentImpl<NetworkSpecFluent.OutageEntryUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OutageEntryUnsupportedConfigOverridesNested<N>,Nested<N>{
    OutageEntryUnsupportedConfigOverridesNestedImpl(OutageEntry item) {
      this.builder = new OutageEntryBuilder(this, item);
    }
    OutageEntryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OutageEntryBuilder(this);
    }
    OutageEntryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOutageEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerListFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManagerList item) {
      this.builder = new OpenShiftControllerManagerListBuilder(this, item);
    }
    OpenShiftControllerManagerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerListBuilder(this);
    }
    OpenShiftControllerManagerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdBuilder(this);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<NetworkSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.EndpointPublishingStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EndpointPublishingStrategyBuilder(this);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEndpointPublishingStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IPFIXConfigUnsupportedOverridesNestedImpl<N> extends IPFIXConfigFluentImpl<NetworkSpecFluent.IPFIXConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.IPFIXConfigUnsupportedOverridesNested<N>,Nested<N>{
    IPFIXConfigUnsupportedOverridesNestedImpl(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigUnsupportedOverridesNestedImpl() {
      this.builder = new IPFIXConfigBuilder(this);
    }
    IPFIXConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPFIXConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class CloudCredentialUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialFluentImpl<NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CloudCredentialUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNestedImpl(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialBuilder(this);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerBuilder(this);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl<N> extends ClusterCSIDriverStatusFluentImpl<NetworkSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl(ClusterCSIDriverStatus item) {
      this.builder = new ClusterCSIDriverStatusBuilder(this, item);
    }
    ClusterCSIDriverStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterCSIDriverStatusBuilder(this);
    }
    ClusterCSIDriverStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkStatusUnsupportedConfigOverridesNestedImpl<N> extends NetworkStatusFluentImpl<NetworkSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NetworkStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkStatusUnsupportedConfigOverridesNestedImpl(NetworkStatus item) {
      this.builder = new NetworkStatusBuilder(this, item);
    }
    NetworkStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkStatusBuilder(this);
    }
    NetworkStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class SFlowConfigUnsupportedOverridesNestedImpl<N> extends SFlowConfigFluentImpl<NetworkSpecFluent.SFlowConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.SFlowConfigUnsupportedOverridesNested<N>,Nested<N>{
    SFlowConfigUnsupportedOverridesNestedImpl(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigUnsupportedOverridesNestedImpl() {
      this.builder = new SFlowConfigBuilder(this);
    }
    SFlowConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ForwardPluginUnsupportedConfigOverridesNestedImpl<N> extends ForwardPluginFluentImpl<NetworkSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ForwardPluginUnsupportedConfigOverridesNested<N>,Nested<N>{
    ForwardPluginUnsupportedConfigOverridesNestedImpl(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ForwardPluginBuilder(this);
    }
    ForwardPluginBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endForwardPluginUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LogEntryUnsupportedConfigOverridesNestedImpl<N> extends LogEntryFluentImpl<NetworkSpecFluent.LogEntryUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.LogEntryUnsupportedConfigOverridesNested<N>,Nested<N>{
    LogEntryUnsupportedConfigOverridesNestedImpl(LogEntry item) {
      this.builder = new LogEntryBuilder(this, item);
    }
    LogEntryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LogEntryBuilder(this);
    }
    LogEntryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLogEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NodeStatusUnsupportedConfigOverridesNestedImpl<N> extends NodeStatusFluentImpl<NetworkSpecFluent.NodeStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NodeStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    NodeStatusUnsupportedConfigOverridesNestedImpl(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NodeStatusBuilder(this);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodeStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckConditionFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckCondition item) {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this, item);
    }
    PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this);
    }
    PodNetworkConnectivityCheckConditionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl<N> extends AdditionalNetworkDefinitionFluentImpl<NetworkSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N>,Nested<N>{
    AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl(AdditionalNetworkDefinition item) {
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AdditionalNetworkDefinitionBuilder(this);
    }
    AdditionalNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl<N> extends RouteAdmissionPolicyFluentImpl<NetworkSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.RouteAdmissionPolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new RouteAdmissionPolicyBuilder(this);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRouteAdmissionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class GenerationStatusUnsupportedConfigOverridesNestedImpl<N> extends GenerationStatusFluentImpl<NetworkSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.GenerationStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    GenerationStatusUnsupportedConfigOverridesNestedImpl(GenerationStatus item) {
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new GenerationStatusBuilder(this);
    }
    GenerationStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGenerationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationStatusUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationStatusFluentImpl<NetworkSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AuthenticationStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationStatusUnsupportedConfigOverridesNestedImpl(AuthenticationStatus item) {
      this.builder = new AuthenticationStatusBuilder(this, item);
    }
    AuthenticationStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationStatusBuilder(this);
    }
    AuthenticationStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerCaptureHTTPHeadersFluentImpl<NetworkSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdListUnsupportedConfigOverridesNestedImpl<N> extends EtcdListFluentImpl<NetworkSpecFluent.EtcdListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.EtcdListUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdListUnsupportedConfigOverridesNestedImpl(EtcdList item) {
      this.builder = new EtcdListBuilder(this, item);
    }
    EtcdListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdListBuilder(this);
    }
    EtcdListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NodePortStrategyUnsupportedConfigOverridesNestedImpl<N> extends NodePortStrategyFluentImpl<NetworkSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NodePortStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    NodePortStrategyUnsupportedConfigOverridesNestedImpl(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NodePortStrategyBuilder(this);
    }
    NodePortStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodePortStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl<N> extends DefaultNetworkDefinitionFluentImpl<NetworkSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N>,Nested<N>{
    DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DefaultNetworkDefinitionBuilder(this);
    }
    DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDefaultNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkBuilder(this);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClientTLSUnsupportedConfigOverridesNestedImpl<N> extends ClientTLSFluentImpl<NetworkSpecFluent.ClientTLSUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClientTLSUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClientTLSUnsupportedConfigOverridesNestedImpl(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClientTLSBuilder(this);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClientTLSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerSpecFluentImpl<NetworkSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServerSpec item) {
      this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
    }
    OpenShiftAPIServerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerSpecBuilder(this);
    }
    OpenShiftAPIServerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerStatusUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerStatusFluentImpl<NetworkSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImagePrunerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerStatusUnsupportedConfigOverridesNestedImpl(ImagePrunerStatus item) {
      this.builder = new ImagePrunerStatusBuilder(this, item);
    }
    ImagePrunerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerStatusBuilder(this);
    }
    ImagePrunerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerStatusFluentImpl<NetworkSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeSchedulerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl(KubeSchedulerStatus item) {
      this.builder = new KubeSchedulerStatusBuilder(this, item);
    }
    KubeSchedulerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerStatusBuilder(this);
    }
    KubeSchedulerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl<N> extends SyslogLoggingDestinationParametersFluentImpl<NetworkSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class UpstreamUnsupportedConfigOverridesNestedImpl<N> extends UpstreamFluentImpl<NetworkSpecFluent.UpstreamUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.UpstreamUnsupportedConfigOverridesNested<N>,Nested<N>{
    UpstreamUnsupportedConfigOverridesNestedImpl(Upstream item) {
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamUnsupportedConfigOverridesNestedImpl() {
      this.builder = new UpstreamBuilder(this);
    }
    UpstreamBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endUpstreamUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends AWSNetworkLoadBalancerParametersFluentImpl<NetworkSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(AWSNetworkLoadBalancerParameters item) {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
    }
    AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this);
    }
    AWSNetworkLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAListUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAListFluentImpl<NetworkSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCAListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAListUnsupportedConfigOverridesNestedImpl(ServiceCAList item) {
      this.builder = new ServiceCAListBuilder(this, item);
    }
    ServiceCAListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCAListBuilder(this);
    }
    ServiceCAListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerBuilder(this);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerCaptureHTTPHeaderFluentImpl<NetworkSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl(IngressControllerCaptureHTTPHeader item) {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkMigrationUnsupportedConfigOverridesNestedImpl<N> extends NetworkMigrationFluentImpl<NetworkSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NetworkMigrationUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkMigrationUnsupportedConfigOverridesNestedImpl(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkMigrationBuilder(this);
    }
    NetworkMigrationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordListUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordListFluentImpl<NetworkSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSRecordListUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordListUnsupportedConfigOverridesNestedImpl(DNSRecordList item) {
      this.builder = new DNSRecordListBuilder(this, item);
    }
    DNSRecordListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordListBuilder(this);
    }
    DNSRecordListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class RawExtensionUnsupportedConfigOverridesNestedImpl<N> extends RawExtensionFluentImpl<NetworkSpecFluent.RawExtensionUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.RawExtensionUnsupportedConfigOverridesNested<N>,Nested<N>{
    RawExtensionUnsupportedConfigOverridesNestedImpl(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionUnsupportedConfigOverridesNestedImpl() {
      this.builder = new RawExtensionBuilder(this);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRawExtensionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdSpecUnsupportedConfigOverridesNestedImpl<N> extends EtcdSpecFluentImpl<NetworkSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.EtcdSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdSpecUnsupportedConfigOverridesNestedImpl(EtcdSpec item) {
      this.builder = new EtcdSpecBuilder(this, item);
    }
    EtcdSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdSpecBuilder(this);
    }
    EtcdSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckBuilder(this);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerStatusFluentImpl<NetworkSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServerStatus item) {
      this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
    }
    OpenShiftAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerStatusBuilder(this);
    }
    OpenShiftAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl<N> extends LoadBalancerStrategyFluentImpl<NetworkSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.LoadBalancerStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LoadBalancerStrategyBuilder(this);
    }
    LoadBalancerStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLoadBalancerStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class EtcdStatusUnsupportedConfigOverridesNestedImpl<N> extends EtcdStatusFluentImpl<NetworkSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.EtcdStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    EtcdStatusUnsupportedConfigOverridesNestedImpl(EtcdStatus item) {
      this.builder = new EtcdStatusBuilder(this, item);
    }
    EtcdStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new EtcdStatusBuilder(this);
    }
    EtcdStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialListUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialListFluentImpl<NetworkSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CloudCredentialListUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialListUnsupportedConfigOverridesNestedImpl(CloudCredentialList item) {
      this.builder = new CloudCredentialListBuilder(this, item);
    }
    CloudCredentialListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialListBuilder(this);
    }
    CloudCredentialListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ImagePrunerSpecUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerSpecFluentImpl<NetworkSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImagePrunerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImagePrunerSpecUnsupportedConfigOverridesNestedImpl(ImagePrunerSpec item) {
      this.builder = new ImagePrunerSpecBuilder(this, item);
    }
    ImagePrunerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImagePrunerSpecBuilder(this);
    }
    ImagePrunerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StatuspageProviderUnsupportedConfigOverridesNestedImpl<N> extends StatuspageProviderFluentImpl<NetworkSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StatuspageProviderUnsupportedConfigOverridesNested<N>,Nested<N>{
    StatuspageProviderUnsupportedConfigOverridesNestedImpl(StatuspageProvider item) {
      this.builder = new StatuspageProviderBuilder(this, item);
    }
    StatuspageProviderUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StatuspageProviderBuilder(this);
    }
    StatuspageProviderBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStatuspageProviderUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorStatusFluentImpl<NetworkSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigratorStatus item) {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this, item);
    }
    KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this);
    }
    KubeStorageVersionMigratorStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConfigListUnsupportedConfigOverridesNestedImpl<N> extends ConfigListFluentImpl<NetworkSpecFluent.ConfigListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConfigListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConfigListUnsupportedConfigOverridesNestedImpl(ConfigList item) {
      this.builder = new ConfigListBuilder(this, item);
    }
    ConfigListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConfigListBuilder(this);
    }
    ConfigListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleProvidersUnsupportedConfigOverridesNestedImpl<N> extends ConsoleProvidersFluentImpl<NetworkSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleProvidersUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleProvidersUnsupportedConfigOverridesNestedImpl(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleProvidersBuilder(this);
    }
    ConsoleProvidersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleProvidersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerLoggingUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerLoggingFluentImpl<NetworkSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerLoggingUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerLoggingUnsupportedConfigOverridesNestedImpl(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerLoggingBuilder(this);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationListUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationListFluentImpl<NetworkSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AuthenticationListUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationListUnsupportedConfigOverridesNestedImpl(AuthenticationList item) {
      this.builder = new AuthenticationListBuilder(this, item);
    }
    AuthenticationListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationListBuilder(this);
    }
    AuthenticationListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageStatusUnsupportedConfigOverridesNestedImpl<N> extends StorageStatusFluentImpl<NetworkSpecFluent.StorageStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StorageStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageStatusUnsupportedConfigOverridesNestedImpl(StorageStatus item) {
      this.builder = new StorageStatusBuilder(this, item);
    }
    StorageStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageStatusBuilder(this);
    }
    StorageStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerListUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerListFluentImpl<NetworkSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeControllerManagerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerListUnsupportedConfigOverridesNestedImpl(KubeControllerManagerList item) {
      this.builder = new KubeControllerManagerListBuilder(this, item);
    }
    KubeControllerManagerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerListBuilder(this);
    }
    KubeControllerManagerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationSpecUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationSpecFluentImpl<NetworkSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AuthenticationSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationSpecUnsupportedConfigOverridesNestedImpl(AuthenticationSpec item) {
      this.builder = new AuthenticationSpecBuilder(this, item);
    }
    AuthenticationSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationSpecBuilder(this);
    }
    AuthenticationSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IPAMConfigUnsupportedOverridesNestedImpl<N> extends IPAMConfigFluentImpl<NetworkSpecFluent.IPAMConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.IPAMConfigUnsupportedOverridesNested<N>,Nested<N>{
    IPAMConfigUnsupportedOverridesNestedImpl(IPAMConfig item) {
      this.builder = new IPAMConfigBuilder(this, item);
    }
    IPAMConfigUnsupportedOverridesNestedImpl() {
      this.builder = new IPAMConfigBuilder(this);
    }
    IPAMConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ContainerUnsupportedConfigOverridesNestedImpl<N> extends ContainerFluentImpl<NetworkSpecFluent.ContainerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ContainerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ContainerUnsupportedConfigOverridesNestedImpl(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endContainerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CSISnapshotControllerBuilder(this);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckSpecFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckSpec item) {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this, item);
    }
    PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this);
    }
    PodNetworkConnectivityCheckSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AccessLoggingUnsupportedConfigOverridesNestedImpl<N> extends AccessLoggingFluentImpl<NetworkSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AccessLoggingUnsupportedConfigOverridesNested<N>,Nested<N>{
    AccessLoggingUnsupportedConfigOverridesNestedImpl(AccessLogging item) {
      this.builder = new AccessLoggingBuilder(this, item);
    }
    AccessLoggingUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AccessLoggingBuilder(this);
    }
    AccessLoggingBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAccessLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class HostNetworkStrategyUnsupportedConfigOverridesNestedImpl<N> extends HostNetworkStrategyFluentImpl<NetworkSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.HostNetworkStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    HostNetworkStrategyUnsupportedConfigOverridesNestedImpl(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new HostNetworkStrategyBuilder(this);
    }
    HostNetworkStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHostNetworkStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordSpecUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordSpecFluentImpl<NetworkSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSRecordSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordSpecUnsupportedConfigOverridesNestedImpl(DNSRecordSpec item) {
      this.builder = new DNSRecordSpecBuilder(this, item);
    }
    DNSRecordSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordSpecBuilder(this);
    }
    DNSRecordSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl<N> extends DeveloperConsoleCatalogCustomizationFluentImpl<NetworkSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N>,Nested<N>{
    DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerSpecFluentImpl<NetworkSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeSchedulerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl(KubeSchedulerSpec item) {
      this.builder = new KubeSchedulerSpecBuilder(this, item);
    }
    KubeSchedulerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeSchedulerSpecBuilder(this);
    }
    KubeSchedulerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class LoggingDestinationUnsupportedConfigOverridesNestedImpl<N> extends LoggingDestinationFluentImpl<NetworkSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.LoggingDestinationUnsupportedConfigOverridesNested<N>,Nested<N>{
    LoggingDestinationUnsupportedConfigOverridesNestedImpl(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    LoggingDestinationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new LoggingDestinationBuilder(this);
    }
    LoggingDestinationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLoggingDestinationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerTuningOptionsFluentImpl<NetworkSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerTuningOptionsBuilder(this);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerTuningOptionsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMConfigUnsupportedOverridesNestedImpl<N> extends StaticIPAMConfigFluentImpl<NetworkSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.StaticIPAMConfigUnsupportedOverridesNested<N>,Nested<N>{
    StaticIPAMConfigUnsupportedOverridesNestedImpl(StaticIPAMConfig item) {
      this.builder = new StaticIPAMConfigBuilder(this, item);
    }
    StaticIPAMConfigUnsupportedOverridesNestedImpl() {
      this.builder = new StaticIPAMConfigBuilder(this);
    }
    StaticIPAMConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyListFluentImpl<NetworkSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N>,Nested<N>{
    ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicyList item) {
      this.builder = new ImageContentSourcePolicyListBuilder(this, item);
    }
    ImageContentSourcePolicyListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ImageContentSourcePolicyListBuilder(this);
    }
    ImageContentSourcePolicyListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerStatusFluentImpl<NetworkSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManagerStatus item) {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this, item);
    }
    OpenShiftControllerManagerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this);
    }
    OpenShiftControllerManagerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerStatusFluentImpl<NetworkSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServerStatus item) {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this, item);
    }
    ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this);
    }
    ServiceCatalogAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerSpecFluentImpl<NetworkSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.KubeControllerManagerSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl(KubeControllerManagerSpec item) {
      this.builder = new KubeControllerManagerSpecBuilder(this, item);
    }
    KubeControllerManagerSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new KubeControllerManagerSpecBuilder(this);
    }
    KubeControllerManagerSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMDNSUnsupportedConfigOverridesNestedImpl<N> extends StaticIPAMDNSFluentImpl<NetworkSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StaticIPAMDNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    StaticIPAMDNSUnsupportedConfigOverridesNestedImpl(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    StaticIPAMDNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StaticIPAMDNSBuilder(this);
    }
    StaticIPAMDNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSNodePlacementUnsupportedConfigOverridesNestedImpl<N> extends DNSNodePlacementFluentImpl<NetworkSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSNodePlacementUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSNodePlacementUnsupportedConfigOverridesNestedImpl(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSNodePlacementBuilder(this);
    }
    DNSNodePlacementBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageSpecUnsupportedConfigOverridesNestedImpl<N> extends StorageSpecFluentImpl<NetworkSpecFluent.StorageSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StorageSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageSpecUnsupportedConfigOverridesNestedImpl(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageSpecBuilder(this);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkListUnsupportedConfigOverridesNestedImpl<N> extends NetworkListFluentImpl<NetworkSpecFluent.NetworkListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NetworkListUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkListUnsupportedConfigOverridesNestedImpl(NetworkList item) {
      this.builder = new NetworkListBuilder(this, item);
    }
    NetworkListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkListBuilder(this);
    }
    NetworkListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NodePlacementUnsupportedConfigOverridesNestedImpl<N> extends NodePlacementFluentImpl<NetworkSpecFluent.NodePlacementUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NodePlacementUnsupportedConfigOverridesNested<N>,Nested<N>{
    NodePlacementUnsupportedConfigOverridesNestedImpl(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NodePlacementBuilder(this);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl<N> extends ProviderLoadBalancerParametersFluentImpl<NetworkSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N>,Nested<N>{
    ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl(ProviderLoadBalancerParameters item) {
      this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
    }
    ProviderLoadBalancerParametersUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ProviderLoadBalancerParametersBuilder(this);
    }
    ProviderLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProviderLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetworkSpecUnsupportedConfigOverridesNestedImpl<N> extends NetworkSpecFluentImpl<NetworkSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.NetworkSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    NetworkSpecUnsupportedConfigOverridesNestedImpl(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new NetworkSpecBuilder(this);
    }
    NetworkSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCASpecUnsupportedConfigOverridesNestedImpl<N> extends ServiceCASpecFluentImpl<NetworkSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCASpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCASpecUnsupportedConfigOverridesNestedImpl(ServiceCASpec item) {
      this.builder = new ServiceCASpecBuilder(this, item);
    }
    ServiceCASpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCASpecBuilder(this);
    }
    ServiceCASpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCASpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PrivateStrategyUnsupportedConfigOverridesNestedImpl<N> extends PrivateStrategyFluentImpl<NetworkSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PrivateStrategyUnsupportedConfigOverridesNested<N>,Nested<N>{
    PrivateStrategyUnsupportedConfigOverridesNestedImpl(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PrivateStrategyBuilder(this);
    }
    PrivateStrategyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPrivateStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleStatusUnsupportedConfigOverridesNestedImpl<N> extends ConsoleStatusFluentImpl<NetworkSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleStatusUnsupportedConfigOverridesNestedImpl(ConsoleStatus item) {
      this.builder = new ConsoleStatusBuilder(this, item);
    }
    ConsoleStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleStatusBuilder(this);
    }
    ConsoleStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl<N> extends PodNetworkConnectivityCheckListFluentImpl<NetworkSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N>,Nested<N>{
    PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl(PodNetworkConnectivityCheckList item) {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this, item);
    }
    PodNetworkConnectivityCheckListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this);
    }
    PodNetworkConnectivityCheckListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ObjectReferenceUnsupportedConfigOverridesNestedImpl<N> extends ObjectReferenceFluentImpl<NetworkSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ObjectReferenceUnsupportedConfigOverridesNested<N>,Nested<N>{
    ObjectReferenceUnsupportedConfigOverridesNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerListFluentImpl<NetworkSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerListUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServerList item) {
      this.builder = new OpenShiftAPIServerListBuilder(this, item);
    }
    OpenShiftAPIServerListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerListBuilder(this);
    }
    OpenShiftAPIServerListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServerUnsupportedConfigOverridesNestedImpl<N> extends ServerFluentImpl<NetworkSpecFluent.ServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServerUnsupportedConfigOverridesNestedImpl(Server item) {
      this.builder = new ServerBuilder(this, item);
    }
    ServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServerBuilder(this);
    }
    ServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl<N> extends OAuthAPIServerStatusFluentImpl<NetworkSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OAuthAPIServerStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl(OAuthAPIServerStatus item) {
      this.builder = new OAuthAPIServerStatusBuilder(this, item);
    }
    OAuthAPIServerStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OAuthAPIServerStatusBuilder(this);
    }
    OAuthAPIServerStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOAuthAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class CloudCredentialSpecUnsupportedConfigOverridesNestedImpl<N> extends CloudCredentialSpecFluentImpl<NetworkSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.CloudCredentialSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    CloudCredentialSpecUnsupportedConfigOverridesNestedImpl(CloudCredentialSpec item) {
      this.builder = new CloudCredentialSpecBuilder(this, item);
    }
    CloudCredentialSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new CloudCredentialSpecBuilder(this);
    }
    CloudCredentialSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordStatusUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordStatusFluentImpl<NetworkSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSRecordStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordStatusUnsupportedConfigOverridesNestedImpl(DNSRecordStatus item) {
      this.builder = new DNSRecordStatusBuilder(this, item);
    }
    DNSRecordStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordStatusBuilder(this);
    }
    DNSRecordStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCatalogControllerManagerBuilder(this);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ClusterNetworkEntryUnsupportedConfigOverridesNested<N>,Nested<N>{
    ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterNetworkEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerCaptureHTTPCookieFluentImpl<NetworkSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N>,Nested<N>{
    IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl(IngressControllerCaptureHTTPCookie item) {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNestedImpl() {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl<N> extends HTTPCompressionPolicyFluentImpl<NetworkSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.HTTPCompressionPolicyUnsupportedConfigOverridesNested<N>,Nested<N>{
    HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyUnsupportedConfigOverridesNestedImpl() {
      this.builder = new HTTPCompressionPolicyBuilder(this);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHTTPCompressionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ProjectAccessUnsupportedConfigOverridesNestedImpl<N> extends ProjectAccessFluentImpl<NetworkSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ProjectAccessUnsupportedConfigOverridesNested<N>,Nested<N>{
    ProjectAccessUnsupportedConfigOverridesNestedImpl(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ProjectAccessBuilder(this);
    }
    ProjectAccessBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProjectAccessUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSBuilder(this);
    }
    DNSBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class NetFlowConfigUnsupportedOverridesNestedImpl<N> extends NetFlowConfigFluentImpl<NetworkSpecFluent.NetFlowConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.NetFlowConfigUnsupportedOverridesNested<N>,Nested<N>{
    NetFlowConfigUnsupportedOverridesNestedImpl(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigUnsupportedOverridesNestedImpl() {
      this.builder = new NetFlowConfigBuilder(this);
    }
    NetFlowConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class PolicyAuditConfigUnsupportedOverridesNestedImpl<N> extends PolicyAuditConfigFluentImpl<NetworkSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<N>> implements NetworkSpecFluent.PolicyAuditConfigUnsupportedOverridesNested<N>,Nested<N>{
    PolicyAuditConfigUnsupportedOverridesNestedImpl(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigUnsupportedOverridesNestedImpl() {
      this.builder = new PolicyAuditConfigBuilder(this);
    }
    PolicyAuditConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPolicyAuditConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  class AddPageUnsupportedConfigOverridesNestedImpl<N> extends AddPageFluentImpl<NetworkSpecFluent.AddPageUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AddPageUnsupportedConfigOverridesNested<N>,Nested<N>{
    AddPageUnsupportedConfigOverridesNestedImpl(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AddPageBuilder(this);
    }
    AddPageBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAddPageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StorageListUnsupportedConfigOverridesNestedImpl<N> extends StorageListFluentImpl<NetworkSpecFluent.StorageListUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StorageListUnsupportedConfigOverridesNested<N>,Nested<N>{
    StorageListUnsupportedConfigOverridesNestedImpl(StorageList item) {
      this.builder = new StorageListBuilder(this, item);
    }
    StorageListUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StorageListBuilder(this);
    }
    StorageListBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl<N> extends StaticIPAMAddressesFluentImpl<NetworkSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.StaticIPAMAddressesUnsupportedConfigOverridesNested<N>,Nested<N>{
    StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl(StaticIPAMAddresses item) {
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    StaticIPAMAddressesUnsupportedConfigOverridesNestedImpl() {
      this.builder = new StaticIPAMAddressesBuilder(this);
    }
    StaticIPAMAddressesBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMAddressesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,Nested<N>{
    DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordUnsupportedConfigOverridesNestedImpl() {
      this.builder = new DNSRecordBuilder(this);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
      this.builder = new OpenShiftAPIServerBuilder(this);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,Nested<N>{
    AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationUnsupportedConfigOverridesNestedImpl() {
      this.builder = new AuthenticationBuilder(this);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ConsoleSpecUnsupportedConfigOverridesNestedImpl<N> extends ConsoleSpecFluentImpl<NetworkSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ConsoleSpecUnsupportedConfigOverridesNested<N>,Nested<N>{
    ConsoleSpecUnsupportedConfigOverridesNestedImpl(ConsoleSpec item) {
      this.builder = new ConsoleSpecBuilder(this, item);
    }
    ConsoleSpecUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ConsoleSpecBuilder(this);
    }
    ConsoleSpecBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  class ServiceCAStatusUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAStatusFluentImpl<NetworkSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<N>> implements NetworkSpecFluent.ServiceCAStatusUnsupportedConfigOverridesNested<N>,Nested<N>{
    ServiceCAStatusUnsupportedConfigOverridesNestedImpl(ServiceCAStatus item) {
      this.builder = new ServiceCAStatusBuilder(this, item);
    }
    ServiceCAStatusUnsupportedConfigOverridesNestedImpl() {
      this.builder = new ServiceCAStatusBuilder(this);
    }
    ServiceCAStatusBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}