package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerLoggingDestinationParametersBuilder extends ContainerLoggingDestinationParametersFluentImpl<ContainerLoggingDestinationParametersBuilder> implements VisitableBuilder<ContainerLoggingDestinationParameters,ContainerLoggingDestinationParametersBuilder>{
  public ContainerLoggingDestinationParametersBuilder() {
    this(false);
  }
  public ContainerLoggingDestinationParametersBuilder(Boolean validationEnabled) {
    this(new ContainerLoggingDestinationParameters(), validationEnabled);
  }
  public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerLoggingDestinationParameters(), validationEnabled);
  }
  public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent,ContainerLoggingDestinationParameters instance) {
    this(fluent, instance, false);
  }
  public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent,ContainerLoggingDestinationParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParameters instance) {
    this(instance,false);
  }
  public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ContainerLoggingDestinationParametersFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerLoggingDestinationParameters build() {
    ContainerLoggingDestinationParameters buildable = new ContainerLoggingDestinationParameters();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}