package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceCatalogAPIServerStatusBuilder extends ServiceCatalogAPIServerStatusFluent<ServiceCatalogAPIServerStatusBuilder> implements VisitableBuilder<ServiceCatalogAPIServerStatus,ServiceCatalogAPIServerStatusBuilder>{
  public ServiceCatalogAPIServerStatusBuilder() {
    this(new ServiceCatalogAPIServerStatus());
  }
  
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatusFluent<?> fluent) {
    this(fluent, new ServiceCatalogAPIServerStatus());
  }
  
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatusFluent<?> fluent,ServiceCatalogAPIServerStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceCatalogAPIServerStatusBuilder(ServiceCatalogAPIServerStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceCatalogAPIServerStatusFluent<?> fluent;
  
  public ServiceCatalogAPIServerStatus build() {
    ServiceCatalogAPIServerStatus buildable = new ServiceCatalogAPIServerStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}