package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DNSSpecFluent<A extends DNSSpecFluent<A>> extends BaseFluent<A>{
  public DNSSpecFluent() {
  }
  
  public DNSSpecFluent(DNSSpec instance) {
    this.copyInstance(instance);
  }
  private DNSCacheBuilder cache;
  private String logLevel;
  private String managementState;
  private DNSNodePlacementBuilder nodePlacement;
  private String operatorLogLevel;
  private ArrayList<ServerBuilder> servers = new ArrayList<ServerBuilder>();
  private UpstreamResolversBuilder upstreamResolvers;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DNSSpec instance) {
    instance = (instance != null ? instance : new DNSSpec());
    if (instance != null) {
          this.withCache(instance.getCache());
          this.withLogLevel(instance.getLogLevel());
          this.withManagementState(instance.getManagementState());
          this.withNodePlacement(instance.getNodePlacement());
          this.withOperatorLogLevel(instance.getOperatorLogLevel());
          this.withServers(instance.getServers());
          this.withUpstreamResolvers(instance.getUpstreamResolvers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public DNSCache buildCache() {
    return this.cache != null ? this.cache.build() : null;
  }
  
  public A withCache(DNSCache cache) {
    this._visitables.remove("cache");
    if (cache != null) {
        this.cache = new DNSCacheBuilder(cache);
        this._visitables.get("cache").add(this.cache);
    } else {
        this.cache = null;
        this._visitables.get("cache").remove(this.cache);
    }
    return (A) this;
  }
  
  public boolean hasCache() {
    return this.cache != null;
  }
  
  public CacheNested<A> withNewCache() {
    return new CacheNested(null);
  }
  
  public CacheNested<A> withNewCacheLike(DNSCache item) {
    return new CacheNested(item);
  }
  
  public CacheNested<A> editCache() {
    return withNewCacheLike(java.util.Optional.ofNullable(buildCache()).orElse(null));
  }
  
  public CacheNested<A> editOrNewCache() {
    return withNewCacheLike(java.util.Optional.ofNullable(buildCache()).orElse(new DNSCacheBuilder().build()));
  }
  
  public CacheNested<A> editOrNewCacheLike(DNSCache item) {
    return withNewCacheLike(java.util.Optional.ofNullable(buildCache()).orElse(item));
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public DNSNodePlacement buildNodePlacement() {
    return this.nodePlacement != null ? this.nodePlacement.build() : null;
  }
  
  public A withNodePlacement(DNSNodePlacement nodePlacement) {
    this._visitables.remove("nodePlacement");
    if (nodePlacement != null) {
        this.nodePlacement = new DNSNodePlacementBuilder(nodePlacement);
        this._visitables.get("nodePlacement").add(this.nodePlacement);
    } else {
        this.nodePlacement = null;
        this._visitables.get("nodePlacement").remove(this.nodePlacement);
    }
    return (A) this;
  }
  
  public boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  
  public NodePlacementNested<A> withNewNodePlacement() {
    return new NodePlacementNested(null);
  }
  
  public NodePlacementNested<A> withNewNodePlacementLike(DNSNodePlacement item) {
    return new NodePlacementNested(item);
  }
  
  public NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(null));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(new DNSNodePlacementBuilder().build()));
  }
  
  public NodePlacementNested<A> editOrNewNodePlacementLike(DNSNodePlacement item) {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(item));
  }
  
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel = operatorLogLevel;
    return (A) this;
  }
  
  public boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  public A addToServers(int index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= servers.size()) { _visitables.get("servers").add(builder); servers.add(builder); } else { _visitables.get("servers").add(index, builder); servers.add(index, builder);}
    return (A)this;
  }
  
  public A setToServers(int index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= servers.size()) { _visitables.get("servers").add(builder); servers.add(builder); } else { _visitables.get("servers").set(index, builder); servers.set(index, builder);}
    return (A)this;
  }
  
  public A addToServers(io.fabric8.openshift.api.model.operator.v1.Server... items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  
  public A addAllToServers(Collection<Server> items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  
  public A removeFromServers(io.fabric8.openshift.api.model.operator.v1.Server... items) {
    if (this.servers == null) return (A)this;
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder); this.servers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServers(Collection<Server> items) {
    if (this.servers == null) return (A)this;
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder); this.servers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Server> buildServers() {
    return this.servers != null ? build(servers) : null;
  }
  
  public Server buildServer(int index) {
    return this.servers.get(index).build();
  }
  
  public Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  
  public Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
      for (ServerBuilder item : servers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
      for (ServerBuilder item : servers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServers(List<Server> servers) {
    if (this.servers != null) {
      this._visitables.get("servers").clear();
    }
    if (servers != null) {
        this.servers = new ArrayList();
        for (Server item : servers) {
          this.addToServers(item);
        }
    } else {
      this.servers = null;
    }
    return (A) this;
  }
  
  public A withServers(io.fabric8.openshift.api.model.operator.v1.Server... servers) {
    if (this.servers != null) {
        this.servers.clear();
        _visitables.remove("servers");
    }
    if (servers != null) {
      for (Server item : servers) {
        this.addToServers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServers() {
    return this.servers != null && !this.servers.isEmpty();
  }
  
  public ServersNested<A> addNewServer() {
    return new ServersNested(-1, null);
  }
  
  public ServersNested<A> addNewServerLike(Server item) {
    return new ServersNested(-1, item);
  }
  
  public ServersNested<A> setNewServerLike(int index,Server item) {
    return new ServersNested(index, item);
  }
  
  public ServersNested<A> editServer(int index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  
  public ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  
  public ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  
  public ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  
  public UpstreamResolvers buildUpstreamResolvers() {
    return this.upstreamResolvers != null ? this.upstreamResolvers.build() : null;
  }
  
  public A withUpstreamResolvers(UpstreamResolvers upstreamResolvers) {
    this._visitables.remove("upstreamResolvers");
    if (upstreamResolvers != null) {
        this.upstreamResolvers = new UpstreamResolversBuilder(upstreamResolvers);
        this._visitables.get("upstreamResolvers").add(this.upstreamResolvers);
    } else {
        this.upstreamResolvers = null;
        this._visitables.get("upstreamResolvers").remove(this.upstreamResolvers);
    }
    return (A) this;
  }
  
  public boolean hasUpstreamResolvers() {
    return this.upstreamResolvers != null;
  }
  
  public UpstreamResolversNested<A> withNewUpstreamResolvers() {
    return new UpstreamResolversNested(null);
  }
  
  public UpstreamResolversNested<A> withNewUpstreamResolversLike(UpstreamResolvers item) {
    return new UpstreamResolversNested(item);
  }
  
  public UpstreamResolversNested<A> editUpstreamResolvers() {
    return withNewUpstreamResolversLike(java.util.Optional.ofNullable(buildUpstreamResolvers()).orElse(null));
  }
  
  public UpstreamResolversNested<A> editOrNewUpstreamResolvers() {
    return withNewUpstreamResolversLike(java.util.Optional.ofNullable(buildUpstreamResolvers()).orElse(new UpstreamResolversBuilder().build()));
  }
  
  public UpstreamResolversNested<A> editOrNewUpstreamResolversLike(UpstreamResolvers item) {
    return withNewUpstreamResolversLike(java.util.Optional.ofNullable(buildUpstreamResolvers()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSSpecFluent that = (DNSSpecFluent) o;
    if (!java.util.Objects.equals(cache, that.cache)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;
    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;
    if (!java.util.Objects.equals(servers, that.servers)) return false;
    if (!java.util.Objects.equals(upstreamResolvers, that.upstreamResolvers)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cache,  logLevel,  managementState,  nodePlacement,  operatorLogLevel,  servers,  upstreamResolvers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cache != null) { sb.append("cache:"); sb.append(cache + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (servers != null && !servers.isEmpty()) { sb.append("servers:"); sb.append(servers + ","); }
    if (upstreamResolvers != null) { sb.append("upstreamResolvers:"); sb.append(upstreamResolvers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CacheNested<N> extends DNSCacheFluent<CacheNested<N>> implements Nested<N>{
    CacheNested(DNSCache item) {
      this.builder = new DNSCacheBuilder(this, item);
    }
    DNSCacheBuilder builder;
    
    public N and() {
      return (N) DNSSpecFluent.this.withCache(builder.build());
    }
    
    public N endCache() {
      return and();
    }
    
  
  }
  public class NodePlacementNested<N> extends DNSNodePlacementFluent<NodePlacementNested<N>> implements Nested<N>{
    NodePlacementNested(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementBuilder builder;
    
    public N and() {
      return (N) DNSSpecFluent.this.withNodePlacement(builder.build());
    }
    
    public N endNodePlacement() {
      return and();
    }
    
  
  }
  public class ServersNested<N> extends ServerFluent<ServersNested<N>> implements Nested<N>{
    ServersNested(int index,Server item) {
      this.index = index;
      this.builder = new ServerBuilder(this, item);
    }
    ServerBuilder builder;
    int index;
    
    public N and() {
      return (N) DNSSpecFluent.this.setToServers(index,builder.build());
    }
    
    public N endServer() {
      return and();
    }
    
  
  }
  public class UpstreamResolversNested<N> extends UpstreamResolversFluent<UpstreamResolversNested<N>> implements Nested<N>{
    UpstreamResolversNested(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversBuilder builder;
    
    public N and() {
      return (N) DNSSpecFluent.this.withUpstreamResolvers(builder.build());
    }
    
    public N endUpstreamResolvers() {
      return and();
    }
    
  
  }

}