package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsoleListBuilder extends ConsoleListFluent<ConsoleListBuilder> implements VisitableBuilder<ConsoleList,ConsoleListBuilder>{
  public ConsoleListBuilder() {
    this(new ConsoleList());
  }
  
  public ConsoleListBuilder(ConsoleListFluent<?> fluent) {
    this(fluent, new ConsoleList());
  }
  
  public ConsoleListBuilder(ConsoleListFluent<?> fluent,ConsoleList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsoleListBuilder(ConsoleList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsoleListFluent<?> fluent;
  
  public ConsoleList build() {
    ConsoleList buildable = new ConsoleList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}