package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressControllerTuningOptionsBuilder extends IngressControllerTuningOptionsFluent<IngressControllerTuningOptionsBuilder> implements VisitableBuilder<IngressControllerTuningOptions,IngressControllerTuningOptionsBuilder>{
  public IngressControllerTuningOptionsBuilder() {
    this(new IngressControllerTuningOptions());
  }
  
  public IngressControllerTuningOptionsBuilder(IngressControllerTuningOptionsFluent<?> fluent) {
    this(fluent, new IngressControllerTuningOptions());
  }
  
  public IngressControllerTuningOptionsBuilder(IngressControllerTuningOptionsFluent<?> fluent,IngressControllerTuningOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressControllerTuningOptionsBuilder(IngressControllerTuningOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressControllerTuningOptionsFluent<?> fluent;
  
  public IngressControllerTuningOptions build() {
    IngressControllerTuningOptions buildable = new IngressControllerTuningOptions(fluent.getClientFinTimeout(),fluent.getClientTimeout(),fluent.getHeaderBufferBytes(),fluent.getHeaderBufferMaxRewriteBytes(),fluent.getHealthCheckInterval(),fluent.getMaxConnections(),fluent.getReloadInterval(),fluent.getServerFinTimeout(),fluent.getServerTimeout(),fluent.getThreadCount(),fluent.getTlsInspectDelay(),fluent.getTunnelTimeout());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}