/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.KubeSchedulerSpec;
import io.fabric8.openshift.api.model.operator.v1.KubeSchedulerSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.KubeSchedulerSpecFluentImpl;
import java.util.Objects;

public class KubeSchedulerSpecBuilder
extends KubeSchedulerSpecFluentImpl<KubeSchedulerSpecBuilder>
implements VisitableBuilder<KubeSchedulerSpec, KubeSchedulerSpecBuilder> {
    KubeSchedulerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KubeSchedulerSpecBuilder() {
        this(false);
    }

    public KubeSchedulerSpecBuilder(Boolean validationEnabled) {
        this(new KubeSchedulerSpec(), validationEnabled);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubeSchedulerSpec(), validationEnabled);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent, KubeSchedulerSpec instance) {
        this(fluent, instance, false);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent, KubeSchedulerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit());
        fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withManagementState(instance.getManagementState());
        fluent.withObservedConfig(instance.getObservedConfig());
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
        fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance) {
        this(instance, (Boolean)false);
    }

    public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFailedRevisionLimit(instance.getFailedRevisionLimit());
        this.withForceRedeploymentReason(instance.getForceRedeploymentReason());
        this.withLogLevel(instance.getLogLevel());
        this.withManagementState(instance.getManagementState());
        this.withObservedConfig(instance.getObservedConfig());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    public KubeSchedulerSpec build() {
        KubeSchedulerSpec buildable = new KubeSchedulerSpec(this.fluent.getFailedRevisionLimit(), this.fluent.getForceRedeploymentReason(), this.fluent.getLogLevel(), this.fluent.getManagementState(), this.fluent.getObservedConfig(), this.fluent.getOperatorLogLevel(), this.fluent.getSucceededRevisionLimit(), this.fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubeSchedulerSpecBuilder that = (KubeSchedulerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

