/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSSpec;
import io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.DNSSpecFluentImpl;
import java.util.Objects;

public class DNSSpecBuilder
extends DNSSpecFluentImpl<DNSSpecBuilder>
implements VisitableBuilder<DNSSpec, DNSSpecBuilder> {
    DNSSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DNSSpecBuilder() {
        this(false);
    }

    public DNSSpecBuilder(Boolean validationEnabled) {
        this(new DNSSpec(), validationEnabled);
    }

    public DNSSpecBuilder(DNSSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DNSSpecBuilder(DNSSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DNSSpec(), validationEnabled);
    }

    public DNSSpecBuilder(DNSSpecFluent<?> fluent, DNSSpec instance) {
        this(fluent, instance, false);
    }

    public DNSSpecBuilder(DNSSpecFluent<?> fluent, DNSSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodePlacement(instance.getNodePlacement());
        fluent.withServers(instance.getServers());
        this.validationEnabled = validationEnabled;
    }

    public DNSSpecBuilder(DNSSpec instance) {
        this(instance, (Boolean)false);
    }

    public DNSSpecBuilder(DNSSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodePlacement(instance.getNodePlacement());
        this.withServers(instance.getServers());
        this.validationEnabled = validationEnabled;
    }

    public DNSSpec build() {
        DNSSpec buildable = new DNSSpec(this.fluent.getNodePlacement(), this.fluent.getServers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSSpecBuilder that = (DNSSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

