/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordStatus;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent;
import io.fabric8.openshift.api.model.operator.v1.DNSZoneStatus;
import io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1.DNSZoneStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSRecordStatusFluentImpl<A extends DNSRecordStatusFluent<A>>
extends BaseFluent<A>
implements DNSRecordStatusFluent<A> {
    private Long observedGeneration;
    private List<DNSZoneStatusBuilder> zones = new ArrayList<DNSZoneStatusBuilder>();

    public DNSRecordStatusFluentImpl() {
    }

    public DNSRecordStatusFluentImpl(DNSRecordStatus instance) {
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withZones(instance.getZones());
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToZones(Integer index, DNSZoneStatus item) {
        if (this.zones == null) {
            this.zones = new ArrayList<DNSZoneStatusBuilder>();
        }
        DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
        this._visitables.get((Object)"zones").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"zones").size(), builder);
        this.zones.add(index >= 0 ? index.intValue() : this.zones.size(), builder);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, DNSZoneStatus item) {
        if (this.zones == null) {
            this.zones = new ArrayList<DNSZoneStatusBuilder>();
        }
        DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"zones").size()) {
            this._visitables.get((Object)"zones").add(builder);
        } else {
            this._visitables.get((Object)"zones").set(index, builder);
        }
        if (index < 0 || index >= this.zones.size()) {
            this.zones.add(builder);
        } else {
            this.zones.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToZones(DNSZoneStatus ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<DNSZoneStatusBuilder>();
        }
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get((Object)"zones").add(builder);
            this.zones.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<DNSZoneStatus> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<DNSZoneStatusBuilder>();
        }
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get((Object)"zones").add(builder);
            this.zones.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(DNSZoneStatus ... items) {
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get((Object)"zones").remove(builder);
            if (this.zones == null) continue;
            this.zones.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<DNSZoneStatus> items) {
        for (DNSZoneStatus item : items) {
            DNSZoneStatusBuilder builder = new DNSZoneStatusBuilder(item);
            this._visitables.get((Object)"zones").remove(builder);
            if (this.zones == null) continue;
            this.zones.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromZones(Predicate<DNSZoneStatusBuilder> predicate) {
        if (this.zones == null) {
            return (A)this;
        }
        Iterator<DNSZoneStatusBuilder> each = this.zones.iterator();
        List visitables = this._visitables.get((Object)"zones");
        while (each.hasNext()) {
            DNSZoneStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DNSZoneStatus> getZones() {
        return DNSRecordStatusFluentImpl.build(this.zones);
    }

    @Override
    public List<DNSZoneStatus> buildZones() {
        return DNSRecordStatusFluentImpl.build(this.zones);
    }

    @Override
    public DNSZoneStatus buildZone(Integer index) {
        return this.zones.get(index).build();
    }

    @Override
    public DNSZoneStatus buildFirstZone() {
        return this.zones.get(0).build();
    }

    @Override
    public DNSZoneStatus buildLastZone() {
        return this.zones.get(this.zones.size() - 1).build();
    }

    @Override
    public DNSZoneStatus buildMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        for (DNSZoneStatusBuilder item : this.zones) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        for (DNSZoneStatusBuilder item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<DNSZoneStatus> zones) {
        if (this.zones != null) {
            this._visitables.get((Object)"zones").removeAll(this.zones);
        }
        if (zones != null) {
            this.zones = new ArrayList<DNSZoneStatusBuilder>();
            for (DNSZoneStatus item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(DNSZoneStatus ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (DNSZoneStatus item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> addNewZone() {
        return new ZonesNestedImpl();
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> addNewZoneLike(DNSZoneStatus item) {
        return new ZonesNestedImpl(-1, item);
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> setNewZoneLike(Integer index, DNSZoneStatus item) {
        return new ZonesNestedImpl(index, item);
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> editZone(Integer index) {
        if (this.zones.size() <= index) {
            throw new RuntimeException("Can't edit zones. Index exceeds size.");
        }
        return this.setNewZoneLike(index, this.buildZone(index));
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> editFirstZone() {
        if (this.zones.size() == 0) {
            throw new RuntimeException("Can't edit first zones. The list is empty.");
        }
        return this.setNewZoneLike(0, this.buildZone(0));
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> editLastZone() {
        int index = this.zones.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last zones. The list is empty.");
        }
        return this.setNewZoneLike(index, this.buildZone(index));
    }

    @Override
    public DNSRecordStatusFluent.ZonesNested<A> editMatchingZone(Predicate<DNSZoneStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.zones.size(); ++i) {
            if (!predicate.test(this.zones.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching zones. No match found.");
        }
        return this.setNewZoneLike(index, this.buildZone(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSRecordStatusFluentImpl that = (DNSRecordStatusFluentImpl)o;
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        return !(this.zones != null ? !this.zones.equals(that.zones) : that.zones != null);
    }

    public int hashCode() {
        return Objects.hash(this.observedGeneration, this.zones, super.hashCode());
    }

    public class ZonesNestedImpl<N>
    extends DNSZoneStatusFluentImpl<DNSRecordStatusFluent.ZonesNested<N>>
    implements DNSRecordStatusFluent.ZonesNested<N>,
    Nested<N> {
        DNSZoneStatusBuilder builder;
        Integer index;

        ZonesNestedImpl(Integer index, DNSZoneStatus item) {
            this.index = index;
            this.builder = new DNSZoneStatusBuilder(this, item);
        }

        ZonesNestedImpl() {
            this.index = -1;
            this.builder = new DNSZoneStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSRecordStatusFluentImpl.this.setToZones(this.index, this.builder.build());
        }

        @Override
        public N endZone() {
            return this.and();
        }
    }
}

