/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.SettingSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SettingSchemaFluent<A extends SettingSchemaFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> allowableValues = new ArrayList<String>();
    private String attributeType;
    private Integer lowerBound;
    private Integer maxLength;
    private Integer minLength;
    private Boolean readOnly;
    private Boolean unique;
    private Integer upperBound;

    public SettingSchemaFluent() {
    }

    public SettingSchemaFluent(SettingSchema instance) {
        this.copyInstance(instance);
    }

    public A addAllToAllowableValues(Collection<String> items) {
        if (this.allowableValues == null) {
            this.allowableValues = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowableValues.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllowableValues(String ... items) {
        if (this.allowableValues == null) {
            this.allowableValues = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowableValues.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAllowableValues(int index, String item) {
        if (this.allowableValues == null) {
            this.allowableValues = new ArrayList<String>();
        }
        this.allowableValues.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(SettingSchema instance) {
        SettingSchema settingSchema = instance = instance != null ? instance : new SettingSchema();
        if (instance != null) {
            this.withAllowableValues(instance.getAllowableValues());
            this.withAttributeType(instance.getAttributeType());
            this.withLowerBound(instance.getLowerBound());
            this.withMaxLength(instance.getMaxLength());
            this.withMinLength(instance.getMinLength());
            this.withReadOnly(instance.getReadOnly());
            this.withUnique(instance.getUnique());
            this.withUpperBound(instance.getUpperBound());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SettingSchemaFluent that = (SettingSchemaFluent)((Object)o);
        if (!Objects.equals(this.allowableValues, that.allowableValues)) {
            return false;
        }
        if (!Objects.equals(this.attributeType, that.attributeType)) {
            return false;
        }
        if (!Objects.equals(this.lowerBound, that.lowerBound)) {
            return false;
        }
        if (!Objects.equals(this.maxLength, that.maxLength)) {
            return false;
        }
        if (!Objects.equals(this.minLength, that.minLength)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.unique, that.unique)) {
            return false;
        }
        if (!Objects.equals(this.upperBound, that.upperBound)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAllowableValue(int index) {
        return this.allowableValues.get(index);
    }

    public List<String> getAllowableValues() {
        return this.allowableValues;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public String getFirstAllowableValue() {
        return this.allowableValues.get(0);
    }

    public String getLastAllowableValue() {
        return this.allowableValues.get(this.allowableValues.size() - 1);
    }

    public Integer getLowerBound() {
        return this.lowerBound;
    }

    public String getMatchingAllowableValue(Predicate<String> predicate) {
        for (String item : this.allowableValues) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public Integer getUpperBound() {
        return this.upperBound;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllowableValues() {
        return this.allowableValues != null && !this.allowableValues.isEmpty();
    }

    public boolean hasAttributeType() {
        return this.attributeType != null;
    }

    public boolean hasLowerBound() {
        return this.lowerBound != null;
    }

    public boolean hasMatchingAllowableValue(Predicate<String> predicate) {
        for (String item : this.allowableValues) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMaxLength() {
        return this.maxLength != null;
    }

    public boolean hasMinLength() {
        return this.minLength != null;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public boolean hasUnique() {
        return this.unique != null;
    }

    public boolean hasUpperBound() {
        return this.upperBound != null;
    }

    public int hashCode() {
        return Objects.hash(this.allowableValues, this.attributeType, this.lowerBound, this.maxLength, this.minLength, this.readOnly, this.unique, this.upperBound, this.additionalProperties);
    }

    public A removeAllFromAllowableValues(Collection<String> items) {
        if (this.allowableValues == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowableValues.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAllowableValues(String ... items) {
        if (this.allowableValues == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowableValues.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToAllowableValues(int index, String item) {
        if (this.allowableValues == null) {
            this.allowableValues = new ArrayList<String>();
        }
        this.allowableValues.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowableValues != null && !this.allowableValues.isEmpty()) {
            sb.append("allowableValues:");
            sb.append(this.allowableValues);
            sb.append(",");
        }
        if (this.attributeType != null) {
            sb.append("attributeType:");
            sb.append(this.attributeType);
            sb.append(",");
        }
        if (this.lowerBound != null) {
            sb.append("lowerBound:");
            sb.append(this.lowerBound);
            sb.append(",");
        }
        if (this.maxLength != null) {
            sb.append("maxLength:");
            sb.append(this.maxLength);
            sb.append(",");
        }
        if (this.minLength != null) {
            sb.append("minLength:");
            sb.append(this.minLength);
            sb.append(",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly);
            sb.append(",");
        }
        if (this.unique != null) {
            sb.append("unique:");
            sb.append(this.unique);
            sb.append(",");
        }
        if (this.upperBound != null) {
            sb.append("upperBound:");
            sb.append(this.upperBound);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAllowableValues(List<String> allowableValues) {
        if (allowableValues != null) {
            this.allowableValues = new ArrayList<String>();
            for (String item : allowableValues) {
                this.addToAllowableValues(item);
            }
        } else {
            this.allowableValues = null;
        }
        return (A)((Object)this);
    }

    public A withAllowableValues(String ... allowableValues) {
        if (this.allowableValues != null) {
            this.allowableValues.clear();
            this._visitables.remove((Object)"allowableValues");
        }
        if (allowableValues != null) {
            for (String item : allowableValues) {
                this.addToAllowableValues(item);
            }
        }
        return (A)((Object)this);
    }

    public A withAttributeType(String attributeType) {
        this.attributeType = attributeType;
        return (A)((Object)this);
    }

    public A withLowerBound(Integer lowerBound) {
        this.lowerBound = lowerBound;
        return (A)((Object)this);
    }

    public A withMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return (A)((Object)this);
    }

    public A withMinLength(Integer minLength) {
        this.minLength = minLength;
        return (A)((Object)this);
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public A withUnique() {
        return this.withUnique(true);
    }

    public A withUnique(Boolean unique) {
        this.unique = unique;
        return (A)((Object)this);
    }

    public A withUpperBound(Integer upperBound) {
        this.upperBound = upperBound;
        return (A)((Object)this);
    }
}

